/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import dev.ludovic.netlib.BLAS;
import dev.ludovic.netlib.JavaBLAS;
import dev.ludovic.netlib.blas.F2jBLAS;
import java.io.Serializable;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.ml.linalg.BLAS$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class BLASBenchmark$
extends BenchmarkBase {
    public static final BLASBenchmark$ MODULE$ = new BLASBenchmark$();

    public void runBenchmarkSuite(String[] mainArgs) {
        int iters = (int)100.0;
        Random rnd = new Random(0);
        JavaBLAS f2jBLAS = F2jBLAS.getInstance();
        BLAS javaBLAS = BLAS$.MODULE$.javaBLAS();
        BLAS nativeBLAS = BLAS$.MODULE$.nativeBLAS();
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("f2jBLAS    = ").append(f2jBLAS.getClass().getName()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("javaBLAS   = ").append(javaBLAS.getClass().getName()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("nativeBLAS = ").append(nativeBLAS.getClass().getName()).toString());
        this.runBenchmark("daxpy", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            double alpha = rnd.nextDouble();
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double[] y = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("daxpy", n, (Function1 & Serializable)impl -> {
                impl.daxpy(n, alpha, x, 1, (double[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("saxpy", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            float alpha = rnd.nextFloat();
            float[] x = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            float[] y = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            this.runBLASBenchmark$1("saxpy", n, (Function1 & Serializable)impl -> {
                impl.saxpy(n, alpha, x, 1, (float[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dcopy", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double[] y = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dcopy", n, (Function1 & Serializable)impl -> {
                impl.dcopy(n, x, 1, (double[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("scopy", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            float[] x = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            float[] y = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> 0.0f, (ClassTag)ClassTag$.MODULE$.Float());
            this.runBLASBenchmark$1("scopy", n, (Function1 & Serializable)impl -> {
                impl.scopy(n, x, 1, (float[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("ddot", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double[] y = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("ddot", n, (Function1 & Serializable)impl -> {
                impl.ddot(n, x, 1, y, 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("sdot", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            float[] x = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            float[] y = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            this.runBLASBenchmark$1("sdot", n, (Function1 & Serializable)impl -> {
                impl.sdot(n, x, 1, y, 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dnrm2", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dnrm2", n, (Function1 & Serializable)impl -> {
                impl.dnrm2(n, x, 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("snrm2", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            float[] x = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            this.runBLASBenchmark$1("snrm2", n, (Function1 & Serializable)impl -> {
                impl.snrm2(n, x, 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dscal", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            double alpha = rnd.nextDouble();
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dscal", n, (Function1 & Serializable)impl -> {
                impl.dscal(n, alpha, (double[])x.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("sscal", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)1.0E8;
            float alpha = rnd.nextFloat();
            float[] x = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            this.runBLASBenchmark$1("sscal", n, (Function1 & Serializable)impl -> {
                impl.sscal(n, alpha, (float[])x.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dgemv[N]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)10000.0;
            int n = (int)10000.0;
            double alpha = rnd.nextDouble();
            double[] a = (double[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int lda = m;
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double beta = rnd.nextDouble();
            double[] y = (double[])Array$.MODULE$.fill(m, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dgemv[N]", m * n, (Function1 & Serializable)impl -> {
                impl.dgemv("N", m, n, alpha, a, lda, x, 1, beta, (double[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dgemv[T]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)10000.0;
            int n = (int)10000.0;
            double alpha = rnd.nextDouble();
            double[] a = (double[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int lda = m;
            double[] x = (double[])Array$.MODULE$.fill(m, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double beta = rnd.nextDouble();
            double[] y = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dgemv[T]", m * n, (Function1 & Serializable)impl -> {
                impl.dgemv("T", m, n, alpha, a, lda, x, 1, beta, (double[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("sgemv[N]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)10000.0;
            int n = (int)10000.0;
            float alpha = rnd.nextFloat();
            float[] a = (float[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int lda = m;
            float[] x = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            float beta = rnd.nextFloat();
            float[] y = (float[])Array$.MODULE$.fill(m, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            this.runBLASBenchmark$1("sgemv[N]", m * n, (Function1 & Serializable)impl -> {
                impl.sgemv("N", m, n, alpha, a, lda, x, 1, beta, (float[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("sgemv[T]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)10000.0;
            int n = (int)10000.0;
            float alpha = rnd.nextFloat();
            float[] a = (float[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int lda = m;
            float[] x = (float[])Array$.MODULE$.fill(m, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            float beta = rnd.nextFloat();
            float[] y = (float[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            this.runBLASBenchmark$1("sgemv[T]", m * n, (Function1 & Serializable)impl -> {
                impl.sgemv("T", m, n, alpha, a, lda, x, 1, beta, (float[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dger", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)10000.0;
            int n = (int)10000.0;
            double alpha = rnd.nextDouble();
            double[] a = (double[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int lda = m;
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double beta = rnd.nextDouble();
            double[] y = (double[])Array$.MODULE$.fill(m, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dger", m * n, (Function1 & Serializable)impl -> {
                impl.dger(m, n, alpha, x, 1, y, 1, (double[])a.clone(), m);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dspmv[U]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)10000.0;
            double alpha = rnd.nextDouble();
            double[] a = (double[])Array$.MODULE$.fill(n * (n + 1) / 2, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double beta = rnd.nextDouble();
            double[] y = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dspmv[U]", n * (n + 1) / 2, (Function1 & Serializable)impl -> {
                impl.dspmv("U", n, alpha, a, x, 1, beta, (double[])y.clone(), 1);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dspr[U]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)10000.0;
            double alpha = rnd.nextDouble();
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double[] a = (double[])Array$.MODULE$.fill(n * (n + 1) / 2, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dspr[U]", n * (n + 1) / 2, (Function1 & Serializable)impl -> {
                impl.dspr("U", n, alpha, x, 1, (double[])a.clone());
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dsyr[U]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int n = (int)10000.0;
            double alpha = rnd.nextDouble();
            double[] x = (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            double[] a = (double[])Array$.MODULE$.fill(n * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            this.runBLASBenchmark$1("dsyr[U]", n * (n + 1) / 2, (Function1 & Serializable)impl -> {
                impl.dsyr("U", n, alpha, x, 1, (double[])a.clone(), n);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dgemm[N,N]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)1000.0;
            int n = (int)1000.0;
            int k = (int)1000.0;
            double alpha = rnd.nextDouble();
            double[] a = (double[])Array$.MODULE$.fill(m * k, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int lda = m;
            double[] b = (double[])Array$.MODULE$.fill(k * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int ldb = k;
            double beta = rnd.nextDouble();
            double[] c = (double[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int ldc = m;
            this.runBLASBenchmark$1("dgemm[N,N]", m * n * k, (Function1 & Serializable)impl -> {
                impl.dgemm("N", "N", m, n, k, alpha, a, lda, b, ldb, beta, (double[])c.clone(), ldc);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dgemm[N,T]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)1000.0;
            int n = (int)1000.0;
            int k = (int)1000.0;
            double alpha = rnd.nextDouble();
            double[] a = (double[])Array$.MODULE$.fill(m * k, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int lda = m;
            double[] b = (double[])Array$.MODULE$.fill(k * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int ldb = n;
            double beta = rnd.nextDouble();
            double[] c = (double[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int ldc = m;
            this.runBLASBenchmark$1("dgemm[N,T]", m * n * k, (Function1 & Serializable)impl -> {
                impl.dgemm("N", "T", m, n, k, alpha, a, lda, b, ldb, beta, (double[])c.clone(), ldc);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dgemm[T,N]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)1000.0;
            int n = (int)1000.0;
            int k = (int)1000.0;
            double alpha = rnd.nextDouble();
            double[] a = (double[])Array$.MODULE$.fill(m * k, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int lda = k;
            double[] b = (double[])Array$.MODULE$.fill(k * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int ldb = k;
            double beta = rnd.nextDouble();
            double[] c = (double[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int ldc = m;
            this.runBLASBenchmark$1("dgemm[T,N]", m * n * k, (Function1 & Serializable)impl -> {
                impl.dgemm("T", "N", m, n, k, alpha, a, lda, b, ldb, beta, (double[])c.clone(), ldc);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("dgemm[T,T]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)1000.0;
            int n = (int)1000.0;
            int k = (int)1000.0;
            double alpha = rnd.nextDouble();
            double[] a = (double[])Array$.MODULE$.fill(m * k, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int lda = k;
            double[] b = (double[])Array$.MODULE$.fill(k * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int ldb = n;
            double beta = rnd.nextDouble();
            double[] c = (double[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
            int ldc = m;
            this.runBLASBenchmark$1("dgemm[T,T]", m * n * k, (Function1 & Serializable)impl -> {
                impl.dgemm("T", "T", m, n, k, alpha, a, lda, b, ldb, beta, (double[])c.clone(), ldc);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("sgemm[N,N]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)1000.0;
            int n = (int)1000.0;
            int k = (int)1000.0;
            float alpha = rnd.nextFloat();
            float[] a = (float[])Array$.MODULE$.fill(m * k, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int lda = m;
            float[] b = (float[])Array$.MODULE$.fill(k * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int ldb = k;
            float beta = rnd.nextFloat();
            float[] c = (float[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int ldc = m;
            this.runBLASBenchmark$1("sgemm[N,N]", m * n * k, (Function1 & Serializable)impl -> {
                impl.sgemm("N", "N", m, n, k, alpha, a, lda, b, ldb, beta, (float[])c.clone(), ldc);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("sgemm[N,T]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)1000.0;
            int n = (int)1000.0;
            int k = (int)1000.0;
            float alpha = rnd.nextFloat();
            float[] a = (float[])Array$.MODULE$.fill(m * k, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int lda = m;
            float[] b = (float[])Array$.MODULE$.fill(k * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int ldb = n;
            float beta = rnd.nextFloat();
            float[] c = (float[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int ldc = m;
            this.runBLASBenchmark$1("sgemm[N,T]", m * n * k, (Function1 & Serializable)impl -> {
                impl.sgemm("N", "T", m, n, k, alpha, a, lda, b, ldb, beta, (float[])c.clone(), ldc);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("sgemm[T,N]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)1000.0;
            int n = (int)1000.0;
            int k = (int)1000.0;
            float alpha = rnd.nextFloat();
            float[] a = (float[])Array$.MODULE$.fill(m * k, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int lda = k;
            float[] b = (float[])Array$.MODULE$.fill(k * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int ldb = k;
            float beta = rnd.nextFloat();
            float[] c = (float[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int ldc = m;
            this.runBLASBenchmark$1("sgemm[T,N]", m * n * k, (Function1 & Serializable)impl -> {
                impl.sgemm("T", "N", m, n, k, alpha, a, lda, b, ldb, beta, (float[])c.clone(), ldc);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
        this.runBenchmark("sgemm[T,T]", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int m = (int)1000.0;
            int n = (int)1000.0;
            int k = (int)1000.0;
            float alpha = rnd.nextFloat();
            float[] a = (float[])Array$.MODULE$.fill(m * k, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int lda = k;
            float[] b = (float[])Array$.MODULE$.fill(k * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int ldb = n;
            float beta = rnd.nextFloat();
            float[] c = (float[])Array$.MODULE$.fill(m * n, (Function0)(JFunction0.mcF.sp & Serializable)() -> rnd.nextFloat(), (ClassTag)ClassTag$.MODULE$.Float());
            int ldc = m;
            this.runBLASBenchmark$1("sgemm[T,T]", m * n * k, (Function1 & Serializable)impl -> {
                impl.sgemm("T", "T", m, n, k, alpha, a, lda, b, ldb, beta, (float[])c.clone(), ldc);
                return BoxedUnit.UNIT;
            }, iters, f2jBLAS, javaBLAS, nativeBLAS);
        });
    }

    private final void runBLASBenchmark$1(String name, int n, Function1 bench, int iters$1, JavaBLAS f2jBLAS$1, BLAS javaBLAS$1, BLAS nativeBLAS$1) {
        String x$12 = name;
        long x$22 = n;
        int x$32 = iters$1;
        FiniteDuration x$4 = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
        FiniteDuration x$5 = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
        Option x$6 = this.output();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$12, x$22, x$32, x$4, x$5, x$7, x$6);
        benchmark.addCase("f2j", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> bench.apply((Object)f2jBLAS$1));
        benchmark.addCase("java", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> bench.apply((Object)javaBLAS$1));
        BLAS bLAS = nativeBLAS$1;
        BLAS bLAS2 = javaBLAS$1;
        if (bLAS == null ? bLAS2 != null : !bLAS.equals(bLAS2)) {
            benchmark.addCase("native", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> bench.apply((Object)nativeBLAS$1));
        }
        benchmark.run();
    }

    private BLASBenchmark$() {
    }
}

