/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.spark.launcher.BaseSuite;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkSubmitCommandBuilder;
import org.apache.spark.launcher.SparkSubmitOptionParser;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SparkSubmitCommandBuilderSuite
extends BaseSuite {
    private static File dummyPropsFile;
    private static SparkSubmitOptionParser parser;

    @BeforeAll
    public static void setUp() throws Exception {
        dummyPropsFile = File.createTempFile("spark", "properties");
        parser = new SparkSubmitOptionParser();
    }

    @AfterAll
    public static void cleanUp() throws Exception {
        dummyPropsFile.delete();
    }

    @Test
    public void testDriverCmdBuilder() throws Exception {
        this.testCmdBuilder(true, true);
        this.testCmdBuilder(true, false);
    }

    @Test
    public void testClusterCmdBuilder() throws Exception {
        this.testCmdBuilder(false, true);
        this.testCmdBuilder(false, false);
    }

    @Test
    public void testCliHelpAndNoArg() throws Exception {
        String[] stringArray = new String[1];
        Objects.requireNonNull(parser);
        stringArray[0] = "--help";
        List<String> helpArgs = Arrays.asList(stringArray);
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = this.buildCommand(helpArgs, env);
        Objects.requireNonNull(parser);
        Assertions.assertTrue((boolean)cmd.contains("--help"), (String)"--help should be contained in the final cmd.");
        List<String> sparkEmptyArgs = Collections.emptyList();
        cmd = this.buildCommand(sparkEmptyArgs, env);
        Assertions.assertTrue((boolean)cmd.contains("org.apache.spark.deploy.SparkSubmit"), (String)"org.apache.spark.deploy.SparkSubmit should be contained in the final cmd of empty input.");
    }

    @Test
    public void testCheckJavaOptionsThrowException() throws Exception {
        HashMap env = new HashMap();
        String[] stringArray = new String[7];
        Objects.requireNonNull(parser);
        stringArray[0] = "--master";
        stringArray[1] = "local";
        Objects.requireNonNull(parser);
        stringArray[2] = "--driver-class-path";
        stringArray[3] = "/driverCp";
        Objects.requireNonNull(parser);
        stringArray[4] = "--driver-java-options";
        stringArray[5] = "-Xmx64g -Dprop=Other -Dprop1=\"-Xmx -Xmx\" -Dprop2=\"-Xmx '-Xmx\" -Dprop3='-Xmx -Xmx' -Dprop4='-Xmx \"-Xmx'";
        stringArray[6] = "spark-internal";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.buildCommand(sparkSubmitArgs, env));
    }

    @Test
    public void testCheckJavaOptions() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        String[] stringArray = new String[7];
        Objects.requireNonNull(parser);
        stringArray[0] = "--master";
        stringArray[1] = "local";
        Objects.requireNonNull(parser);
        stringArray[2] = "--driver-class-path";
        stringArray[3] = "/driverCp";
        Objects.requireNonNull(parser);
        stringArray[4] = "--driver-java-options";
        stringArray[5] = "-Dprop=-Xmx -Dprop1=\"-Xmx -Xmx\" -Dprop2=\"-Xmx '-Xmx\" -Dprop3='-Xmx -Xmx' -Dprop4='-Xmx \"-Xmx'";
        stringArray[6] = "spark-internal";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        this.buildCommand(sparkSubmitArgs, env);
    }

    @Test
    public void testCliKillAndStatus() throws Exception {
        List<String> params = Arrays.asList("driver-20160531171222-0000");
        Objects.requireNonNull(parser);
        this.testCLIOpts(null, "--status", params);
        Objects.requireNonNull(parser);
        this.testCLIOpts(null, "--kill", params);
        Objects.requireNonNull(parser);
        this.testCLIOpts("run-example", "--status", params);
        Objects.requireNonNull(parser);
        this.testCLIOpts("run-example", "--kill", params);
    }

    @Test
    public void testCliParser() throws Exception {
        String[] stringArray = new String[13];
        Objects.requireNonNull(parser);
        stringArray[0] = "--master";
        stringArray[1] = "local";
        Objects.requireNonNull(parser);
        stringArray[2] = "--driver-memory";
        stringArray[3] = "42g";
        Objects.requireNonNull(parser);
        stringArray[4] = "--driver-class-path";
        stringArray[5] = "/driverCp";
        Objects.requireNonNull(parser);
        stringArray[6] = "--driver-java-options";
        stringArray[7] = "extraJavaOpt";
        Objects.requireNonNull(parser);
        stringArray[8] = "--conf";
        stringArray[9] = "spark.randomOption=foo";
        Objects.requireNonNull(parser);
        stringArray[10] = "--conf";
        stringArray[11] = "spark.driver.extraLibraryPath=/driverLibPath";
        stringArray[12] = "spark-internal";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = this.buildCommand(sparkSubmitArgs, env);
        Assertions.assertTrue((boolean)this.findInStringList((String)env.get(CommandBuilderUtils.getLibPathEnvName()), File.pathSeparator, "/driverLibPath"));
        Assertions.assertTrue((boolean)this.findInStringList(this.findArgValue(cmd, "-cp"), File.pathSeparator, "/driverCp"));
        Assertions.assertTrue((boolean)cmd.contains("-Xmx42g"), (String)"Driver -Xmx should be configured.");
        String[] stringArray2 = new String[2];
        Objects.requireNonNull(parser);
        stringArray2[0] = "--conf";
        stringArray2[1] = "spark.randomOption=foo";
        Assertions.assertTrue((Collections.indexOfSubList(cmd, Arrays.asList(stringArray2)) > 0 ? 1 : 0) != 0, (String)"Command should contain user-defined conf.");
    }

    @Test
    public void testShellCliParser() throws Exception {
        String[] stringArray = new String[11];
        Objects.requireNonNull(parser);
        stringArray[0] = "--class";
        stringArray[1] = "org.apache.spark.repl.Main";
        Objects.requireNonNull(parser);
        stringArray[2] = "--master";
        stringArray[3] = "foo";
        stringArray[4] = "--app-arg";
        stringArray[5] = "bar";
        stringArray[6] = "--app-switch";
        Objects.requireNonNull(parser);
        stringArray[7] = "--files";
        stringArray[8] = "baz";
        Objects.requireNonNull(parser);
        stringArray[9] = "--name";
        stringArray[10] = "appName";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        List args = this.newCommandBuilder(sparkSubmitArgs).buildSparkSubmitArgs();
        List<String> expected = Arrays.asList("spark-shell", "--app-arg", "bar", "--app-switch");
        Assertions.assertEquals(expected, args.subList(args.size() - expected.size(), args.size()));
    }

    @Test
    public void testAlternateSyntaxParsing() throws Exception {
        String[] stringArray = new String[4];
        Objects.requireNonNull(parser);
        stringArray[0] = "--class" + "=org.my.Class";
        Objects.requireNonNull(parser);
        stringArray[1] = "--master" + "=foo";
        Objects.requireNonNull(parser);
        stringArray[2] = "--deploy-mode" + "=bar";
        stringArray[3] = "spark-internal";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        List cmd = this.newCommandBuilder(sparkSubmitArgs).buildSparkSubmitArgs();
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"org.my.Class", (Object)this.findArgValue(cmd, "--class"));
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"foo", (Object)this.findArgValue(cmd, "--master"));
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"bar", (Object)this.findArgValue(cmd, "--deploy-mode"));
    }

    @Test
    public void testPySparkLauncher() throws Exception {
        List<String> sparkSubmitArgs = Arrays.asList("pyspark-shell-main", "--master=foo", "--deploy-mode=bar");
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = this.buildCommand(sparkSubmitArgs, env);
        Assertions.assertTrue((boolean)Arrays.asList("python", "python2", "python3").contains(cmd.get(cmd.size() - 1)));
        Object[] objectArray = new Object[3];
        Objects.requireNonNull(parser);
        objectArray[0] = "--master";
        Objects.requireNonNull(parser);
        objectArray[1] = "--deploy-mode";
        objectArray[2] = "pyspark-shell";
        Assertions.assertEquals((Object)String.format("\"%s\" \"foo\" \"%s\" \"bar\" \"%s\"", objectArray), env.get("PYSPARK_SUBMIT_ARGS"));
    }

    @Test
    public void testPySparkFallback() throws Exception {
        List<String> sparkSubmitArgs = Arrays.asList("--master=foo", "--deploy-mode=bar", "script.py", "arg1");
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = this.buildCommand(sparkSubmitArgs, env);
        Assertions.assertEquals((Object)"foo", (Object)this.findArgValue(cmd, "--master"));
        Assertions.assertEquals((Object)"bar", (Object)this.findArgValue(cmd, "--deploy-mode"));
        Assertions.assertEquals((Object)"script.py", (Object)cmd.get(cmd.size() - 2));
        Assertions.assertEquals((Object)"arg1", (Object)cmd.get(cmd.size() - 1));
    }

    @Test
    public void testSparkRShell() throws Exception {
        List<String> sparkSubmitArgs = Arrays.asList("sparkr-shell-main", "--master=foo", "--deploy-mode=bar", "--conf", "spark.r.shell.command=/usr/bin/R");
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = this.buildCommand(sparkSubmitArgs, env);
        Assertions.assertEquals((Object)"/usr/bin/R", (Object)cmd.get(cmd.size() - 1));
        Object[] objectArray = new Object[3];
        Objects.requireNonNull(parser);
        objectArray[0] = "--master";
        Objects.requireNonNull(parser);
        objectArray[1] = "--deploy-mode";
        objectArray[2] = "sparkr-shell";
        Assertions.assertEquals((Object)String.format("\"%s\" \"foo\" \"%s\" \"bar\" \"--conf\" \"spark.r.shell.command=/usr/bin/R\" \"%s\"", objectArray), env.get("SPARKR_SUBMIT_ARGS"));
    }

    @Test
    public void testExamplesRunnerNoArg() {
        List<String> sparkSubmitArgs = Arrays.asList("run-example");
        HashMap env = new HashMap();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.buildCommand(sparkSubmitArgs, env));
    }

    @Test
    public void testExamplesRunnerNoMainClass() throws Exception {
        Objects.requireNonNull(parser);
        this.testCLIOpts("run-example", "--help", null);
        Objects.requireNonNull(parser);
        this.testCLIOpts("run-example", "--usage-error", null);
        Objects.requireNonNull(parser);
        this.testCLIOpts("run-example", "--version", null);
    }

    @Test
    public void testExamplesRunnerWithMasterNoMainClass() {
        String[] stringArray = new String[2];
        stringArray[0] = "run-example";
        Objects.requireNonNull(parser);
        stringArray[1] = "--master" + "=foo";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        HashMap env = new HashMap();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.buildCommand(sparkSubmitArgs, env), (String)"Missing example class name.");
    }

    @Test
    public void testExamplesRunner() throws Exception {
        String[] stringArray = new String[5];
        stringArray[0] = "run-example";
        Objects.requireNonNull(parser);
        stringArray[1] = "--master" + "=foo";
        Objects.requireNonNull(parser);
        stringArray[2] = "--deploy-mode" + "=bar";
        stringArray[3] = "SparkPi";
        stringArray[4] = "42";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = this.buildCommand(sparkSubmitArgs, env);
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"foo", (Object)this.findArgValue(cmd, "--master"));
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"bar", (Object)this.findArgValue(cmd, "--deploy-mode"));
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"org.apache.spark.examples.SparkPi", (Object)this.findArgValue(cmd, "--class"));
        Assertions.assertEquals((Object)"42", (Object)cmd.get(cmd.size() - 1));
    }

    @Test
    public void testExamplesRunnerPrimaryResource() {
        String[] stringArray = new String[5];
        stringArray[0] = "run-example";
        Objects.requireNonNull(parser);
        stringArray[1] = "--master" + "=foo";
        Objects.requireNonNull(parser);
        stringArray[2] = "--deploy-mode" + "=cluster";
        stringArray[3] = "SparkPi";
        stringArray[4] = "100";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        List cmd = this.newCommandBuilder(sparkSubmitArgs).buildSparkSubmitArgs();
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"org.apache.spark.examples.SparkPi", (Object)this.findArgValue(cmd, "--class"));
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"cluster", (Object)this.findArgValue(cmd, "--deploy-mode"));
        String primaryResource = (String)cmd.get(cmd.size() - 2);
        Assertions.assertTrue((primaryResource.equals("spark-internal") || new File(primaryResource).getName().startsWith("spark-examples") ? 1 : 0) != 0);
    }

    @Test
    public void testMissingAppResource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SparkSubmitCommandBuilder().buildSparkSubmitArgs());
    }

    @Test
    public void testIsClientMode() {
        SparkSubmitCommandBuilder builder = this.newCommandBuilder(Collections.emptyList());
        Assertions.assertTrue((boolean)builder.isClientMode(Collections.emptyMap()), (String)"By default application run in local mode");
        String[] stringArray = new String[2];
        Objects.requireNonNull(parser);
        stringArray[0] = "--master";
        stringArray[1] = "yarn";
        List<String> sparkSubmitArgs = Arrays.asList(stringArray);
        builder = this.newCommandBuilder(sparkSubmitArgs);
        Assertions.assertTrue((boolean)builder.isClientMode(Collections.emptyMap()), (String)"By default deploy mode is client");
        HashMap<String, String> userProps = new HashMap<String, String>();
        userProps.put("spark.submit.deployMode", "client");
        Assertions.assertTrue((boolean)builder.isClientMode(userProps));
    }

    private void testCmdBuilder(boolean isDriver, boolean useDefaultPropertyFile) throws Exception {
        String DRIVER_DEFAULT_PARAM = "-Ddriver-default";
        String DRIVER_EXTRA_PARAM = "-Ddriver-extra";
        String deployMode = isDriver ? "client" : "cluster";
        SparkSubmitCommandBuilder launcher = this.newCommandBuilder(Collections.emptyList());
        launcher.childEnv.put("SPARK_HOME", System.getProperty("spark.test.home"));
        launcher.master = "yarn";
        launcher.deployMode = deployMode;
        launcher.appResource = "/foo";
        launcher.appName = "MyApp";
        launcher.mainClass = "my.Class";
        launcher.appArgs.add("foo");
        launcher.appArgs.add("bar");
        launcher.conf.put("spark.foo", "foo");
        if (!useDefaultPropertyFile) {
            launcher.setPropertiesFile(dummyPropsFile.getAbsolutePath());
            launcher.conf.put("spark.driver.memory", "1g");
            launcher.conf.put("spark.driver.extraClassPath", "/driver");
            launcher.conf.put("spark.driver.defaultJavaOptions", "-Ddriver-default");
            launcher.conf.put("spark.driver.extraJavaOptions", "-Ddriver-extra");
            launcher.conf.put("spark.driver.extraLibraryPath", "/native");
        } else {
            launcher.childEnv.put("SPARK_CONF_DIR", System.getProperty("spark.test.home") + "/launcher/src/test/resources");
        }
        HashMap env = new HashMap();
        List cmd = launcher.buildCommand(env);
        if (isDriver) {
            Assertions.assertTrue((boolean)cmd.contains("-Xmx1g"), (String)"Driver -Xmx should be configured.");
            Assertions.assertTrue((boolean)cmd.contains("-Ddriver-default"), (String)"Driver default options should be configured.");
            Assertions.assertTrue((boolean)cmd.contains("-Ddriver-extra"), (String)"Driver extra options should be configured.");
        } else {
            boolean found = false;
            for (String arg : cmd) {
                if (!arg.startsWith("-Xmx")) continue;
                found = true;
                break;
            }
            Assertions.assertFalse((boolean)found, (String)"Memory arguments should not be set.");
            Assertions.assertFalse((boolean)cmd.contains("-Ddriver-default"), (String)"Driver default options should not be configured.");
            Assertions.assertFalse((boolean)cmd.contains("-Ddriver-extra"), (String)"Driver extra options should not be configured.");
        }
        String[] cp = this.findArgValue(cmd, "-cp").split(Pattern.quote(File.pathSeparator));
        if (isDriver) {
            Assertions.assertTrue((boolean)this.contains("/driver", cp), (String)"Driver classpath should contain provided entry.");
        } else {
            Assertions.assertFalse((boolean)this.contains("/driver", cp), (String)"Driver classpath should not be in command.");
        }
        String libPath = (String)env.get(CommandBuilderUtils.getLibPathEnvName());
        if (isDriver) {
            Assertions.assertNotNull((Object)libPath, (String)"Native library path should be set.");
            Assertions.assertTrue((boolean)this.contains("/native", libPath.split(Pattern.quote(File.pathSeparator))), (String)"Native library path should contain provided entry.");
        } else {
            Assertions.assertNull((Object)libPath, (String)"Native library should not be set.");
        }
        if (!useDefaultPropertyFile) {
            String string = dummyPropsFile.getAbsolutePath();
            Objects.requireNonNull(parser);
            Assertions.assertEquals((Object)string, (Object)this.findArgValue(cmd, "--properties-file"));
        }
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"yarn", (Object)this.findArgValue(cmd, "--master"));
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)deployMode, (Object)this.findArgValue(cmd, "--deploy-mode"));
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"my.Class", (Object)this.findArgValue(cmd, "--class"));
        Objects.requireNonNull(parser);
        Assertions.assertEquals((Object)"MyApp", (Object)this.findArgValue(cmd, "--name"));
        boolean appArgsOk = false;
        for (int i = 0; i < cmd.size(); ++i) {
            if (!((String)cmd.get(i)).equals("/foo")) continue;
            Assertions.assertEquals((Object)"foo", cmd.get(i + 1));
            Assertions.assertEquals((Object)"bar", cmd.get(i + 2));
            Assertions.assertEquals((int)cmd.size(), (int)(i + 3));
            appArgsOk = true;
            break;
        }
        Assertions.assertTrue((boolean)appArgsOk, (String)"App resource and args should be added to command.");
        Map<String, String> conf = this.parseConf(cmd, parser);
        Assertions.assertEquals((Object)"foo", (Object)conf.get("spark.foo"));
    }

    private boolean contains(String needle, String[] haystack) {
        for (String entry : haystack) {
            if (!entry.equals(needle)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> parseConf(List<String> cmd, SparkSubmitOptionParser parser) {
        HashMap<String, String> conf = new HashMap<String, String>();
        for (int i = 0; i < cmd.size(); ++i) {
            Objects.requireNonNull(parser);
            if (!cmd.get(i).equals("--conf")) continue;
            String[] val = cmd.get(i + 1).split("=", 2);
            conf.put(val[0], val[1]);
            ++i;
        }
        return conf;
    }

    private String findArgValue(List<String> cmd, String name) {
        for (int i = 0; i < cmd.size(); ++i) {
            if (!cmd.get(i).equals(name)) continue;
            return cmd.get(i + 1);
        }
        Assertions.fail((String)String.format("arg '%s' not found", name));
        return null;
    }

    private boolean findInStringList(String list, String sep, String needle) {
        return this.contains(needle, list.split(sep));
    }

    private SparkSubmitCommandBuilder newCommandBuilder(List<String> args) {
        SparkSubmitCommandBuilder builder = new SparkSubmitCommandBuilder(args);
        builder.childEnv.put("SPARK_HOME", System.getProperty("spark.test.home"));
        return builder;
    }

    private List<String> buildCommand(List<String> args, Map<String, String> env) throws Exception {
        return this.newCommandBuilder(args).buildCommand(env);
    }

    private void testCLIOpts(String appResource, String opt, List<String> params) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (appResource != null) {
            args.add(appResource);
        }
        args.add(opt);
        if (params != null) {
            args.addAll(params);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        List<String> cmd = this.buildCommand(args, env);
        Assertions.assertTrue((boolean)cmd.contains(opt), (String)(opt + " should be contained in the final cmd."));
    }
}

