/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.spark.launcher.BaseSuite;
import org.apache.spark.launcher.ChildProcAppHandle;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ChildProcAppHandleSuite
extends BaseSuite {
    private static final List<String> MESSAGES = new ArrayList<String>();
    private static final List<String> TEST_SCRIPT = Arrays.asList("#!/bin/sh", "echo \"output\"", "echo \"error\" 1>&2", "while [ -n \"$1\" ]; do EC=$1; shift; done", "exit $EC");
    private static File TEST_SCRIPT_PATH;

    @AfterAll
    public static void cleanupClass() throws Exception {
        if (TEST_SCRIPT_PATH != null) {
            TEST_SCRIPT_PATH.delete();
            TEST_SCRIPT_PATH = null;
        }
    }

    @BeforeAll
    public static void setupClass() throws Exception {
        TEST_SCRIPT_PATH = File.createTempFile("output-redir-test", ".sh");
        Files.setPosixFilePermissions(TEST_SCRIPT_PATH.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE));
        Files.write(TEST_SCRIPT_PATH.toPath(), TEST_SCRIPT, new OpenOption[0]);
    }

    @BeforeEach
    public void cleanupLog() {
        MESSAGES.clear();
    }

    @Test
    public void testRedirectsSimple() throws Exception {
        SparkLauncher launcher = new SparkLauncher();
        launcher.redirectError(ProcessBuilder.Redirect.PIPE);
        Assertions.assertNotNull((Object)launcher.errorStream);
        Assertions.assertEquals((Object)((Object)ProcessBuilder.Redirect.Type.PIPE), (Object)((Object)launcher.errorStream.type()));
        launcher.redirectOutput(ProcessBuilder.Redirect.PIPE);
        Assertions.assertNotNull((Object)launcher.outputStream);
        Assertions.assertEquals((Object)((Object)ProcessBuilder.Redirect.Type.PIPE), (Object)((Object)launcher.outputStream.type()));
    }

    @Test
    public void testRedirectLastWins() throws Exception {
        SparkLauncher launcher = new SparkLauncher();
        launcher.redirectError(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT);
        Assertions.assertEquals((Object)((Object)ProcessBuilder.Redirect.Type.INHERIT), (Object)((Object)launcher.errorStream.type()));
        launcher.redirectOutput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Assertions.assertEquals((Object)((Object)ProcessBuilder.Redirect.Type.INHERIT), (Object)((Object)launcher.outputStream.type()));
    }

    @Test
    public void testRedirectToLog() throws Exception {
        Assumptions.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        ChildProcAppHandle handle = (ChildProcAppHandle)new TestSparkLauncher().startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor((SparkAppHandle)handle);
        Assertions.assertTrue((boolean)MESSAGES.contains("output"));
        Assertions.assertTrue((boolean)MESSAGES.contains("error"));
    }

    @Test
    public void testRedirectErrorToLog() throws Exception {
        Assumptions.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        Path err = Files.createTempFile("stderr", "txt", new FileAttribute[0]);
        err.toFile().deleteOnExit();
        ChildProcAppHandle handle = (ChildProcAppHandle)new TestSparkLauncher().redirectError(err.toFile()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor((SparkAppHandle)handle);
        Assertions.assertTrue((boolean)MESSAGES.contains("output"));
        try (Stream<String> lines = Files.lines(err);){
            Assertions.assertEquals(Arrays.asList("error"), lines.collect(Collectors.toList()));
        }
    }

    @Test
    public void testRedirectOutputToLog() throws Exception {
        Assumptions.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        Path out = Files.createTempFile("stdout", "txt", new FileAttribute[0]);
        out.toFile().deleteOnExit();
        ChildProcAppHandle handle = (ChildProcAppHandle)new TestSparkLauncher().redirectOutput(out.toFile()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor((SparkAppHandle)handle);
        Assertions.assertTrue((boolean)MESSAGES.contains("error"));
        try (Stream<String> lines = Files.lines(out);){
            Assertions.assertEquals(Arrays.asList("output"), lines.collect(Collectors.toList()));
        }
    }

    @Test
    public void testNoRedirectToLog() throws Exception {
        Assumptions.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        Path out = Files.createTempFile("stdout", "txt", new FileAttribute[0]);
        Path err = Files.createTempFile("stderr", "txt", new FileAttribute[0]);
        out.toFile().deleteOnExit();
        err.toFile().deleteOnExit();
        ChildProcAppHandle handle = (ChildProcAppHandle)new TestSparkLauncher().redirectError(err.toFile()).redirectOutput(out.toFile()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor((SparkAppHandle)handle);
        Assertions.assertTrue((boolean)MESSAGES.isEmpty());
        try (Stream<String> lines = Files.lines(err);){
            Assertions.assertEquals(Arrays.asList("error"), lines.collect(Collectors.toList()));
        }
        lines = Files.lines(out);
        try {
            Assertions.assertEquals(Arrays.asList("output"), lines.collect(Collectors.toList()));
        }
        finally {
            if (lines != null) {
                lines.close();
            }
        }
    }

    @Test
    public void testBadLogRedirect() throws Exception {
        File out = Files.createTempFile("stdout", "txt", new FileAttribute[0]).toFile();
        out.deleteOnExit();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SparkLauncher().redirectError().redirectOutput(out).redirectToLog("foo").launch().waitFor());
    }

    @Test
    public void testRedirectErrorTwiceFails() throws Exception {
        File err = Files.createTempFile("stderr", "txt", new FileAttribute[0]).toFile();
        err.deleteOnExit();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SparkLauncher().redirectError().redirectError(err).launch().waitFor());
    }

    @Test
    public void testProcMonitorWithOutputRedirection() throws Exception {
        Assumptions.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        File err = Files.createTempFile("out", "txt", new FileAttribute[0]).toFile();
        err.deleteOnExit();
        SparkAppHandle handle = new TestSparkLauncher().redirectError().redirectOutput(err).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor(handle);
        Assertions.assertEquals((Object)SparkAppHandle.State.LOST, (Object)handle.getState());
    }

    @Test
    public void testProcMonitorWithLogRedirection() throws Exception {
        Assumptions.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        SparkAppHandle handle = new TestSparkLauncher().redirectToLog(this.getClass().getName()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor(handle);
        Assertions.assertEquals((Object)SparkAppHandle.State.LOST, (Object)handle.getState());
    }

    @Test
    public void testFailedChildProc() throws Exception {
        Assumptions.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        SparkAppHandle handle = new TestSparkLauncher(1).redirectToLog(this.getClass().getName()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor(handle);
        Assertions.assertEquals((Object)SparkAppHandle.State.FAILED, (Object)handle.getState());
    }

    private static class TestSparkLauncher
    extends SparkLauncher {
        TestSparkLauncher() {
            this(0);
        }

        TestSparkLauncher(int ec) {
            this.setAppResource("outputredirtest");
            this.addAppArgs(new String[]{String.valueOf(ec)});
        }

        String findSparkSubmit() {
            return TEST_SCRIPT_PATH.getAbsolutePath();
        }
    }

    @Plugin(name="LogAppender", category="Core", elementType="appender", printObject=true)
    public static class LogAppender
    extends AbstractAppender {
        protected LogAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
            super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        }

        public void append(LogEvent event) {
            MESSAGES.add(event.getMessage().toString());
        }

        @PluginFactory
        public static LogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="otherAttribute") String otherAttribute) {
            return new LogAppender(name, filter, layout, false);
        }
    }
}

