/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandBuilderUtilsSuite {
    @Test
    public void testValidOptionStrings() {
        CommandBuilderUtilsSuite.testOpt("a b c d e", Arrays.asList("a", "b", "c", "d", "e"));
        CommandBuilderUtilsSuite.testOpt("a 'b c' \"d\" e", Arrays.asList("a", "b c", "d", "e"));
        CommandBuilderUtilsSuite.testOpt("a 'b\\\"c' \"'d'\" e", Arrays.asList("a", "b\\\"c", "'d'", "e"));
        CommandBuilderUtilsSuite.testOpt("a 'b\"c' \"\\\"d\\\"\" e", Arrays.asList("a", "b\"c", "\"d\"", "e"));
        CommandBuilderUtilsSuite.testOpt(" a b c \\\\ ", Arrays.asList("a", "b", "c", "\\"));
        CommandBuilderUtilsSuite.testOpt("", new ArrayList<String>());
        CommandBuilderUtilsSuite.testOpt("a", Arrays.asList("a"));
        CommandBuilderUtilsSuite.testOpt("aaa", Arrays.asList("aaa"));
        CommandBuilderUtilsSuite.testOpt("a b c", Arrays.asList("a", "b", "c"));
        CommandBuilderUtilsSuite.testOpt("  a   b\t c ", Arrays.asList("a", "b", "c"));
        CommandBuilderUtilsSuite.testOpt("a 'b c'", Arrays.asList("a", "b c"));
        CommandBuilderUtilsSuite.testOpt("a 'b c' d", Arrays.asList("a", "b c", "d"));
        CommandBuilderUtilsSuite.testOpt("'b c'", Arrays.asList("b c"));
        CommandBuilderUtilsSuite.testOpt("a \"b c\"", Arrays.asList("a", "b c"));
        CommandBuilderUtilsSuite.testOpt("a \"b c\" d", Arrays.asList("a", "b c", "d"));
        CommandBuilderUtilsSuite.testOpt("\"b c\"", Arrays.asList("b c"));
        CommandBuilderUtilsSuite.testOpt("a 'b\" c' \"d' e\"", Arrays.asList("a", "b\" c", "d' e"));
        CommandBuilderUtilsSuite.testOpt("a\t'b\nc'\nd", Arrays.asList("a", "b\nc", "d"));
        CommandBuilderUtilsSuite.testOpt("a \"b\\\\c\"", Arrays.asList("a", "b\\c"));
        CommandBuilderUtilsSuite.testOpt("a \"b\\\"c\"", Arrays.asList("a", "b\"c"));
        CommandBuilderUtilsSuite.testOpt("a 'b\\\"c'", Arrays.asList("a", "b\\\"c"));
        CommandBuilderUtilsSuite.testOpt("'a'b", Arrays.asList("ab"));
        CommandBuilderUtilsSuite.testOpt("'a''b'", Arrays.asList("ab"));
        CommandBuilderUtilsSuite.testOpt("\"a\"b", Arrays.asList("ab"));
        CommandBuilderUtilsSuite.testOpt("\"a\"\"b\"", Arrays.asList("ab"));
        CommandBuilderUtilsSuite.testOpt("''", Arrays.asList(""));
        CommandBuilderUtilsSuite.testOpt("\"\"", Arrays.asList(""));
    }

    @Test
    public void testInvalidOptionStrings() {
        CommandBuilderUtilsSuite.testInvalidOpt("\\");
        CommandBuilderUtilsSuite.testInvalidOpt("\"abcde");
        CommandBuilderUtilsSuite.testInvalidOpt("'abcde");
    }

    @Test
    public void testWindowsBatchQuoting() {
        Assertions.assertEquals((Object)"abc", (Object)CommandBuilderUtils.quoteForBatchScript((String)"abc"));
        Assertions.assertEquals((Object)"\"a b c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a b c"));
        Assertions.assertEquals((Object)"\"a \"\"b\"\" c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a \"b\" c"));
        Assertions.assertEquals((Object)"\"a\"\"b\"\"c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a\"b\"c"));
        Assertions.assertEquals((Object)"\"ab=\"\"cd\"\"\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"ab=\"cd\""));
        Assertions.assertEquals((Object)"\"a,b,c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a,b,c"));
        Assertions.assertEquals((Object)"\"a;b;c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a;b;c"));
        Assertions.assertEquals((Object)"\"a,b,c\\\\\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a,b,c\\"));
    }

    @Test
    public void testPythonArgQuoting() {
        Assertions.assertEquals((Object)"\"abc\"", (Object)CommandBuilderUtils.quoteForCommandString((String)"abc"));
        Assertions.assertEquals((Object)"\"a b c\"", (Object)CommandBuilderUtils.quoteForCommandString((String)"a b c"));
        Assertions.assertEquals((Object)"\"a \\\"b\\\" c\"", (Object)CommandBuilderUtils.quoteForCommandString((String)"a \"b\" c"));
    }

    @Test
    public void testJavaMajorVersion() {
        Assertions.assertEquals((int)6, (int)CommandBuilderUtils.javaMajorVersion((String)"1.6.0_50"));
        Assertions.assertEquals((int)7, (int)CommandBuilderUtils.javaMajorVersion((String)"1.7.0_79"));
        Assertions.assertEquals((int)8, (int)CommandBuilderUtils.javaMajorVersion((String)"1.8.0_66"));
        Assertions.assertEquals((int)9, (int)CommandBuilderUtils.javaMajorVersion((String)"9-ea"));
        Assertions.assertEquals((int)9, (int)CommandBuilderUtils.javaMajorVersion((String)"9+100"));
        Assertions.assertEquals((int)9, (int)CommandBuilderUtils.javaMajorVersion((String)"9"));
        Assertions.assertEquals((int)9, (int)CommandBuilderUtils.javaMajorVersion((String)"9.1.0"));
        Assertions.assertEquals((int)10, (int)CommandBuilderUtils.javaMajorVersion((String)"10"));
    }

    private static void testOpt(String opts, List<String> expected) {
        Assertions.assertEquals(expected, (Object)CommandBuilderUtils.parseOptionString((String)opts), (String)String.format("test string failed to parse: [[ %s ]]", opts));
    }

    private static void testInvalidOpt(String opts) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandBuilderUtils.parseOptionString((String)opts));
    }
}

