/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.time.Duration;
import org.apache.spark.launcher.AbstractAppHandle;
import org.apache.spark.launcher.LauncherServer;
import org.apache.spark.launcher.SparkAppHandle;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.slf4j.bridge.SLF4JBridgeHandler;

class BaseSuite {
    BaseSuite() {
    }

    @AfterEach
    public void postChecks() {
        LauncherServer server = LauncherServer.getServer();
        if (server != null) {
            try {
                server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Assertions.assertNull((Object)server);
    }

    protected void waitFor(SparkAppHandle handle) throws Exception {
        try {
            this.eventually(Duration.ofSeconds(10L), Duration.ofMillis(10L), () -> Assertions.assertTrue((boolean)handle.getState().isFinal(), (String)"Handle is not in final state."));
        }
        finally {
            if (!handle.getState().isFinal()) {
                handle.kill();
            }
        }
        AbstractAppHandle ahandle = (AbstractAppHandle)handle;
        this.eventually(Duration.ofSeconds(10L), Duration.ofMillis(10L), () -> Assertions.assertTrue((boolean)ahandle.isDisposed(), (String)"Handle is still not marked as disposed."));
    }

    protected void eventually(Duration timeout, Duration period, Runnable check) throws Exception {
        Assertions.assertTrue((timeout.compareTo(period) > 0 ? 1 : 0) != 0, (String)"Timeout needs to be larger than period.");
        long deadline = System.nanoTime() + timeout.toNanos();
        int count = 0;
        while (true) {
            try {
                ++count;
                check.run();
                return;
            }
            catch (Throwable t) {
                if (System.nanoTime() >= deadline) {
                    String msg = String.format("Failed check after %d tries: %s.", count, t.getMessage());
                    throw new IllegalStateException(msg, t);
                }
                Thread.sleep(period.toMillis());
                continue;
            }
            break;
        }
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

