/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.launcher.AbstractAppHandle;
import org.apache.spark.launcher.BaseSuite;
import org.apache.spark.launcher.ChildProcAppHandle;
import org.apache.spark.launcher.LauncherConnection;
import org.apache.spark.launcher.LauncherProtocol;
import org.apache.spark.launcher.LauncherServer;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.junit.Assert;
import org.junit.Test;

public class LauncherServerSuite
extends BaseSuite {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLauncherServerReuse() throws Exception {
        LauncherServer server1 = LauncherServer.getOrCreateServer();
        ChildProcAppHandle handle = new ChildProcAppHandle(server1);
        handle.kill();
        LauncherServer server2 = LauncherServer.getOrCreateServer();
        try {
            Assert.assertNotSame((Object)server1, (Object)server2);
        }
        finally {
            server2.unref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommunication() throws Exception {
        LauncherServer server = LauncherServer.getOrCreateServer();
        ChildProcAppHandle handle = new ChildProcAppHandle(server);
        String secret = server.registerHandle((AbstractAppHandle)handle);
        TestClient client = null;
        try {
            Socket s = new Socket(InetAddress.getLoopbackAddress(), server.getPort());
            final Semaphore semaphore = new Semaphore(0);
            handle.addListener(new SparkAppHandle.Listener(){

                public void stateChanged(SparkAppHandle handle) {
                    semaphore.release();
                }

                public void infoChanged(SparkAppHandle handle) {
                    semaphore.release();
                }
            });
            client = new TestClient(s);
            client.send((LauncherProtocol.Message)new LauncherProtocol.Hello(secret, "1.4.0"));
            Assert.assertTrue((boolean)semaphore.tryAcquire(30L, TimeUnit.SECONDS));
            Assert.assertNotNull((Object)handle.getConnection());
            client.send((LauncherProtocol.Message)new LauncherProtocol.SetAppId("app-id"));
            Assert.assertTrue((boolean)semaphore.tryAcquire(30L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)"app-id", (Object)handle.getAppId());
            client.send((LauncherProtocol.Message)new LauncherProtocol.SetState(SparkAppHandle.State.RUNNING));
            Assert.assertTrue((boolean)semaphore.tryAcquire(1L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)SparkAppHandle.State.RUNNING, (Object)handle.getState());
            handle.stop();
            LauncherProtocol.Message stopMsg = client.inbound.poll(30L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)(stopMsg instanceof LauncherProtocol.Stop));
            this.close((Closeable)((Object)client));
        }
        catch (Throwable throwable) {
            this.close((Closeable)((Object)client));
            handle.kill();
            client.clientThread.join();
            throw throwable;
        }
        handle.kill();
        client.clientThread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() throws Exception {
        LauncherServer server = LauncherServer.getOrCreateServer();
        ChildProcAppHandle handle = new ChildProcAppHandle(server);
        String secret = server.registerHandle((AbstractAppHandle)handle);
        TestClient client = null;
        try {
            SparkLauncher.setConfig((String)"spark.launcher.childConnectionTimeout", (String)"0");
            Socket s = new Socket(InetAddress.getLoopbackAddress(), server.getPort());
            client = new TestClient(s);
            this.waitForError(client, secret);
            SparkLauncher.launcherConfig.remove("spark.launcher.childConnectionTimeout");
        }
        catch (Throwable throwable) {
            SparkLauncher.launcherConfig.remove("spark.launcher.childConnectionTimeout");
            handle.kill();
            this.close((Closeable)((Object)client));
            throw throwable;
        }
        handle.kill();
        this.close((Closeable)((Object)client));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSparkSubmitVmShutsDown() throws Exception {
        LauncherServer server = LauncherServer.getOrCreateServer();
        ChildProcAppHandle handle = new ChildProcAppHandle(server);
        String secret = server.registerHandle((AbstractAppHandle)handle);
        TestClient client = null;
        final Semaphore semaphore = new Semaphore(0);
        try {
            Socket s = new Socket(InetAddress.getLoopbackAddress(), server.getPort());
            handle.addListener(new SparkAppHandle.Listener(){

                public void stateChanged(SparkAppHandle handle) {
                    semaphore.release();
                }

                public void infoChanged(SparkAppHandle handle) {
                    semaphore.release();
                }
            });
            client = new TestClient(s);
            client.send((LauncherProtocol.Message)new LauncherProtocol.Hello(secret, "1.4.0"));
            Assert.assertTrue((boolean)semaphore.tryAcquire(30L, TimeUnit.SECONDS));
            Assert.assertNotNull((Object)handle.getConnection());
            client.close();
            handle.dispose();
            Assert.assertTrue((boolean)semaphore.tryAcquire(30L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)SparkAppHandle.State.LOST, (Object)handle.getState());
        }
        catch (Throwable throwable) {
            handle.kill();
            this.close((Closeable)((Object)client));
            client.clientThread.join();
            throw throwable;
        }
        handle.kill();
        this.close((Closeable)((Object)client));
        client.clientThread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamFiltering() throws Exception {
        LauncherServer server = LauncherServer.getOrCreateServer();
        ChildProcAppHandle handle = new ChildProcAppHandle(server);
        String secret = server.registerHandle((AbstractAppHandle)handle);
        TestClient client = null;
        try {
            Socket s = new Socket(InetAddress.getLoopbackAddress(), server.getPort());
            client = new TestClient(s);
            try {
                client.send(new EvilPayload());
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.waitForError(client, secret);
            Assert.assertEquals((long)0L, (long)EvilPayload.EVIL_BIT);
        }
        catch (Throwable throwable) {
            handle.kill();
            this.close((Closeable)((Object)client));
            client.clientThread.join();
            throw throwable;
        }
        handle.kill();
        this.close((Closeable)((Object)client));
        client.clientThread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppHandleDisconnect() throws Exception {
        LauncherServer server = LauncherServer.getOrCreateServer();
        ChildProcAppHandle handle = new ChildProcAppHandle(server);
        String secret = server.registerHandle((AbstractAppHandle)handle);
        TestClient client = null;
        try {
            Socket s = new Socket(InetAddress.getLoopbackAddress(), server.getPort());
            client = new TestClient(s);
            client.send((LauncherProtocol.Message)new LauncherProtocol.Hello(secret, "1.4.0"));
            client.send((LauncherProtocol.Message)new LauncherProtocol.SetAppId("someId"));
            this.eventually(Duration.ofSeconds(1L), Duration.ofMillis(10L), () -> Assert.assertEquals((Object)"someId", (Object)handle.getAppId()));
            handle.disconnect();
            this.waitForError(client, secret);
        }
        catch (Throwable throwable) {
            handle.kill();
            this.close((Closeable)((Object)client));
            client.clientThread.join();
            throw throwable;
        }
        handle.kill();
        this.close((Closeable)((Object)client));
        client.clientThread.join();
    }

    private void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void waitForError(TestClient client, String secret) throws Exception {
        AtomicBoolean helloSent = new AtomicBoolean();
        this.eventually(Duration.ofSeconds(1L), Duration.ofMillis(10L), () -> {
            if (!helloSent.get()) {
                if (client.isOpen()) {
                    Assert.assertThrows(IOException.class, () -> client.send((LauncherProtocol.Message)new LauncherProtocol.SetAppId("appId")));
                } else {
                    Assert.assertThrows(IllegalStateException.class, () -> client.send((LauncherProtocol.Message)new LauncherProtocol.Hello(secret, "1.4.0")));
                    helloSent.set(true);
                }
            }
        });
    }

    private static class EvilPayload
    extends LauncherProtocol.Message {
        static int EVIL_BIT = 0;
        private List<String> notAllowedField = Arrays.asList("disallowed");

        private EvilPayload() {
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            EVIL_BIT = 1;
        }
    }

    private static class TestClient
    extends LauncherConnection {
        final BlockingQueue<LauncherProtocol.Message> inbound = new LinkedBlockingQueue<LauncherProtocol.Message>();
        final Thread clientThread = new Thread((Runnable)((Object)this));

        TestClient(Socket s) throws IOException {
            super(s);
            this.clientThread.setName("TestClient");
            this.clientThread.setDaemon(true);
            this.clientThread.start();
        }

        protected void handle(LauncherProtocol.Message msg) throws IOException {
            this.inbound.offer(msg);
        }
    }
}

