/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.junit.Assert;
import org.junit.Test;

public class CommandBuilderUtilsSuite {
    @Test
    public void testValidOptionStrings() {
        CommandBuilderUtilsSuite.testOpt("a b c d e", Arrays.asList("a", "b", "c", "d", "e"));
        CommandBuilderUtilsSuite.testOpt("a 'b c' \"d\" e", Arrays.asList("a", "b c", "d", "e"));
        CommandBuilderUtilsSuite.testOpt("a 'b\\\"c' \"'d'\" e", Arrays.asList("a", "b\\\"c", "'d'", "e"));
        CommandBuilderUtilsSuite.testOpt("a 'b\"c' \"\\\"d\\\"\" e", Arrays.asList("a", "b\"c", "\"d\"", "e"));
        CommandBuilderUtilsSuite.testOpt(" a b c \\\\ ", Arrays.asList("a", "b", "c", "\\"));
        CommandBuilderUtilsSuite.testOpt("", new ArrayList<String>());
        CommandBuilderUtilsSuite.testOpt("a", Arrays.asList("a"));
        CommandBuilderUtilsSuite.testOpt("aaa", Arrays.asList("aaa"));
        CommandBuilderUtilsSuite.testOpt("a b c", Arrays.asList("a", "b", "c"));
        CommandBuilderUtilsSuite.testOpt("  a   b\t c ", Arrays.asList("a", "b", "c"));
        CommandBuilderUtilsSuite.testOpt("a 'b c'", Arrays.asList("a", "b c"));
        CommandBuilderUtilsSuite.testOpt("a 'b c' d", Arrays.asList("a", "b c", "d"));
        CommandBuilderUtilsSuite.testOpt("'b c'", Arrays.asList("b c"));
        CommandBuilderUtilsSuite.testOpt("a \"b c\"", Arrays.asList("a", "b c"));
        CommandBuilderUtilsSuite.testOpt("a \"b c\" d", Arrays.asList("a", "b c", "d"));
        CommandBuilderUtilsSuite.testOpt("\"b c\"", Arrays.asList("b c"));
        CommandBuilderUtilsSuite.testOpt("a 'b\" c' \"d' e\"", Arrays.asList("a", "b\" c", "d' e"));
        CommandBuilderUtilsSuite.testOpt("a\t'b\nc'\nd", Arrays.asList("a", "b\nc", "d"));
        CommandBuilderUtilsSuite.testOpt("a \"b\\\\c\"", Arrays.asList("a", "b\\c"));
        CommandBuilderUtilsSuite.testOpt("a \"b\\\"c\"", Arrays.asList("a", "b\"c"));
        CommandBuilderUtilsSuite.testOpt("a 'b\\\"c'", Arrays.asList("a", "b\\\"c"));
        CommandBuilderUtilsSuite.testOpt("'a'b", Arrays.asList("ab"));
        CommandBuilderUtilsSuite.testOpt("'a''b'", Arrays.asList("ab"));
        CommandBuilderUtilsSuite.testOpt("\"a\"b", Arrays.asList("ab"));
        CommandBuilderUtilsSuite.testOpt("\"a\"\"b\"", Arrays.asList("ab"));
        CommandBuilderUtilsSuite.testOpt("''", Arrays.asList(""));
        CommandBuilderUtilsSuite.testOpt("\"\"", Arrays.asList(""));
    }

    @Test
    public void testInvalidOptionStrings() {
        CommandBuilderUtilsSuite.testInvalidOpt("\\");
        CommandBuilderUtilsSuite.testInvalidOpt("\"abcde");
        CommandBuilderUtilsSuite.testInvalidOpt("'abcde");
    }

    @Test
    public void testRedactCommandLineArgs() {
        Assert.assertEquals((Object)CommandBuilderUtils.redact((String)"secret"), (Object)"secret");
        Assert.assertEquals((Object)CommandBuilderUtils.redact((String)"-Dk=v"), (Object)"-Dk=v");
        Assert.assertEquals((Object)CommandBuilderUtils.redact((String)"-Dk=secret"), (Object)"-Dk=secret");
        Assert.assertEquals((Object)CommandBuilderUtils.redact((String)"-DsecretKey=my-secret"), (Object)"-DsecretKey=*********(redacted)");
        Assert.assertEquals((Object)CommandBuilderUtils.redactCommandLineArgs(Arrays.asList("-DsecretKey=my-secret")), Arrays.asList("-DsecretKey=*********(redacted)"));
    }

    @Test
    public void testWindowsBatchQuoting() {
        Assert.assertEquals((Object)"abc", (Object)CommandBuilderUtils.quoteForBatchScript((String)"abc"));
        Assert.assertEquals((Object)"\"a b c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a b c"));
        Assert.assertEquals((Object)"\"a \"\"b\"\" c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a \"b\" c"));
        Assert.assertEquals((Object)"\"a\"\"b\"\"c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a\"b\"c"));
        Assert.assertEquals((Object)"\"ab=\"\"cd\"\"\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"ab=\"cd\""));
        Assert.assertEquals((Object)"\"a,b,c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a,b,c"));
        Assert.assertEquals((Object)"\"a;b;c\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a;b;c"));
        Assert.assertEquals((Object)"\"a,b,c\\\\\"", (Object)CommandBuilderUtils.quoteForBatchScript((String)"a,b,c\\"));
    }

    @Test
    public void testPythonArgQuoting() {
        Assert.assertEquals((Object)"\"abc\"", (Object)CommandBuilderUtils.quoteForCommandString((String)"abc"));
        Assert.assertEquals((Object)"\"a b c\"", (Object)CommandBuilderUtils.quoteForCommandString((String)"a b c"));
        Assert.assertEquals((Object)"\"a \\\"b\\\" c\"", (Object)CommandBuilderUtils.quoteForCommandString((String)"a \"b\" c"));
    }

    @Test
    public void testJavaMajorVersion() {
        Assert.assertEquals((long)6L, (long)CommandBuilderUtils.javaMajorVersion((String)"1.6.0_50"));
        Assert.assertEquals((long)7L, (long)CommandBuilderUtils.javaMajorVersion((String)"1.7.0_79"));
        Assert.assertEquals((long)8L, (long)CommandBuilderUtils.javaMajorVersion((String)"1.8.0_66"));
        Assert.assertEquals((long)9L, (long)CommandBuilderUtils.javaMajorVersion((String)"9-ea"));
        Assert.assertEquals((long)9L, (long)CommandBuilderUtils.javaMajorVersion((String)"9+100"));
        Assert.assertEquals((long)9L, (long)CommandBuilderUtils.javaMajorVersion((String)"9"));
        Assert.assertEquals((long)9L, (long)CommandBuilderUtils.javaMajorVersion((String)"9.1.0"));
        Assert.assertEquals((long)10L, (long)CommandBuilderUtils.javaMajorVersion((String)"10"));
    }

    private static void testOpt(String opts, List<String> expected) {
        Assert.assertEquals((String)String.format("test string failed to parse: [[ %s ]]", opts), expected, (Object)CommandBuilderUtils.parseOptionString((String)opts));
    }

    private static void testInvalidOpt(String opts) {
        Assert.assertThrows(IllegalArgumentException.class, () -> CommandBuilderUtils.parseOptionString((String)opts));
    }
}

