/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileBuilder;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.StatefulSetPodsAllocator;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tMd\u0001\u0002\u001d:\u0001\u0019CQ!\u0015\u0001\u0005\u0002ICq!\u0016\u0001C\u0002\u0013%a\u000b\u0003\u0004`\u0001\u0001\u0006Ia\u0016\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019\u0001\b\u0001)A\u0005E\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0004x\u0001\t\u0007I\u0011\u0002=\t\r}\u0004\u0001\u0015!\u0003z\u0011!\t\t\u0001\u0001b\u0001\n\u0013A\bbBA\u0002\u0001\u0001\u0006I!\u001f\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"a\u0004\u0001A\u0003%\u0011\u0011\u0002\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0002C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0002bCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003+A1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H!Y\u0011Q\u000b\u0001A\u0002\u0003\u0007I\u0011BA,\u0011-\tY\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0013\t\u0017\u0005}\u0003\u00011AA\u0002\u0013%\u0011\u0011\r\u0005\f\u0003#\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019\nC\u0006\u0002\u0018\u0002\u0001\r\u0011!Q!\n\u0005\r\u0004bCAN\u0001\u0001\u0007\t\u0019!C\u0005\u0003;C1\"!*\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(\"Y\u00111\u0016\u0001A\u0002\u0003\u0005\u000b\u0015BAP\u0011-\ty\u000b\u0001a\u0001\u0002\u0004%I!!-\t\u0017\u0005e\u0006\u00011AA\u0002\u0013%\u00111\u0018\u0005\f\u0003\u007f\u0003\u0001\u0019!A!B\u0013\t\u0019\fC\u0006\u0002D\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0007bCAg\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fD1\"a5\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H\"Y\u0011q\u001b\u0001A\u0002\u0003\u0007I\u0011BAm\u0011-\t\t\u000f\u0001a\u0001\u0002\u0004%I!a9\t\u0017\u0005\u001d\b\u00011A\u0001B\u0003&\u00111\u001c\u0005\f\u0003W\u0004\u0001\u0019!a\u0001\n\u0013\ti\u000fC\u0006\u0002v\u0002\u0001\r\u00111A\u0005\n\u0005]\bbCA~\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_D1\"a@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002n\"Y!\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0002\u0011-\u00119\u0001\u0001a\u0001\u0002\u0003\u0006K!a<\t\u0017\t-\u0001\u00011AA\u0002\u0013%!Q\u0002\u0005\f\u0005+\u0001\u0001\u0019!a\u0001\n\u0013\u00119\u0002C\u0006\u0003\u001c\u0001\u0001\r\u0011!Q!\n\t=\u0001b\u0003B\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0005?A1Ba\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003*!Y!Q\u0006\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u0011\u0011-\u0011y\u0003\u0001a\u0001\u0002\u0004%IA!\r\t\u0017\te\u0002\u00011AA\u0002\u0013%!1\b\u0005\f\u0005\u007f\u0001\u0001\u0019!A!B\u0013\u0011\u0019\u0004C\u0006\u0003D\u0001\u0001\r\u00111A\u0005\n\t\u0015\u0003b\u0003B'\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u001fB1Ba\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003H!A!q\u000b\u0001C\u0002\u0013\u0005a\u000bC\u0004\u0003Z\u0001\u0001\u000b\u0011B,\t\u000f\tm\u0003\u0001\"\u0003\u0003^\tI2\u000b^1uK\u001a,HnU3u\u00032dwnY1u_J\u001cV/\u001b;f\u0015\tQ4(A\u0002lqMT!\u0001P\u001f\u0002\u000f\rdWo\u001d;fe*\u0011ahP\u0001\ng\u000eDW\rZ;mKJT!\u0001Q!\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001b\u0015AB1qC\u000eDWMC\u0001E\u0003\ry'oZ\u0002\u0001'\r\u0001qi\u0013\t\u0003\u0011&k\u0011aP\u0005\u0003\u0015~\u0012Qb\u00159be.4UO\\*vSR,\u0007C\u0001'P\u001b\u0005i%B\u0001(D\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002Q\u001b\nq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001T!\t!\u0006!D\u0001:\u00035!'/\u001b<feB{GMT1nKV\tq\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006!A.\u00198h\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX-\u0003\rM#(/\u001b8h\u00039!'/\u001b<feB{GMT1nK\u0002\n\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0016\u0003\t\u0004\"a\u00198\u000e\u0003\u0011T!!\u001a4\u0002\u000b5|G-\u001a7\u000b\u0005\u001dD\u0017aA1qS*\u0011\u0011N[\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(BA6m\u0003\u001d1\u0017M\u0019:jGbR\u0011!\\\u0001\u0003S>L!a\u001c3\u0003\u0007A{G-\u0001\u0006ee&4XM\u001d)pI\u0002\nAaY8oMV\t1\u000f\u0005\u0002Ii&\u0011Qo\u0010\u0002\n'B\f'o[\"p]\u001a\fQaY8oM\u0002\na\u0002Z3gCVdG\u000f\u0015:pM&dW-F\u0001z!\tQX0D\u0001|\u0015\tax(\u0001\u0005sKN|WO]2f\u0013\tq8PA\bSKN|WO]2f!J|g-\u001b7f\u0003=!WMZ1vYR\u0004&o\u001c4jY\u0016\u0004\u0013!D:fG>tG\r\u0015:pM&dW-\u0001\btK\u000e|g\u000e\u001a)s_\u001aLG.\u001a\u0011\u0002\rM,7-T4s+\t\tI\u0001E\u0002I\u0003\u0017I1!!\u0004@\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\u0018aB:fG6;'\u000fI\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R,\"!!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007i\u0003\u0019\u0019G.[3oi&!\u0011qDA\r\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG/\u0001\u000blk\n,'O\\3uKN\u001cE.[3oi~#S-\u001d\u000b\u0005\u0003K\t\t\u0004\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\t\tY#A\u0003tG\u0006d\u0017-\u0003\u0003\u00020\u0005%\"\u0001B+oSRD\u0011\"a\r\u0010\u0003\u0003\u0005\r!!\u0006\u0002\u0007a$\u0013'A\tlk\n,'O\\3uKN\u001cE.[3oi\u0002B3\u0001EA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \u0007\u00069Qn\\2lSR|\u0017\u0002BA\"\u0003{\u0011A!T8dW\u0006i\u0011\r\u001d9Pa\u0016\u0014\u0018\r^5p]N,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bRA!a\u0014\u0002\u001a\u0005\u0019Am\u001d7\n\t\u0005M\u0013Q\n\u0002\u0010\u0003B\u00048/\u0011)J\u000fJ|W\u000f\u001d#T\u0019\u0006\t\u0012\r\u001d9Pa\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\t\u0005\u0015\u0012\u0011\f\u0005\n\u0003g\u0011\u0012\u0011!a\u0001\u0003\u0013\na\"\u00199q\u001fB,'/\u0019;j_:\u001c\b\u0005K\u0002\u0014\u0003s\tQc\u001d;bi\u00164W\u000f\\*fi>\u0003XM]1uS>t7/\u0006\u0002\u0002dA!\u0011QMAF\u001d\u0011\t9'!\"\u000f\t\u0005%\u0014\u0011\u0011\b\u0005\u0003W\niH\u0004\u0003\u0002n\u0005md\u0002BA8\u0003srA!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003k*\u0015A\u0002\u001fs_>$h(C\u0001E\u0013\t\u00115)\u0003\u0002A\u0003&\u0019\u0011qP \u0002\r\u0011,\u0007\u000f\\8z\u0013\rQ\u00141\u0011\u0006\u0004\u0003\u007fz\u0014\u0002BAD\u0003\u0013\u000baBR1ce&\u001c\u0007(\u00117jCN,7OC\u0002;\u0003\u0007KA!!$\u0002\u0010\ni1\u000bV!U\u000b\u001a+FjX*F)NSA!a\"\u0002\n\u0006I2\u000f^1uK\u001a,HnU3u\u001fB,'/\u0019;j_:\u001cx\fJ3r)\u0011\t)#!&\t\u0013\u0005MR#!AA\u0002\u0005\r\u0014AF:uCR,g-\u001e7TKR|\u0005/\u001a:bi&|gn\u001d\u0011)\u0007Y\tI$A\u000bti\u0006$XMZ;m'\u0016$h*Y7fgB\f7-\u001a3\u0016\u0005\u0005}\u0005\u0003BA3\u0003CKA!a)\u0002\u0010\nA2\u000bV!U\u000b\u001a+FjX*F)N{f*Q'F'B\u000b5)\u0012#\u00023M$\u0018\r^3gk2\u001cV\r\u001e(b[\u0016\u001c\b/Y2fI~#S-\u001d\u000b\u0005\u0003K\tI\u000bC\u0005\u00024a\t\t\u00111\u0001\u0002 \u000612\u000f^1uK\u001a,HnU3u\u001d\u0006lWm\u001d9bG\u0016$\u0007\u0005K\u0002\u001a\u0003s\t1\"\u001a3ji\u0006\u0014G.Z*fiV\u0011\u00111\u0017\t\u0005\u0003K\n),\u0003\u0003\u00028\u0006=%\u0001E*U\u0003R+e)\u0016'`'\u0016#vLU#T\u0003=)G-\u001b;bE2,7+\u001a;`I\u0015\fH\u0003BA\u0013\u0003{C\u0011\"a\r\u001c\u0003\u0003\u0005\r!a-\u0002\u0019\u0015$\u0017\u000e^1cY\u0016\u001cV\r\u001e\u0011)\u0007q\tI$A\u0007q_\u0012|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003\u000f\u0004B!!\u001a\u0002J&!\u00111ZAH\u0005\u0011\u0001v\nR*\u0002#A|Gm\u00149fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005E\u0007\"CA\u001a=\u0005\u0005\t\u0019AAd\u00039\u0001x\u000eZ(qKJ\fG/[8og\u0002B3aHA\u001d\u0003E\u0001x\u000eZ:XSRDg*Y7fgB\f7-Z\u000b\u0003\u00037\u0004B!!\u001a\u0002^&!\u0011q\\AH\u0005M\u0001v\nR*`/&#\u0006j\u0018(B\u001b\u0016\u001b\u0006+Q\"F\u0003U\u0001x\u000eZ:XSRDg*Y7fgB\f7-Z0%KF$B!!\n\u0002f\"I\u00111G\u0011\u0002\u0002\u0003\u0007\u00111\\\u0001\u0013a>$7oV5uQ:\u000bW.Z:qC\u000e,\u0007\u0005K\u0002#\u0003s\t1\u0002]8e%\u0016\u001cx.\u001e:dKV\u0011\u0011q\u001e\t\u0005\u0003\u0017\n\t0\u0003\u0003\u0002t\u00065#a\u0003)pIJ+7o\\;sG\u0016\fq\u0002]8e%\u0016\u001cx.\u001e:dK~#S-\u001d\u000b\u0005\u0003K\tI\u0010C\u0005\u00024\u0011\n\t\u00111\u0001\u0002p\u0006a\u0001o\u001c3SKN|WO]2fA!\u001aQ%!\u000f\u0002'\u0011\u0014\u0018N^3s!>$w\n]3sCRLwN\\:\u0002/\u0011\u0014\u0018N^3s!>$w\n]3sCRLwN\\:`I\u0015\fH\u0003BA\u0013\u0005\u000bA\u0011\"a\r(\u0003\u0003\u0005\r!a<\u0002)\u0011\u0014\u0018N^3s!>$w\n]3sCRLwN\\:!Q\rA\u0013\u0011H\u0001\u0017a>$7/\u00117m_\u000e\fGo\u001c:V]\u0012,'\u000fV3tiV\u0011!q\u0002\t\u0004)\nE\u0011b\u0001B\ns\tA2\u000b^1uK\u001a,HnU3u!>$7/\u00117m_\u000e\fGo\u001c:\u00025A|Gm]!mY>\u001c\u0017\r^8s+:$WM\u001d+fgR|F%Z9\u0015\t\u0005\u0015\"\u0011\u0004\u0005\n\u0003gQ\u0013\u0011!a\u0001\u0005\u001f\tq\u0003]8eg\u0006cGn\\2bi>\u0014XK\u001c3feR+7\u000f\u001e\u0011\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKV\u0011!\u0011\u0005\t\u0004)\n\r\u0012b\u0001B\u0013s\t9C)\u001a;fe6Lg.[:uS\u000e,\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u0003I\u0019h.\u00199tQ>$8o\u0015;pe\u0016|F%Z9\u0015\t\u0005\u0015\"1\u0006\u0005\n\u0003gi\u0013\u0011!a\u0001\u0005C\tqb\u001d8baNDw\u000e^:Ti>\u0014X\rI\u0001\u0010Kb,7-\u001e;pe\n+\u0018\u000e\u001c3feV\u0011!1\u0007\t\u0004)\nU\u0012b\u0001B\u001cs\tI2*\u001e2fe:,G/Z:Fq\u0016\u001cW\u000f^8s\u0005VLG\u000eZ3s\u0003M)\u00070Z2vi>\u0014()^5mI\u0016\u0014x\fJ3r)\u0011\t)C!\u0010\t\u0013\u0005M\u0002'!AA\u0002\tM\u0012\u0001E3yK\u000e,Ho\u001c:Ck&dG-\u001a:!Q\r\t\u0014\u0011H\u0001\u0011g\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012,\"Aa\u0012\u0011\u0007Q\u0013I%C\u0002\u0003Le\u0012\u0011eS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\fAc]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3`I\u0015\fH\u0003BA\u0013\u0005#B\u0011\"a\r4\u0003\u0003\u0005\rAa\u0012\u0002#M\u001c\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007\u0005K\u00025\u0003s\tQ!\u00199q\u0013\u0012\fa!\u00199q\u0013\u0012\u0004\u0013!E3yK\u000e,Ho\u001c:Q_\u0012\fen]<feR\u0011!q\f\t\u0007\u0005C\u00129Ga\u001b\u000e\u0005\t\r$\u0002\u0002B3\u0003{\t\u0001b\u001d;vE\nLgnZ\u0005\u0005\u0005S\u0012\u0019G\u0001\u0004B]N<XM\u001d\t\u0005\u0005[\u0012y'\u0004\u0002\u0002\n&!!\u0011OAE\u0005YYUOY3s]\u0016$Xm]#yK\u000e,Ho\u001c:Ta\u0016\u001c\u0007")
public class StatefulSetAllocatorSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String driverPodName;
    private final Pod driverPod;
    private final SparkConf conf;
    private final ResourceProfile defaultProfile;
    private final ResourceProfile secondProfile;
    private final SecurityManager secMgr;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private AppsAPIGroupDSL appOperations;
    @Mock
    private MixedOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> statefulSetOperations;
    @Mock
    private NonNamespaceOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> statefulSetNamespaced;
    @Mock
    private RollableScalableResource<StatefulSet> editableSet;
    @Mock
    private MixedOperation<Pod, PodList, PodResource> podOperations;
    @Mock
    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace;
    @Mock
    private PodResource podResource;
    @Mock
    private PodResource driverPodOperations;
    private StatefulSetPodsAllocator podsAllocatorUnderTest;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    @Mock
    private KubernetesExecutorBuilder executorBuilder;
    @Mock
    private KubernetesClusterSchedulerBackend schedulerBackend;
    private final String appId;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private Pod driverPod() {
        return this.driverPod;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    private ResourceProfile secondProfile() {
        return this.secondProfile;
    }

    private SecurityManager secMgr() {
        return this.secMgr;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private AppsAPIGroupDSL appOperations() {
        return this.appOperations;
    }

    private void appOperations_$eq(AppsAPIGroupDSL x$1) {
        this.appOperations = x$1;
    }

    private MixedOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> statefulSetOperations() {
        return this.statefulSetOperations;
    }

    private void statefulSetOperations_$eq(MixedOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> x$1) {
        this.statefulSetOperations = x$1;
    }

    private NonNamespaceOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> statefulSetNamespaced() {
        return this.statefulSetNamespaced;
    }

    private void statefulSetNamespaced_$eq(NonNamespaceOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> x$1) {
        this.statefulSetNamespaced = x$1;
    }

    private RollableScalableResource<StatefulSet> editableSet() {
        return this.editableSet;
    }

    private void editableSet_$eq(RollableScalableResource<StatefulSet> x$1) {
        this.editableSet = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource> x$1) {
        this.podOperations = x$1;
    }

    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace() {
        return this.podsWithNamespace;
    }

    private void podsWithNamespace_$eq(NonNamespaceOperation<Pod, PodList, PodResource> x$1) {
        this.podsWithNamespace = x$1;
    }

    private PodResource podResource() {
        return this.podResource;
    }

    private void podResource_$eq(PodResource x$1) {
        this.podResource = x$1;
    }

    private PodResource driverPodOperations() {
        return this.driverPodOperations;
    }

    private void driverPodOperations_$eq(PodResource x$1) {
        this.driverPodOperations = x$1;
    }

    private StatefulSetPodsAllocator podsAllocatorUnderTest() {
        return this.podsAllocatorUnderTest;
    }

    private void podsAllocatorUnderTest_$eq(StatefulSetPodsAllocator x$1) {
        this.podsAllocatorUnderTest = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private KubernetesExecutorBuilder executorBuilder() {
        return this.executorBuilder;
    }

    private void executorBuilder_$eq(KubernetesExecutorBuilder x$1) {
        this.executorBuilder = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackend() {
        return this.schedulerBackend;
    }

    private void schedulerBackend_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackend = x$1;
    }

    public String appId() {
        return this.appId;
    }

    private Answer<KubernetesExecutorSpec> executorPodAnswer() {
        return invocation -> {
            KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
            return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithId(0L, k8sConf.resourceProfileId()), (Seq)package$.MODULE$.Seq().empty());
        };
    }

    public StatefulSetAllocatorSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.driverPodName = "driver";
        this.driverPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.driverPodName()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid("driver-pod-uid")).endMetadata()).build();
        this.conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.driverPodName()).set(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT().key(), "10s");
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.conf());
        this.secondProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.conf());
        this.secMgr = new SecurityManager(this.conf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        this.appId = "testapp";
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().inNamespace("default")).thenReturn(this.podsWithNamespace());
            Mockito.when((Object)this.kubernetesClient().apps()).thenReturn((Object)this.appOperations());
            Mockito.when((Object)this.appOperations().statefulSets()).thenReturn(this.statefulSetOperations());
            Mockito.when((Object)this.statefulSetOperations().inNamespace("default")).thenReturn(this.statefulSetNamespaced());
            Mockito.when((Object)this.statefulSetNamespaced().resource(ArgumentMatchers.any())).thenReturn(this.editableSet());
            Mockito.when((Object)this.statefulSetNamespaced().withName((String)ArgumentMatchers.any())).thenReturn(this.editableSet());
            Mockito.when((Object)this.podsWithNamespace().withName(this.driverPodName())).thenReturn((Object)this.driverPodOperations());
            Mockito.when((Object)this.podsWithNamespace().resource(ArgumentMatchers.any())).thenReturn((Object)this.podResource());
            Mockito.when((Object)this.driverPodOperations().get()).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.driverPodOperations().waitUntilReady(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (TimeUnit)((Object)((Object)ArgumentMatchers.any())))).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(this.executorPodAnswer());
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.podsAllocatorUnderTest_$eq(new StatefulSetPodsAllocator(this.conf(), this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), null));
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)package$.MODULE$.Seq().empty());
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
        }, new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("Validate initial statefulSet creation & cleanup with two resource profiles", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ResourceProfileBuilder rprof = new ResourceProfileBuilder();
            TaskResourceRequests taskReq = new TaskResourceRequests().resource("gpu", 1.0);
            ExecutorResourceRequests execReq = new ExecutorResourceRequests().resource("gpu", 2L, "myscript", "nvidia");
            rprof.require(taskReq).require(execReq);
            ResourceProfile immrprof = new ResourceProfile(rprof.executorResources(), rprof.taskResources());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)immrprof), (Object)BoxesRunTime.boxToInteger((int)420))})));
            ArgumentCaptor captor = ArgumentCaptor.forClass(StatefulSet.class);
            ((AnyNamespaceOperation)Mockito.verify(this.statefulSetNamespaced(), (VerificationMode)Mockito.times((int)2))).resource(ArgumentMatchers.any());
            ((CreateOrReplaceable)Mockito.verify(this.editableSet(), (VerificationMode)Mockito.times((int)2))).create();
            this.podsAllocatorUnderTest().stop(this.appId());
            return ((Deletable)Mockito.verify(this.editableSet(), (VerificationMode)Mockito.times((int)2))).delete();
        }, new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("Validate statefulSet scale up", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)10))})));
            ArgumentCaptor captor = ArgumentCaptor.forClass(StatefulSet.class);
            ((AnyNamespaceOperation)Mockito.verify(this.statefulSetNamespaced(), (VerificationMode)Mockito.times((int)1))).resource(captor.capture());
            ((CreateOrReplaceable)Mockito.verify(this.editableSet(), (VerificationMode)Mockito.times((int)1))).create();
            StatefulSet set = (StatefulSet)captor.getValue();
            String setName = set.getMetadata().getName();
            String namespace = set.getMetadata().getNamespace();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(namespace);
            String $org_scalatest_assert_macro_right = "default";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            StatefulSetSpec spec = set.getSpec();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(spec.getReplicas());
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(spec.getPodManagementPolicy());
            String $org_scalatest_assert_macro_right3 = "Parallel";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.never())).create();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)20))})));
            return (StatefulSet)((ScalableResource)Mockito.verify(this.editableSet(), (VerificationMode)Mockito.times((int)1))).scale(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        }, new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        Statics.releaseFence();
    }
}

