/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001B\u000f\u001f\u0001-BQA\u000e\u0001\u0005\u0002]B\u0011B\u000f\u0001A\u0002\u0003\u0007I\u0011B\u001e\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0013\u0001\u0005\"C%\u0001\u0001\u0004\u0005\t\u0015)\u0003=\u0011%\t\u0006\u00011AA\u0002\u0013%!\u000bC\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\"I!\r\u0001a\u0001\u0002\u0003\u0006Ka\u0015\u0005\nI\u0002\u0001\r\u00111A\u0005\n\u0015D\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0002@\t\u0015\u0005\u0005\u0001\u00011A\u0001B\u0003&a\rC\u0006\u0002\u0006\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0001bCA\b\u0001\u0001\u0007\t\u0019!C\u0005\u0003#A1\"!\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\n!Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000e\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%I!!\n\t\u0017\u0005%\u0002\u00011A\u0001B\u0003&\u0011Q\u0004\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002C\u0006\u00020\u0001\u0001\r\u00111A\u0005\n\u0005E\u0002bCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;A1\"!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<!Y\u00111\t\u0001A\u0002\u0003\u0007I\u0011BA#\u0011-\tI\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u0010\t\u0017\u00055\u0003\u00011AA\u0002\u0013%\u0011q\n\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0007C\u0006\u0002t\u0001\u0001\r\u0011!Q!\n\u0005E\u0003bCA;\u0001\u0001\u0007\t\u0019!C\u0005\u0003oB1\"a \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0002\"Y\u0011Q\u0011\u0001A\u0002\u0003\u0005\u000b\u0015BA=\u0005\u0011*\u00050Z2vi>\u0014\bk\u001c3t/\u0006$8\r[*oCB\u001c\bn\u001c;T_V\u00148-Z*vSR,'BA\u0010!\u0003\rY\u0007h\u001d\u0006\u0003C\t\nqa\u00197vgR,'O\u0003\u0002$I\u0005I1o\u00195fIVdWM\u001d\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011c\u0001\u0001-aA\u0011QFL\u0007\u0002I%\u0011q\u0006\n\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MB\u0013!C:dC2\fG/Z:u\u0013\t)$G\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\u0002\rqJg.\u001b;?)\u0005A\u0004CA\u001d\u0001\u001b\u0005q\u0012AC3wK:$\u0018+^3vKV\tA\b\u0005\u0002:{%\u0011aH\b\u0002\u001b\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;t'R|'/Z\u0001\u000fKZ,g\u000e^)vKV,w\fJ3r)\t\tu\t\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15I\u0001\u0003V]&$\bb\u0002%\u0004\u0003\u0003\u0005\r\u0001P\u0001\u0004q\u0012\n\u0014aC3wK:$\u0018+^3vK\u0002B#\u0001B&\u0011\u00051{U\"A'\u000b\u00059C\u0013aB7pG.LGo\\\u0005\u0003!6\u0013A!T8dW\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e^\u000b\u0002'B\u0011A+X\u0007\u0002+*\u0011akV\u0001\u0007G2LWM\u001c;\u000b\u0005aK\u0016AC6vE\u0016\u0014h.\u001a;fg*\u0011!lW\u0001\bM\u0006\u0014'/[29\u0015\u0005a\u0016AA5p\u0013\tqVK\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u0006!2.\u001e2fe:,G/Z:DY&,g\u000e^0%KF$\"!Q1\t\u000f!3\u0011\u0011!a\u0001'\u0006\t2.\u001e2fe:,G/Z:DY&,g\u000e\u001e\u0011)\u0005\u001dY\u0015!\u00049pI>\u0003XM]1uS>t7/F\u0001g!\t9'P\u0004\u0002io:\u0011\u0011.\u001e\b\u0003UNt!a\u001b:\u000f\u00051\fhBA7q\u001b\u0005q'BA8+\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002(Q%\u0011QEJ\u0005\u0003i\u0012\na\u0001Z3qY>L\u0018BA\u0010w\u0015\t!H%\u0003\u0002ys\u0006qa)\u00192sS\u000eD\u0014\t\\5bg\u0016\u001c(BA\u0010w\u0013\tYHP\u0001\u0003Q\u001f\u0012\u001b&B\u0001=z\u0003E\u0001x\u000eZ(qKJ\fG/[8og~#S-\u001d\u000b\u0003\u0003~Dq\u0001S\u0005\u0002\u0002\u0003\u0007a-\u0001\bq_\u0012|\u0005/\u001a:bi&|gn\u001d\u0011)\u0005)Y\u0015!\u00059pIN<\u0016\u000e\u001e5OC6,7\u000f]1dKV\u0011\u0011\u0011\u0002\t\u0004O\u0006-\u0011bAA\u0007y\n\u0019\u0002k\u0014#T?^KE\u000bS0O\u00036+5\u000bU!D\u000b\u0006)\u0002o\u001c3t/&$\bNT1nKN\u0004\u0018mY3`I\u0015\fHcA!\u0002\u0014!A\u0001\nDA\u0001\u0002\u0004\tI!\u0001\nq_\u0012\u001cx+\u001b;i\u001d\u0006lWm\u001d9bG\u0016\u0004\u0003FA\u0007L\u0003A\t\u0007\u000f]%e\u0019\u0006\u0014W\r\\3e!>$7/\u0006\u0002\u0002\u001eA\u0019q-a\b\n\u0007\u0005\u0005BP\u0001\u0007M\u0003\n+E*\u0012#`!>#5+\u0001\u000bbaBLE\rT1cK2,G\rU8eg~#S-\u001d\u000b\u0004\u0003\u0006\u001d\u0002\u0002\u0003%\u0010\u0003\u0003\u0005\r!!\b\u0002#\u0005\u0004\b/\u00133MC\n,G.\u001a3Q_\u0012\u001c\b\u0005\u000b\u0002\u0011\u0017\u00069R\r_3dkR|'OU8mK2\u000b'-\u001a7fIB{Gm]\u0001\u001cKb,7-\u001e;peJ{G.\u001a'bE\u0016dW\r\u001a)pIN|F%Z9\u0015\u0007\u0005\u000b\u0019\u0004\u0003\u0005I%\u0005\u0005\t\u0019AA\u000f\u0003a)\u00070Z2vi>\u0014(k\u001c7f\u0019\u0006\u0014W\r\\3e!>$7\u000f\t\u0015\u0003'-\u000bqb^1uG\"\u001cuN\u001c8fGRLwN\\\u000b\u0003\u0003{\u00012\u0001VA \u0013\r\t\t%\u0016\u0002\u0006/\u0006$8\r[\u0001\u0014o\u0006$8\r[\"p]:,7\r^5p]~#S-\u001d\u000b\u0004\u0003\u0006\u001d\u0003\u0002\u0003%\u0016\u0003\u0003\u0005\r!!\u0010\u0002!]\fGo\u00195D_:tWm\u0019;j_:\u0004\u0003F\u0001\fL\u0003\u00159\u0018\r^2i+\t\t\t\u0006E\u0003M\u0003'\n9&C\u0002\u0002V5\u0013a\"\u0011:hk6,g\u000e^\"baR|'\u000fE\u0003U\u00033\ni&C\u0002\u0002\\U\u0013qaV1uG\",'\u000f\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u000b5|G-\u001a7\u000b\u0007\u0005\u001dt+A\u0002ba&LA!a\u001b\u0002b\t\u0019\u0001k\u001c3\u0002\u0013]\fGo\u00195`I\u0015\fHcA!\u0002r!A\u0001\nGA\u0001\u0002\u0004\t\t&\u0001\u0004xCR\u001c\u0007\u000eI\u0001\u0015o\u0006$8\r[*pkJ\u001cW-\u00168eKJ$Vm\u001d;\u0016\u0005\u0005e\u0004cA\u001d\u0002|%\u0019\u0011Q\u0010\u0010\u0003?\u0015CXmY;u_J\u0004v\u000eZ:XCR\u001c\u0007n\u00158baNDw\u000e^*pkJ\u001cW-\u0001\rxCR\u001c\u0007nU8ve\u000e,WK\u001c3feR+7\u000f^0%KF$2!QAB\u0011!A5$!AA\u0002\u0005e\u0014!F<bi\u000eD7k\\;sG\u0016,f\u000eZ3s)\u0016\u001cH\u000f\t")
public class ExecutorPodsWatchSnapshotSourceSuite
extends SparkFunSuite
implements BeforeAndAfter {
    @Mock
    private ExecutorPodsSnapshotsStore eventQueue;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource> podOperations;
    @Mock
    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, PodResource> appIdLabeledPods;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, PodResource> executorRoleLabeledPods;
    @Mock
    private Watch watchConnection;
    private ArgumentCaptor<Watcher<Pod>> watch;
    private ExecutorPodsWatchSnapshotSource watchSourceUnderTest;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private ExecutorPodsSnapshotsStore eventQueue() {
        return this.eventQueue;
    }

    private void eventQueue_$eq(ExecutorPodsSnapshotsStore x$1) {
        this.eventQueue = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource> x$1) {
        this.podOperations = x$1;
    }

    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace() {
        return this.podsWithNamespace;
    }

    private void podsWithNamespace_$eq(NonNamespaceOperation<Pod, PodList, PodResource> x$1) {
        this.podsWithNamespace = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, PodResource> appIdLabeledPods() {
        return this.appIdLabeledPods;
    }

    private void appIdLabeledPods_$eq(FilterWatchListDeletable<Pod, PodList, PodResource> x$1) {
        this.appIdLabeledPods = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, PodResource> executorRoleLabeledPods() {
        return this.executorRoleLabeledPods;
    }

    private void executorRoleLabeledPods_$eq(FilterWatchListDeletable<Pod, PodList, PodResource> x$1) {
        this.executorRoleLabeledPods = x$1;
    }

    private Watch watchConnection() {
        return this.watchConnection;
    }

    private void watchConnection_$eq(Watch x$1) {
        this.watchConnection = x$1;
    }

    private ArgumentCaptor<Watcher<Pod>> watch() {
        return this.watch;
    }

    private void watch_$eq(ArgumentCaptor<Watcher<Pod>> x$1) {
        this.watch = x$1;
    }

    private ExecutorPodsWatchSnapshotSource watchSourceUnderTest() {
        return this.watchSourceUnderTest;
    }

    private void watchSourceUnderTest_$eq(ExecutorPodsWatchSnapshotSource x$1) {
        this.watchSourceUnderTest = x$1;
    }

    public ExecutorPodsWatchSnapshotSourceSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(Function0 & Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            this.watch_$eq((ArgumentCaptor<Watcher<Pod>>)ArgumentCaptor.forClass(Watcher.class));
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().inNamespace("default")).thenReturn(this.podsWithNamespace());
            Mockito.when((Object)this.podsWithNamespace().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.appIdLabeledPods());
            Mockito.when((Object)this.appIdLabeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.executorRoleLabeledPods());
            return Mockito.when((Object)this.executorRoleLabeledPods().watch((Watcher)this.watch().capture())).thenReturn((Object)this.watchConnection());
        }, new Position("ExecutorPodsWatchSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("Watch events should be pushed to the snapshots store as snapshot updates.", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf();
            this.watchSourceUnderTest_$eq(new ExecutorPodsWatchSnapshotSource(this.eventQueue(), this.kubernetesClient(), conf));
            this.watchSourceUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            Pod exec1 = ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2());
            Pod exec2 = ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2());
            ((Watcher)this.watch().getValue()).eventReceived(Watcher.Action.ADDED, (Object)exec1);
            ((Watcher)this.watch().getValue()).eventReceived(Watcher.Action.MODIFIED, (Object)exec2);
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).updatePod(exec1);
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).updatePod(exec2);
        }, new Position("ExecutorPodsWatchSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("SPARK-36462: Verify if watchers are disabled we don't call pods() on the client", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf();
            conf.set(Config$.MODULE$.KUBERNETES_EXECUTOR_ENABLE_API_WATCHER(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.watchSourceUnderTest_$eq(new ExecutorPodsWatchSnapshotSource(this.eventQueue(), this.kubernetesClient(), conf));
            this.watchSourceUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            return ((KubernetesClient)Mockito.verify((Object)this.kubernetesClient(), (VerificationMode)Mockito.never())).pods();
        }, new Position("ExecutorPodsWatchSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        Statics.releaseFence();
    }
}

