/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileBuilder;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$;
import org.scalatest.Status;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tMh\u0001B$I\u0001UCQ\u0001\u0019\u0001\u0005\u0002\u0005Dq\u0001\u001a\u0001C\u0002\u0013%Q\r\u0003\u0004o\u0001\u0001\u0006IA\u001a\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u0019y\b\u0001)A\u0005c\"I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003\u0017\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0012!I\u0011q\u0004\u0001C\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002$!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u00026!I\u0011Q\b\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u00026!I\u0011\u0011\t\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u00026!I\u0011Q\t\u0001C\u0002\u0013%\u0011q\t\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002J!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011BA*\u0011-\t\t\u0007\u0001a\u0001\u0002\u0004%I!a\u0019\t\u0017\u0005=\u0004\u00011A\u0001B\u0003&\u0011Q\u000b\u0005\f\u0003c\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\bC\u0006\u0002\u0002\u0002\u0001\r\u00111A\u0005\n\u0005\r\u0005bCAD\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kB1\"a&\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a\"Y\u0011\u0011\u001a\u0001A\u0002\u0003\u0007I\u0011BAf\u0011-\ty\r\u0001a\u0001\u0002\u0003\u0006K!a'\t\u0017\u0005M\u0007\u00011AA\u0002\u0013%\u0011Q\u001b\u0005\f\u0003;\u0004\u0001\u0019!a\u0001\n\u0013\ty\u000eC\u0006\u0002d\u0002\u0001\r\u0011!Q!\n\u0005]\u0007bCAt\u0001\u0001\u0007\t\u0019!C\u0005\u0003SD1\"a>\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002z\"Y\u0011Q \u0001A\u0002\u0003\u0005\u000b\u0015BAv\u0011-\u0011\t\u0001\u0001a\u0001\u0002\u0004%IAa\u0001\t\u0017\t-\u0001\u00011AA\u0002\u0013%!Q\u0002\u0005\f\u0005#\u0001\u0001\u0019!A!B\u0013\u0011)\u0001C\u0006\u0003\u0016\u0001\u0001\r\u00111A\u0005\n\t]\u0001b\u0003B\u0010\u0001\u0001\u0007\t\u0019!C\u0005\u0005CA1B!\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u001a!Y!\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0016\u0011-\u0011I\u0004\u0001a\u0001\u0002\u0004%IAa\u000f\t\u0017\t}\u0002\u00011A\u0001B\u0003&!Q\u0006\u0005\f\u0005\u0007\u0002\u0001\u0019!a\u0001\n\u0013\u0011)\u0005C\u0006\u0003N\u0001\u0001\r\u00111A\u0005\n\t=\u0003b\u0003B*\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u000fB1Ba\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003Z!Y!\u0011\r\u0001A\u0002\u0003\u0007I\u0011\u0002B2\u0011-\u00119\u0007\u0001a\u0001\u0002\u0003\u0006KAa\u0017\t\u0017\t-\u0004\u00011AA\u0002\u0013%!Q\u000e\u0005\f\u0005k\u0002\u0001\u0019!a\u0001\n\u0013\u00119\bC\u0006\u0003|\u0001\u0001\r\u0011!Q!\n\t=\u0004b\u0003B@\u0001\u0001\u0007\t\u0019!C\u0005\u0003SD1B!!\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0004\"Y!q\u0011\u0001A\u0002\u0003\u0005\u000b\u0015BAv\u0011-\u0011Y\t\u0001a\u0001\u0002\u0004%IA!$\t\u0017\tU\u0005\u00011AA\u0002\u0013%!q\u0013\u0005\f\u00057\u0003\u0001\u0019!A!B\u0013\u0011y\tC\u0006\u0003 \u0002\u0001\r\u00111A\u0005\n\t\u0005\u0006b\u0003BU\u0001\u0001\u0007\t\u0019!C\u0005\u0005WC1Ba,\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003$\"Y!1\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002B[\u0011-\u0011i\f\u0001a\u0001\u0002\u0004%IAa0\t\u0017\t\r\u0007\u00011A\u0001B\u0003&!q\u0017\u0005\f\u0005\u000b\u0004\u0001\u0019!a\u0001\n\u0013\u00119\rC\u0006\u0003P\u0002\u0001\r\u00111A\u0005\n\tE\u0007b\u0003Bk\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0013D\u0001Ba6\u0001\u0005\u0004%\t!\u001a\u0005\b\u00053\u0004\u0001\u0015!\u0003g\u0011\u001d\u0011Y\u000e\u0001C\u0005\u0005;\u0014!$\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'oU;ji\u0016T!!\u0013&\u0002\u0007-D4O\u0003\u0002L\u0019\u000691\r\\;ti\u0016\u0014(BA'O\u0003%\u00198\r[3ek2,'O\u0003\u0002P!\u0006)1\u000f]1sW*\u0011\u0011KU\u0001\u0007CB\f7\r[3\u000b\u0003M\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001,[!\t9\u0006,D\u0001O\u0013\tIfJA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0003;J\u000b\u0011b]2bY\u0006$Xm\u001d;\n\u0005}c&A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0004\"a\u0019\u0001\u000e\u0003!\u000bQ\u0002\u001a:jm\u0016\u0014\bk\u001c3OC6,W#\u00014\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001\u00027b]\u001eT\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n11\u000b\u001e:j]\u001e\fa\u0002\u001a:jm\u0016\u0014\bk\u001c3OC6,\u0007%A\u0005ee&4XM\u001d)pIV\t\u0011\u000f\u0005\u0002s{6\t1O\u0003\u0002uk\u0006)Qn\u001c3fY*\u0011ao^\u0001\u0004CBL'B\u0001=z\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003un\fqAZ1ce&\u001c\u0007HC\u0001}\u0003\tIw.\u0003\u0002\u007fg\n\u0019\u0001k\u001c3\u0002\u0015\u0011\u0014\u0018N^3s!>$\u0007%\u0001\u0003d_:4WCAA\u0003!\r9\u0016qA\u0005\u0004\u0003\u0013q%!C*qCJ\\7i\u001c8g\u0003\u0015\u0019wN\u001c4!\u00039!WMZ1vYR\u0004&o\u001c4jY\u0016,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006O\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BA\u000e\u0003+\u0011qBU3t_V\u00148-\u001a)s_\u001aLG.Z\u0001\u0010I\u00164\u0017-\u001e7u!J|g-\u001b7fA\u0005\t\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0005\u0005%\u0012!B:dC2\f\u0017\u0002BA\u0017\u0003O\u00111!\u00138u\u0003I\u0001x\u000eZ!mY>\u001c\u0017\r^5p]NK'0\u001a\u0011\u0002%A|G-\u00117m_\u000e\fG/[8o\t\u0016d\u0017-_\u000b\u0003\u0003k\u0001B!!\n\u00028%!\u0011\u0011HA\u0014\u0005\u0011auN\\4\u0002'A|G-\u00117m_\u000e\fG/[8o\t\u0016d\u0017-\u001f\u0011\u0002'\u0015DXmY;u_JLE\r\\3US6,w.\u001e;\u0002)\u0015DXmY;u_JLE\r\\3US6,w.\u001e;!\u0003I\u0001x\u000eZ\"sK\u0006$\u0018n\u001c8US6,w.\u001e;\u0002'A|Gm\u0011:fCRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002\rM,7-T4s+\t\tI\u0005E\u0002X\u0003\u0017J1!!\u0014O\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\u0018aB:fG6;'\u000fI\u0001\u0019o\u0006LGOR8s\u000bb,7-\u001e;peB{Gm]\"m_\u000e\\WCAA+!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\u001d\u0006!Q\u000f^5m\u0013\u0011\ty&!\u0017\u0003\u00175\u000bg.^1m\u00072|7m[\u0001\u001do\u0006LGOR8s\u000bb,7-\u001e;peB{Gm]\"m_\u000e\\w\fJ3r)\u0011\t)'a\u001b\u0011\t\u0005\u0015\u0012qM\u0005\u0005\u0003S\n9C\u0001\u0003V]&$\b\"CA7+\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\u001ao\u0006LGOR8s\u000bb,7-\u001e;peB{Gm]\"m_\u000e\\\u0007%\u0001\tlk\n,'O\\3uKN\u001cE.[3oiV\u0011\u0011Q\u000f\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P<\u0002\r\rd\u0017.\u001a8u\u0013\u0011\ty(!\u001f\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018\u0001F6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002f\u0005\u0015\u0005\"CA71\u0005\u0005\t\u0019AA;\u0003EYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\t\u0015\u00043\u0005-\u0005\u0003BAG\u0003'k!!a$\u000b\u0007\u0005E%+A\u0004n_\u000e\\\u0017\u000e^8\n\t\u0005U\u0015q\u0012\u0002\u0005\u001b>\u001c7.A\u0007q_\u0012|\u0005/\u001a:bi&|gn]\u000b\u0003\u00037\u0003B!!(\u0002D:!\u0011qTA_\u001d\u0011\t\t+!/\u000f\t\u0005\r\u0016Q\u0017\b\u0005\u0003K\u000b\u0019L\u0004\u0003\u0002(\u0006Ef\u0002BAU\u0003_k!!a+\u000b\u0007\u00055F+\u0001\u0004=e>|GOP\u0005\u0002'&\u0011\u0011KU\u0005\u0003\u001fBK1!a.O\u0003\u0019!W\r\u001d7ps&\u0019\u0011*a/\u000b\u0007\u0005]f*\u0003\u0003\u0002@\u0006\u0005\u0017A\u0004$bEJL7\rO!mS\u0006\u001cXm\u001d\u0006\u0004\u0013\u0006m\u0016\u0002BAc\u0003\u000f\u0014A\u0001U(E'*!\u0011qXAa\u0003E\u0001x\u000eZ(qKJ\fG/[8og~#S-\u001d\u000b\u0005\u0003K\ni\rC\u0005\u0002nm\t\t\u00111\u0001\u0002\u001c\u0006q\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N\u0004\u0003f\u0001\u000f\u0002\f\u0006\t\u0002o\u001c3t/&$\bNT1nKN\u0004\u0018mY3\u0016\u0005\u0005]\u0007\u0003BAO\u00033LA!a7\u0002H\n\u0019\u0002k\u0014#T?^KE\u000bS0O\u00036+5\u000bU!D\u000b\u0006)\u0002o\u001c3t/&$\bNT1nKN\u0004\u0018mY3`I\u0015\fH\u0003BA3\u0003CD\u0011\"!\u001c\u001f\u0003\u0003\u0005\r!a6\u0002%A|Gm],ji\"t\u0015-\\3ta\u0006\u001cW\r\t\u0015\u0004?\u0005-\u0015a\u00039pIJ+7o\\;sG\u0016,\"!a;\u0011\t\u00055\u00181_\u0007\u0003\u0003_TA!!=\u0002z\u0005\u0019Am\u001d7\n\t\u0005U\u0018q\u001e\u0002\f!>$'+Z:pkJ\u001cW-A\bq_\u0012\u0014Vm]8ve\u000e,w\fJ3r)\u0011\t)'a?\t\u0013\u00055\u0014%!AA\u0002\u0005-\u0018\u0001\u00049pIJ+7o\\;sG\u0016\u0004\u0003f\u0001\u0012\u0002\f\u00061\u0002/\u001a:tSN$XM\u001c;W_2,X.Z\"mC&l7/\u0006\u0002\u0003\u0006A!\u0011Q\u0014B\u0004\u0013\u0011\u0011I!a2\u00031A+%kU%T)\u0016sEk\u0018,P\u0019VkUiX\"M\u0003&k5+\u0001\u000eqKJ\u001c\u0018n\u001d;f]R4v\u000e\\;nK\u000ec\u0017-[7t?\u0012*\u0017\u000f\u0006\u0003\u0002f\t=\u0001\"CA7I\u0005\u0005\t\u0019\u0001B\u0003\u0003]\u0001XM]:jgR,g\u000e\u001e,pYVlWm\u00117bS6\u001c\b\u0005K\u0002&\u0003\u0017\u000b\u0001\u0003\u001d<d/&$\bNT1nKN\u0004\u0018mY3\u0016\u0005\te\u0001\u0003BAO\u00057IAA!\b\u0002H\n\u0011\u0002KV\"`/&#\u0006j\u0018(B\u001b\u0016\u001b\u0006+Q\"F\u0003Q\u0001hoY,ji\"t\u0015-\\3ta\u0006\u001cWm\u0018\u0013fcR!\u0011Q\rB\u0012\u0011%\tigJA\u0001\u0002\u0004\u0011I\"A\tqm\u000e<\u0016\u000e\u001e5OC6,7\u000f]1dK\u0002B3\u0001KAF\u0003-\u0001ho\u0019*fg>,(oY3\u0016\u0005\t5\u0002CBAw\u0005_\u0011\u0019$\u0003\u0003\u00032\u0005=(\u0001\u0003*fg>,(oY3\u0011\u0007I\u0014)$C\u0002\u00038M\u0014Q\u0003U3sg&\u001cH/\u001a8u->dW/\\3DY\u0006LW.A\bqm\u000e\u0014Vm]8ve\u000e,w\fJ3r)\u0011\t)G!\u0010\t\u0013\u00055$&!AA\u0002\t5\u0012\u0001\u00049wGJ+7o\\;sG\u0016\u0004\u0003fA\u0016\u0002\f\u0006iB.\u00192fY\u0016$\u0007+\u001a:tSN$XM\u001c;W_2,X.Z\"mC&l7/\u0006\u0002\u0003HA!\u0011Q\u0014B%\u0013\u0011\u0011Y%a2\u0003A1\u000b%)\u0012'F\t~\u0003VIU*J'R+e\nV0W\u001f2+V*R0D\u0019\u0006KUjU\u0001\"Y\u0006\u0014W\r\\3e!\u0016\u00148/[:uK:$hk\u001c7v[\u0016\u001cE.Y5ng~#S-\u001d\u000b\u0005\u0003K\u0012\t\u0006C\u0005\u0002n5\n\t\u00111\u0001\u0003H\u0005qB.\u00192fY\u0016$\u0007+\u001a:tSN$XM\u001c;W_2,X.Z\"mC&l7\u000f\t\u0015\u0004]\u0005-\u0015!\u00079feNL7\u000f^3oiZ{G.^7f\u00072\f\u0017.\u001c'jgR,\"Aa\u0017\u0011\u0007I\u0014i&C\u0002\u0003`M\u0014\u0011\u0004U3sg&\u001cH/\u001a8u->dW/\\3DY\u0006LW\u000eT5ti\u0006i\u0002/\u001a:tSN$XM\u001c;W_2,X.Z\"mC&lG*[:u?\u0012*\u0017\u000f\u0006\u0003\u0002f\t\u0015\u0004\"CA7a\u0005\u0005\t\u0019\u0001B.\u0003i\u0001XM]:jgR,g\u000e\u001e,pYVlWm\u00117bS6d\u0015n\u001d;!Q\r\t\u00141R\u0001\fY\u0006\u0014W\r\\3e!>$7/\u0006\u0002\u0003pA!\u0011Q\u0014B9\u0013\u0011\u0011\u0019(a2\u0003\u00191\u000b%)\u0012'F\t~\u0003v\nR*\u0002\u001f1\f'-\u001a7fIB{Gm]0%KF$B!!\u001a\u0003z!I\u0011QN\u001a\u0002\u0002\u0003\u0007!qN\u0001\rY\u0006\u0014W\r\\3e!>$7\u000f\t\u0015\u0004i\u0005-\u0015a\u00053sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001c\u0018a\u00063sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001cx\fJ3r)\u0011\t)G!\"\t\u0013\u00055d'!AA\u0002\u0005-\u0018\u0001\u00063sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001c\b\u0005K\u00028\u0003\u0017\u000bq\"\u001a=fGV$xN\u001d\"vS2$WM]\u000b\u0003\u0005\u001f\u00032a\u0019BI\u0013\r\u0011\u0019\n\u0013\u0002\u001a\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'OQ;jY\u0012,'/A\nfq\u0016\u001cW\u000f^8s\u0005VLG\u000eZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002f\te\u0005\"CA7s\u0005\u0005\t\u0019\u0001BH\u0003A)\u00070Z2vi>\u0014()^5mI\u0016\u0014\b\u0005K\u0002;\u0003\u0017\u000b\u0001c]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0016\u0005\t\r\u0006cA2\u0003&&\u0019!q\u0015%\u0003C-+(-\u001a:oKR,7o\u00117vgR,'oU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0002)M\u001c\u0007.\u001a3vY\u0016\u0014()Y2lK:$w\fJ3r)\u0011\t)G!,\t\u0013\u00055D(!AA\u0002\t\r\u0016!E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8eA!\u001aQ(a#\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKV\u0011!q\u0017\t\u0004G\ne\u0016b\u0001B^\u0011\n9C)\u001a;fe6Lg.[:uS\u000e,\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u0003I\u0019h.\u00199tQ>$8o\u0015;pe\u0016|F%Z9\u0015\t\u0005\u0015$\u0011\u0019\u0005\n\u0003[z\u0014\u0011!a\u0001\u0005o\u000bqb\u001d8baNDw\u000e^:Ti>\u0014X\rI\u0001\u0017a>$7/\u00117m_\u000e\fGo\u001c:V]\u0012,'\u000fV3tiV\u0011!\u0011\u001a\t\u0004G\n-\u0017b\u0001Bg\u0011\n)R\t_3dkR|'\u000fU8eg\u0006cGn\\2bi>\u0014\u0018A\u00079pIN\fE\u000e\\8dCR|'/\u00168eKJ$Vm\u001d;`I\u0015\fH\u0003BA3\u0005'D\u0011\"!\u001cC\u0003\u0003\u0005\rA!3\u0002/A|Gm]!mY>\u001c\u0017\r^8s+:$WM\u001d+fgR\u0004\u0013!B1qa&#\u0017AB1qa&#\u0007%A\tfq\u0016\u001cW\u000f^8s!>$\u0017I\\:xKJ$\"Aa8\u0011\r\t\u0005(q\u001dBv\u001b\t\u0011\u0019O\u0003\u0003\u0003f\u0006=\u0015\u0001C:uk\n\u0014\u0017N\\4\n\t\t%(1\u001d\u0002\u0007\u0003:\u001cx/\u001a:\u0011\t\t5(q^\u0007\u0003\u0003\u0003LAA!=\u0002B\n12*\u001e2fe:,G/Z:Fq\u0016\u001cW\u000f^8s'B,7\r")
public class ExecutorPodsAllocatorSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String driverPodName;
    private final Pod driverPod;
    private final SparkConf conf;
    private final ResourceProfile defaultProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long executorIdleTimeout;
    private final long podCreationTimeout;
    private final SecurityManager secMgr;
    private ManualClock waitForExecutorPodsClock;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource> podOperations;
    @Mock
    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace;
    @Mock
    private PodResource podResource;
    @Mock
    private MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims;
    @Mock
    private NonNamespaceOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> pvcWithNamespace;
    @Mock
    private Resource<PersistentVolumeClaim> pvcResource;
    @Mock
    private FilterWatchListDeletable<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> labeledPersistentVolumeClaims;
    @Mock
    private PersistentVolumeClaimList persistentVolumeClaimList;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, PodResource> labeledPods;
    @Mock
    private PodResource driverPodOperations;
    @Mock
    private KubernetesExecutorBuilder executorBuilder;
    @Mock
    private KubernetesClusterSchedulerBackend schedulerBackend;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    private ExecutorPodsAllocator podsAllocatorUnderTest;
    private final String appId;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private Pod driverPod() {
        return this.driverPod;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private SecurityManager secMgr() {
        return this.secMgr;
    }

    private ManualClock waitForExecutorPodsClock() {
        return this.waitForExecutorPodsClock;
    }

    private void waitForExecutorPodsClock_$eq(ManualClock x$1) {
        this.waitForExecutorPodsClock = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource> x$1) {
        this.podOperations = x$1;
    }

    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace() {
        return this.podsWithNamespace;
    }

    private void podsWithNamespace_$eq(NonNamespaceOperation<Pod, PodList, PodResource> x$1) {
        this.podsWithNamespace = x$1;
    }

    private PodResource podResource() {
        return this.podResource;
    }

    private void podResource_$eq(PodResource x$1) {
        this.podResource = x$1;
    }

    private MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.persistentVolumeClaims;
    }

    private void persistentVolumeClaims_$eq(MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> x$1) {
        this.persistentVolumeClaims = x$1;
    }

    private NonNamespaceOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> pvcWithNamespace() {
        return this.pvcWithNamespace;
    }

    private void pvcWithNamespace_$eq(NonNamespaceOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> x$1) {
        this.pvcWithNamespace = x$1;
    }

    private Resource<PersistentVolumeClaim> pvcResource() {
        return this.pvcResource;
    }

    private void pvcResource_$eq(Resource<PersistentVolumeClaim> x$1) {
        this.pvcResource = x$1;
    }

    private FilterWatchListDeletable<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> labeledPersistentVolumeClaims() {
        return this.labeledPersistentVolumeClaims;
    }

    private void labeledPersistentVolumeClaims_$eq(FilterWatchListDeletable<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> x$1) {
        this.labeledPersistentVolumeClaims = x$1;
    }

    private PersistentVolumeClaimList persistentVolumeClaimList() {
        return this.persistentVolumeClaimList;
    }

    private void persistentVolumeClaimList_$eq(PersistentVolumeClaimList x$1) {
        this.persistentVolumeClaimList = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, PodResource> labeledPods() {
        return this.labeledPods;
    }

    private void labeledPods_$eq(FilterWatchListDeletable<Pod, PodList, PodResource> x$1) {
        this.labeledPods = x$1;
    }

    private PodResource driverPodOperations() {
        return this.driverPodOperations;
    }

    private void driverPodOperations_$eq(PodResource x$1) {
        this.driverPodOperations = x$1;
    }

    private KubernetesExecutorBuilder executorBuilder() {
        return this.executorBuilder;
    }

    private void executorBuilder_$eq(KubernetesExecutorBuilder x$1) {
        this.executorBuilder = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackend() {
        return this.schedulerBackend;
    }

    private void schedulerBackend_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackend = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private ExecutorPodsAllocator podsAllocatorUnderTest() {
        return this.podsAllocatorUnderTest;
    }

    private void podsAllocatorUnderTest_$eq(ExecutorPodsAllocator x$1) {
        this.podsAllocatorUnderTest = x$1;
    }

    public String appId() {
        return this.appId;
    }

    private Answer<KubernetesExecutorSpec> executorPodAnswer() {
        return invocation -> {
            KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
            return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithId(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(k8sConf.executorId())), k8sConf.resourceProfileId()), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
        };
    }

    public static final /* synthetic */ PodResource $anonfun$new$5(ExecutorPodsAllocatorSuite $this, int nextId) {
        return (PodResource)((AnyNamespaceOperation)Mockito.verify($this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(nextId, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
    }

    public ExecutorPodsAllocatorSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.driverPodName = "driver";
        this.driverPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.driverPodName()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid("driver-pod-uid")).endMetadata()).build();
        this.conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.driverPodName()).set(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT().key(), "10s");
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.conf());
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.secMgr = new SecurityManager(this.conf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        this.appId = "testapp";
        this.before((Function0<Object>)(Function0 & Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().inNamespace("default")).thenReturn(this.podsWithNamespace());
            Mockito.when((Object)this.podsWithNamespace().withName(this.driverPodName())).thenReturn((Object)this.driverPodOperations());
            Mockito.when((Object)this.podsWithNamespace().resource(ArgumentMatchers.any())).thenReturn((Object)this.podResource());
            Mockito.when((Object)this.podsWithNamespace().withLabel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.podsWithNamespace().withLabelIn(ArgumentMatchers.anyString(), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            Mockito.when((Object)this.podsWithNamespace().withField(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn(ArgumentMatchers.anyString(), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withField(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.driverPodOperations().get()).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.driverPodOperations().waitUntilReady(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (TimeUnit)((Object)((Object)ArgumentMatchers.any())))).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(this.executorPodAnswer());
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.waitForExecutorPodsClock_$eq(new ManualClock(0L));
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(this.conf(), this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)scala.package$.MODULE$.Seq().empty());
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
            Mockito.when((Object)this.kubernetesClient().persistentVolumeClaims()).thenReturn(this.persistentVolumeClaims());
            Mockito.when((Object)this.persistentVolumeClaims().inNamespace("default")).thenReturn(this.pvcWithNamespace());
            Mockito.when((Object)this.pvcWithNamespace().withLabel((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.labeledPersistentVolumeClaims());
            Mockito.when((Object)this.pvcWithNamespace().resource(ArgumentMatchers.any())).thenReturn(this.pvcResource());
            Mockito.when((Object)this.labeledPersistentVolumeClaims().list()).thenReturn((Object)this.persistentVolumeClaimList());
            return Mockito.when((Object)this.persistentVolumeClaimList().getItems()).thenReturn(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)scala.package$.MODULE$.Seq().empty()).asJava());
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("SPARK-36052: test splitSlots", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            scala.collection.immutable.Seq seq1 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq1, 0));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq1, 1));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq1, 2));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            scala.collection.immutable.Seq seq2 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 0));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 1));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right5 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 2));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right6 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))}));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 3));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right7 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 4));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_right8 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("SPARK-36052: pending pod limit with multiple resource profiles", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            SparkConf confWithLowMaxPendingPods = this.conf().clone().set(Config$.MODULE$.KUBERNETES_MAX_PENDING_PODS().key(), "3");
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(confWithLowMaxPendingPods, this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, rp.id()));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)3))).create();
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(2L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(3L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)3))).create();
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.times((int)1))).delete();
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(3L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(4L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, rp.id()));
            return ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.times((int)1))).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("Initially request executors in batches. Do not request another batch if the first has not finished.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)(this.podAllocationSize() + 1)))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach((Function1 & Serializable)nextId -> ExecutorPodsAllocatorSuite.$anonfun$new$5(this, BoxesRunTime.unboxToInt((Object)nextId)));
            return (PodResource)((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace(), (VerificationMode)Mockito.never())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("Request executors in batches. Allow another batch to be requested if all pending executors start running.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PrivateMethodTester.Invocation counter = PrivateMethodTester$.MODULE$.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "EXECUTOR_ID_COUNTER")).apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)(this.podAllocationSize() + 1)))})));
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)execId -> this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2())));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace(), (VerificationMode)Mockito.never())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)this.podAllocationSize()))).create();
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left5 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            return (Pod)((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)(this.podAllocationSize() + 1)))).create();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("When a current batch reaches error states immediately, re-request them on the next batch.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.podAllocationSize()))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)execId -> this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2())));
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            return (PodResource)((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("Verify stopping deletes the labeled pods", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            this.podsAllocatorUnderTest().stop(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            return ((Deletable)Mockito.verify(this.labeledPods())).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("When an executor is requested but the API does not report it in a reasonable time, retry requesting that executor.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"})).thenReturn(this.labeledPods());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.waitForExecutorPodsClock().setTime(this.podCreationTimeout() + 1L);
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            ((Deletable)Mockito.verify(this.labeledPods())).delete();
            return (PodResource)((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        this.test("SPARK-28487: scale up and down on target executor count changes", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withField("status.phase", "Pending")).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)1))).create();
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)4))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)4))).create();
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left5 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)4))).create();
            ((Filterable)Mockito.verify(this.labeledPods())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"3", "4"});
            ((Deletable)Mockito.verify(this.labeledPods())).delete();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("4"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"4\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(4L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().removeDeletedExecutors();
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("4"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"4\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("SPARK-34334: correctly identify timed out pending pod requests as excess", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withField("status.phase", "Pending")).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource())).create();
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2))})));
            this.snapshotsStore().notifySubscribers();
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            ((Filterable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"});
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout());
            this.snapshotsStore().notifySubscribers();
            ((Filterable)Mockito.verify(this.labeledPods())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"});
            return ((Deletable)Mockito.verify(this.labeledPods())).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("SPARK-33099: Respect executor idle timeout configuration", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withField("status.phase", "Pending")).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)5))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)5))).create();
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)0))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
            ((Filterable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1", "2", "3", "4", "5"});
            ((Deletable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "3", "4"})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
            ((Filterable)Mockito.verify(this.labeledPods())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"2", "5"});
            return ((Deletable)Mockito.verify(this.labeledPods())).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        this.test("SPARK-34361: scheduler backend known pods with multiple resource profiles at downscaling", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withField("status.phase", "Pending")).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)4))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 7;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, rp.id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, rp.id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(6L, rp.id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(7L, rp.id()));
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "4"})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"scheduler backend known PODs are not outstanding", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)7))).create();
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "4", "5"})));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(2L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(3L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(5L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(6L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)7))).create();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)7))).create();
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.times((int)2))).delete();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("6"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"6\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("7"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"7\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)2))})));
            this.snapshotsStore().notifySubscribers();
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)7))).create();
            int $org_scalatest_assert_macro_left5 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)7))).create();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)9))).create();
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(8L, this.defaultProfile().id()));
            return (PodResource)((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(9L, rp.id()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
        this.test("SPARK-33288: multiple resource profiles", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withField("status.phase", "Pending")).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)2))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, rp.id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(3L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)3))).create();
            ((Deletable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 4;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(6L, this.defaultProfile().id()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(7L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(4L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(5L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(7L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)7))).create();
            ((Deletable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left5 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)7))).create();
            ((Filterable)Mockito.verify(this.labeledPods())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"5", "6"});
            ((Filterable)Mockito.verify(this.labeledPods())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"7"});
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.times((int)2))).delete();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("5"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"5\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("6"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"6\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("7"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"7\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(5L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(6L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(7L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().removeDeletedExecutors();
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("5"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"5\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("6"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"6\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("7"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"7\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        this.test("SPARK-33262: pod allocator does not stall with pending pods", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.podsWithNamespace().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"})).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"2", "3", "4", "5", "6"})).thenReturn(this.labeledPods());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)6))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(4L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(5L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.waitForExecutorPodsClock().setTime(this.podAllocationDelay() + 1L);
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
            return (PodResource)((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(6L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        this.test("SPARK-35416: Support PersistentVolumeClaim Reuse", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String prefix = "spark.kubernetes.executor.volumes.persistentVolumeClaim.spark-local-dir-1";
            SparkConf confWithPVC = this.conf().clone().set(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC().key(), "true").set(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC().key(), "true").set(new StringBuilder(11).append(prefix).append(".mount.path").toString(), "/spark-local-dir").set(new StringBuilder(15).append(prefix).append(".mount.readOnly").toString(), "false").set(new StringBuilder(17).append(prefix).append(".option.claimName").toString(), "OnDemand").set(new StringBuilder(17).append(prefix).append(".option.sizeLimit").toString(), "200Gi").set(new StringBuilder(20).append(prefix).append(".option.storageClass").toString(), "gp2");
            PersistentVolumeClaim pvc = ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-0", "gp2", "200Gi");
            pvc.getMetadata().setCreationTimestamp(Instant.now().minus(this.podAllocationDelay() + 1L, ChronoUnit.MILLIS).toString());
            Mockito.when((Object)this.persistentVolumeClaimList().getItems()).thenReturn(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PersistentVolumeClaim[]{pvc}))).asJava());
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(invocation -> {
                KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
                return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithIdAndVolume(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(k8sConf.executorId())), k8sConf.resourceProfileId()), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PersistentVolumeClaim[]{ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-0", "gp2", "200Gi")})));
            });
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(confWithPVC, this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
            Mockito.when((Object)this.podsWithNamespace().withField("status.phase", "Pending")).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)1))).create();
            ((Deletable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume$default$2()));
            return (Resource)((AnyNamespaceOperation)Mockito.verify(this.pvcWithNamespace(), (VerificationMode)Mockito.never())).resource(ArgumentMatchers.any());
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
        this.test("print the pod name instead of Some(name) if pod is absent", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String nonexistentPod = "i-do-not-exist";
            SparkConf conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)nonexistentPod);
            Mockito.when((Object)this.podsWithNamespace().withName(nonexistentPod)).thenReturn((Object)this.driverPodOperations());
            Mockito.when((Object)this.driverPodOperations().get()).thenReturn(null);
            SparkException e = (SparkException)this.intercept((Function0 & Serializable)() -> new ExecutorPodsAllocator(conf, this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()), ClassTag$.MODULE$.apply(SparkException.class), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "No pod was found named i-do-not-exist in the cluster in the namespace default";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
        this.test("SPARK-39688: getReusablePVCs should handle accounts with no PVC permission", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PrivateMethodTester.PrivateMethod getReusablePVCs = PrivateMethodTester$.MODULE$.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "getReusablePVCs"));
            Mockito.when((Object)this.persistentVolumeClaimList().getItems()).thenThrow(new Throwable[]{new KubernetesClientException("Error")});
            return (Buffer)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(getReusablePVCs.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"appId", scala.package$.MODULE$.Seq().empty()})));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
        this.test("SPARK-41388: getReusablePVCs should ignore recently created PVCs in the previous batch", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PrivateMethodTester.PrivateMethod getReusablePVCs = PrivateMethodTester$.MODULE$.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "getReusablePVCs"));
            PersistentVolumeClaim pvc1 = ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-0", "gp2", "200Gi");
            PersistentVolumeClaim pvc2 = ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-1", "gp2", "200Gi");
            Instant now = Instant.now();
            pvc1.getMetadata().setCreationTimestamp(now.minus(2L * this.podAllocationDelay(), ChronoUnit.MILLIS).toString());
            pvc2.getMetadata().setCreationTimestamp(now.toString());
            Mockito.when((Object)this.persistentVolumeClaimList().getItems()).thenReturn(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PersistentVolumeClaim[]{pvc1, pvc2}))).asJava());
            return (Buffer)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(getReusablePVCs.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"appId", scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pvc-1"}))})));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
        this.test("SPARK-41410: Support waitToReusePersistentVolumeClaims", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String prefix = "spark.kubernetes.executor.volumes.persistentVolumeClaim.spark-local-dir-1";
            SparkConf confWithPVC = this.conf().clone().set(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC().key(), "true").set(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC().key(), "true").set(Config$.MODULE$.KUBERNETES_DRIVER_WAIT_TO_REUSE_PVC().key(), "true").set(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key(), "1").set(new StringBuilder(11).append(prefix).append(".mount.path").toString(), "/spark-local-dir").set(new StringBuilder(15).append(prefix).append(".mount.readOnly").toString(), "false").set(new StringBuilder(17).append(prefix).append(".option.claimName").toString(), "OnDemand").set(new StringBuilder(17).append(prefix).append(".option.sizeLimit").toString(), "200Gi").set(new StringBuilder(20).append(prefix).append(".option.storageClass").toString(), "gp3");
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(invocation -> {
                KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
                return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithIdAndVolume(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(k8sConf.executorId())), k8sConf.resourceProfileId()), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PersistentVolumeClaim[]{ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-0", "gp3", "200Gi")})));
            });
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(confWithPVC, this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
            Mockito.when((Object)this.podsWithNamespace().withField("status.phase", "Pending")).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.labeledPods());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            PrivateMethodTester.Invocation counter = PrivateMethodTester$.MODULE$.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "PVC_COUNTER")).apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume$default$2()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)1))).create();
            ((Deletable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.never())).delete();
            ((AnyNamespaceOperation)Mockito.verify(this.pvcWithNamespace(), (VerificationMode)Mockito.times((int)1))).resource(ArgumentMatchers.any());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
            ((CreateOrReplaceable)Mockito.verify((Object)this.podResource(), (VerificationMode)Mockito.times((int)1))).create();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 882));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        this.test("SPARK-41410: An exception during PVC creation should not increase PVC counter", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String prefix = "spark.kubernetes.executor.volumes.persistentVolumeClaim.spark-local-dir-1";
            SparkConf confWithPVC = this.conf().clone().set(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC().key(), "true").set(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC().key(), "true").set(Config$.MODULE$.KUBERNETES_DRIVER_WAIT_TO_REUSE_PVC().key(), "true").set(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key(), "1").set(new StringBuilder(11).append(prefix).append(".mount.path").toString(), "/spark-local-dir").set(new StringBuilder(15).append(prefix).append(".mount.readOnly").toString(), "false").set(new StringBuilder(17).append(prefix).append(".option.claimName").toString(), "OnDemand").set(new StringBuilder(17).append(prefix).append(".option.sizeLimit").toString(), "200Gi").set(new StringBuilder(20).append(prefix).append(".option.storageClass").toString(), "gp3");
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(invocation -> {
                KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
                return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithIdAndVolume(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(k8sConf.executorId())), k8sConf.resourceProfileId()), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PersistentVolumeClaim[]{ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-0", "gp3", "200Gi")})));
            });
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(confWithPVC, this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            PrivateMethodTester.Invocation counter = PrivateMethodTester$.MODULE$.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "PVC_COUNTER")).apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
            Mockito.when((Object)this.pvcResource().create()).thenThrow(new Throwable[]{new KubernetesClientException("PVC fails to create")});
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))}))), ClassTag$.MODULE$.apply(KubernetesClientException.class), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 919));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 922));
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
        Statics.releaseFence();
    }
}

