/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.submit.Client;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Stubber;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatestplus.mockito.MockitoSugar$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-h\u0001B$I\u0001UCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ\u0001\u001a\u0001\u0005\n\u0015DqA\u001e\u0001C\u0002\u0013%q\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002=\t\u0011\u0005\r\u0001A1A\u0005\n]Dq!!\u0002\u0001A\u0003%\u0001\u0010\u0003\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003x\u0011\u001d\tI\u0001\u0001Q\u0001\naD\u0001\"a\u0003\u0001\u0005\u0004%Ia\u001e\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003y\u0011!\ty\u0001\u0001b\u0001\n\u00139\bbBA\t\u0001\u0001\u0006I\u0001\u001f\u0005\t\u0003'\u0001!\u0019!C\u0005o\"9\u0011Q\u0003\u0001!\u0002\u0013A\b\"CA\f\u0001\t\u0007I\u0011BA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\ti\u0005\u0001Q\u0001\n\u0005E\u0002\"CA(\u0001\t\u0007I\u0011BA)\u0011!\tI\u0006\u0001Q\u0001\n\u0005M\u0003\"CA.\u0001\t\u0007I\u0011BA/\u0011!\tY\u0007\u0001Q\u0001\n\u0005}\u0003\"CA7\u0001\t\u0007I\u0011BA8\u0011!\t\u0019\t\u0001Q\u0001\n\u0005E\u0004\"CAC\u0001\t\u0007I\u0011BAD\u0011!\t\t\n\u0001Q\u0001\n\u0005%\u0005\"CAJ\u0001\t\u0007I\u0011BAD\u0011!\t)\n\u0001Q\u0001\n\u0005%\u0005\"CAL\u0001\t\u0007I\u0011BA)\u0011!\tI\n\u0001Q\u0001\n\u0005M\u0003\"CAN\u0001\t\u0007I\u0011BAO\u0011!\t)\u000b\u0001Q\u0001\n\u0005}\u0005bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\n\u0003\u000f\u0004\u0011\u0013!C\u0005\u0003\u0013Dq!a8\u0001\t\u0013\t\t\u000fC\u0005\u0002f\u0002\t\n\u0011\"\u0003\u0002J\"I\u0011q\u001d\u0001C\u0002\u0013%\u0011Q\f\u0005\t\u0003S\u0004\u0001\u0015!\u0003\u0002`!I\u00111\u001e\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0003[\u0004\u0001\u0015!\u0003\u0002r!Y\u0011q\u001e\u0001A\u0002\u0003\u0007I\u0011BAy\u0011-\ty\u0010\u0001a\u0001\u0002\u0004%IA!\u0001\t\u0017\t5\u0001\u00011A\u0001B\u0003&\u00111\u001f\u0005\f\u00053\u0001\u0001\u0019!a\u0001\n\u0013\u0011Y\u0002C\u0006\u0003@\u0001\u0001\r\u00111A\u0005\n\t\u0005\u0003b\u0003B#\u0001\u0001\u0007\t\u0011)Q\u0005\u0005;A1B!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003L!Y!1\u000b\u0001A\u0002\u0003\u0007I\u0011\u0002B+\u0011-\u0011I\u0006\u0001a\u0001\u0002\u0003\u0006KA!\u0014\t\u0017\tu\u0003\u00011AA\u0002\u0013%!q\f\u0005\f\u0005[\u0002\u0001\u0019!a\u0001\n\u0013\u0011y\u0007C\u0006\u0003t\u0001\u0001\r\u0011!Q!\n\t\u0005\u0004b\u0003B<\u0001\u0001\u0007\t\u0019!C\u0005\u0005sB1B!!\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0004\"Y!q\u0011\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B>\u0011-\u0011Y\t\u0001a\u0001\u0002\u0004%IA!$\t\u0017\tU\u0005\u00011AA\u0002\u0013%!q\u0013\u0005\f\u00057\u0003\u0001\u0019!A!B\u0013\u0011y\tC\u0006\u0003 \u0002\u0001\r\u00111A\u0005\n\t\u0005\u0006b\u0003BU\u0001\u0001\u0007\t\u0019!C\u0005\u0005WC1Ba,\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003$\"Y!1\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002B[\u0011-\u0011i\f\u0001a\u0001\u0002\u0004%IAa0\t\u0017\t\r\u0007\u00011A\u0001B\u0003&!q\u0017\u0005\f\u0005\u000b\u0004\u0001\u0019!a\u0001\n\u0013\u00119\rC\u0006\u0003P\u0002\u0001\r\u00111A\u0005\n\tE\u0007b\u0003Bk\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0013D1Ba6\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003Z\"Y!1\u001d\u0001A\u0002\u0003\u0007I\u0011\u0002Bs\u0011-\u0011I\u000f\u0001a\u0001\u0002\u0003\u0006KAa7\u0003\u0017\rc\u0017.\u001a8u'VLG/\u001a\u0006\u0003\u0013*\u000baa];c[&$(BA&M\u0003\rY\u0007h\u001d\u0006\u0003\u001b:\u000ba\u0001Z3qY>L(BA(Q\u0003\u0015\u0019\b/\u0019:l\u0015\t\t&+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0006\u0019qN]4\u0004\u0001M\u0019\u0001A\u0016.\u0011\u0005]CV\"\u0001(\n\u0005es%!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\\=6\tAL\u0003\u0002^%\u0006I1oY1mCR,7\u000f^\u0005\u0003?r\u0013aBQ3g_J,\u0017I\u001c3BMR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002EB\u00111\rA\u0007\u0002\u0011\u0006AAm\u001c*fiV\u0014h\u000e\u0006\u0002g]B\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\tgR,(MY5oO*\u00111NU\u0001\b[>\u001c7.\u001b;p\u0013\ti\u0007NA\u0004TiV\u0014'-\u001a:\t\u000b=\u0014\u0001\u0019\u00019\u0002\u000bY\fG.^3\u0011\u0005E$X\"\u0001:\u000b\u0003M\fQa]2bY\u0006L!!\u001e:\u0003\u0007\u0005s\u00170\u0001\bE%&3VIU0Q\u001f\u0012{V+\u0013#\u0016\u0003a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\t1\fgn\u001a\u0006\u0002{\u0006!!.\u0019<b\u0013\ty(P\u0001\u0004TiJLgnZ\u0001\u0010\tJKe+\u0012*`!>#u,V%EA\u00051BIU%W\u000bJ{\u0006k\u0014#`\u0003BKuLV#S'&{e*A\fE%&3VIU0Q\u001f\u0012{\u0016\tU%`-\u0016\u00136+S(OA\u0005yAIU%W\u000bJ{\u0006k\u0014#`\u0017&sE)\u0001\tE%&3VIU0Q\u001f\u0012{6*\u0013(EA\u0005Q2*\u0016\"F%:+E+R*`%\u0016\u001bv*\u0016*D\u000b~\u0003&+\u0012$J1\u0006Y2*\u0016\"F%:+E+R*`%\u0016\u001bv*\u0016*D\u000b~\u0003&+\u0012$J1\u0002\n\u0001\u0002U(E?:\u000bU*R\u0001\n!>#uLT!N\u000b\u0002\nabQ(O)\u0006Ke*\u0012*`\u001d\u0006kU)A\bD\u001f:#\u0016)\u0013(F%~s\u0015)T#!\u0003U\u0011ViU(M-\u0016#uLS!W\u0003~{\u0005\u000bV%P\u001dN+\"!a\u0007\u0011\r\u0005u\u0011q\u0005=y\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012!C5n[V$\u0018M\u00197f\u0015\r\t)C]\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0015\u0003?\u00111!T1q\u0003Y\u0011ViU(M-\u0016#uLS!W\u0003~{\u0005\u000bV%P\u001dN\u0003\u0013\u0001\u0005\"V\u00132#v\f\u0012*J-\u0016\u0013v\fU(E+\t\t\t\u0004\u0005\u0003\u00024\u0005%SBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u000b5|G-\u001a7\u000b\t\u0005m\u0012QH\u0001\u0004CBL'\u0002BA \u0003\u0003\n!b[;cKJtW\r^3t\u0015\u0011\t\u0019%!\u0012\u0002\u000f\u0019\f'M]5dq)\u0011\u0011qI\u0001\u0003S>LA!a\u0013\u00026\t\u0019\u0001k\u001c3\u0002#\t+\u0016\n\u0014+`\tJKe+\u0012*`!>#\u0005%\u0001\fC+&cEk\u0018#S\u0013Z+%kX\"P\u001dR\u000b\u0015JT#S+\t\t\u0019\u0006\u0005\u0003\u00024\u0005U\u0013\u0002BA,\u0003k\u0011\u0011bQ8oi\u0006Lg.\u001a:\u0002/\t+\u0016\n\u0014+`\tJKe+\u0012*`\u0007>sE+Q%O\u000bJ\u0003\u0013\u0001F!E\t&#\u0016j\u0014(B\u0019~\u0013ViU(V%\u000e+5+\u0006\u0002\u0002`A1\u0011QDA1\u0003KJA!a\u0019\u0002 \t\u00191+Z9\u0011\t\u0005M\u0012qM\u0005\u0005\u0003S\n)D\u0001\u0004TK\u000e\u0014X\r^\u0001\u0016\u0003\u0012#\u0015\nV%P\u001d\u0006cuLU#T\u001fV\u00136)R*!\u00035\u0001&+R0S\u000bN{UKU\"F'V\u0011\u0011\u0011\u000f\t\u0007\u0003;\t\t'a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005\u0011a/\r\u0006\u0005\u0003{\n)$A\u0007ba&,\u0007\u0010^3og&|gn]\u0005\u0005\u0003\u0003\u000b9H\u0001\rDkN$x.\u001c*fg>,(oY3EK\u001aLg.\u001b;j_:\fa\u0002\u0015*F?J+5kT+S\u0007\u0016\u001b\u0006%A\u000bC+&cEkX&V\u0005\u0016\u0013f*\u0012+F'~\u001b\u0006+R\"\u0016\u0005\u0005%\u0005\u0003BAF\u0003\u001bk\u0011AS\u0005\u0004\u0003\u001fS%\u0001F&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s'B,7-\u0001\fC+&cEkX&V\u0005\u0016\u0013f*\u0012+F'~\u001b\u0006+R\"!\u0003\u0005\u0012U+\u0013'U?.+&)\u0012*O\u000bR+5kX*Q\u000b\u000e{v+\u0013+I?B\u0013VIU#T\u0003\t\u0012U+\u0013'U?.+&)\u0012*O\u000bR+5kX*Q\u000b\u000e{v+\u0013+I?B\u0013VIU#TA\u00059b)\u0016'M?\u0016C\u0006+R\"U\u000b\u0012{6i\u0014(U\u0003&sUIU\u0001\u0019\rVcEjX#Y!\u0016\u001bE+\u0012#`\u0007>sE+Q%O\u000bJ\u0003\u0013aC&F3~#vj\u0018)B)\"+\"!a(\u0011\t\u0005M\u0012\u0011U\u0005\u0005\u0003G\u000b)DA\u0005LKf$v\u000eU1uQ\u0006a1*R-`)>{\u0006+\u0011+IA\u0005ya-\u001e7m\u000bb\u0004Xm\u0019;fIB{G\r\u0006\u0003\u00022\u0005-\u0006\"CAWCA\u0005\t\u0019AAX\u0003)YW-\u001f+p!\u0006$\bn\u001d\t\u0007\u0003c\u000b\t-a(\u000f\t\u0005M\u0016Q\u0018\b\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011\u0018+\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0018bAA`e\u00069\u0001/Y2lC\u001e,\u0017\u0002BAb\u0003\u000b\u0014A\u0001T5ti*\u0019\u0011q\u0018:\u00023\u0019,H\u000e\\#ya\u0016\u001cG/\u001a3Q_\u0012$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017TC!a,\u0002N.\u0012\u0011q\u001a\t\u0005\u0003#\fY.\u0004\u0002\u0002T*!\u0011Q[Al\u0003%)hn\u00195fG.,GMC\u0002\u0002ZJ\f!\"\u00198o_R\fG/[8o\u0013\u0011\ti.a5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000bq_\u0012<\u0016\u000e\u001e5Po:,'OU3gKJ,gnY3\u0015\t\u0005E\u00121\u001d\u0005\n\u0003[\u001b\u0003\u0013!a\u0001\u0003_\u000bq\u0004]8e/&$\bnT<oKJ\u0014VMZ3sK:\u001cW\r\n3fM\u0006,H\u000e\u001e\u00132\u0003)\nE\tR%U\u0013>s\u0015\tT0S\u000bN{UKU\"F'~;\u0016\n\u0016%`\u001f^sUIU0S\u000b\u001a+%+\u0012(D\u000bN\u000b1&\u0011#E\u0013RKuJT!M?J+5kT+S\u0007\u0016\u001bvlV%U\u0011~{uKT#S?J+e)\u0012*F\u001d\u000e+5\u000bI\u0001/!J+u,\u0011#E\u0013RKuJT!M?J+5kT+S\u0007\u0016\u001bvlV%U\u0011~{uKT#S?J+e)\u0012*F\u001d\u000e+5+A\u0018Q%\u0016{\u0016\t\u0012#J)&{e*\u0011'`%\u0016\u001bv*\u0016*D\u000bN{v+\u0013+I?>;f*\u0012*`%\u00163UIU#O\u0007\u0016\u001b\u0006%\u0001\tlk\n,'O\\3uKN\u001cE.[3oiV\u0011\u00111\u001f\t\u0005\u0003k\fY0\u0004\u0002\u0002x*!\u0011\u0011`A\u001f\u0003\u0019\u0019G.[3oi&!\u0011Q`A|\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG/\u0001\u000blk\n,'O\\3uKN\u001cE.[3oi~#S-\u001d\u000b\u0005\u0005\u0007\u0011I\u0001E\u0002r\u0005\u000bI1Aa\u0002s\u0005\u0011)f.\u001b;\t\u0013\t-!&!AA\u0002\u0005M\u0018a\u0001=%c\u0005\t2.\u001e2fe:,G/Z:DY&,g\u000e\u001e\u0011)\u0007-\u0012\t\u0002\u0005\u0003\u0003\u0014\tUQ\"\u00016\n\u0007\t]!N\u0001\u0003N_\u000e\\\u0017!\u00049pI>\u0003XM]1uS>t7/\u0006\u0002\u0003\u001eA!!q\u0004B\u001d\u001d\u0011\u0011\tC!\u000e\u000f\t\t\r\"1\u0007\b\u0005\u0005K\u0011\tD\u0004\u0003\u0003(\t=b\u0002\u0002B\u0015\u0005[qA!!.\u0003,%\t1+\u0003\u0002R%&\u0011q\nU\u0005\u0003\u001b:K!a\u0013'\n\u0007\t]\"*\u0001\bGC\n\u0014\u0018n\u0019\u001dBY&\f7/Z:\n\t\tm\"Q\b\u0002\u0005!>#5KC\u0002\u00038)\u000b\u0011\u0003]8e\u001fB,'/\u0019;j_:\u001cx\fJ3r)\u0011\u0011\u0019Aa\u0011\t\u0013\t-Q&!AA\u0002\tu\u0011A\u00049pI>\u0003XM]1uS>t7\u000f\t\u0015\u0004]\tE\u0011!\u00059pIN<\u0016\u000e\u001e5OC6,7\u000f]1dKV\u0011!Q\n\t\u0005\u0005?\u0011y%\u0003\u0003\u0003R\tu\"a\u0005)P\tN{v+\u0013+I?:\u000bU*R*Q\u0003\u000e+\u0015!\u00069pIN<\u0016\u000e\u001e5OC6,7\u000f]1dK~#S-\u001d\u000b\u0005\u0005\u0007\u00119\u0006C\u0005\u0003\fA\n\t\u00111\u0001\u0003N\u0005\u0011\u0002o\u001c3t/&$\bNT1nKN\u0004\u0018mY3!Q\r\t$\u0011C\u0001\n]\u0006lW\r\u001a)pIN,\"A!\u0019\u0011\t\t\r$\u0011N\u0007\u0003\u0005KRAAa\u001a\u0002x\u0006\u0019Am\u001d7\n\t\t-$Q\r\u0002\f!>$'+Z:pkJ\u001cW-A\u0007oC6,G\rU8eg~#S-\u001d\u000b\u0005\u0005\u0007\u0011\t\bC\u0005\u0003\fM\n\t\u00111\u0001\u0003b\u0005Qa.Y7fIB{Gm\u001d\u0011)\u0007Q\u0012\t\"A\fm_\u001e<\u0017N\\4Q_\u0012\u001cF/\u0019;vg^\u000bGo\u00195feV\u0011!1\u0010\t\u0004G\nu\u0014b\u0001B@\u0011\n9Bj\\4hS:<\u0007k\u001c3Ti\u0006$Xo],bi\u000eDWM]\u0001\u001cY><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJ|F%Z9\u0015\t\t\r!Q\u0011\u0005\n\u0005\u00171\u0014\u0011!a\u0001\u0005w\n\u0001\u0004\\8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:!Q\r9$\u0011C\u0001\u000eIJLg/\u001a:Ck&dG-\u001a:\u0016\u0005\t=\u0005cA2\u0003\u0012&\u0019!1\u0013%\u0003/-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u0014()^5mI\u0016\u0014\u0018!\u00053sSZ,'OQ;jY\u0012,'o\u0018\u0013fcR!!1\u0001BM\u0011%\u0011Y!OA\u0001\u0002\u0004\u0011y)\u0001\bee&4XM\u001d\"vS2$WM\u001d\u0011)\u0007i\u0012\t\"\u0001\u0007sKN|WO]2f\u0019&\u001cH/\u0006\u0002\u0003$B!!q\u0004BS\u0013\u0011\u00119K!\u0010\u0003\u001bI+5kT+S\u0007\u0016{F*S*U\u0003A\u0011Xm]8ve\u000e,G*[:u?\u0012*\u0017\u000f\u0006\u0003\u0003\u0004\t5\u0006\"\u0003B\u0006y\u0005\u0005\t\u0019\u0001BR\u00035\u0011Xm]8ve\u000e,G*[:uA!\u001aQH!\u0005\u0002\u000b-\u001cwN\u001c4\u0016\u0005\t]\u0006\u0003BAF\u0005sK1Aa/K\u0005QYUOY3s]\u0016$Xm\u001d#sSZ,'oQ8oM\u0006I1nY8oM~#S-\u001d\u000b\u0005\u0005\u0007\u0011\t\rC\u0005\u0003\f}\n\t\u00111\u0001\u00038\u000611nY8oM\u0002\n\u0001d\u0019:fCR,G\rU8e\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s+\t\u0011I\r\u0005\u0004\u0003\u0014\t-\u0017\u0011G\u0005\u0004\u0005\u001bT'AD!sOVlWM\u001c;DCB$xN]\u0001\u001dGJ,\u0017\r^3e!>$\u0017I]4v[\u0016tGoQ1qi>\u0014x\fJ3r)\u0011\u0011\u0019Aa5\t\u0013\t-!)!AA\u0002\t%\u0017!G2sK\u0006$X\r\u001a)pI\u0006\u0013x-^7f]R\u001c\u0015\r\u001d;pe\u0002\nad\u0019:fCR,GMU3t_V\u00148-Z:Be\u001e,X.\u001a8u\u0007\u0006\u0004Ho\u001c:\u0016\u0005\tm\u0007C\u0002B\n\u0005\u0017\u0014i\u000e\u0005\u0003\u00024\t}\u0017\u0002\u0002Bq\u0003k\u00111\u0002S1t\u001b\u0016$\u0018\rZ1uC\u0006\u00113M]3bi\u0016$'+Z:pkJ\u001cWm]!sOVlWM\u001c;DCB$xN]0%KF$BAa\u0001\u0003h\"I!1B#\u0002\u0002\u0003\u0007!1\\\u0001 GJ,\u0017\r^3e%\u0016\u001cx.\u001e:dKN\f%oZ;nK:$8)\u00199u_J\u0004\u0003")
public class ClientSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String DRIVER_POD_UID;
    private final String DRIVER_POD_API_VERSION;
    private final String DRIVER_POD_KIND;
    private final String KUBERNETES_RESOURCE_PREFIX;
    private final String POD_NAME;
    private final String CONTAINER_NAME;
    private final Map<String, String> RESOLVED_JAVA_OPTIONS;
    private final Pod BUILT_DRIVER_POD;
    private final Container BUILT_DRIVER_CONTAINER;
    private final Seq<Secret> ADDITIONAL_RESOURCES;
    private final Seq<CustomResourceDefinition> PRE_RESOURCES;
    private final KubernetesDriverSpec BUILT_KUBERNETES_SPEC;
    private final KubernetesDriverSpec BUILT_KUBERNETES_SPEC_WITH_PRERES;
    private final Container FULL_EXPECTED_CONTAINER;
    private final KeyToPath KEY_TO_PATH;
    private final Seq<Secret> ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    private final Seq<CustomResourceDefinition> PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource> podOperations;
    @Mock
    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace;
    @Mock
    private PodResource namedPods;
    @Mock
    private LoggingPodStatusWatcher loggingPodStatusWatcher;
    @Mock
    private KubernetesDriverBuilder driverBuilder;
    @Mock
    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList;
    private KubernetesDriverConf kconf;
    private ArgumentCaptor<Pod> createdPodArgumentCaptor;
    private ArgumentCaptor<HasMetadata> createdResourcesArgumentCaptor;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private Stubber doReturn(Object value) {
        return Mockito.doReturn((Object)value, (Object[])ScalaRunTime$.MODULE$.toObjectArray(package$.MODULE$.Seq().empty().toArray(ClassTag$.MODULE$.Any())));
    }

    private String DRIVER_POD_UID() {
        return this.DRIVER_POD_UID;
    }

    private String DRIVER_POD_API_VERSION() {
        return this.DRIVER_POD_API_VERSION;
    }

    private String DRIVER_POD_KIND() {
        return this.DRIVER_POD_KIND;
    }

    private String KUBERNETES_RESOURCE_PREFIX() {
        return this.KUBERNETES_RESOURCE_PREFIX;
    }

    private String POD_NAME() {
        return this.POD_NAME;
    }

    private String CONTAINER_NAME() {
        return this.CONTAINER_NAME;
    }

    private Map<String, String> RESOLVED_JAVA_OPTIONS() {
        return this.RESOLVED_JAVA_OPTIONS;
    }

    private Pod BUILT_DRIVER_POD() {
        return this.BUILT_DRIVER_POD;
    }

    private Container BUILT_DRIVER_CONTAINER() {
        return this.BUILT_DRIVER_CONTAINER;
    }

    private Seq<Secret> ADDITIONAL_RESOURCES() {
        return this.ADDITIONAL_RESOURCES;
    }

    private Seq<CustomResourceDefinition> PRE_RESOURCES() {
        return this.PRE_RESOURCES;
    }

    private KubernetesDriverSpec BUILT_KUBERNETES_SPEC() {
        return this.BUILT_KUBERNETES_SPEC;
    }

    private KubernetesDriverSpec BUILT_KUBERNETES_SPEC_WITH_PRERES() {
        return this.BUILT_KUBERNETES_SPEC_WITH_PRERES;
    }

    private Container FULL_EXPECTED_CONTAINER() {
        return this.FULL_EXPECTED_CONTAINER;
    }

    private KeyToPath KEY_TO_PATH() {
        return this.KEY_TO_PATH;
    }

    private Pod fullExpectedPod(List<KeyToPath> keyToPaths) {
        return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(this.BUILT_DRIVER_POD()).editSpec().addToContainers(new Container[]{this.FULL_EXPECTED_CONTAINER()}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withNewConfigMap().withItems((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(keyToPaths).asJava()).withName(KubernetesClientUtils$.MODULE$.configMapNameDriver())).endConfigMap()).endVolume()).endSpec()).build();
    }

    private List<KeyToPath> fullExpectedPod$default$1() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyToPath[]{this.KEY_TO_PATH()}));
    }

    private Pod podWithOwnerReference(List<KeyToPath> keyToPaths) {
        return ((PodBuilder)((PodFluentImpl)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(this.fullExpectedPod(keyToPaths)).editMetadata().withUid(this.DRIVER_POD_UID())).endMetadata()).withApiVersion(this.DRIVER_POD_API_VERSION())).withKind(this.DRIVER_POD_KIND())).build();
    }

    private List<KeyToPath> podWithOwnerReference$default$1() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyToPath[]{this.KEY_TO_PATH()}));
    }

    private Seq<Secret> ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES() {
        return this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    }

    private Seq<CustomResourceDefinition> PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES() {
        return this.PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource> x$1) {
        this.podOperations = x$1;
    }

    private NonNamespaceOperation<Pod, PodList, PodResource> podsWithNamespace() {
        return this.podsWithNamespace;
    }

    private void podsWithNamespace_$eq(NonNamespaceOperation<Pod, PodList, PodResource> x$1) {
        this.podsWithNamespace = x$1;
    }

    private PodResource namedPods() {
        return this.namedPods;
    }

    private void namedPods_$eq(PodResource x$1) {
        this.namedPods = x$1;
    }

    private LoggingPodStatusWatcher loggingPodStatusWatcher() {
        return this.loggingPodStatusWatcher;
    }

    private void loggingPodStatusWatcher_$eq(LoggingPodStatusWatcher x$1) {
        this.loggingPodStatusWatcher = x$1;
    }

    private KubernetesDriverBuilder driverBuilder() {
        return this.driverBuilder;
    }

    private void driverBuilder_$eq(KubernetesDriverBuilder x$1) {
        this.driverBuilder = x$1;
    }

    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList() {
        return this.resourceList;
    }

    private void resourceList_$eq(NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> x$1) {
        this.resourceList = x$1;
    }

    private KubernetesDriverConf kconf() {
        return this.kconf;
    }

    private void kconf_$eq(KubernetesDriverConf x$1) {
        this.kconf = x$1;
    }

    private ArgumentCaptor<Pod> createdPodArgumentCaptor() {
        return this.createdPodArgumentCaptor;
    }

    private void createdPodArgumentCaptor_$eq(ArgumentCaptor<Pod> x$1) {
        this.createdPodArgumentCaptor = x$1;
    }

    private ArgumentCaptor<HasMetadata> createdResourcesArgumentCaptor() {
        return this.createdResourcesArgumentCaptor;
    }

    private void createdResourcesArgumentCaptor_$eq(ArgumentCaptor<HasMetadata> x$1) {
        this.createdResourcesArgumentCaptor = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$new$4(Object x$11) {
        return x$11 instanceof Secret;
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Object x$12) {
        return x$12 instanceof ConfigMap;
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Object x$14) {
        return x$14 instanceof CustomResourceDefinition;
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Object x$15) {
        return x$15 instanceof Secret;
    }

    public static final /* synthetic */ boolean $anonfun$new$10(Object x$16) {
        return x$16 instanceof ConfigMap;
    }

    public static final /* synthetic */ String $anonfun$new$13(int i) {
        return new StringBuilder(9).append("testConf.").append(i).toString();
    }

    private static final Tuple2 testSetup$1() {
        File tempDir = Utils$.MODULE$.createTempDir();
        SparkConf sparkConf = new SparkConf(false).setSparkHome(tempDir.getAbsolutePath());
        File tempConfDir = new File(new StringBuilder(5).append(tempDir.getAbsolutePath()).append("/conf").toString());
        tempConfDir.mkdir();
        Set filteredConfFileNames = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark-env.sh.template", "spark.properties", "spark-defaults.conf", "test.gz", "test2.jar", "non_utf8.txt"}));
        IndexedSeq confFileNames = (IndexedSeq)((IterableOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable)i -> ClientSuite.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)i))).$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark-env.sh"})))).$plus$plus((IterableOnce)filteredConfFileNames);
        IndexedSeq testConfFiles = (IndexedSeq)confFileNames.map((Function1 & Serializable)i -> {
            File file = new File(new StringBuilder(1).append(tempConfDir.getAbsolutePath()).append("/").append((String)i).toString());
            Path path = i.startsWith("non_utf8") ? Files.write(file.toPath(), new byte[]{(byte)0, (byte)161}, new OpenOption[0]) : Files.write(file.toPath(), "conf1key=conf1value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return file.getName();
        });
        File[] $org_scalatest_assert_macro_left = tempConfDir.listFiles();
        int $org_scalatest_assert_macro_right = confFileNames.length();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        Seq expectedConfFiles = (Seq)testConfFiles.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)filteredConfFileNames.contains((Object)elem)));
        return new Tuple2((Object)sparkConf, (Object)expectedConfFiles);
    }

    public static final /* synthetic */ boolean $anonfun$new$18(Object x$19) {
        return x$19 instanceof ConfigMap;
    }

    public ClientSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.DRIVER_POD_UID = "pod-id";
        this.DRIVER_POD_API_VERSION = "v1";
        this.DRIVER_POD_KIND = "pod";
        this.KUBERNETES_RESOURCE_PREFIX = "resource-example";
        this.POD_NAME = "driver";
        this.CONTAINER_NAME = "container";
        this.RESOLVED_JAVA_OPTIONS = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf1key"), (Object)"conf1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf2key"), (Object)"conf2value")}));
        this.BUILT_DRIVER_POD = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.POD_NAME())).endMetadata()).withNewSpec().withHostname("localhost")).endSpec()).build();
        this.BUILT_DRIVER_CONTAINER = ((ContainerBuilder)new ContainerBuilder().withName(this.CONTAINER_NAME())).build();
        this.ADDITIONAL_RESOURCES = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Secret[]{((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName("secret")).endMetadata()).build()}));
        this.PRE_RESOURCES = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CustomResourceDefinition[]{((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName("preCRD")).endMetadata()).build()}));
        this.BUILT_KUBERNETES_SPEC = new KubernetesDriverSpec(new SparkPod(this.BUILT_DRIVER_POD(), this.BUILT_DRIVER_CONTAINER()), (Seq)package$.MODULE$.Nil(), this.ADDITIONAL_RESOURCES(), this.RESOLVED_JAVA_OPTIONS());
        this.BUILT_KUBERNETES_SPEC_WITH_PRERES = new KubernetesDriverSpec(new SparkPod(this.BUILT_DRIVER_POD(), this.BUILT_DRIVER_CONTAINER()), this.PRE_RESOURCES(), this.ADDITIONAL_RESOURCES(), this.RESOLVED_JAVA_OPTIONS());
        this.FULL_EXPECTED_CONTAINER = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(this.BUILT_DRIVER_CONTAINER()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        this.KEY_TO_PATH = new KeyToPath(Constants$.MODULE$.SPARK_CONF_FILE_NAME(), Predef$.MODULE$.int2Integer(420), Constants$.MODULE$.SPARK_CONF_FILE_NAME());
        this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES = (Seq)this.ADDITIONAL_RESOURCES().map((Function1 & Serializable)secret -> ((SecretBuilder)((SecretFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new SecretBuilder(secret).editMetadata().addNewOwnerReference().withName(this.POD_NAME()).withApiVersion(this.DRIVER_POD_API_VERSION()).withKind(this.DRIVER_POD_KIND()).withController(Predef$.MODULE$.boolean2Boolean(true)).withUid(this.DRIVER_POD_UID())).endOwnerReference()).endMetadata()).build());
        this.PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES = (Seq)this.PRE_RESOURCES().map((Function1 & Serializable)crd -> ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new CustomResourceDefinitionBuilder(crd).editMetadata().addNewOwnerReference().withName(this.POD_NAME()).withApiVersion(this.DRIVER_POD_API_VERSION()).withKind(this.DRIVER_POD_KIND()).withController(Predef$.MODULE$.boolean2Boolean(true)).withUid(this.DRIVER_POD_UID())).endOwnerReference()).endMetadata()).build());
        this.before((Function0<Object>)(Function0 & Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Some x$1 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            SparkConf x$2 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$3 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$4 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Seq<KubernetesVolumeSpec> x$14 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$15 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            this.kconf_$eq(KubernetesTestConf$.MODULE$.createDriverConf(x$2, x$3, x$4, x$5, x$6, (Option<String>)x$1, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15));
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(this.kconf(), this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().inNamespace(this.kconf().namespace())).thenReturn(this.podsWithNamespace());
            Mockito.when((Object)this.podsWithNamespace().withName(this.POD_NAME())).thenReturn((Object)this.namedPods());
            this.createdPodArgumentCaptor_$eq((ArgumentCaptor<Pod>)ArgumentCaptor.forClass(Pod.class));
            this.createdResourcesArgumentCaptor_$eq((ArgumentCaptor<HasMetadata>)ArgumentCaptor.forClass(HasMetadata.class));
            Mockito.when((Object)this.podsWithNamespace().resource((Object)this.fullExpectedPod(this.fullExpectedPod$default$1()))).thenReturn((Object)this.namedPods());
            Mockito.when((Object)this.namedPods().create()).thenReturn((Object)this.podWithOwnerReference(this.podWithOwnerReference$default$1()));
            Mockito.when((Object)this.namedPods().watch((Watcher)this.loggingPodStatusWatcher())).thenReturn(MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Watch.class)));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.loggingPodStatusWatcher().watchOrStop(new StringBuilder(1).append(this.kconf().namespace()).append(":").append(this.POD_NAME()).toString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return ((KubernetesClient)this.doReturn(this.resourceList()).when((Object)this.kubernetesClient())).resourceList(new HasMetadata[]{(HasMetadata)this.createdResourcesArgumentCaptor().capture()});
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("The client should configure the pod using the builder.", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            ((AnyNamespaceOperation)Mockito.verify(this.podsWithNamespace())).resource((Object)this.fullExpectedPod(this.fullExpectedPod$default$1()));
            return (Pod)((CreateOrReplaceable)Mockito.verify((Object)this.namedPods())).create();
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("The client should create Kubernetes resources", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            java.util.List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)otherCreatedResources.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            Seq secrets = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray()), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$4(x$11)))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(secrets);
            Seq<Secret> $org_scalatest_assert_macro_right2 = this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            ConfigMap[] configMaps = (ConfigMap[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray()), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$5(x$12)))), (Function1 & Serializable)x$13 -> (ConfigMap)x$13, ClassTag$.MODULE$.apply(ConfigMap.class));
            Seq $org_scalatest_assert_macro_left3 = secrets;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            Object $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left4), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            ConfigMap configMap = (ConfigMap)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])configMaps));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(configMap.getMetadata().getName());
            String $org_scalatest_assert_macro_right3 = KubernetesClientUtils$.MODULE$.configMapNameDriver();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(configMap.getImmutable()), "scala.Predef.Boolean2boolean(configMap.getImmutable())", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(configMap.getData().containsKey(Constants$.MODULE$.SPARK_CONF_FILE_NAME()), "configMap.getData().containsKey(org.apache.spark.deploy.k8s.Constants.SPARK_CONF_FILE_NAME)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            String $org_scalatest_assert_macro_left6 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right4 = "conf1key=conf1value";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            String $org_scalatest_assert_macro_left7 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right5 = "conf2key=conf2value";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("SPARK-37331: The client should create Kubernetes resources with pre resources", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$162 = sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-executor:latest").set(Config$.MODULE$.KUBERNETES_DRIVER_POD_FEATURE_STEPS().key(), "org.apache.spark.deploy.k8s.TestStepTwo,org.apache.spark.deploy.k8s.TestStep");
            Some x$172 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            String x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$27 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$28 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Seq<KubernetesVolumeSpec> x$29 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$30 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf preResKconf = KubernetesTestConf$.MODULE$.createDriverConf(x$162, x$18, x$19, x$20, x$21, (Option<String>)x$172, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(preResKconf, this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC_WITH_PRERES());
            Client submissionClient = new Client(preResKconf, this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            java.util.List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)otherCreatedResources.size()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            Seq preRes = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray()), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$8(x$14)))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)preRes.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(preRes.last());
            CustomResourceDefinition $org_scalatest_assert_macro_right3 = (CustomResourceDefinition)this.PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            Seq secrets = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray()), (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$9(x$15)))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(secrets);
            Seq<Secret> $org_scalatest_assert_macro_right4 = this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            ConfigMap[] configMaps = (ConfigMap[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray()), (Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$10(x$16)))), (Function1 & Serializable)x$17 -> (ConfigMap)x$17, ClassTag$.MODULE$.apply(ConfigMap.class));
            Seq $org_scalatest_assert_macro_left5 = secrets;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            Object $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left6), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            ConfigMap configMap = (ConfigMap)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])configMaps));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(configMap.getMetadata().getName());
            String $org_scalatest_assert_macro_right5 = KubernetesClientUtils$.MODULE$.configMapNameDriver();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(configMap.getImmutable()), "scala.Predef.Boolean2boolean(configMap.getImmutable())", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(configMap.getData().containsKey(Constants$.MODULE$.SPARK_CONF_FILE_NAME()), "configMap.getData().containsKey(org.apache.spark.deploy.k8s.Constants.SPARK_CONF_FILE_NAME)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
            String $org_scalatest_assert_macro_left8 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right6 = "conf1key=conf1value";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            String $org_scalatest_assert_macro_left9 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right7 = "conf2key=conf2value";
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("All files from SPARK_CONF_DIR, except templates, spark config, binary files and are within size limit, should be populated to pod's configMap.", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf sparkConf;
            Seq expectedConfFiles;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = ClientSuite.testSetup$1();
                    if (tuple2 == null) break block2;
                    SparkConf sparkConf2 = (SparkConf)tuple2._1();
                    expectedConfFiles = (Seq)tuple2._2();
                    if (sparkConf2 == null) break block2;
                    sparkConf = sparkConf2;
                    if (expectedConfFiles != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Seq seq = expectedConfFiles;
            Tuple2 tuple2 = new Tuple2((Object)sparkConf, (Object)seq);
            Tuple2 tuple22 = tuple2;
            SparkConf sparkConf3 = (SparkConf)tuple22._1();
            Seq expectedConfFiles2 = (Seq)tuple22._2();
            List expectedKeyToPaths = (List)((SeqOps)((IterableOnceOps)expectedConfFiles2.map((Function1 & Serializable)x -> new KeyToPath(x, Predef$.MODULE$.int2Integer(420), x))).toList().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyToPath[]{this.KEY_TO_PATH()})))).sortBy((Function1 & Serializable)x -> x.getKey(), (Ordering)Ordering.String$.MODULE$);
            Mockito.when((Object)this.podsWithNamespace().resource((Object)this.fullExpectedPod((List<KeyToPath>)expectedKeyToPaths))).thenReturn((Object)this.namedPods());
            Mockito.when((Object)this.namedPods().create()).thenReturn((Object)this.podWithOwnerReference((List<KeyToPath>)expectedKeyToPaths));
            SparkConf x$31 = sparkConf3;
            Some x$32 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            String x$33 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$34 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$35 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$36 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$37 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$38 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$39 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$40 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$41 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$42 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$43 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Seq<KubernetesVolumeSpec> x$44 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$45 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            this.kconf_$eq(KubernetesTestConf$.MODULE$.createDriverConf(x$31, x$33, x$34, x$35, x$36, (Option<String>)x$32, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.kconf().sparkConf().getOption("spark.home").isDefined(), "ClientSuite.this.kconf.sparkConf.getOption(\"spark.home\").isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(this.kconf(), this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC());
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            java.util.List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            ConfigMap[] configMaps = (ConfigMap[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray()), (Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$18(x$19)))), (Function1 & Serializable)x$20 -> (ConfigMap)x$20, ClassTag$.MODULE$.apply(ConfigMap.class));
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            String configMapName = KubernetesClientUtils$.MODULE$.configMapNameDriver();
            ConfigMap configMap = (ConfigMap)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])configMaps));
            String $org_scalatest_assert_macro_left2 = configMap.getMetadata().getName();
            String $org_scalatest_assert_macro_right = configMapName;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            Set configMapLoadedFiles = (Set)((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(configMap.getData().keySet()).asScala()).toSet().$minus((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(configMapLoadedFiles);
            Set $org_scalatest_assert_macro_right2 = (Set)expectedConfFiles2.toSet().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Constants$.MODULE$.SPARK_CONF_FILE_NAME()})));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            configMapLoadedFiles.foreach((Function1 & Serializable)f -> {
                String $org_scalatest_assert_macro_left = (String)configMap.getData().get(f);
                String $org_scalatest_assert_macro_right = "conf1key=conf1value";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            });
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("Waiting for app completion should stall on the watcher", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            return ((LoggingPodStatusWatcher)Mockito.verify((Object)this.loggingPodStatusWatcher())).watchOrStop(new StringBuilder(7).append(this.kconf().namespace()).append(":driver").toString());
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        Statics.releaseFence();
    }
}

