/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesNFSVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf$;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\taRj\\;oiZ{G.^7fg\u001a+\u0017\r^;sKN#X\r]*vSR,'B\u0001\u0003\u0006\u0003!1W-\u0019;ve\u0016\u001c(B\u0001\u0004\b\u0003\rY\u0007h\u001d\u0006\u0003\u0011%\ta\u0001Z3qY>L(B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011!C\u0005\u0003)%\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0004\u0001")
public class MountVolumesFeatureStepSuite
extends SparkFunSuite {
    public MountVolumesFeatureStepSuite() {
        this.test("Mounts hostPath volumes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesHostPathVolumeConf("/hostPath/tmp"));
            Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$2 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$3 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$4 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$14 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$15 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Seq<KubernetesVolumeSpec>)x$1, x$15);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getHostPath().getPath());
            String $org_scalatest_assert_macro_right2 = "/hostPath/tmp";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right4 = "/tmp";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right5 = "testVolume";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly());
            boolean $org_scalatest_assert_macro_right6 = false;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("Mounts persistentVolumeClaims", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvcClaim", KubernetesPVCVolumeConf$.MODULE$.apply$default$2(), KubernetesPVCVolumeConf$.MODULE$.apply$default$3()));
            Seq x$16 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$17 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$27 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$28 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$29 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$30 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, (Seq<KubernetesVolumeSpec>)x$16, x$30);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            PersistentVolumeClaimVolumeSource pvcClaim = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(pvcClaim.getClaimName());
            String $org_scalatest_assert_macro_right2 = "pvcClaim";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right4 = "/tmp";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right5 = "testVolume";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly()), "scala.Predef.Boolean2boolean(configuredPod.container.getVolumeMounts().get(0).getReadOnly())", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("SPARK-32713 Mounts parameterized persistentVolumeClaims in executors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvc-spark-SPARK_EXECUTOR_ID", KubernetesPVCVolumeConf$.MODULE$.apply$default$2(), KubernetesPVCVolumeConf$.MODULE$.apply$default$3()));
            Seq x$31 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$32 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$33 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$34 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$35 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$36 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$37 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$38 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$39 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$40 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$41 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$42 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$43 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$44 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$45 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf driverConf = KubernetesTestConf$.MODULE$.createDriverConf(x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, (Seq<KubernetesVolumeSpec>)x$31, x$45);
            MountVolumesFeatureStep driverStep = new MountVolumesFeatureStep((KubernetesConf)driverConf);
            SparkPod driverPod = driverStep.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            PersistentVolumeClaimVolumeSource driverPVC = ((Volume)driverPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(driverPVC.getClaimName());
            String $org_scalatest_assert_macro_right2 = "pvc-spark-SPARK_EXECUTOR_ID";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Seq x$46 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$47 = KubernetesTestConf$.MODULE$.createExecutorConf$default$1();
            Option<Pod> x$48 = KubernetesTestConf$.MODULE$.createExecutorConf$default$2();
            Map<String, String> x$49 = KubernetesTestConf$.MODULE$.createExecutorConf$default$3();
            Map<String, String> x$50 = KubernetesTestConf$.MODULE$.createExecutorConf$default$4();
            Map<String, String> x$51 = KubernetesTestConf$.MODULE$.createExecutorConf$default$5();
            Map<String, String> x$52 = KubernetesTestConf$.MODULE$.createExecutorConf$default$6();
            Map<String, String> x$53 = KubernetesTestConf$.MODULE$.createExecutorConf$default$7();
            KubernetesExecutorConf executorConf = KubernetesTestConf$.MODULE$.createExecutorConf(x$47, x$48, x$49, x$50, x$51, x$52, x$53, (Seq<KubernetesVolumeSpec>)x$46);
            MountVolumesFeatureStep executorStep = new MountVolumesFeatureStep((KubernetesConf)executorConf);
            SparkPod executorPod = executorStep.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executorPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            PersistentVolumeClaimVolumeSource executorPVC = ((Volume)executorPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(executorPVC.getClaimName());
            String $org_scalatest_assert_macro_right4 = new StringBuilder(10).append("pvc-spark-").append(KubernetesTestConf$.MODULE$.EXECUTOR_ID()).toString();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("SPARK-32713 Mounts parameterized persistentVolumeClaims in executors with storage class", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvc-spark-SPARK_EXECUTOR_ID", (Option)new Some((Object)"fast"), (Option)new Some((Object)"512mb")));
            Seq x$54 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$55 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$56 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$57 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$58 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$59 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$60 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$61 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$62 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$63 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$64 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$65 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$66 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$67 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$68 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf driverConf = KubernetesTestConf$.MODULE$.createDriverConf(x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, (Seq<KubernetesVolumeSpec>)x$54, x$68);
            MountVolumesFeatureStep driverStep = new MountVolumesFeatureStep((KubernetesConf)driverConf);
            SparkPod driverPod = driverStep.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            PersistentVolumeClaimVolumeSource driverPVC = ((Volume)driverPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(driverPVC.getClaimName());
            String $org_scalatest_assert_macro_right2 = "pvc-spark-SPARK_EXECUTOR_ID";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Seq x$69 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$70 = KubernetesTestConf$.MODULE$.createExecutorConf$default$1();
            Option<Pod> x$71 = KubernetesTestConf$.MODULE$.createExecutorConf$default$2();
            Map<String, String> x$72 = KubernetesTestConf$.MODULE$.createExecutorConf$default$3();
            Map<String, String> x$73 = KubernetesTestConf$.MODULE$.createExecutorConf$default$4();
            Map<String, String> x$74 = KubernetesTestConf$.MODULE$.createExecutorConf$default$5();
            Map<String, String> x$75 = KubernetesTestConf$.MODULE$.createExecutorConf$default$6();
            Map<String, String> x$76 = KubernetesTestConf$.MODULE$.createExecutorConf$default$7();
            KubernetesExecutorConf executorConf = KubernetesTestConf$.MODULE$.createExecutorConf(x$70, x$71, x$72, x$73, x$74, x$75, x$76, (Seq<KubernetesVolumeSpec>)x$69);
            MountVolumesFeatureStep executorStep = new MountVolumesFeatureStep((KubernetesConf)executorConf);
            SparkPod executorPod = executorStep.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executorPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            PersistentVolumeClaimVolumeSource executorPVC = ((Volume)executorPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(executorPVC.getClaimName());
            String $org_scalatest_assert_macro_right4 = new StringBuilder(10).append("pvc-spark-").append(KubernetesTestConf$.MODULE$.EXECUTOR_ID()).toString();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("Create and mounts persistentVolumeClaims in driver", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("OnDemand", KubernetesPVCVolumeConf$.MODULE$.apply$default$2(), KubernetesPVCVolumeConf$.MODULE$.apply$default$3()));
            Seq x$77 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$78 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$79 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$80 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$81 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$82 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$83 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$84 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$85 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$86 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$87 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$88 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$89 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$90 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$91 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, (Seq<KubernetesVolumeSpec>)x$77, x$91);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            PersistentVolumeClaimVolumeSource pvcClaim = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            String $org_scalatest_assert_macro_left2 = pvcClaim.getClaimName();
            String $org_scalatest_assert_macro_right2 = "-driver-pvc-0";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "endsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.endsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("Create and mount persistentVolumeClaims in executors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND(), KubernetesPVCVolumeConf$.MODULE$.apply$default$2(), KubernetesPVCVolumeConf$.MODULE$.apply$default$3()));
            Seq x$92 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$93 = KubernetesTestConf$.MODULE$.createExecutorConf$default$1();
            Option<Pod> x$94 = KubernetesTestConf$.MODULE$.createExecutorConf$default$2();
            Map<String, String> x$95 = KubernetesTestConf$.MODULE$.createExecutorConf$default$3();
            Map<String, String> x$96 = KubernetesTestConf$.MODULE$.createExecutorConf$default$4();
            Map<String, String> x$97 = KubernetesTestConf$.MODULE$.createExecutorConf$default$5();
            Map<String, String> x$98 = KubernetesTestConf$.MODULE$.createExecutorConf$default$6();
            Map<String, String> x$99 = KubernetesTestConf$.MODULE$.createExecutorConf$default$7();
            KubernetesExecutorConf executorConf = KubernetesTestConf$.MODULE$.createExecutorConf(x$93, x$94, x$95, x$96, x$97, x$98, x$99, (Seq<KubernetesVolumeSpec>)x$92);
            MountVolumesFeatureStep executorStep = new MountVolumesFeatureStep((KubernetesConf)executorConf);
            SparkPod executorPod = executorStep.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executorPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            PersistentVolumeClaimVolumeSource executorPVC = ((Volume)executorPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            String $org_scalatest_assert_macro_left2 = executorPVC.getClaimName();
            String $org_scalatest_assert_macro_right2 = "-exec-1-pvc-0";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "endsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.endsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("SPARK-39006: Check PVC ClaimName", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf;
            String claimName = new StringBuilder(4).append("pvc-").append(UUID.randomUUID().toString()).toString();
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf(claimName, KubernetesPVCVolumeConf$.MODULE$.apply$default$2(), KubernetesPVCVolumeConf$.MODULE$.apply$default$3()));
            SparkConf x$100 = conf = new SparkConf().set(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES(), (Object)BoxesRunTime.boxToInteger((int)2));
            Seq x$101 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            Option<Pod> x$102 = KubernetesTestConf$.MODULE$.createExecutorConf$default$2();
            Map<String, String> x$103 = KubernetesTestConf$.MODULE$.createExecutorConf$default$3();
            Map<String, String> x$104 = KubernetesTestConf$.MODULE$.createExecutorConf$default$4();
            Map<String, String> x$105 = KubernetesTestConf$.MODULE$.createExecutorConf$default$5();
            Map<String, String> x$106 = KubernetesTestConf$.MODULE$.createExecutorConf$default$6();
            Map<String, String> x$107 = KubernetesTestConf$.MODULE$.createExecutorConf$default$7();
            KubernetesExecutorConf executorConf = KubernetesTestConf$.MODULE$.createExecutorConf(x$100, x$102, x$103, x$104, x$105, x$106, x$107, (Seq<KubernetesVolumeSpec>)x$101);
            ObjectRef executorStep = ObjectRef.create((Object)new MountVolumesFeatureStep((KubernetesConf)executorConf));
            this.assertThrows((Function0 & Serializable)() -> ((MountVolumesFeatureStep)executorStep$1.elem).configurePod(SparkPod$.MODULE$.initialPod()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((Throwable)this.intercept((Function0 & Serializable)() -> ((MountVolumesFeatureStep)executorStep$1.elem).configurePod(SparkPod$.MODULE$.initialPod()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171))).getMessage().equals(new StringBuilder(78).append(new StringBuilder(16).append("PVC ClaimName: ").append(claimName).append(" ").toString()).append("should contain OnDemand or SPARK_EXECUTOR_ID when requiring multiple executors").toString()), "MountVolumesFeatureStepSuite.this.intercept[IllegalArgumentException](executorStep.configurePod(org.apache.spark.deploy.k8s.SparkPod.initialPod()))((ClassTag.apply[IllegalArgumentException](classOf[java.lang.IllegalArgumentException]): scala.reflect.ClassTag[IllegalArgumentException]), (Position.apply(\"MountVolumesFeatureStepSuite.scala\", \"Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.\", 171): org.scalactic.source.Position)).getMessage().equals((\"PVC ClaimName: \".+(claimName).+(\" \"): String).+(\"should contain OnDemand or SPARK_EXECUTOR_ID when requiring multiple executors\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            conf.set(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES(), (Object)BoxesRunTime.boxToInteger((int)1));
            SparkConf x$108 = conf;
            Seq x$109 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            Option<Pod> x$110 = KubernetesTestConf$.MODULE$.createExecutorConf$default$2();
            Map<String, String> x$111 = KubernetesTestConf$.MODULE$.createExecutorConf$default$3();
            Map<String, String> x$112 = KubernetesTestConf$.MODULE$.createExecutorConf$default$4();
            Map<String, String> x$113 = KubernetesTestConf$.MODULE$.createExecutorConf$default$5();
            Map<String, String> x$114 = KubernetesTestConf$.MODULE$.createExecutorConf$default$6();
            Map<String, String> x$115 = KubernetesTestConf$.MODULE$.createExecutorConf$default$7();
            executorConf = KubernetesTestConf$.MODULE$.createExecutorConf(x$108, x$110, x$111, x$112, x$113, x$114, x$115, (Seq<KubernetesVolumeSpec>)x$109);
            executorStep.elem = new MountVolumesFeatureStep((KubernetesConf)executorConf);
            SparkPod executorPod = ((MountVolumesFeatureStep)executorStep.elem).configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executorPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            PersistentVolumeClaimVolumeSource executorPVC = ((Volume)executorPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(executorPVC.getClaimName().equals(claimName), "executorPVC.getClaimName().equals(claimName)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("Mounts emptyDir", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)new Some((Object)"Memory"), (Option)new Some((Object)"6G")));
            Seq x$116 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$117 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$118 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$119 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$120 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$121 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$122 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$123 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$124 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$125 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$126 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$127 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$128 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$129 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$130 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, (Seq<KubernetesVolumeSpec>)x$116, x$130);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            EmptyDirVolumeSource emptyDir = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getEmptyDir();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(emptyDir.getMedium());
            String $org_scalatest_assert_macro_right2 = "Memory";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(emptyDir.getSizeLimit().getAmount());
            String $org_scalatest_assert_macro_right3 = "6";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(emptyDir.getSizeLimit().getFormat());
            String $org_scalatest_assert_macro_right4 = "G";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right6 = "/tmp";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right7 = "testVolume";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly());
            boolean $org_scalatest_assert_macro_right8 = false;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("Mounts emptyDir with no options", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$));
            Seq x$131 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$132 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$133 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$134 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$135 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$136 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$137 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$138 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$139 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$140 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$141 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$142 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$143 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$144 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$145 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, (Seq<KubernetesVolumeSpec>)x$131, x$145);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            EmptyDirVolumeSource emptyDir = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getEmptyDir();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(emptyDir.getMedium());
            String $org_scalatest_assert_macro_right2 = "";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(emptyDir.getSizeLimit());
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", null, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right5 = "/tmp";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right6 = "testVolume";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly());
            boolean $org_scalatest_assert_macro_right7 = false;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("Mounts read/write nfs volumes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesNFSVolumeConf("/share/name", "nfs.example.com"));
            Seq x$146 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$147 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$148 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$149 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$150 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$151 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$152 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$153 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$154 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$155 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$156 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$157 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$158 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$159 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$160 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, (Seq<KubernetesVolumeSpec>)x$146, x$160);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getNfs().getPath());
            String $org_scalatest_assert_macro_right2 = "/share/name";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getNfs().getReadOnly());
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", null, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getNfs().getServer());
            String $org_scalatest_assert_macro_right4 = "nfs.example.com";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right6 = "/tmp";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right7 = "testVolume";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly());
            boolean $org_scalatest_assert_macro_right8 = false;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("Mounts read-only nfs volumes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", true, (KubernetesVolumeSpecificConf)new KubernetesNFSVolumeConf("/share/name", "nfs.example.com"));
            Seq x$161 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$162 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$163 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$164 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$165 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$166 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$167 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$168 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$169 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$170 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$171 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$172 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$173 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$174 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$175 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, (Seq<KubernetesVolumeSpec>)x$161, x$175);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getNfs().getPath());
            String $org_scalatest_assert_macro_right2 = "/share/name";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getNfs().getReadOnly());
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", null, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getNfs().getServer());
            String $org_scalatest_assert_macro_right4 = "nfs.example.com";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right6 = "/tmp";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right7 = "testVolume";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly());
            boolean $org_scalatest_assert_macro_right8 = true;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("Mounts multiple volumes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec hpVolumeConf = new KubernetesVolumeSpec("hpVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesHostPathVolumeConf("/hostPath/tmp"));
            KubernetesVolumeSpec pvcVolumeConf = new KubernetesVolumeSpec("checkpointVolume", "/checkpoints", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvcClaim", KubernetesPVCVolumeConf$.MODULE$.apply$default$2(), KubernetesPVCVolumeConf$.MODULE$.apply$default$3()));
            Seq x$176 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{hpVolumeConf, pvcVolumeConf}));
            SparkConf x$177 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$178 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$179 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$180 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$181 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$182 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$183 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$184 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$185 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$186 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$187 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$188 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$189 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$190 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$177, x$178, x$179, x$180, x$181, x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189, (Seq<KubernetesVolumeSpec>)x$176, x$190);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        this.test("mountPath should be unique", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String m;
            KubernetesVolumeSpec hpVolumeConf = new KubernetesVolumeSpec("hpVolume", "/data", "", false, (KubernetesVolumeSpecificConf)new KubernetesHostPathVolumeConf("/hostPath/tmp"));
            KubernetesVolumeSpec pvcVolumeConf = new KubernetesVolumeSpec("checkpointVolume", "/data", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvcClaim", KubernetesPVCVolumeConf$.MODULE$.apply$default$2(), KubernetesPVCVolumeConf$.MODULE$.apply$default$3()));
            Seq x$191 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{hpVolumeConf, pvcVolumeConf}));
            SparkConf x$192 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$193 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$194 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$195 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$196 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$197 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$198 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$199 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$200 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$201 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$202 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$203 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$204 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$205 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$192, x$193, x$194, x$195, x$196, x$197, x$198, x$199, x$200, x$201, x$202, x$203, x$204, (Seq<KubernetesVolumeSpec>)x$191, x$205);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            String $org_scalatest_assert_macro_left = m = ((Throwable)this.intercept((Function0 & Serializable)() -> step.configurePod(SparkPod$.MODULE$.initialPod()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320))).getMessage();
            String $org_scalatest_assert_macro_right = "Found duplicated mountPath: '/data'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        this.test("Mounts subpath on emptyDir", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "foo", false, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$));
            Seq x$206 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$207 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$208 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$209 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$210 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$211 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$212 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$213 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$214 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$215 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$216 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$217 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$218 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$219 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$220 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$207, x$208, x$209, x$210, x$211, x$212, x$213, x$214, x$215, x$216, x$217, x$218, x$219, (Seq<KubernetesVolumeSpec>)x$206, x$220);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
            VolumeMount emptyDirMount = (VolumeMount)configuredPod.container().getVolumeMounts().get(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(emptyDirMount.getMountPath());
            String $org_scalatest_assert_macro_right2 = "/tmp";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(emptyDirMount.getName());
            String $org_scalatest_assert_macro_right3 = "testVolume";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(emptyDirMount.getSubPath());
            String $org_scalatest_assert_macro_right4 = "foo";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("Mounts subpath on persistentVolumeClaims", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "bar", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvcClaim", KubernetesPVCVolumeConf$.MODULE$.apply$default$2(), KubernetesPVCVolumeConf$.MODULE$.apply$default$3()));
            Seq x$221 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$222 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$223 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$224 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$225 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$226 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$227 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$228 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$229 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$230 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$231 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$232 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$233 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$234 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$235 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$231, x$232, x$233, x$234, (Seq<KubernetesVolumeSpec>)x$221, x$235);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            PersistentVolumeClaimVolumeSource pvcClaim = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(pvcClaim.getClaimName());
            String $org_scalatest_assert_macro_right2 = "pvcClaim";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            VolumeMount pvcMount = (VolumeMount)configuredPod.container().getVolumeMounts().get(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(pvcMount.getMountPath());
            String $org_scalatest_assert_macro_right4 = "/tmp";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(pvcMount.getName());
            String $org_scalatest_assert_macro_right5 = "testVolume";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(pvcMount.getSubPath());
            String $org_scalatest_assert_macro_right6 = "bar";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        this.test("Mounts multiple subpaths", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            KubernetesEmptyDirVolumeConf volumeConf = new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$);
            KubernetesVolumeSpec emptyDirSpec = new KubernetesVolumeSpec("testEmptyDir", "/tmp/foo", "foo", true, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$));
            KubernetesVolumeSpec pvcSpec = new KubernetesVolumeSpec("testPVC", "/tmp/bar", "bar", true, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$));
            Seq x$236 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{emptyDirSpec, pvcSpec}));
            SparkConf x$237 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$238 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$239 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$240 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$241 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$242 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$243 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$244 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$245 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$246 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$247 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$248 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$249 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$250 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$237, x$238, x$239, x$240, x$241, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, (Seq<KubernetesVolumeSpec>)x$236, x$250);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            Buffer mounts = (Buffer)((SeqOps)JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.container().getVolumeMounts()).asScala()).sortBy((Function1 & Serializable)x$1 -> x$1.getName(), (Ordering)Ordering.String$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mounts.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((VolumeMount)mounts.apply(0)).getName());
            String $org_scalatest_assert_macro_right3 = "testEmptyDir";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((VolumeMount)mounts.apply(0)).getMountPath());
            String $org_scalatest_assert_macro_right4 = "/tmp/foo";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((VolumeMount)mounts.apply(0)).getSubPath());
            String $org_scalatest_assert_macro_right5 = "foo";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)mounts.apply(1)).getName());
            String $org_scalatest_assert_macro_right6 = "testPVC";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((VolumeMount)mounts.apply(1)).getMountPath());
            String $org_scalatest_assert_macro_right7 = "/tmp/bar";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((VolumeMount)mounts.apply(1)).getSubPath());
            String $org_scalatest_assert_macro_right8 = "bar";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
    }
}

