/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.ExecutorKubernetesCredentialsFeatureStep;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005u3A\u0001C\u0005\u0001-!)\u0011\u0005\u0001C\u0001E!IQ\u0005\u0001a\u0001\u0002\u0004%IA\n\u0005\nU\u0001\u0001\r\u00111A\u0005\n-B\u0011\u0002\u000e\u0001A\u0002\u0003\u0005\u000b\u0015B\u0014\t\u000bU\u0002A\u0011\u0002\u001c\t\u000f-\u0003\u0011\u0013!C\u0005\u0019\")q\u000b\u0001C\u00011\niS\t_3dkR|'oS;cKJtW\r^3t\u0007J,G-\u001a8uS\u0006d7OR3biV\u0014Xm\u0015;faN+\u0018\u000e^3\u000b\u0005)Y\u0011\u0001\u00034fCR,(/Z:\u000b\u00051i\u0011aA69g*\u0011abD\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005A\t\u0012!B:qCJ\\'B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001/m\u0001\"\u0001G\r\u000e\u0003=I!AG\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tar$D\u0001\u001e\u0015\tq2#A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0001%\b\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t\u0011\"\u0001\u0005cCN,7i\u001c8g+\u00059\u0003C\u0001\r)\u0013\tIsBA\u0005Ta\u0006\u00148nQ8oM\u0006a!-Y:f\u0007>tgm\u0018\u0013fcR\u0011AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000fC\u00044\u0007\u0005\u0005\t\u0019A\u0014\u0002\u0007a$\u0013'A\u0005cCN,7i\u001c8gA\u0005ya.Z<Fq\u0016\u001cW\u000f^8s\u0007>tg\r\u0006\u00028wA\u0011\u0001(O\u0007\u0002\u0017%\u0011!h\u0003\u0002\u0017\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'oQ8oM\"9A(\u0002I\u0001\u0002\u0004i\u0014aC3om&\u0014xN\\7f]R\u0004BAP#I\u0011:\u0011qh\u0011\t\u0003\u0001:j\u0011!\u0011\u0006\u0003\u0005V\ta\u0001\u0010:p_Rt\u0014B\u0001#/\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0004\u001b\u0006\u0004(B\u0001#/!\tq\u0014*\u0003\u0002K\u000f\n11\u000b\u001e:j]\u001e\f\u0011D\\3x\u000bb,7-\u001e;pe\u000e{gN\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\tQJ\u000b\u0002>\u001d.\nq\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003):\n!\"\u00198o_R\fG/[8o\u0013\t1\u0016KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA\"Y:tKJ$8+\u0011(b[\u0016$2\u0001L-\\\u0011\u0015Qv\u00011\u0001I\u0003I\u0019XM\u001d<jG\u0016\f5mY8v]Rt\u0015-\\3\t\u000bq;\u0001\u0019\u0001%\u0002\u0017\u0005\u001c7m\\;oi:\u000bW.\u001a")
public class ExecutorKubernetesCredentialsFeatureStepSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private SparkConf baseConf;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkConf baseConf() {
        return this.baseConf;
    }

    private void baseConf_$eq(SparkConf x$1) {
        this.baseConf = x$1;
    }

    private KubernetesExecutorConf newExecutorConf(Map<String, String> environment) {
        SparkConf x$1 = this.baseConf();
        Map<String, String> x$2 = environment;
        Option<Pod> x$3 = KubernetesTestConf$.MODULE$.createExecutorConf$default$2();
        Map<String, String> x$4 = KubernetesTestConf$.MODULE$.createExecutorConf$default$3();
        Map<String, String> x$5 = KubernetesTestConf$.MODULE$.createExecutorConf$default$5();
        Map<String, String> x$6 = KubernetesTestConf$.MODULE$.createExecutorConf$default$6();
        Map<String, String> x$7 = KubernetesTestConf$.MODULE$.createExecutorConf$default$7();
        Seq<KubernetesVolumeSpec> x$8 = KubernetesTestConf$.MODULE$.createExecutorConf$default$8();
        return KubernetesTestConf$.MODULE$.createExecutorConf(x$1, x$3, x$4, x$2, x$5, x$6, x$7, x$8);
    }

    private Map<String, String> newExecutorConf$default$1() {
        return Predef$.MODULE$.Map().empty();
    }

    public void assertSAName(String serviceAccountName, String accountName) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(serviceAccountName.equals(serviceAccountName), "serviceAccountName.equals(serviceAccountName)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(accountName.equals(accountName), "accountName.equals(accountName)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    public ExecutorKubernetesCredentialsFeatureStepSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.baseConf_$eq(new SparkConf(false)), new Position("ExecutorKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("configure spark pod with executor service account", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_SERVICE_ACCOUNT_NAME(), (Object)"executor-name");
            ExecutorKubernetesCredentialsFeatureStep step = new ExecutorKubernetesCredentialsFeatureStep((KubernetesConf)this.newExecutorConf(this.newExecutorConf$default$1()));
            PodSpec spec = step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec();
            String serviceAccountName = spec.getServiceAccountName();
            String accountName = spec.getServiceAccount();
            this.assertSAName(serviceAccountName, accountName);
        }, new Position("ExecutorKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("configure spark pod with with driver service account and without executor service account", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.baseConf().set(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_ACCOUNT_NAME(), (Object)"driver-name");
            ExecutorKubernetesCredentialsFeatureStep step = new ExecutorKubernetesCredentialsFeatureStep((KubernetesConf)this.newExecutorConf(this.newExecutorConf$default$1()));
            PodSpec spec = step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec();
            String serviceAccountName = spec.getServiceAccountName();
            String accountName = spec.getServiceAccount();
            this.assertSAName(serviceAccountName, accountName);
        }, new Position("ExecutorKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("configure spark pod with with driver service account and with executor service account", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.baseConf().set(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_ACCOUNT_NAME(), (Object)"driver-name");
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_SERVICE_ACCOUNT_NAME(), (Object)"executor-name");
            ExecutorKubernetesCredentialsFeatureStep step = new ExecutorKubernetesCredentialsFeatureStep((KubernetesConf)this.newExecutorConf(this.newExecutorConf$default$1()));
            PodSpec spec = step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec();
            String serviceAccountName = spec.getServiceAccountName();
            String accountName = spec.getServiceAccount();
            this.assertSAName(serviceAccountName, accountName);
        }, new Position("ExecutorKubernetesCredentialsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Statics.releaseFence();
    }
}

