/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.net.InternetDomainName;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005-4Aa\u0003\u0007\u00013!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003BB\u0019\u0001A\u0003%A\u0005C\u00043\u0001\t\u0007I\u0011B\u001a\t\r\r\u0003\u0001\u0015!\u00035\u0011\u001d!\u0005A1A\u0005\nMBa!\u0012\u0001!\u0002\u0013!\u0004b\u0002$\u0001\u0005\u0004%Ia\r\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002\u001b\t\u000b!\u0003A\u0011B%\u0003;\u0011\u0013\u0018N^3s'\u0016\u0014h/[2f\r\u0016\fG/\u001e:f'R,\u0007oU;ji\u0016T!!\u0004\b\u0002\u0011\u0019,\u0017\r^;sKNT!a\u0004\t\u0002\u0007-D4O\u0003\u0002\u0012%\u00051A-\u001a9m_fT!a\u0005\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c95\t!#\u0003\u0002\u001e%\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0007\u000231{ejR0S\u000bN{UKU\"F?:\u000bU*R0Q%\u00163\u0015\nW\u000b\u0002IA\u0011QE\f\b\u0003M1\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\r\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055R\u0013A\u0007'P\u001d\u001e{&+R*P+J\u001bUi\u0018(B\u001b\u0016{\u0006KU#G\u0013b\u0003\u0013!\u0004#S\u0013Z+%k\u0018'B\u0005\u0016c5+F\u00015!\u0011)$\b\u0010\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0013%lW.\u001e;bE2,'BA\u001d+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003wY\u00121!T1q!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003_y\na\u0002\u0012*J-\u0016\u0013v\fT!C\u000b2\u001b\u0006%\u0001\u000eE%&3VIU0T\u000bJ3\u0016jQ#`\u0003:su\nV!U\u0013>s5+A\u000eE%&3VIU0T\u000bJ3\u0016jQ#`\u0003:su\nV!U\u0013>s5\u000bI\u0001\u0016\tJKe+\u0012*`'\u0016\u0013f+S\"F?2\u000b%)\u0012'T\u0003Y!%+\u0013,F%~\u001bVI\u0015,J\u0007\u0016{F*\u0011\"F\u0019N\u0003\u0013!\u0004<fe&4\u0017pU3sm&\u001cW\rF\u0004K\u001dN+v+W.\u0011\u0005-cU\"\u0001\u0016\n\u00055S#\u0001B+oSRDQa\u0014\u0006A\u0002A\u000b!\u0002\u001a:jm\u0016\u0014\bk\u001c:u!\tY\u0015+\u0003\u0002SU\t\u0019\u0011J\u001c;\t\u000bQS\u0001\u0019\u0001)\u0002!\tdwnY6NC:\fw-\u001a:Q_J$\b\"\u0002,\u000b\u0001\u0004\u0001\u0016a\u00033sS\u0016\u0014X+\u0013)peRDQ\u0001\u0017\u0006A\u0002\u0011\n1#\u001a=qK\u000e$X\rZ*feZL7-\u001a(b[\u0016DQA\u0017\u0006A\u0002\u0011\nQ!\u00199q\u0013\u0012DQ\u0001\u0018\u0006A\u0002u\u000bqa]3sm&\u001cW\r\u0005\u0002_S6\tqL\u0003\u0002aC\u0006)Qn\u001c3fY*\u0011!mY\u0001\u0004CBL'B\u00013f\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003M\u001e\fqAZ1ce&\u001c\u0007HC\u0001i\u0003\tIw.\u0003\u0002k?\n91+\u001a:wS\u000e,\u0007")
public class DriverServiceFeatureStepSuite
extends SparkFunSuite {
    private final String LONG_RESOURCE_NAME_PREFIX = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH() - DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX().length() + 1);
    private final Map<String, String> DRIVER_LABELS = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label1key"), (Object)"label1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label2key"), (Object)"label2value")}));
    private final Map<String, String> DRIVER_SERVICE_ANNOTATIONS = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"annotation1key"), (Object)"annotation1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"annotation2key"), (Object)"annotation2value")}));
    private final Map<String, String> DRIVER_SERVICE_LABELS = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"svclabel1key"), (Object)"svclabel1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"svclabel2key"), (Object)"svclabel2value")}));

    private String LONG_RESOURCE_NAME_PREFIX() {
        return this.LONG_RESOURCE_NAME_PREFIX;
    }

    private Map<String, String> DRIVER_LABELS() {
        return this.DRIVER_LABELS;
    }

    private Map<String, String> DRIVER_SERVICE_ANNOTATIONS() {
        return this.DRIVER_SERVICE_ANNOTATIONS;
    }

    private Map<String, String> DRIVER_SERVICE_LABELS() {
        return this.DRIVER_SERVICE_LABELS;
    }

    private void verifyService(int driverPort, int blockManagerPort, int drierUIPort, String expectedServiceName, String appId, Service service) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getMetadata().getName());
        String $org_scalatest_assert_macro_right = expectedServiceName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.simpleMacroBool(service.getMetadata().getLabels().containsKey(Constants$.MODULE$.SPARK_APP_ID_LABEL()), "service.getMetadata().getLabels().containsKey(org.apache.spark.deploy.k8s.Constants.SPARK_APP_ID_LABEL)", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_right2 = $org_scalatest_assert_macro_left2.value() ? Bool$.MODULE$.simpleMacroBool(((String)service.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_APP_ID_LABEL())).equals(appId), "service.getMetadata().getLabels().get(org.apache.spark.deploy.k8s.Constants.SPARK_APP_ID_LABEL).equals(appId)", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(service.getSpec().getClusterIP());
        String $org_scalatest_assert_macro_right3 = "None";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.DRIVER_LABELS().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getSpec().getSelector().get(k));
            String $org_scalatest_assert_macro_right = v;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            return assertion;
        });
        this.DRIVER_SERVICE_LABELS().foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getMetadata().getLabels().get(k));
            String $org_scalatest_assert_macro_right = v;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            return assertion;
        });
        this.DRIVER_SERVICE_ANNOTATIONS().foreach((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getMetadata().getAnnotations().get(k));
            String $org_scalatest_assert_macro_right = v;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            return assertion;
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)service.getSpec().getPorts().size()));
        int $org_scalatest_assert_macro_right4 = 3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        Buffer driverServicePorts = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(service.getSpec().getPorts()).asScala();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((ServicePort)driverServicePorts.head()).getName());
        String $org_scalatest_assert_macro_right5 = Constants$.MODULE$.DRIVER_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.head()).getPort()));
        int $org_scalatest_assert_macro_right6 = driverPort;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((ServicePort)driverServicePorts.head()).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right7 = driverPort;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(1)).getName());
        String $org_scalatest_assert_macro_right8 = Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.apply(1)).getPort()));
        int $org_scalatest_assert_macro_right9 = blockManagerPort;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(1)).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right10 = blockManagerPort;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(2)).getName());
        String $org_scalatest_assert_macro_right11 = Constants$.MODULE$.UI_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.apply(2)).getPort()));
        int $org_scalatest_assert_macro_right12 = drierUIPort;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(2)).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right13 = drierUIPort;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$5(KubernetesDriverConf kconf$1, ManualClock clock$1, int x$1) {
        DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf$1, (Clock)clock$1);
        String serviceName = ((Service)configurationStep.getAdditionalKubernetesResources().head()).getMetadata().getName();
        String hostAddress = (String)configurationStep.getAdditionalPodSystemProperties().apply((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS().key());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)serviceName), (Object)hostAddress);
    }

    public static final /* synthetic */ void $anonfun$new$13(DriverServiceFeatureStepSuite $this, String stack) {
        scala.collection.immutable.Seq configAndAnswers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"IPv4,IPv6", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"IPv4", "IPv6"}))), new Tuple2((Object)"IPv6,IPv4", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"IPv6", "IPv4"})))}));
        configAndAnswers.foreach((Function1 & Serializable)x0$2 -> {
            SparkConf sparkConf;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String config = (String)tuple2._1();
            scala.collection.immutable.Seq answer = (scala.collection.immutable.Seq)tuple2._2();
            SparkConf x$91 = sparkConf = new SparkConf(false).set(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_IP_FAMILY_POLICY(), (Object)stack).set(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_IP_FAMILIES(), (Object)config);
            Map<String, String> x$92 = $this.DRIVER_LABELS();
            Map<String, String> x$93 = $this.DRIVER_SERVICE_LABELS();
            Map<String, String> x$94 = $this.DRIVER_SERVICE_ANNOTATIONS();
            String x$95 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$96 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$97 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$98 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$99 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$100 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$101 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$102 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$103 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            scala.collection.immutable.Seq<KubernetesVolumeSpec> x$104 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$105 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$91, x$95, x$96, x$97, x$98, x$99, x$92, x$100, x$101, x$93, x$94, x$102, x$103, x$104, x$105);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(configurationStep.configurePod(SparkPod$.MODULE$.initialPod()));
            SparkPod $org_scalatest_assert_macro_right = SparkPod$.MODULE$.initialPod();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            Service driverService = (Service)configurationStep.getAdditionalKubernetesResources().head();
            String $org_scalatest_assert_macro_left2 = driverService.getSpec().getIpFamilyPolicy();
            String $org_scalatest_assert_macro_right2 = stack;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(driverService.getSpec().getIpFamilies());
            List $org_scalatest_assert_macro_right3 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)answer).asJava();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            return assertion;
        });
    }

    public DriverServiceFeatureStepSuite() {
        this.test("Headless service has a port for the driver RPC, the block manager and driver ui.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$1 = sparkConf = new SparkConf(false).set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT(), (Object)BoxesRunTime.boxToInteger((int)9000)).set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)8080)).set(UI$.MODULE$.UI_PORT(), (Object)BoxesRunTime.boxToInteger((int)4080));
            Map<String, String> x$2 = this.DRIVER_LABELS();
            Map<String, String> x$3 = this.DRIVER_SERVICE_LABELS();
            Map<String, String> x$4 = this.DRIVER_SERVICE_ANNOTATIONS();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            scala.collection.immutable.Seq<KubernetesVolumeSpec> x$14 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$15 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$1, x$5, x$6, x$7, x$8, x$9, x$2, x$10, x$11, x$3, x$4, x$12, x$13, x$14, x$15);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configurationStep.configurePod(SparkPod$.MODULE$.initialPod()));
            SparkPod $org_scalatest_assert_macro_right = SparkPod$.MODULE$.initialPod();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configurationStep.getAdditionalKubernetesResources().size()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            HasMetadata $org_scalatest_assert_macro_left3 = (HasMetadata)configurationStep.getAdditionalKubernetesResources().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "io.fabric8.kubernetes.api.model.Service", $org_scalatest_assert_macro_left3 instanceof Service, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Service driverService = (Service)configurationStep.getAdditionalKubernetesResources().head();
            this.verifyService(9000, 8080, 4080, new StringBuilder(0).append(kconf.resourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString(), kconf.appId(), driverService);
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("Hostname and ports are set according to the service name.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$16 = sparkConf = new SparkConf(false).set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT(), (Object)BoxesRunTime.boxToInteger((int)9000)).set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)8080)).set(Config$.MODULE$.KUBERNETES_NAMESPACE(), (Object)"my-namespace");
            Map<String, String> x$17 = this.DRIVER_LABELS();
            String x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$27 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$28 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            scala.collection.immutable.Seq<KubernetesVolumeSpec> x$29 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$30 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$16, x$18, x$19, x$20, x$21, x$22, x$17, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            String expectedServiceName = new StringBuilder(0).append(kconf.resourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
            String expectedHostName = new StringBuilder(17).append(expectedServiceName).append(".my-namespace.svc").toString();
            Map additionalProps = configurationStep.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(additionalProps.apply((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS().key()));
            String $org_scalatest_assert_macro_right = expectedHostName;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("Ports should resolve to defaults in SparkConf and in the service.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Map<String, String> x$31 = this.DRIVER_LABELS();
            Map<String, String> x$32 = this.DRIVER_SERVICE_LABELS();
            Map<String, String> x$33 = this.DRIVER_SERVICE_ANNOTATIONS();
            SparkConf x$34 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$35 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$36 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$37 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$38 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$39 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$40 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$41 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$42 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$43 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            scala.collection.immutable.Seq<KubernetesVolumeSpec> x$44 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$45 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$34, x$35, x$36, x$37, x$38, x$39, x$31, x$40, x$41, x$32, x$33, x$42, x$43, x$44, x$45);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            Service resolvedService = (Service)configurationStep.getAdditionalKubernetesResources().head();
            this.verifyService(Constants$.MODULE$.DEFAULT_DRIVER_PORT(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT(), BoxesRunTime.unboxToInt((Object)UI$.MODULE$.UI_PORT().defaultValue().get()), new StringBuilder(0).append(kconf.resourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString(), kconf.appId(), resolvedService);
            Map additionalProps = configurationStep.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(additionalProps.apply((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key()));
            String $org_scalatest_assert_macro_right = Integer.toString(Constants$.MODULE$.DEFAULT_DRIVER_PORT());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(additionalProps.apply((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key()));
            String $org_scalatest_assert_macro_right2 = Integer.toString(Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("Long prefixes should switch to using a generated unique name.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$46 = sparkConf = new SparkConf(false).set(Config$.MODULE$.KUBERNETES_NAMESPACE(), (Object)"my-namespace");
            Some x$47 = new Some((Object)this.LONG_RESOURCE_NAME_PREFIX());
            Map<String, String> x$48 = this.DRIVER_LABELS();
            String x$49 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$50 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$51 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$52 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$53 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$54 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$55 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$56 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$57 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$58 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            scala.collection.immutable.Seq<KubernetesVolumeSpec> x$59 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$60 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$46, x$49, x$50, x$51, x$52, (Option<String>)x$47, x$48, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
            ManualClock clock = new ManualClock();
            Map services = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$1 -> DriverServiceFeatureStepSuite.$anonfun$new$5(kconf, clock, BoxesRunTime.unboxToInt((Object)x$1))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)services.size()));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            services.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                String address = (String)tuple2._2();
                String $org_scalatest_assert_macro_left = name;
                String $org_scalatest_assert_macro_right = kconf.resourceNamePrefix();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                String $org_scalatest_assert_macro_left2 = address;
                String $org_scalatest_assert_macro_right2 = kconf.resourceNamePrefix();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "startsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.startsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(InternetDomainName.isValid((String)address), "com.google.common.net.InternetDomainName.isValid(address)", Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                return assertion;
            });
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("Disallow bind address and driver host to be set explicitly.", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false).set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BIND_ADDRESS(), (Object)"host").set("spark.app.name", this.LONG_RESOURCE_NAME_PREFIX());
            IllegalArgumentException e1 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> new DriverServiceFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15()), DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e1.getMessage());
            String $org_scalatest_assert_macro_right = new StringBuilder(114).append(new StringBuilder(23).append("requirement failed: ").append(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).append(" is").toString()).append(" not supported in Kubernetes mode, as the driver's bind address is managed").append(" and set to the driver pod's IP address.").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            sparkConf.remove(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BIND_ADDRESS());
            sparkConf.set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS(), (Object)"host");
            IllegalArgumentException e2 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> new DriverServiceFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15()), DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(e2.getMessage());
            String $org_scalatest_assert_macro_right2 = new StringBuilder(101).append(new StringBuilder(23).append("requirement failed: ").append(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).append(" is").toString()).append(" not supported in Kubernetes mode, as the driver's hostname will be managed via").append(" a Kubernetes service.").toString();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("Support ipFamilies spec with default SingleStack and IPv4", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$61 = sparkConf = new SparkConf(false);
            Map<String, String> x$62 = this.DRIVER_LABELS();
            Map<String, String> x$63 = this.DRIVER_SERVICE_LABELS();
            Map<String, String> x$64 = this.DRIVER_SERVICE_ANNOTATIONS();
            String x$65 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$66 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$67 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$68 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$69 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$70 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$71 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$72 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$73 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            scala.collection.immutable.Seq<KubernetesVolumeSpec> x$74 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$75 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$61, x$65, x$66, x$67, x$68, x$69, x$62, x$70, x$71, x$63, x$64, x$72, x$73, x$74, x$75);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configurationStep.configurePod(SparkPod$.MODULE$.initialPod()));
            SparkPod $org_scalatest_assert_macro_right = SparkPod$.MODULE$.initialPod();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Service driverService = (Service)configurationStep.getAdditionalKubernetesResources().head();
            String $org_scalatest_assert_macro_left2 = driverService.getSpec().getIpFamilyPolicy();
            String $org_scalatest_assert_macro_right2 = "SingleStack";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverService.getSpec().getIpFamilies().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            String $org_scalatest_assert_macro_left4 = (String)driverService.getSpec().getIpFamilies().get(0);
            String $org_scalatest_assert_macro_right4 = "IPv4";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("Support ipFamilies spec with SingleStack and IPv6", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$76 = sparkConf = new SparkConf(false).set(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_IP_FAMILIES(), (Object)"IPv6");
            Map<String, String> x$77 = this.DRIVER_LABELS();
            Map<String, String> x$78 = this.DRIVER_SERVICE_LABELS();
            Map<String, String> x$79 = this.DRIVER_SERVICE_ANNOTATIONS();
            String x$80 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$81 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$82 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$83 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$84 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$85 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$86 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$87 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Map<String, String> x$88 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            scala.collection.immutable.Seq<KubernetesVolumeSpec> x$89 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$90 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$76, x$80, x$81, x$82, x$83, x$84, x$77, x$85, x$86, x$78, x$79, x$87, x$88, x$89, x$90);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configurationStep.configurePod(SparkPod$.MODULE$.initialPod()));
            SparkPod $org_scalatest_assert_macro_right = SparkPod$.MODULE$.initialPod();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            Service driverService = (Service)configurationStep.getAdditionalKubernetesResources().head();
            String $org_scalatest_assert_macro_left2 = driverService.getSpec().getIpFamilyPolicy();
            String $org_scalatest_assert_macro_right2 = "SingleStack";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverService.getSpec().getIpFamilies().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            String $org_scalatest_assert_macro_left4 = (String)driverService.getSpec().getIpFamilies().get(0);
            String $org_scalatest_assert_macro_right4 = "IPv6";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("Support DualStack", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"PreferDualStack", "RequireDualStack"})).foreach((Function1 & Serializable)stack -> {
            DriverServiceFeatureStepSuite.$anonfun$new$13(this, stack);
            return BoxedUnit.UNIT;
        }), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
    }
}

