/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicDriverFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils;
import org.apache.spark.deploy.k8s.features.TestFileSystem;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.deploy.k8s.submit.PythonMainAppResource;
import org.apache.spark.deploy.k8s.submit.RMainAppResource;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\f\u0018\u0001\u0011BQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u0004B\u0001\u0001\u0006Ia\f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019!\u0005\u0001)A\u0005s!9Q\t\u0001b\u0001\n\u0013q\u0003B\u0002$\u0001A\u0003%q\u0006C\u0004H\u0001\t\u0007I\u0011\u0002\u0018\t\r!\u0003\u0001\u0015!\u00030\u0011\u001dI\u0005A1A\u0005\n)CaA\u0014\u0001!\u0002\u0013Y\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007A\u0002\u0001\u000b\u0011B)\t\u000f\u0005\u0004!\u0019!C\u0001E\"1q\r\u0001Q\u0001\n\rDq\u0001\u001b\u0001C\u0002\u0013\u0005!\r\u0003\u0004j\u0001\u0001\u0006Ia\u0019\u0005\bU\u0002\u0011\r\u0011\"\u0001c\u0011\u0019Y\u0007\u0001)A\u0005G\")A\u000e\u0001C\u0001[\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d!a\u0007\"bg&\u001cGI]5wKJ4U-\u0019;ve\u0016\u001cF/\u001a9Tk&$XM\u0003\u0002\u00193\u0005Aa-Z1ukJ,7O\u0003\u0002\u001b7\u0005\u00191\u000eO:\u000b\u0005qi\u0012A\u00023fa2|\u0017P\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019:S\"A\u000f\n\u0005!j\"!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u0011A\u0006A\u0007\u0002/\u0005!2)V*U\u001f6{FIU%W\u000bJ{F*\u0011\"F\u0019N+\u0012a\f\t\u0005a]J\u0014(D\u00012\u0015\t\u00114'A\u0005j[6,H/\u00192mK*\u0011A'N\u0001\u000bG>dG.Z2uS>t'\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a\n$aA'baB\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$AB*ue&tw-A\u000bD+N#v*T0E%&3VIU0M\u0003\n+Ej\u0015\u0011\u00027\r{e\nV!J\u001d\u0016\u0013v,S'B\u000f\u0016{\u0006+\u0016'M?B{E*S\"Z+\u0005I\u0014\u0001H\"P\u001dR\u000b\u0015JT#S?&k\u0015iR#`!VcEj\u0018)P\u0019&\u001b\u0015\fI\u0001\u0013\tJKe+\u0012*`\u0003:su\nV!U\u0013>s5+A\nE%&3VIU0B\u001d:{E+\u0011+J\u001f:\u001b\u0006%A\u0006E%&3VIU0F\u001dZ\u001b\u0016\u0001\u0004#S\u0013Z+%kX#O-N\u0003\u0013a\u0006+F'R{\u0016*T!H\u000b~\u0003V\u000b\u0014'`'\u0016\u001b%+\u0012+T+\u0005Y\u0005c\u0001\u0019Ms%\u0011Q*\r\u0002\u0004'\u0016\f\u0018\u0001\u0007+F'R{\u0016*T!H\u000b~\u0003V\u000b\u0014'`'\u0016\u001b%+\u0012+TA\u0005qB+R*U?&k\u0015iR#`!VcEjX*F\u0007J+EkX(C\u0015\u0016\u001bEkU\u000b\u0002#B\u0019\u0001\u0007\u0014*\u0011\u0005MsV\"\u0001+\u000b\u0005U3\u0016!B7pI\u0016d'BA,Y\u0003\r\t\u0007/\u001b\u0006\u00033j\u000b!b[;cKJtW\r^3t\u0015\tYF,A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003u\u000b!![8\n\u0005}#&\u0001\u0006'pG\u0006dwJ\u00196fGR\u0014VMZ3sK:\u001cW-A\u0010U\u000bN#v,S'B\u000f\u0016{\u0006+\u0016'M?N+5IU#U?>\u0013%*R\"U'\u0002\nQ\u0002\u001a:jm\u0016\u0014H)\u001a4bk2$X#A2\u0011\u0005\u0011,W\"A\u001b\n\u0005\u0019,$A\u0002#pk\ndW-\u0001\bee&4XM\u001d#fM\u0006,H\u000e\u001e\u0011\u0002!=dGmQ8oM&<G)\u001a4bk2$\u0018!E8mI\u000e{gNZ5h\t\u00164\u0017-\u001e7uA\u00051an\u001c8Km6\fqA\\8o\u0015Zl\u0007%A\u0007d_:$\u0018-\u001b8feB{'\u000f\u001e\u000b\u0004]Fl\bCA*p\u0013\t\u0001HKA\u0007D_:$\u0018-\u001b8feB{'\u000f\u001e\u0005\u0006eR\u0001\ra]\u0001\u0005]\u0006lW\r\u0005\u0002uw:\u0011Q/\u001f\t\u0003mVj\u0011a\u001e\u0006\u0003q\u000e\na\u0001\u0010:p_Rt\u0014B\u0001>6\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001\t \u0006\u0003uVBQA \u000bA\u0002}\f!\u0002]8si:+XNY3s!\r!\u0017\u0011A\u0005\u0004\u0003\u0007)$aA%oi\u0006y\u0011-\\8v]R\fe\u000e\u001a$pe6\fG\u000fF\u0002t\u0003\u0013Aq!a\u0003\u0016\u0001\u0004\ti!\u0001\u0005rk\u0006tG/\u001b;z!\r\u0019\u0016qB\u0005\u0004\u0003#!&\u0001C)vC:$\u0018\u000e^=")
public class BasicDriverFeatureStepSuite
extends SparkFunSuite {
    private final scala.collection.immutable.Map<String, String> CUSTOM_DRIVER_LABELS = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelkey"), (Object)"labelvalue")}));
    private final String CONTAINER_IMAGE_PULL_POLICY;
    private final scala.collection.immutable.Map<String, String> DRIVER_ANNOTATIONS = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customAnnotation"), (Object)"customAnnotationValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yunikorn.apache.org/app-id"), (Object)"{{APPID}}")}));
    private final scala.collection.immutable.Map<String, String> DRIVER_ENVS = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customDriverEnv1"), (Object)"customDriverEnv1Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customDriverEnv2"), (Object)"customDriverEnv2Value")}));
    private final Seq<String> TEST_IMAGE_PULL_SECRETS = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"my-secret-1", "my-secret-2"}));
    private final Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS = (Seq)this.TEST_IMAGE_PULL_SECRETS().map((Function1 & Serializable)secret -> ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(secret)).build());
    private final double driverDefault;
    private final double oldConfigDefault;
    private final double nonJvm;

    private scala.collection.immutable.Map<String, String> CUSTOM_DRIVER_LABELS() {
        return this.CUSTOM_DRIVER_LABELS;
    }

    private String CONTAINER_IMAGE_PULL_POLICY() {
        return this.CONTAINER_IMAGE_PULL_POLICY;
    }

    private scala.collection.immutable.Map<String, String> DRIVER_ANNOTATIONS() {
        return this.DRIVER_ANNOTATIONS;
    }

    private scala.collection.immutable.Map<String, String> DRIVER_ENVS() {
        return this.DRIVER_ENVS;
    }

    private Seq<String> TEST_IMAGE_PULL_SECRETS() {
        return this.TEST_IMAGE_PULL_SECRETS;
    }

    private Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS() {
        return this.TEST_IMAGE_PULL_SECRET_OBJECTS;
    }

    public double driverDefault() {
        return this.driverDefault;
    }

    public double oldConfigDefault() {
        return this.oldConfigDefault;
    }

    public double nonJvm() {
        return this.nonJvm;
    }

    public ContainerPort containerPort(String name, int portNumber) {
        return ((ContainerPortBuilder)((ContainerPortFluentImpl)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(portNumber))).withProtocol("TCP")).build();
    }

    private String amountAndFormat(Quantity quantity) {
        return new StringBuilder(0).append(quantity.getAmount()).append(quantity.getFormat()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$new$5(EnvVar envVar) {
        return envVar.getName().equals(Constants$.MODULE$.ENV_DRIVER_BIND_ADDRESS()) && envVar.getValueFrom().getFieldRef().getApiVersion().equals("v1") && envVar.getValueFrom().getFieldRef().getFieldPath().equals("status.podIP");
    }

    public static final /* synthetic */ void $anonfun$new$12(BasicDriverFeatureStepSuite $this, Tuple5 x0$6) {
        Tuple5 tuple5 = x0$6;
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        String name = (String)tuple5._1();
        Product resource = (Product)tuple5._2();
        Option factor = (Option)tuple5._3();
        double expectedFactor = BoxesRunTime.unboxToDouble((Object)tuple5._4());
        double expectedPropFactor = BoxesRunTime.unboxToDouble((Object)tuple5._5());
        $this.test(new StringBuilder(35).append("memory overhead factor new config: ").append(name).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            double driverMem = (double)ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB() / BoxesRunTime.unboxToDouble((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR().defaultValue().get()) * (double)2;
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), new StringBuilder(1).append((int)driverMem).append("m").toString());
            factor.foreach((Function1 & Serializable)value -> sparkConf.set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value))));
            SparkConf x$31 = sparkConf;
            Product x$32 = resource;
            String x$33 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            String x$34 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$35 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$36 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            scala.collection.immutable.Map<String, String> x$37 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            scala.collection.immutable.Map<String, String> x$38 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            scala.collection.immutable.Map<String, String> x$39 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            scala.collection.immutable.Map<String, String> x$40 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            scala.collection.immutable.Map<String, String> x$41 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            scala.collection.immutable.Map<String, String> x$42 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            scala.collection.immutable.Map<String, String> x$43 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Seq<KubernetesVolumeSpec> x$44 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$45 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf conf = KubernetesTestConf$.MODULE$.createDriverConf(x$31, x$33, (MainAppResource)x$32, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45);
            BasicDriverFeatureStep step = new BasicDriverFeatureStep(conf);
            SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
            String mem = $this.amountAndFormat((Quantity)pod.container().getResources().getRequests().get("memory"));
            int expected = (int)(driverMem + driverMem * expectedFactor);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(mem);
            String $org_scalatest_assert_macro_right = new StringBuilder(2).append(expected).append("Mi").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            scala.collection.immutable.Map systemProperties = step.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(systemProperties.apply((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()));
            String $org_scalatest_assert_macro_right2 = Double.toString(expectedPropFactor);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$15(BasicDriverFeatureStepSuite $this, Tuple4 x0$7) {
        Tuple4 tuple4 = x0$7;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String name = (String)tuple4._1();
        Product resource = (Product)tuple4._2();
        Option factor = (Option)tuple4._3();
        double expectedFactor = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        $this.test(new StringBuilder(35).append("memory overhead factor old config: ").append(name).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            double driverMem = (double)ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB() / BoxesRunTime.unboxToDouble((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().defaultValue().get()) * (double)2;
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), new StringBuilder(1).append((int)driverMem).append("m").toString());
            factor.foreach((Function1 & Serializable)value -> sparkConf.set(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value))));
            SparkConf x$46 = sparkConf;
            Product x$47 = resource;
            String x$48 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            String x$49 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$50 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$51 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            scala.collection.immutable.Map<String, String> x$52 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            scala.collection.immutable.Map<String, String> x$53 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            scala.collection.immutable.Map<String, String> x$54 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            scala.collection.immutable.Map<String, String> x$55 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            scala.collection.immutable.Map<String, String> x$56 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            scala.collection.immutable.Map<String, String> x$57 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            scala.collection.immutable.Map<String, String> x$58 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Seq<KubernetesVolumeSpec> x$59 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$60 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf conf = KubernetesTestConf$.MODULE$.createDriverConf(x$46, x$48, (MainAppResource)x$47, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
            BasicDriverFeatureStep step = new BasicDriverFeatureStep(conf);
            SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
            String mem = $this.amountAndFormat((Quantity)pod.container().getResources().getRequests().get("memory"));
            int expected = (int)(driverMem + driverMem * expectedFactor);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(mem);
            String $org_scalatest_assert_macro_right = new StringBuilder(2).append(expected).append("Mi").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            scala.collection.immutable.Map systemProperties = step.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(systemProperties.apply((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()));
            String $org_scalatest_assert_macro_right2 = Double.toString(expectedFactor);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$25(String FILE_UPLOAD_PATH$1, String path) {
        return path.startsWith(FILE_UPLOAD_PATH$1) && path.endsWith("some-local-jar.jar");
    }

    public BasicDriverFeatureStepSuite() {
        this.CONTAINER_IMAGE_PULL_POLICY = "IfNotPresent";
        this.test("Check the pod respects all configurations from the user.", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ResourceID resourceID = new ResourceID(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX(), ResourceUtils$.MODULE$.GPU());
            scala.collection.immutable.Map resources = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nvidia.com/gpu"), (Object)new KubernetesFeaturesTestUtils.TestResourceInformation(resourceID, "2", "nvidia.com"))}));
            SparkConf sparkConf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)"spark-driver-pod").set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES(), (Object)BoxesRunTime.boxToInteger((int)2)).set(Config$.MODULE$.KUBERNETES_DRIVER_LIMIT_CORES(), (Object)"4").set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), "256M").set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD(), (Object)BoxesRunTime.boxToLong((long)200L)).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(Config$.MODULE$.IMAGE_PULL_SECRETS(), this.TEST_IMAGE_PULL_SECRETS());
            resources.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                sparkConf.set(testRInfo.rId().amountConf(), testRInfo.count());
                SparkConf sparkConf = sparkConf.set(testRInfo.rId().vendorConf(), testRInfo.vendor());
                return sparkConf;
            });
            SparkConf x$1 = sparkConf;
            scala.collection.immutable.Map<String, String> x$2 = this.CUSTOM_DRIVER_LABELS();
            scala.collection.immutable.Map<String, String> x$3 = this.DRIVER_ENVS();
            scala.collection.immutable.Map<String, String> x$4 = this.DRIVER_ANNOTATIONS();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            scala.collection.immutable.Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            scala.collection.immutable.Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            scala.collection.immutable.Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            scala.collection.immutable.Map<String, String> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Seq<KubernetesVolumeSpec> x$14 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$15 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$1, x$5, x$6, x$7, x$8, x$9, x$2, x$3, x$4, x$10, x$11, x$12, x$13, x$14, x$15);
            BasicDriverFeatureStep featureStep = new BasicDriverFeatureStep(kubernetesConf);
            SparkPod basePod = SparkPod$.MODULE$.initialPod();
            SparkPod configuredPod = featureStep.configurePod(basePod);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configuredPod.container().getName());
            String $org_scalatest_assert_macro_right = Constants$.MODULE$.DEFAULT_DRIVER_CONTAINER_NAME();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(configuredPod.container().getImage());
            String $org_scalatest_assert_macro_right2 = "spark-driver:latest";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(configuredPod.container().getImagePullPolicy());
            String $org_scalatest_assert_macro_right3 = this.CONTAINER_IMAGE_PULL_POLICY();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            Set expectedPortNames = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ContainerPort[]{this.containerPort(Constants$.MODULE$.DRIVER_PORT_NAME(), Constants$.MODULE$.DEFAULT_DRIVER_PORT()), this.containerPort(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT()), this.containerPort(Constants$.MODULE$.UI_PORT_NAME(), BoxesRunTime.unboxToInt((Object)UI$.MODULE$.UI_PORT().defaultValue().get()))}));
            Set foundPortNames = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.container().getPorts()).asScala()).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(expectedPortNames);
            Set $org_scalatest_assert_macro_right4 = foundPortNames;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            scala.collection.immutable.Map envs = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.container().getEnv()).asScala()).map((Function1 & Serializable)env -> new Tuple2((Object)env.getName(), (Object)env.getValue()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.DRIVER_ENVS().foreach((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(envs.apply((Object)k));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                return assertion;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(envs.apply((Object)Constants$.MODULE$.ENV_SPARK_USER()));
            String $org_scalatest_assert_macro_right5 = Utils$.MODULE$.getCurrentUserName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(envs.apply((Object)Constants$.MODULE$.ENV_APPLICATION_ID()));
            String $org_scalatest_assert_macro_right6 = kubernetesConf.appId();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.pod().getSpec().getImagePullSecrets()).asScala());
            Seq<LocalObjectReference> $org_scalatest_assert_macro_right7 = this.TEST_IMAGE_PULL_SECRET_OBJECTS();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", $org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq($org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.container().getEnv()).asScala()).exists((Function1 & Serializable)envVar -> BoxesRunTime.boxToBoolean((boolean)BasicDriverFeatureStepSuite.$anonfun$new$5(envVar))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.EnvVar](configuredPod.container.getEnv()).asScala.exists(((envVar: io.fabric8.kubernetes.api.model.EnvVar) => envVar.getName().equals(org.apache.spark.deploy.k8s.Constants.ENV_DRIVER_BIND_ADDRESS).&&(envVar.getValueFrom().getFieldRef().getApiVersion().equals(\"v1\")).&&(envVar.getValueFrom().getFieldRef().getFieldPath().equals(\"status.podIP\"))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            ResourceRequirements resourceRequirements = configuredPod.container().getResources();
            scala.collection.mutable.Map requests = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(resourceRequirements.getRequests()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(this.amountAndFormat((Quantity)requests.apply((Object)"cpu")));
            String $org_scalatest_assert_macro_right8 = "2";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(this.amountAndFormat((Quantity)requests.apply((Object)"memory")));
            String $org_scalatest_assert_macro_right9 = "456Mi";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            scala.collection.mutable.Map limits = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(resourceRequirements.getLimits()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(this.amountAndFormat((Quantity)limits.apply((Object)"memory")));
            String $org_scalatest_assert_macro_right10 = "456Mi";
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(this.amountAndFormat((Quantity)limits.apply((Object)"cpu")));
            String $org_scalatest_assert_macro_right11 = "4";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            resources.foreach((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k8sName = (String)tuple2._1();
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)limits.apply((Object)k8sName)));
                String $org_scalatest_assert_macro_right = testRInfo.count();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                return assertion;
            });
            ObjectMeta driverPodMetadata = configuredPod.pod().getMetadata();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(driverPodMetadata.getName());
            String $org_scalatest_assert_macro_right12 = "spark-driver-pod";
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            this.CUSTOM_DRIVER_LABELS().foreach((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(driverPodMetadata.getLabels().get(k));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
                return assertion;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(driverPodMetadata.getLabels());
            java.util.Map $org_scalatest_assert_macro_right13 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)kubernetesConf.labels()).asJava();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            scala.collection.mutable.Map annotations = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(driverPodMetadata.getAnnotations()).asScala();
            this.DRIVER_ANNOTATIONS().foreach((Function1 & Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(annotations.apply((Object)k));
                String $org_scalatest_assert_macro_right = Utils$.MODULE$.substituteAppNExecIds(v, KubernetesTestConf$.MODULE$.APP_ID(), "");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
                return assertion;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(configuredPod.pod().getSpec().getRestartPolicy());
            String $org_scalatest_assert_macro_right14 = "Never";
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            scala.collection.immutable.Map expectedSparkConf = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME().key()), (Object)"spark-driver-pod"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.id"), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kubernetes.submitInDriver"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()), (Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().defaultValue().get().toString())}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(featureStep.getAdditionalPodSystemProperties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right15 = expectedSparkConf;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Check driver pod respects kubernetes driver request cores", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf sparkConf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)"spark-driver-pod").set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest");
            SparkPod basePod = SparkPod$.MODULE$.initialPod();
            scala.collection.mutable.Map requests1 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new BasicDriverFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15())).configurePod(basePod).container().getResources().getRequests()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)requests1.apply((Object)"cpu")));
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            sparkConf.set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES(), (Object)BoxesRunTime.boxToInteger((int)10));
            scala.collection.mutable.Map requests2 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new BasicDriverFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15())).configurePod(basePod).container().getResources().getRequests()).asScala();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)requests2.apply((Object)"cpu")));
            String $org_scalatest_assert_macro_right2 = "10";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0.1", "100m"})).foreach((Function1 & Serializable)value -> {
                sparkConf.set(Config$.MODULE$.KUBERNETES_DRIVER_REQUEST_CORES(), value);
                scala.collection.mutable.Map requests3 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new BasicDriverFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15())).configurePod(basePod).container().getResources().getRequests()).asScala();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)requests3.apply((Object)"cpu")));
                String $org_scalatest_assert_macro_right = value;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            });
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("Check appropriate entrypoint rerouting for various bindings", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf javaSparkConf = new SparkConf().set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), "4g").set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest");
            SparkConf pythonSparkConf = new SparkConf().set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), "4g").set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver-py:latest");
            KubernetesDriverConf javaKubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(javaSparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            SparkConf x$16 = pythonSparkConf;
            PythonMainAppResource x$17 = new PythonMainAppResource("");
            String x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            String x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            scala.collection.immutable.Map<String, String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            scala.collection.immutable.Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            scala.collection.immutable.Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            scala.collection.immutable.Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            scala.collection.immutable.Map<String, String> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            scala.collection.immutable.Map<String, String> x$27 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            scala.collection.immutable.Map<String, String> x$28 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Seq<KubernetesVolumeSpec> x$29 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            Option<String> x$30 = KubernetesTestConf$.MODULE$.createDriverConf$default$15();
            KubernetesDriverConf pythonKubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$16, x$18, (MainAppResource)x$17, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
            BasicDriverFeatureStep javaFeatureStep = new BasicDriverFeatureStep(javaKubernetesConf);
            BasicDriverFeatureStep pythonFeatureStep = new BasicDriverFeatureStep(pythonKubernetesConf);
            SparkPod basePod = SparkPod$.MODULE$.initialPod();
            SparkPod configuredJavaPod = javaFeatureStep.configurePod(basePod);
            SparkPod configuredPythonPod = pythonFeatureStep.configurePod(basePod);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configuredJavaPod.container().getImage());
            String $org_scalatest_assert_macro_right = "spark-driver:latest";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(configuredPythonPod.container().getImage());
            String $org_scalatest_assert_macro_right2 = "spark-driver-py:latest";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.driverDefault = BoxesRunTime.unboxToDouble((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR().defaultValue().get());
        this.oldConfigDefault = BoxesRunTime.unboxToDouble((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().defaultValue().get());
        this.nonJvm = Constants$.MODULE$.NON_JVM_MEMORY_OVERHEAD_FACTOR();
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)"java", (Object)new JavaMainAppResource((Option)None$.MODULE$), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)this.driverDefault()), (Object)BoxesRunTime.boxToDouble((double)this.oldConfigDefault())), new Tuple5((Object)"python default", (Object)new PythonMainAppResource(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)this.nonJvm()), (Object)BoxesRunTime.boxToDouble((double)this.nonJvm())), new Tuple5((Object)"python w/ override", (Object)new PythonMainAppResource(null), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9)), (Object)BoxesRunTime.boxToDouble((double)0.9), (Object)BoxesRunTime.boxToDouble((double)this.nonJvm())), new Tuple5((Object)"r default", (Object)new RMainAppResource(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)this.nonJvm()), (Object)BoxesRunTime.boxToDouble((double)this.nonJvm()))})).foreach((Function1 & Serializable)x0$6 -> {
            BasicDriverFeatureStepSuite.$anonfun$new$12(this, x0$6);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)"java", (Object)new JavaMainAppResource((Option)None$.MODULE$), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)this.driverDefault())), new Tuple4((Object)"python default", (Object)new PythonMainAppResource(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)this.nonJvm())), new Tuple4((Object)"python w/ override", (Object)new PythonMainAppResource(null), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9)), (Object)BoxesRunTime.boxToDouble((double)0.9)), new Tuple4((Object)"r default", (Object)new RMainAppResource(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)this.nonJvm()))})).foreach((Function1 & Serializable)x0$7 -> {
            BasicDriverFeatureStepSuite.$anonfun$new$15(this, x0$7);
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-38194: memory overhead factor precendence", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            double driverMem = (double)ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB() / BoxesRunTime.unboxToDouble((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR().defaultValue().get()) * (double)2;
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), new StringBuilder(1).append((int)driverMem).append("m").toString());
            double expectedFactor = 0.2;
            double oldFactor = 0.3;
            sparkConf.set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)expectedFactor));
            sparkConf.set(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)oldFactor));
            KubernetesDriverConf conf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            BasicDriverFeatureStep step = new BasicDriverFeatureStep(conf);
            SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
            String mem = this.amountAndFormat((Quantity)pod.container().getResources().getRequests().get("memory"));
            int expected = (int)(driverMem + driverMem * expectedFactor);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mem);
            String $org_scalatest_assert_macro_right = new StringBuilder(2).append(expected).append("Mi").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            scala.collection.immutable.Map systemProperties = step.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(systemProperties.apply((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()));
            String $org_scalatest_assert_macro_right2 = Double.toString(oldFactor);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("SPARK-38194: old memory factor settings is applied if new one isn't given", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            double driverMem = (double)ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB() / BoxesRunTime.unboxToDouble((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR().defaultValue().get()) * (double)2;
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), new StringBuilder(1).append((int)driverMem).append("m").toString());
            double expectedFactor = 0.3;
            sparkConf.set(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)expectedFactor));
            KubernetesDriverConf conf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            BasicDriverFeatureStep step = new BasicDriverFeatureStep(conf);
            SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
            String mem = this.amountAndFormat((Quantity)pod.container().getResources().getRequests().get("memory"));
            int expected = (int)(driverMem + driverMem * expectedFactor);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mem);
            String $org_scalatest_assert_macro_right = new StringBuilder(2).append(expected).append("Mi").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            scala.collection.immutable.Map systemProperties = step.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(systemProperties.apply((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()));
            String $org_scalatest_assert_macro_right2 = Double.toString(expectedFactor);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("SPARK-35493: make spark.blockManager.port be able to be fallen back to in driver pod", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkPod initPod = SparkPod$.MODULE$.initialPod();
            SparkConf sparkConf = new SparkConf().set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(org.apache.spark.internal.config.package$.MODULE$.BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)1234));
            KubernetesDriverConf driverConf1 = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            SparkPod pod1 = new BasicDriverFeatureStep(driverConf1).configurePod(initPod);
            scala.collection.immutable.Map portMap1 = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(pod1.container().getPorts()).asScala()).map((Function1 & Serializable)cp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cp.getName()), (Object)cp.getContainerPort()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(portMap1.apply((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()));
            int $org_scalatest_assert_macro_right = 1234;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(16).append("fallback to ").append(org.apache.spark.internal.config.package$.MODULE$.BLOCK_MANAGER_PORT()).append(".key").toString(), Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
            KubernetesDriverConf driverConf2 = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf.set(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)1235)), KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            SparkPod pod2 = new BasicDriverFeatureStep(driverConf2).configurePod(initPod);
            scala.collection.immutable.Map portMap2 = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(pod2.container().getPorts()).asScala()).map((Function1 & Serializable)cp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cp.getName()), (Object)cp.getContainerPort()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(portMap2.apply((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()));
            int $org_scalatest_assert_macro_right2 = 1235;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("SPARK-36075: Check driver pod respects nodeSelector/driverNodeSelector", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkPod initPod = SparkPod$.MODULE$.initialPod();
            SparkConf sparkConf = new SparkConf().set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(new StringBuilder(12).append(Config$.MODULE$.KUBERNETES_NODE_SELECTOR_PREFIX()).append("nodeLabelKey").toString(), "nodeLabelValue").set(new StringBuilder(18).append(Config$.MODULE$.KUBERNETES_DRIVER_NODE_SELECTOR_PREFIX()).append("driverNodeLabelKey").toString(), "driverNodeLabelValue").set(new StringBuilder(16).append(Config$.MODULE$.KUBERNETES_EXECUTOR_NODE_SELECTOR_PREFIX()).append("execNodeLabelKey").toString(), "execNodeLabelValue");
            KubernetesDriverConf driverConf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            SparkPod driver = new BasicDriverFeatureStep(driverConf).configurePod(initPod);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(driver.pod().getSpec().getNodeSelector()).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nodeLabelKey"), (Object)"nodeLabelValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driverNodeLabelKey"), (Object)"driverNodeLabelValue")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("SPARK-40817: Check that remote JARs do not get discarded in spark.jars", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String FILE_UPLOAD_PATH = "s3a://some-bucket/upload-path";
            String REMOTE_JAR_URI = "s3a://some-bucket/my-application.jar";
            String LOCAL_JAR_URI = "/tmp/some-local-jar.jar";
            SparkConf sparkConf = new SparkConf().set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(org.apache.spark.internal.config.package$.MODULE$.JARS(), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{REMOTE_JAR_URI, LOCAL_JAR_URI}))).set(Config$.MODULE$.KUBERNETES_FILE_UPLOAD_PATH(), (Object)FILE_UPLOAD_PATH).set("spark.hadoop.fs.s3a.impl", TestFileSystem.class.getCanonicalName()).set("spark.hadoop.fs.s3a.impl.disable.cache", "true");
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14(), KubernetesTestConf$.MODULE$.createDriverConf$default$15());
            BasicDriverFeatureStep featureStep = new BasicDriverFeatureStep(kubernetesConf);
            String[] sparkJars = ((String)featureStep.getAdditionalPodSystemProperties().apply((Object)org.apache.spark.internal.config.package$.MODULE$.JARS().key())).split(",");
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])sparkJars);
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)ArrayOps$.MODULE$.size$extension($org_scalatest_assert_macro_left)), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])sparkJars);
            String $org_scalatest_assert_macro_right2 = REMOTE_JAR_URI;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, ArrayOps$.MODULE$.contains$extension($org_scalatest_assert_macro_left2, (Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])sparkJars);
            String $org_scalatest_assert_macro_right3 = LOCAL_JAR_URI;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, ArrayOps$.MODULE$.contains$extension($org_scalatest_assert_macro_left3, (Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])sparkJars), (Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)BasicDriverFeatureStepSuite.$anonfun$new$25(FILE_UPLOAD_PATH, path))), "scala.Predef.refArrayOps[String](sparkJars).exists(((path: String) => path.startsWith(FILE_UPLOAD_PATH).&&(path.endsWith(\"some-local-jar.jar\"))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        }, new Position("BasicDriverFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
    }
}

