/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesDriverCustomFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.KubernetesExecutorCustomFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005!3A\u0001C\u0005\u0001)!)A\u0005\u0001C\u0001K!I\u0001\u0006\u0001a\u0001\u0002\u0004%I!\u000b\u0005\n[\u0001\u0001\r\u00111A\u0005\n9B\u0011\u0002\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0016\t\u000bU\u0002A\u0011\t\u001c\t\u000bU\u0002A\u0011\t\u001f\t\u000b\u0005\u0003A\u0011\t\"\u0003!Q+7\u000f^*uKB<\u0016\u000e\u001e5D_:4'B\u0001\u0006\f\u0003\rY\u0007h\u001d\u0006\u0003\u00195\ta\u0001Z3qY>L(B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M!\u0001!F\u000e\"!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011AdH\u0007\u0002;)\u0011a$C\u0001\tM\u0016\fG/\u001e:fg&\u0011\u0001%\b\u0002(\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u001cUo\u001d;p[\u001a+\u0017\r^;sK\u000e{gNZ5h'R,\u0007\u000f\u0005\u0002\u001dE%\u00111%\b\u0002*\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'oQ;ti>lg)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u0005I\u0011AD6vE\u0016\u0014h.\u001a;fg\u000e{gNZ\u000b\u0002UA\u0011qeK\u0005\u0003Y%\u0011abS;cKJtW\r^3t\u0007>tg-\u0001\nlk\n,'O\\3uKN\u001cuN\u001c4`I\u0015\fHCA\u00183!\t1\u0002'\u0003\u00022/\t!QK\\5u\u0011\u001d\u00194!!AA\u0002)\n1\u0001\u001f\u00132\u0003=YWOY3s]\u0016$Xm]\"p]\u001a\u0004\u0013\u0001B5oSR$\"aL\u001c\t\u000ba*\u0001\u0019A\u001d\u0002\t\r|gN\u001a\t\u0003OiJ!aO\u0005\u0003)-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u00148i\u001c8g)\tyS\bC\u00039\r\u0001\u0007a\b\u0005\u0002(\u007f%\u0011\u0001)\u0003\u0002\u0017\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'oQ8oM\u0006a1m\u001c8gS\u001e,(/\u001a)pIR\u00111I\u0012\t\u0003O\u0011K!!R\u0005\u0003\u0011M\u0003\u0018M]6Q_\u0012DQaR\u0004A\u0002\r\u000b1\u0001]8e\u0001")
public class TestStepWithConf
implements KubernetesDriverCustomFeatureConfigStep,
KubernetesExecutorCustomFeatureConfigStep {
    private KubernetesConf kubernetesConf;

    public Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$((KubernetesFeatureConfigStep)this);
    }

    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$((KubernetesFeatureConfigStep)this);
    }

    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$((KubernetesFeatureConfigStep)this);
    }

    private KubernetesConf kubernetesConf() {
        return this.kubernetesConf;
    }

    private void kubernetesConf_$eq(KubernetesConf x$1) {
        this.kubernetesConf = x$1;
    }

    public void init(KubernetesDriverConf conf) {
        this.kubernetesConf_$eq((KubernetesConf)conf);
    }

    public void init(KubernetesExecutorConf conf) {
        this.kubernetesConf_$eq((KubernetesConf)conf);
    }

    public SparkPod configurePod(SparkPod pod) {
        PodBuilder k8sPodBuilder = (PodBuilder)((PodFluent.MetadataNested)new PodBuilder(pod.pod()).editOrNewMetadata().addToAnnotations("test-features-key", this.kubernetesConf().get("test-features-key"))).endMetadata();
        Pod k8sPod = k8sPodBuilder.build();
        return new SparkPod(k8sPod, pod.container());
    }

    public TestStepWithConf() {
        KubernetesFeatureConfigStep.$init$((KubernetesFeatureConfigStep)this);
    }
}

