/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.PrivateMethodTester;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005u2AAB\u0004\u0001%!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u0016\u0001A\u0003%1\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rq\u0002\u0001\u0015!\u0003/\u0005QYUOY3s]\u0016$Xm]+uS2\u001c8+^5uK*\u0011\u0001\"C\u0001\u0004Wb\u001a(B\u0001\u0006\f\u0003\u0019!W\r\u001d7ps*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019r\u0003\u0005\u0002\u0015+5\t1\"\u0003\u0002\u0017\u0017\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001G\u000e\u000e\u0003eQ!AG\b\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u000f\u001a\u0005M\u0001&/\u001b<bi\u0016lU\r\u001e5pIR+7\u000f^3s\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\tq!\u0001\u0003I\u001fN#V#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001\u00027b]\u001eT\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t11\u000b\u001e:j]\u001e\fQ\u0001S(T)\u0002\n1\u0001U(E+\u0005q\u0003CA\u0018;\u001b\u0005\u0001$BA\u00193\u0003\u0015iw\u000eZ3m\u0015\t\u0019D'A\u0002ba&T!!\u000e\u001c\u0002\u0015-,(-\u001a:oKR,7O\u0003\u00028q\u00059a-\u00192sS\u000eD$\"A\u001d\u0002\u0005%|\u0017BA\u001e1\u0005\r\u0001v\u000eZ\u0001\u0005!>#\u0005\u0005")
public class KubernetesUtilsSuite
extends SparkFunSuite
implements PrivateMethodTester {
    private final String HOST;
    private final Pod POD;
    private volatile PrivateMethodTester.PrivateMethod$ PrivateMethod$module;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public PrivateMethodTester.PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    private String HOST() {
        return this.HOST;
    }

    private Pod POD() {
        return this.POD;
    }

    private final void PrivateMethod$lzycompute$1() {
        KubernetesUtilsSuite kubernetesUtilsSuite = this;
        synchronized (kubernetesUtilsSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester.PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    private final void checkUploadException$1(boolean delSrc, boolean overwrite, PrivateMethodTester.PrivateMethod upload$1, Path src$1, Path dest$1, FileSystem fs$1) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.anyRefToInvoker(KubernetesUtils$.MODULE$).invokePrivate(upload$1.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{src$1, dest$1, fs$1, BoxesRunTime.boxToBoolean((boolean)delSrc), BoxesRunTime.boxToBoolean((boolean)overwrite)}))), ClassTag$.MODULE$.apply(SparkException.class), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87))).getMessage();
        String $org_scalatest_assert_macro_right = "Error uploading file";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
    }

    private final void appendFileAndUpload$1(String content, boolean delSrc, boolean overwrite, File srcFile$1, PrivateMethodTester.PrivateMethod upload$1, Path src$1, Path dest$1, FileSystem fs$1) {
        FileUtils.write((File)srcFile$1, (CharSequence)content, (Charset)StandardCharsets.UTF_8, (boolean)true);
        this.anyRefToInvoker(KubernetesUtils$.MODULE$).invokePrivate(upload$1.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{src$1, dest$1, fs$1, BoxesRunTime.boxToBoolean((boolean)delSrc), BoxesRunTime.boxToBoolean((boolean)overwrite)})));
    }

    public static final /* synthetic */ void $anonfun$new$10(KubernetesUtilsSuite $this, File srcDir$1, File destDir) {
        PrivateMethodTester.PrivateMethod upload = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "uploadFileToHadoopCompatibleFS"));
        String fileName = "test.txt";
        File srcFile = new File(srcDir$1, fileName);
        Path src = new Path(srcFile.getAbsolutePath());
        Path dest = new Path(destDir.getAbsolutePath(), fileName);
        FileSystem fs = src.getFileSystem(new Configuration());
        $this.appendFileAndUpload$1("init-content", false, true, srcFile, upload, src, dest, fs);
        long firstLength = fs.getFileStatus(dest).getLen();
        $this.appendFileAndUpload$1("append-content", false, true, srcFile, upload, src, dest, fs);
        long secondLength = fs.getFileStatus(dest).getLen();
        long $org_scalatest_assert_macro_left = firstLength;
        long $org_scalatest_assert_macro_right = secondLength;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        $this.checkUploadException$1(false, false, upload, src, dest, fs);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fs.exists(dest), "fs.exists(dest)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        long $org_scalatest_assert_macro_left2 = fs.getFileStatus(dest).getLen();
        long $org_scalatest_assert_macro_right2 = secondLength;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        $this.appendFileAndUpload$1("append-content", true, true, srcFile, upload, src, dest, fs);
        long thirdLength = fs.getFileStatus(dest).getLen();
        long $org_scalatest_assert_macro_left3 = secondLength;
        long $org_scalatest_assert_macro_right3 = thirdLength;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fs.exists(src), "fs.exists(src)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        FileUtils.write((File)srcFile, (CharSequence)"re-init-content", (Charset)StandardCharsets.UTF_8, (boolean)true);
        $this.checkUploadException$1(true, false, upload, src, dest, fs);
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(fs.exists(src), "fs.exists(src)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$13(int i) {
        return new Tuple2((Object)new StringBuilder(11).append("testEnvKey.").append(i).toString(), (Object)new StringBuilder(13).append("testEnvValue.").append(i).toString());
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$16(int i) {
        return new Tuple3((Object)new StringBuilder(11).append("testEnvKey.").append(i).toString(), (Object)new StringBuilder(1).append("v").append(i).toString(), (Object)new StringBuilder(13).append("testEnvValue.").append(i).toString());
    }

    public KubernetesUtilsSuite() {
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.HOST = "test-host";
        this.POD = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder().withNewSpec().withHostname(this.HOST()).withContainers(new Container[]{((ContainerBuilder)new ContainerBuilder().withName("first")).build(), ((ContainerBuilder)new ContainerBuilder().withName("second")).build()})).endSpec()).build();
        this.test("Selects the given container as spark container.", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkPod sparkPod = KubernetesUtils$.MODULE$.selectSparkContainer(this.POD(), (Option)new Some((Object)"second"));
            String $org_scalatest_assert_macro_left = sparkPod.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right = this.HOST();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            List $org_scalatest_assert_macro_left2 = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(sparkPod.pod().getSpec().getContainers()).asScala()).toList().map((Function1 & Serializable)x$1 -> x$1.getName());
            List $org_scalatest_assert_macro_right2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first"}));
            List list = $org_scalatest_assert_macro_left2;
            List list2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list != null ? !list.equals(list2) : list2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            String $org_scalatest_assert_macro_left3 = sparkPod.container().getName();
            String $org_scalatest_assert_macro_right3 = "second";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("Selects the first container if no container name is given.", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkPod sparkPod = KubernetesUtils$.MODULE$.selectSparkContainer(this.POD(), Option$.MODULE$.empty());
            String $org_scalatest_assert_macro_left = sparkPod.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right = this.HOST();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            List $org_scalatest_assert_macro_left2 = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(sparkPod.pod().getSpec().getContainers()).asScala()).toList().map((Function1 & Serializable)x$2 -> x$2.getName());
            List $org_scalatest_assert_macro_right2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"second"}));
            List list = $org_scalatest_assert_macro_left2;
            List list2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list != null ? !list.equals(list2) : list2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            String $org_scalatest_assert_macro_left3 = sparkPod.container().getName();
            String $org_scalatest_assert_macro_right3 = "first";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("Falls back to the first container if given container name does not exist.", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkPod sparkPod = KubernetesUtils$.MODULE$.selectSparkContainer(this.POD(), (Option)new Some((Object)"does-not-exist"));
            String $org_scalatest_assert_macro_left = sparkPod.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right = this.HOST();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            List $org_scalatest_assert_macro_left2 = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(sparkPod.pod().getSpec().getContainers()).asScala()).toList().map((Function1 & Serializable)x$3 -> x$3.getName());
            List $org_scalatest_assert_macro_right2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"second"}));
            List list = $org_scalatest_assert_macro_left2;
            List list2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list != null ? !list.equals(list2) : list2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            String $org_scalatest_assert_macro_left3 = sparkPod.container().getName();
            String $org_scalatest_assert_macro_right3 = "first";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("constructs spark pod correctly with pod template with no containers", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Pod noContainersPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(this.POD()).editSpec().withContainers(new Container[0])).endSpec()).build();
            SparkPod sparkPod = KubernetesUtils$.MODULE$.selectSparkContainer(noContainersPod, (Option)new Some((Object)"does-not-exist"));
            String $org_scalatest_assert_macro_left = sparkPod.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right = this.HOST();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            String $org_scalatest_assert_macro_left2 = sparkPod.container().getName();
            Object $org_scalatest_assert_macro_right2 = null;
            String string3 = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string3 != null ? !string3.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            SparkPod sparkPodWithNoContainerName = KubernetesUtils$.MODULE$.selectSparkContainer(noContainersPod, Option$.MODULE$.empty());
            String $org_scalatest_assert_macro_left3 = sparkPodWithNoContainerName.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right3 = this.HOST();
            String string4 = $org_scalatest_assert_macro_left3;
            String string5 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string4 != null ? !string4.equals(string5) : string5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            String $org_scalatest_assert_macro_left4 = sparkPodWithNoContainerName.container().getName();
            Object $org_scalatest_assert_macro_right4 = null;
            String string6 = $org_scalatest_assert_macro_left4;
            Object var19_18 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", null, !(string6 != null ? !string6.equals(var19_18) : var19_18 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("SPARK-38201: check uploadFileToHadoopCompatibleFS with different delSrc and overwrite", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)srcDir -> {
            this.withTempDir((Function1 & Serializable)destDir -> {
                KubernetesUtilsSuite.$anonfun$new$10($this, srcDir, destDir);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("SPARK-38582: verify that envVars is built with kv env as expected", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IndexedSeq input = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 1).by(-1).map((Function1 & Serializable)i -> KubernetesUtilsSuite.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)i)));
            IndexedSeq expectedEnvVars = (IndexedSeq)((IndexedSeqOps)input.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testKeyWithEmptyValue"), (Object)""))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(k)).withValue(v)).build();
                return envVar;
            });
            Seq outputEnvVars = KubernetesUtils$.MODULE$.buildEnvVars((Seq)input.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testKeyWithNullValue"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testKeyWithEmptyValue"), (Object)"")}))));
            Set $org_scalatest_assert_macro_left = outputEnvVars.toSet();
            Set $org_scalatest_assert_macro_right = expectedEnvVars.toSet();
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("SPARK-38582: verify that envVars is built with field ref env as expected", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq outputEnvVars;
            IndexedSeq input = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 1).by(-1).map((Function1 & Serializable)i -> KubernetesUtilsSuite.$anonfun$new$16(BoxesRunTime.unboxToInt((Object)i)));
            IndexedSeq expectedEnvVars = (IndexedSeq)input.map((Function1 & Serializable)env -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef((String)env._2(), (String)env._3())).build())).build());
            Seq $org_scalatest_assert_macro_left = outputEnvVars = KubernetesUtils$.MODULE$.buildEnvVarsWithFieldRef((Seq)input.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"testKey1", null, (Object)"testValue1"), new Tuple3((Object)"testKey2", (Object)"v1", null), new Tuple3((Object)"testKey3", null, null)}))));
            IndexedSeq $org_scalatest_assert_macro_right = expectedEnvVars;
            Seq seq = $org_scalatest_assert_macro_left;
            IndexedSeq indexedSeq = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(indexedSeq) : indexedSeq != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }
}

