/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.Scaleable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileBuilder;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.StatefulSetPodsAllocator;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u00181\u0001uBQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013%Q\n\u0003\u0004W\u0001\u0001\u0006IA\u0014\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u00199\u0007\u0001)A\u00053\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007BB7\u0001A\u0003%!\u000eC\u0004o\u0001\t\u0007I\u0011B8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u001d9\bA1A\u0005\n=Da\u0001\u001f\u0001!\u0002\u0013\u0001\bbB=\u0001\u0005\u0004%IA\u001f\u0005\u0007}\u0002\u0001\u000b\u0011B>\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u0001C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\n\u0005E\u0001bCA\u0012\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007A1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026!Y\u00111\t\u0001A\u0002\u0003\u0007I\u0011BA#\u0011-\tI\u0005\u0001a\u0001\u0002\u0003\u0006K!a\u000e\t\u0017\u00055\u0003\u00011AA\u0002\u0013%\u0011q\n\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0013\t\t\bC\u0006\u0002v\u0001\u0001\r\u0011!Q!\n\u0005E\u0003bCA=\u0001\u0001\u0007\t\u0019!C\u0005\u0003wB1\"! \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0000!Y\u00111\u0011\u0001A\u0002\u0003\u0005\u000b\u0015BA5\u0011-\t9\t\u0001a\u0001\u0002\u0004%I!!#\t\u0017\u0005e\u0006\u00011AA\u0002\u0013%\u00111\u0018\u0005\f\u0003\u007f\u0003\u0001\u0019!A!B\u0013\tY\tC\u0006\u0002D\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0007bCAg\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fD1\"a5\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H\"Y\u0011q\u001b\u0001A\u0002\u0003\u0007I\u0011BAm\u0011-\t\t\u000f\u0001a\u0001\u0002\u0004%I!a9\t\u0017\u0005\u001d\b\u00011A\u0001B\u0003&\u00111\u001c\u0005\f\u0003S\u0004\u0001\u0019!a\u0001\n\u0013\tY\u000fC\u0006\u0002t\u0002\u0001\r\u00111A\u0005\n\u0005U\bbCA}\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[D1\"a?\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002~\"Y!Q\u0001\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0004\u0011-\u0011Y\u0001\u0001a\u0001\u0002\u0003\u0006K!a@\t\u0017\t=\u0001\u00011AA\u0002\u0013%!\u0011\u0003\u0005\f\u00053\u0001\u0001\u0019!a\u0001\n\u0013\u0011Y\u0002C\u0006\u0003 \u0001\u0001\r\u0011!Q!\n\tM\u0001\u0002\u0003B\u0012\u0001\t\u0007I\u0011A'\t\u000f\t\u0015\u0002\u0001)A\u0005\u001d\"9!q\u0005\u0001\u0005\n\t%\"!G*uCR,g-\u001e7TKR\fE\u000e\\8dCR|'oU;ji\u0016T!!\r\u001a\u0002\u0007-D4O\u0003\u00024i\u000591\r\\;ti\u0016\u0014(BA\u001b7\u0003%\u00198\r[3ek2,'O\u0003\u00028q\u0005)1\u000f]1sW*\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001 C!\ty\u0004)D\u00017\u0013\t\teGA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bj\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u001d#%A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0003\"a\u0013\u0001\u000e\u0003A\nQ\u0002\u001a:jm\u0016\u0014\bk\u001c3OC6,W#\u0001(\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016\u0001\u00027b]\u001eT\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V!\n11\u000b\u001e:j]\u001e\fa\u0002\u001a:jm\u0016\u0014\bk\u001c3OC6,\u0007%A\u0005ee&4XM\u001d)pIV\t\u0011\f\u0005\u0002[K6\t1L\u0003\u0002];\u0006)Qn\u001c3fY*\u0011alX\u0001\u0004CBL'B\u00011b\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003E\u000e\fqAZ1ce&\u001c\u0007HC\u0001e\u0003\tIw.\u0003\u0002g7\n\u0019\u0001k\u001c3\u0002\u0015\u0011\u0014\u0018N^3s!>$\u0007%\u0001\u0003d_:4W#\u00016\u0011\u0005}Z\u0017B\u000177\u0005%\u0019\u0006/\u0019:l\u0007>tg-A\u0003d_:4\u0007%\u0001\beK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u001c\u0002\u0011I,7o\\;sG\u0016L!!\u001e:\u0003\u001fI+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\fq\u0002Z3gCVdG\u000f\u0015:pM&dW\rI\u0001\u000eg\u0016\u001cwN\u001c3Qe>4\u0017\u000e\\3\u0002\u001dM,7m\u001c8e!J|g-\u001b7fA\u000511/Z2NOJ,\u0012a\u001f\t\u0003\u007fqL!! \u001c\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJ\fqa]3d\u001b\u001e\u0014\b%\u0001\tlk\n,'O\\3uKN\u001cE.[3oiV\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B0\u0002\r\rd\u0017.\u001a8u\u0013\u0011\ti!a\u0002\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018\u0001F6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005}\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0005\u0005e\u0011!B:dC2\f\u0017\u0002BA\u000f\u0003/\u0011A!\u00168ji\"I\u0011\u0011E\b\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0014!E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8uA!\u001a\u0001#a\n\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f;\u0003\u001diwnY6ji>LA!!\r\u0002,\t!Qj\\2l\u00035\t\u0007\u000f](qKJ\fG/[8ogV\u0011\u0011q\u0007\t\u0005\u0003s\ty$\u0004\u0002\u0002<)!\u0011QHA\u0004\u0003\r!7\u000f\\\u0005\u0005\u0003\u0003\nYDA\bBaB\u001c\u0018\tU%He>,\b\u000fR*M\u0003E\t\u0007\u000f](qKJ\fG/[8og~#S-\u001d\u000b\u0005\u0003'\t9\u0005C\u0005\u0002\"I\t\t\u00111\u0001\u00028\u0005q\u0011\r\u001d9Pa\u0016\u0014\u0018\r^5p]N\u0004\u0003fA\n\u0002(\u0005)2\u000f^1uK\u001a,HnU3u\u001fB,'/\u0019;j_:\u001cXCAA)!)\tI$a\u0015\u0002X\u0005\r\u0014\u0011N\u0005\u0005\u0003+\nYD\u0001\bNSb,Gm\u00149fe\u0006$\u0018n\u001c8\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018\\\u0003\u0011\t\u0007\u000f]:\n\t\u0005\u0005\u00141\f\u0002\f'R\fG/\u001a4vYN+G\u000f\u0005\u0003\u0002Z\u0005\u0015\u0014\u0002BA4\u00037\u0012qb\u0015;bi\u00164W\u000f\\*fi2K7\u000f\u001e\t\u0007\u0003s\tY'a\u0016\n\t\u00055\u00141\b\u0002\u0019%>dG.\u00192mKN\u001b\u0017\r\\1cY\u0016\u0014Vm]8ve\u000e,\u0017!G:uCR,g-\u001e7TKR|\u0005/\u001a:bi&|gn]0%KF$B!a\u0005\u0002t!I\u0011\u0011E\u000b\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0017gR\fG/\u001a4vYN+Go\u00149fe\u0006$\u0018n\u001c8tA!\u001aa#a\n\u0002\u0017\u0015$\u0017\u000e^1cY\u0016\u001cV\r^\u000b\u0003\u0003S\nq\"\u001a3ji\u0006\u0014G.Z*fi~#S-\u001d\u000b\u0005\u0003'\t\t\tC\u0005\u0002\"a\t\t\u00111\u0001\u0002j\u0005aQ\rZ5uC\ndWmU3uA!\u001a\u0011$a\n\u0002\u001bA|Gm\u00149fe\u0006$\u0018n\u001c8t+\t\tY\t\u0005\u0003\u0002\u000e\u0006Mf\u0002BAH\u0003[sA!!%\u0002*:!\u00111SAS\u001d\u0011\t)*a)\u000f\t\u0005]\u0015\u0011\u0015\b\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019\u0011Q\u0014\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014BA\u001d;\u0013\t9\u0004(C\u0002\u0002(Z\na\u0001Z3qY>L\u0018bA\u0019\u0002,*\u0019\u0011q\u0015\u001c\n\t\u0005=\u0016\u0011W\u0001\u000f\r\u0006\u0014'/[29\u00032L\u0017m]3t\u0015\r\t\u00141V\u0005\u0005\u0003k\u000b9L\u0001\u0003Q\u001f\u0012\u001b&\u0002BAX\u0003c\u000b\u0011\u0003]8e\u001fB,'/\u0019;j_:\u001cx\fJ3r)\u0011\t\u0019\"!0\t\u0013\u0005\u00052$!AA\u0002\u0005-\u0015A\u00049pI>\u0003XM]1uS>t7\u000f\t\u0015\u00049\u0005\u001d\u0012a\u00053sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001cXCAAd!\u0015\tI$!3Z\u0013\u0011\tY-a\u000f\u0003\u0017A{GMU3t_V\u00148-Z\u0001\u0018IJLg/\u001a:Q_\u0012|\u0005/\u001a:bi&|gn]0%KF$B!a\u0005\u0002R\"I\u0011\u0011\u0005\u0010\u0002\u0002\u0003\u0007\u0011qY\u0001\u0015IJLg/\u001a:Q_\u0012|\u0005/\u001a:bi&|gn\u001d\u0011)\u0007}\t9#\u0001\fq_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]+oI\u0016\u0014H+Z:u+\t\tY\u000eE\u0002L\u0003;L1!a81\u0005a\u0019F/\u0019;fMVd7+\u001a;Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]\u0001\u001ba>$7/\u00117m_\u000e\fGo\u001c:V]\u0012,'\u000fV3ti~#S-\u001d\u000b\u0005\u0003'\t)\u000fC\u0005\u0002\"\u0005\n\t\u00111\u0001\u0002\\\u00069\u0002o\u001c3t\u00032dwnY1u_J,f\u000eZ3s)\u0016\u001cH\u000fI\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f+\t\ti\u000fE\u0002L\u0003_L1!!=1\u0005\u001d\"U\r^3s[&t\u0017n\u001d;jG\u0016CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\u0002%Mt\u0017\r]:i_R\u001c8\u000b^8sK~#S-\u001d\u000b\u0005\u0003'\t9\u0010C\u0005\u0002\"\u0011\n\t\u00111\u0001\u0002n\u0006y1O\\1qg\"|Go]*u_J,\u0007%A\bfq\u0016\u001cW\u000f^8s\u0005VLG\u000eZ3s+\t\ty\u0010E\u0002L\u0005\u0003I1Aa\u00011\u0005eYUOY3s]\u0016$Xm]#yK\u000e,Ho\u001c:Ck&dG-\u001a:\u0002'\u0015DXmY;u_J\u0014U/\u001b7eKJ|F%Z9\u0015\t\u0005M!\u0011\u0002\u0005\n\u0003C9\u0013\u0011!a\u0001\u0003\u007f\f\u0001#\u001a=fGV$xN\u001d\"vS2$WM\u001d\u0011)\u0007!\n9#\u0001\ttG\",G-\u001e7fe\n\u000b7m[3oIV\u0011!1\u0003\t\u0004\u0017\nU\u0011b\u0001B\fa\t\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI\u0006!2o\u00195fIVdWM\u001d\"bG.,g\u000eZ0%KF$B!a\u0005\u0003\u001e!I\u0011\u0011\u0005\u0016\u0002\u0002\u0003\u0007!1C\u0001\u0012g\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u0004\u0003fA\u0016\u0002(\u0005)\u0011\r\u001d9JI\u00061\u0011\r\u001d9JI\u0002\n\u0011#\u001a=fGV$xN\u001d)pI\u0006s7o^3s)\t\u0011Y\u0003\u0005\u0004\u0003.\tM\"qG\u0007\u0003\u0005_QAA!\r\u0002,\u0005A1\u000f^;cE&tw-\u0003\u0003\u00036\t=\"AB!og^,'\u000f\u0005\u0003\u0003:\tmRBAAY\u0013\u0011\u0011i$!-\u0003--+(-\u001a:oKR,7/\u0012=fGV$xN]*qK\u000e\u0004")
public class StatefulSetAllocatorSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String driverPodName;
    private final Pod driverPod;
    private final SparkConf conf;
    private final ResourceProfile defaultProfile;
    private final ResourceProfile secondProfile;
    private final SecurityManager secMgr;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private AppsAPIGroupDSL appOperations;
    @Mock
    private MixedOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> statefulSetOperations;
    @Mock
    private RollableScalableResource<StatefulSet> editableSet;
    @Mock
    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations;
    @Mock
    private PodResource<Pod> driverPodOperations;
    private StatefulSetPodsAllocator podsAllocatorUnderTest;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    @Mock
    private KubernetesExecutorBuilder executorBuilder;
    @Mock
    private KubernetesClusterSchedulerBackend schedulerBackend;
    private final String appId;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private Pod driverPod() {
        return this.driverPod;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    private ResourceProfile secondProfile() {
        return this.secondProfile;
    }

    private SecurityManager secMgr() {
        return this.secMgr;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private AppsAPIGroupDSL appOperations() {
        return this.appOperations;
    }

    private void appOperations_$eq(AppsAPIGroupDSL x$1) {
        this.appOperations = x$1;
    }

    private MixedOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> statefulSetOperations() {
        return this.statefulSetOperations;
    }

    private void statefulSetOperations_$eq(MixedOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> x$1) {
        this.statefulSetOperations = x$1;
    }

    private RollableScalableResource<StatefulSet> editableSet() {
        return this.editableSet;
    }

    private void editableSet_$eq(RollableScalableResource<StatefulSet> x$1) {
        this.editableSet = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource<Pod>> x$1) {
        this.podOperations = x$1;
    }

    private PodResource<Pod> driverPodOperations() {
        return this.driverPodOperations;
    }

    private void driverPodOperations_$eq(PodResource<Pod> x$1) {
        this.driverPodOperations = x$1;
    }

    private StatefulSetPodsAllocator podsAllocatorUnderTest() {
        return this.podsAllocatorUnderTest;
    }

    private void podsAllocatorUnderTest_$eq(StatefulSetPodsAllocator x$1) {
        this.podsAllocatorUnderTest = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private KubernetesExecutorBuilder executorBuilder() {
        return this.executorBuilder;
    }

    private void executorBuilder_$eq(KubernetesExecutorBuilder x$1) {
        this.executorBuilder = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackend() {
        return this.schedulerBackend;
    }

    private void schedulerBackend_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackend = x$1;
    }

    public String appId() {
        return this.appId;
    }

    private Answer<KubernetesExecutorSpec> executorPodAnswer() {
        return invocation -> {
            KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
            return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithId(0L, k8sConf.resourceProfileId()), (Seq)Nil$.MODULE$);
        };
    }

    public StatefulSetAllocatorSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.driverPodName = "driver";
        this.driverPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.driverPodName()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid("driver-pod-uid")).endMetadata()).build();
        this.conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.driverPodName()).set(package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT().key(), "10s");
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.conf());
        this.secondProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.conf());
        this.secMgr = new SecurityManager(this.conf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        this.appId = "testapp";
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.kubernetesClient().apps()).thenReturn((Object)this.appOperations());
            Mockito.when((Object)this.appOperations().statefulSets()).thenReturn(this.statefulSetOperations());
            Mockito.when((Object)this.statefulSetOperations().withName((String)ArgumentMatchers.any())).thenReturn(this.editableSet());
            Mockito.when((Object)this.podOperations().withName(this.driverPodName())).thenReturn(this.driverPodOperations());
            Mockito.when((Object)this.driverPodOperations().get()).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.driverPodOperations().waitUntilReady(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (TimeUnit)((Object)((Object)ArgumentMatchers.any())))).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(this.executorPodAnswer());
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.podsAllocatorUnderTest_$eq(new StatefulSetPodsAllocator(this.conf(), this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), null));
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)Nil$.MODULE$);
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
        }, new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("Validate initial statefulSet creation & cleanup with two resource profiles", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ResourceProfileBuilder rprof = new ResourceProfileBuilder();
            TaskResourceRequests taskReq = new TaskResourceRequests().resource("gpu", 1.0);
            ExecutorResourceRequests execReq = new ExecutorResourceRequests().resource("gpu", 2L, "myscript", "nvidia");
            rprof.require(taskReq).require(execReq);
            ResourceProfile immrprof = new ResourceProfile(rprof.executorResources(), rprof.taskResources());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)immrprof), (Object)BoxesRunTime.boxToInteger((int)420))})));
            ArgumentCaptor captor = ArgumentCaptor.forClass(StatefulSet.class);
            ((InOutCreateable)Mockito.verify(this.statefulSetOperations(), (VerificationMode)Mockito.times((int)2))).create(ArgumentMatchers.any());
            this.podsAllocatorUnderTest().stop(this.appId());
            return ((Deletable)Mockito.verify(this.editableSet(), (VerificationMode)Mockito.times((int)2))).delete();
        }, new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("Validate statefulSet scale up", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)10))})));
            ArgumentCaptor captor = ArgumentCaptor.forClass(StatefulSet.class);
            ((InOutCreateable)Mockito.verify(this.statefulSetOperations(), (VerificationMode)Mockito.times((int)1))).create(captor.capture());
            StatefulSet set = (StatefulSet)captor.getValue();
            String setName = set.getMetadata().getName();
            String namespace = set.getMetadata().getNamespace();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(namespace);
            String $org_scalatest_assert_macro_right = "default";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            StatefulSetSpec spec = set.getSpec();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(spec.getReplicas());
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(spec.getPodManagementPolicy());
            String $org_scalatest_assert_macro_right3 = "Parallel";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).create(ArgumentMatchers.any());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)20))})));
            return (StatefulSet)((Scaleable)Mockito.verify(this.editableSet(), (VerificationMode)Mockito.times((int)1))).scale(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        }, new Position("StatefulSetAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }
}

