/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y2Aa\u0001\u0003\u0001#!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C\tQ2*\u001e2fe:,G/Z:DY&,g\u000e^+uS2\u001c8+^5uK*\u0011QAB\u0001\u0007gV\u0014W.\u001b;\u000b\u0005\u001dA\u0011aA69g*\u0011\u0011BC\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9\"$D\u0001\u0019\u0015\tIb\"A\u0005tG\u0006d\u0017\r^3ti&\u00111\u0004\u0007\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\tA!A\u0005uKN$8+\u001a;vaR\u0011!%\n\t\u0003'\rJ!\u0001\n\u0006\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"\u0002\u0014\u0003\u0001\u00049\u0013AC5oaV$h)\u001b7fgB!\u0001&\r\u001b8\u001d\tIs\u0006\u0005\u0002+[5\t1F\u0003\u0002-!\u00051AH]8pizR\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\ri\u0015\r\u001d\u0006\u0003a5\u0002\"\u0001K\u001b\n\u0005Y\u001a$AB*ue&tw\rE\u00029smj\u0011!L\u0005\u0003u5\u0012Q!\u0011:sCf\u0004\"\u0001\u000f\u001f\n\u0005uj#\u0001\u0002\"zi\u0016\u0004")
public class KubernetesClientUtilsSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public SparkConf testSetup(scala.collection.immutable.Map<String, byte[]> inputFiles) {
        void var3_3;
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        SparkConf sparkConf = new SparkConf(false).setSparkHome(tempDir.getAbsolutePath());
        File tempConfDir = new File(new StringBuilder(5).append(tempDir.getAbsolutePath()).append("/conf").toString());
        tempConfDir.mkdir();
        inputFiles.map((Function1 & Serializable & scala.Serializable)i -> {
            File file = new File(new StringBuilder(1).append(tempConfDir.getAbsolutePath()).append("/").append(i._1()).toString());
            Files.write(file.toPath(), (byte[])i._2(), new OpenOption[0]);
            return file.getName();
        }, Iterable$.MODULE$.canBuildFrom());
        return var3_3;
    }

    public KubernetesClientUtilsSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.test("verify load files, loads only allowed files and not the disallowed files.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map input = ((MapLike)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.txt"), (Object)"test123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"z12.zip"), (Object)"zZ"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rere.jar"), (Object)"@31"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.jar"), (Object)"@31"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_test"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample.conf"), (Object)"conf")}))).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._1()), (Object)((String)f._2()).getBytes(StandardCharsets.UTF_8)), Map$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"binary-file.conf"), Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)0, (byte)161}), ClassTag$.MODULE$.Byte()))})));
            SparkConf sparkConf = this.testSetup((scala.collection.immutable.Map<String, byte[]>)input);
            scala.collection.immutable.Map output = KubernetesClientUtils$.MODULE$.loadSparkConfDirFiles(sparkConf);
            scala.collection.immutable.Map expectedOutput = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.txt"), (Object)"test123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sample.conf"), (Object)"conf"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_test"), (Object)"")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(output);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = expectedOutput;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        }, new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("verify load files, truncates the content to maxSize, when keys are very large in number.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map input = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10000), 1).by(-1).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("testConf.").append(BoxesRunTime.unboxToInt((Object)i)).toString()), (Object)"test123456"), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            SparkConf sparkConf = this.testSetup((scala.collection.immutable.Map<String, byte[]>)((scala.collection.immutable.Map)input.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._1()), (Object)((String)f._2()).getBytes(StandardCharsets.UTF_8)), Map$.MODULE$.canBuildFrom()))).set(Config$.MODULE$.CONFIG_MAP_MAXSIZE().key(), "60");
            scala.collection.immutable.Map output = KubernetesClientUtils$.MODULE$.loadSparkConfDirFiles(sparkConf);
            scala.collection.immutable.Map expectedOutput = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testConf.1"), (Object)"test123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testConf.2"), (Object)"test123456")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(output);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = expectedOutput;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            scala.collection.immutable.Map output1 = KubernetesClientUtils$.MODULE$.loadSparkConfDirFiles(sparkConf.set(Config$.MODULE$.CONFIG_MAP_MAXSIZE().key(), "250000"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(output1);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = input;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("verify load files, truncates the content to maxSize, when keys are equal in length.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map input = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(9), 1).by(-1).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("testConf.").append(BoxesRunTime.unboxToInt((Object)i)).toString()), (Object)"test123456"), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            SparkConf sparkConf = this.testSetup((scala.collection.immutable.Map<String, byte[]>)((scala.collection.immutable.Map)input.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._1()), (Object)((String)f._2()).getBytes(StandardCharsets.UTF_8)), Map$.MODULE$.canBuildFrom()))).set(Config$.MODULE$.CONFIG_MAP_MAXSIZE().key(), "80");
            scala.collection.immutable.Map output = KubernetesClientUtils$.MODULE$.loadSparkConfDirFiles(sparkConf);
            scala.collection.immutable.Map expectedOutput = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testConf.1"), (Object)"test123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testConf.2"), (Object)"test123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"testConf.3"), (Object)"test123456")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(output);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = expectedOutput;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("verify that configmap built as expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String configMapName = new StringBuilder(15).append("configmap-name-").append(UUID.randomUUID().toString()).toString();
            String configMapNameSpace = new StringBuilder(20).append("configmap-namespace-").append(UUID.randomUUID().toString()).toString();
            scala.collection.immutable.Map properties = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key()), (Object)configMapNameSpace)}));
            SparkConf sparkConf = this.testSetup((scala.collection.immutable.Map<String, byte[]>)((scala.collection.immutable.Map)properties.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._1()), (Object)((String)f._2()).getBytes(StandardCharsets.UTF_8)), Map$.MODULE$.canBuildFrom())));
            scala.collection.immutable.Map confFileMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, sparkConf, properties);
            ConfigMap outputConfigMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, confFileMap, properties);
            ConfigMap expectedConfigMap = ((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName).withNamespace(configMapNameSpace).withLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)properties).asJava())).endMetadata()).withImmutable(Predef$.MODULE$.boolean2Boolean(true))).addToData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)confFileMap).asJava())).build();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(outputConfigMap);
            ConfigMap $org_scalatest_assert_macro_right = expectedConfigMap;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("KubernetesClientUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }
}

