/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u001a5\u0001\u0005CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004]\u0001\u0001\u0006IA\u0015\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u0019\u0011\u0007\u0001)A\u0005?\"I1\r\u0001a\u0001\u0002\u0004%I\u0001\u001a\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%D\u0011B\u001d\u0001A\u0002\u0003\u0005\u000b\u0015B3\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0013Y\bBC@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0002!Q\u0011Q\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u0002?\t\u0017\u0005%\u0001\u00011AA\u0002\u0013%\u00111\u0002\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002C\u0006\u0002 \u0001\u0001\r\u0011!Q!\n\u00055\u0001bCA\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0003KA1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020!Y\u00111\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0014\u0011-\t9\u0004\u0001a\u0001\u0002\u0004%I!!\u000f\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011Q\u000b\u0005\f\u00033\u0002\u0001\u0019!A!B\u0013\tY\u0004C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\n\u0005}\u0003bCAH\u0001\u0001\u0007\t\u0019!C\u0005\u0003#C1\"!&\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002b!Y\u0011\u0011\u0014\u0001A\u0002\u0003\u0007I\u0011BAN\u0011-\t\u0019\u000b\u0001a\u0001\u0002\u0004%I!!*\t\u0017\u0005%\u0006\u00011A\u0001B\u0003&\u0011Q\u0014\u0005\f\u0003[\u0003\u0001\u0019!a\u0001\n\u0013\ty\u000bC\u0006\u0002:\u0002\u0001\r\u00111A\u0005\n\u0005m\u0006bCA`\u0001\u0001\u0007\t\u0011)Q\u0005\u0003cC1\"a1\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002F\"Y\u0011Q\u001a\u0001A\u0002\u0003\u0007I\u0011BAh\u0011-\t\u0019\u000e\u0001a\u0001\u0002\u0003\u0006K!a2\t\u0017\u0005]\u0007\u00011AA\u0002\u0013%\u0011\u0011\u001c\u0005\f\u0003C\u0004\u0001\u0019!a\u0001\n\u0013\t\u0019\u000fC\u0006\u0002h\u0002\u0001\r\u0011!Q!\n\u0005m\u0007bCAv\u0001\u0001\u0007\t\u0019!C\u0005\u0003[D1\"!>\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002x\"Y\u00111 \u0001A\u0002\u0003\u0005\u000b\u0015BAx\u0011-\ty\u0010\u0001a\u0001\u0002\u0004%IA!\u0001\t\u0017\t%\u0001\u00011AA\u0002\u0013%!1\u0002\u0005\f\u0005\u001f\u0001\u0001\u0019!A!B\u0013\u0011\u0019\u0001C\u0006\u0003\u0014\u0001\u0001\r\u00111A\u0005\n\tU\u0001b\u0003B\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0005?A1Ba\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0018!Y!q\u0005\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0015\u0011-\u00119\u0004\u0001a\u0001\u0002\u0004%IA!\u000f\t\u0017\tu\u0002\u00011A\u0001B\u0003&!1\u0006\u0005\f\u0005\u007f\u0001\u0001\u0019!a\u0001\n\u0013\u0011\t\u0005C\u0006\u0003J\u0001\u0001\r\u00111A\u0005\n\t-\u0003b\u0003B(\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0007\u0012aeS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u001cV/\u001b;f\u0015\t)d'A\u0002lqMT!a\u000e\u001d\u0002\u000f\rdWo\u001d;fe*\u0011\u0011HO\u0001\ng\u000eDW\rZ;mKJT!a\u000f\u001f\u0002\u000bM\u0004\u0018M]6\u000b\u0005ur\u0014AB1qC\u000eDWMC\u0001@\u0003\ry'oZ\u0002\u0001'\r\u0001!I\u0012\t\u0003\u0007\u0012k\u0011AO\u0005\u0003\u000bj\u0012Qb\u00159be.4UO\\*vSR,\u0007CA$K\u001b\u0005A%BA%?\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002L\u0011\nq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001O!\ty\u0005!D\u00015\u0003a\u00198\r[3ek2,'/\u0012=fGV$xN]*feZL7-Z\u000b\u0002%B\u00111KW\u0007\u0002)*\u0011QKV\u0001\u000bG>t7-\u001e:sK:$(BA,Y\u0003\ra\u0017N\u0019\u0006\u00033z\nQA[7pG.L!a\u0017+\u0003-\u0011+G/\u001a:nS:L7\u000f^5d'\u000eDW\rZ;mKJ\f\u0011d]2iK\u0012,H.\u001a:Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2fA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002?B\u00111\tY\u0005\u0003Cj\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015M\u0004\u0018M]6D_:4\u0007%\u0001\u0002tGV\tQ\r\u0005\u0002DM&\u0011qM\u000f\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007g\u000e|F%Z9\u0015\u0005)\u0004\bCA6o\u001b\u0005a'\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d'\u0001B+oSRDq!]\u0004\u0002\u0002\u0003\u0007Q-A\u0002yIE\n1a]2!Q\tAA\u000f\u0005\u0002vq6\taO\u0003\u0002x}\u00059Qn\\2lSR|\u0017BA=w\u0005\u0011iunY6\u0002\u0007\u0015tg/F\u0001}!\t\u0019U0\u0003\u0002\u007fu\tA1\u000b]1sW\u0016sg/A\u0004f]Z|F%Z9\u0015\u0007)\f\u0019\u0001C\u0004r\u0015\u0005\u0005\t\u0019\u0001?\u0002\t\u0015tg\u000f\t\u0015\u0003\u0017Q\faA\u001d9d\u000b:4XCAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nu\u0005\u0019!\u000f]2\n\t\u0005]\u0011\u0011\u0003\u0002\u0007%B\u001cWI\u001c<\u0002\u0015I\u00048-\u00128w?\u0012*\u0017\u000fF\u0002k\u0003;A\u0001\"]\u0007\u0002\u0002\u0003\u0007\u0011QB\u0001\beB\u001cWI\u001c<!Q\tqA/A\tee&4XM]#oIB|\u0017N\u001c;SK\u001a,\"!a\n\u0011\t\u0005=\u0011\u0011F\u0005\u0005\u0003W\t\tB\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002+\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oiJ+gm\u0018\u0013fcR\u0019!.!\r\t\u0011E\u0004\u0012\u0011!a\u0001\u0003O\t!\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tGOU3gA!\u0012\u0011\u0003^\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R,\"!a\u000f\u0011\t\u0005u\u0012qJ\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u000511\r\\5f]RTA!!\u0012\u0002H\u0005Q1.\u001e2fe:,G/Z:\u000b\t\u0005%\u00131J\u0001\bM\u0006\u0014'/[29\u0015\t\ti%\u0001\u0002j_&!\u0011\u0011KA \u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG/\u0001\u000blk\n,'O\\3uKN\u001cE.[3oi~#S-\u001d\u000b\u0004U\u0006]\u0003\u0002C9\u0014\u0003\u0003\u0005\r!a\u000f\u0002#-,(-\u001a:oKR,7o\u00117jK:$\b\u0005\u000b\u0002\u0015i\u0006i\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N,\"!!\u0019\u0011\t\u0005\r\u0014\u0011\u0012\b\u0005\u0003K\n\u0019I\u0004\u0003\u0002h\u0005}d\u0002BA5\u0003wrA!a\u001b\u0002z9!\u0011QNA<\u001d\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:\u0001\u00061AH]8pizJ\u0011aP\u0005\u0003{yJ!a\u000f\u001f\n\u0007\u0005u$(\u0001\u0004eKBdw._\u0005\u0004k\u0005\u0005%bAA?u%!\u0011QQAD\u000391\u0015M\u0019:jGb\nE.[1tKNT1!NAA\u0013\u0011\tY)!$\u0003\tA{Ei\u0015\u0006\u0005\u0003\u000b\u000b9)A\tq_\u0012|\u0005/\u001a:bi&|gn]0%KF$2A[AJ\u0011!\th#!AA\u0002\u0005\u0005\u0014A\u00049pI>\u0003XM]1uS>t7\u000f\t\u0015\u0003/Q\f1\u0002\\1cK2,G\rU8egV\u0011\u0011Q\u0014\t\u0005\u0003G\ny*\u0003\u0003\u0002\"\u00065%\u0001\u0004'B\u0005\u0016cU\tR0Q\u001f\u0012\u001b\u0016a\u00047bE\u0016dW\r\u001a)pIN|F%Z9\u0015\u0007)\f9\u000b\u0003\u0005r3\u0005\u0005\t\u0019AAO\u00031a\u0017MY3mK\u0012\u0004v\u000eZ:!Q\tQB/A\u0007uCN\\7k\u00195fIVdWM]\u000b\u0003\u0003c\u0003B!a-\u000266\t\u0001(C\u0002\u00028b\u0012\u0011\u0003V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018*\u001c9m\u0003E!\u0018m]6TG\",G-\u001e7fe~#S-\u001d\u000b\u0004U\u0006u\u0006\u0002C9\u001d\u0003\u0003\u0005\r!!-\u0002\u001dQ\f7o[*dQ\u0016$W\u000f\\3sA!\u0012Q\u0004^\u0001\u000bKZ,g\u000e^)vKV,WCAAd!\ry\u0015\u0011Z\u0005\u0004\u0003\u0017$$AG#yK\u000e,Ho\u001c:Q_\u0012\u001c8K\\1qg\"|Go]*u_J,\u0017AD3wK:$\u0018+^3vK~#S-\u001d\u000b\u0004U\u0006E\u0007\u0002C9 \u0003\u0003\u0005\r!a2\u0002\u0017\u00154XM\u001c;Rk\u0016,X\r\t\u0015\u0003AQ\fA\u0002]8e\u00032dwnY1u_J,\"!a7\u0011\u0007=\u000bi.C\u0002\u0002`R\u0012Q#\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'/\u0001\tq_\u0012\fE\u000e\\8dCR|'o\u0018\u0013fcR\u0019!.!:\t\u0011E\u0014\u0013\u0011!a\u0001\u00037\fQ\u0002]8e\u00032dwnY1u_J\u0004\u0003FA\u0012u\u0003Ua\u0017NZ3ds\u000edW-\u0012<f]RD\u0015M\u001c3mKJ,\"!a<\u0011\u0007=\u000b\t0C\u0002\u0002tR\u0012A$\u0012=fGV$xN\u001d)pINd\u0015NZ3ds\u000edW-T1oC\u001e,'/A\rmS\u001a,7-_2mK\u00163XM\u001c;IC:$G.\u001a:`I\u0015\fHc\u00016\u0002z\"A\u0011/JA\u0001\u0002\u0004\ty/\u0001\fmS\u001a,7-_2mK\u00163XM\u001c;IC:$G.\u001a:!Q\t1C/A\u0006xCR\u001c\u0007.\u0012<f]R\u001cXC\u0001B\u0002!\ry%QA\u0005\u0004\u0005\u000f!$aH#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQNs\u0017\r]:i_R\u001cv.\u001e:dK\u0006yq/\u0019;dQ\u00163XM\u001c;t?\u0012*\u0017\u000fF\u0002k\u0005\u001bA\u0001\"\u001d\u0015\u0002\u0002\u0003\u0007!1A\u0001\ro\u0006$8\r[#wK:$8\u000f\t\u0015\u0003SQ\f!\u0002]8mY\u00163XM\u001c;t+\t\u00119\u0002E\u0002P\u00053I1Aa\u00075\u0005\u0005*\u00050Z2vi>\u0014\bk\u001c3t!>dG.\u001b8h':\f\u0007o\u001d5piN{WO]2f\u00039\u0001x\u000e\u001c7Fm\u0016tGo]0%KF$2A\u001bB\u0011\u0011!\t8&!AA\u0002\t]\u0011a\u00039pY2,e/\u001a8ug\u0002B#\u0001\f;\u0002\u001d\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oiV\u0011!1\u0006\t\u0006k\n5\"\u0011G\u0005\u0004\u0005_1(AD!sOVlWM\u001c;DCB$xN\u001d\t\u0005\u0003\u001f\u0011\u0019$\u0003\u0003\u00036\u0005E!a\u0003*qG\u0016sG\r]8j]R\f!\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tGo\u0018\u0013fcR\u0019!Na\u000f\t\u0011Et\u0013\u0011!a\u0001\u0005W\tq\u0002\u001a:jm\u0016\u0014XI\u001c3q_&tG\u000fI\u0001\u001ag\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012,f\u000eZ3s)\u0016\u001cH/\u0006\u0002\u0003DA\u0019qJ!\u0012\n\u0007\t\u001dCGA\u0011Lk\n,'O\\3uKN\u001cE.^:uKJ\u001c6\r[3ek2,'OQ1dW\u0016tG-A\u000ftG\",G-\u001e7fe\n\u000b7m[3oIVsG-\u001a:UKN$x\fJ3r)\rQ'Q\n\u0005\tcF\n\t\u00111\u0001\u0003D\u0005Q2o\u00195fIVdWM\u001d\"bG.,g\u000eZ+oI\u0016\u0014H+Z:uA\u0001")
public class KubernetesClusterSchedulerBackendSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final DeterministicScheduler schedulerExecutorService;
    private final SparkConf sparkConf;
    @Mock
    private SparkContext sc;
    @Mock
    private SparkEnv env;
    @Mock
    private RpcEnv rpcEnv;
    @Mock
    private RpcEndpointRef driverEndpointRef;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> labeledPods;
    @Mock
    private TaskSchedulerImpl taskScheduler;
    @Mock
    private ExecutorPodsSnapshotsStore eventQueue;
    @Mock
    private ExecutorPodsAllocator podAllocator;
    @Mock
    private ExecutorPodsLifecycleManager lifecycleEventHandler;
    @Mock
    private ExecutorPodsWatchSnapshotSource watchEvents;
    @Mock
    private ExecutorPodsPollingSnapshotSource pollEvents;
    private ArgumentCaptor<RpcEndpoint> driverEndpoint;
    private KubernetesClusterSchedulerBackend schedulerBackendUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private DeterministicScheduler schedulerExecutorService() {
        return this.schedulerExecutorService;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private SparkEnv env() {
        return this.env;
    }

    private void env_$eq(SparkEnv x$1) {
        this.env = x$1;
    }

    private RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    private void rpcEnv_$eq(RpcEnv x$1) {
        this.rpcEnv = x$1;
    }

    private RpcEndpointRef driverEndpointRef() {
        return this.driverEndpointRef;
    }

    private void driverEndpointRef_$eq(RpcEndpointRef x$1) {
        this.driverEndpointRef = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.podOperations = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> labeledPods() {
        return this.labeledPods;
    }

    private void labeledPods_$eq(FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> x$1) {
        this.labeledPods = x$1;
    }

    private TaskSchedulerImpl taskScheduler() {
        return this.taskScheduler;
    }

    private void taskScheduler_$eq(TaskSchedulerImpl x$1) {
        this.taskScheduler = x$1;
    }

    private ExecutorPodsSnapshotsStore eventQueue() {
        return this.eventQueue;
    }

    private void eventQueue_$eq(ExecutorPodsSnapshotsStore x$1) {
        this.eventQueue = x$1;
    }

    private ExecutorPodsAllocator podAllocator() {
        return this.podAllocator;
    }

    private void podAllocator_$eq(ExecutorPodsAllocator x$1) {
        this.podAllocator = x$1;
    }

    private ExecutorPodsLifecycleManager lifecycleEventHandler() {
        return this.lifecycleEventHandler;
    }

    private void lifecycleEventHandler_$eq(ExecutorPodsLifecycleManager x$1) {
        this.lifecycleEventHandler = x$1;
    }

    private ExecutorPodsWatchSnapshotSource watchEvents() {
        return this.watchEvents;
    }

    private void watchEvents_$eq(ExecutorPodsWatchSnapshotSource x$1) {
        this.watchEvents = x$1;
    }

    private ExecutorPodsPollingSnapshotSource pollEvents() {
        return this.pollEvents;
    }

    private void pollEvents_$eq(ExecutorPodsPollingSnapshotSource x$1) {
        this.pollEvents = x$1;
    }

    private ArgumentCaptor<RpcEndpoint> driverEndpoint() {
        return this.driverEndpoint;
    }

    private void driverEndpoint_$eq(ArgumentCaptor<RpcEndpoint> x$1) {
        this.driverEndpoint = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackendUnderTest() {
        return this.schedulerBackendUnderTest;
    }

    private void schedulerBackendUnderTest_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackendUnderTest = x$1;
    }

    public KubernetesClusterSchedulerBackendSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.schedulerExecutorService = new DeterministicScheduler();
        this.sparkConf = new SparkConf(false).set("spark.executor.instances", "3").set("spark.app.id", ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.initMocks((Object)((Object)this));
            Mockito.when((Object)this.taskScheduler().sc()).thenReturn((Object)this.sc());
            Mockito.when((Object)this.sc().conf()).thenReturn((Object)this.sparkConf());
            Mockito.when((Object)this.sc().env()).thenReturn((Object)this.env());
            Mockito.when((Object)this.env().rpcEnv()).thenReturn((Object)this.rpcEnv());
            this.driverEndpoint_$eq((ArgumentCaptor<RpcEndpoint>)ArgumentCaptor.forClass(RpcEndpoint.class));
            Mockito.when((Object)this.rpcEnv().setupEndpoint((String)ArgumentMatchers.eq((Object)CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()), (RpcEndpoint)this.driverEndpoint().capture())).thenReturn((Object)this.driverEndpointRef());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            this.schedulerBackendUnderTest_$eq(new KubernetesClusterSchedulerBackend(this.taskScheduler(), this.sc(), this.kubernetesClient(), (ScheduledExecutorService)this.schedulerExecutorService(), this.eventQueue(), this.podAllocator(), this.lifecycleEventHandler(), this.watchEvents(), this.pollEvents()));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("Start all components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).setTotalExpectedExecutors(3);
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            ((ExecutorPodsLifecycleManager)Mockito.verify((Object)this.lifecycleEventHandler())).start(this.schedulerBackendUnderTest());
            ((ExecutorPodsWatchSnapshotSource)Mockito.verify((Object)this.watchEvents())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            ((ExecutorPodsPollingSnapshotSource)Mockito.verify((Object)this.pollEvents())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("Stop all components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            this.schedulerBackendUnderTest().stop();
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).stop();
            ((ExecutorPodsWatchSnapshotSource)Mockito.verify((Object)this.watchEvents())).stop();
            ((ExecutorPodsPollingSnapshotSource)Mockito.verify((Object)this.pollEvents())).stop();
            ((Deletable)Mockito.verify(this.labeledPods())).delete();
            ((Client)Mockito.verify((Object)this.kubernetesClient())).close();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("Remove executor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClusterSchedulerBackend backend = (KubernetesClusterSchedulerBackend)Mockito.spy((Object)this.schedulerBackendUnderTest());
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)backend.isExecutorActive((String)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)backend.isExecutorActive((String)ArgumentMatchers.eq((Object)"2")))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            backend.start();
            backend.doRemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$);
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef(), (VerificationMode)Mockito.never())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            backend.doRemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$);
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef(), (VerificationMode)Mockito.never())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("Kill executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            Mockito.when((Object)this.podOperations().withField((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1", "2"})).thenReturn(this.labeledPods());
            PodList podList = (PodList)Mockito.mock(PodList.class);
            Mockito.when((Object)this.labeledPods().list()).thenReturn((Object)podList);
            Mockito.when((Object)podList.getItems()).thenReturn(Arrays.asList((Object[])new Pod[0]));
            this.schedulerBackendUnderTest().doKillExecutors((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})));
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            Mockito.when((Object)podList.getItems()).thenReturn(Arrays.asList((Object[])new Pod[]{(Pod)Mockito.mock(Pod.class)}));
            this.schedulerBackendUnderTest().doKillExecutors((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            return (Boolean)((Deletable)Mockito.verify(this.labeledPods())).delete();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
    }
}

