/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u000e\u001d\u0001%BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0011\u00191\u0005\u0001)A\u0005\u0001\"Iq\t\u0001a\u0001\u0002\u0004%I\u0001\u0013\u0005\n+\u0002\u0001\r\u00111A\u0005\nYC\u0011\u0002\u0018\u0001A\u0002\u0003\u0005\u000b\u0015B%\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0013)\u0007\"C?\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u007f\u0011)\t\t\u0001\u0001a\u0001\u0002\u0003\u0006KA\u001a\u0005\f\u0003\u000b\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0001C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\n\u0005E\u0001bCA\u000b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0013A1\"!\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\b!Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011-\t\t\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u0003\t\u0017\u0005\u0015\u0002\u00011AA\u0002\u0013%\u0011q\u0005\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0004C\u0006\u00026\u0001\u0001\r\u0011!Q!\n\u0005%\u0002bCA\u001d\u0001\u0001\u0007\t\u0019!C\u0005\u0003wA1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002T!Y\u0011q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001f\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\t\u0017\u0005\r\u0004\u00011AA\u0002\u0013%\u0011Q\r\u0005\f\u0003S\u0002\u0001\u0019!A!B\u0013\tiF\u0001\u0014Fq\u0016\u001cW\u000f^8s!>$7\u000fU8mY&twm\u00158baNDw\u000e^*pkJ\u001cWmU;ji\u0016T!!\b\u0010\u0002\u0007-D4O\u0003\u0002 A\u000591\r\\;ti\u0016\u0014(BA\u0011#\u0003%\u00198\r[3ek2,'O\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0016/!\tYC&D\u0001#\u0013\ti#EA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0019\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005M\u0002$A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003q\t\u0011b\u001d9be.\u001cuN\u001c4\u0016\u0003i\u0002\"aK\u001e\n\u0005q\u0012#!C*qCJ\\7i\u001c8g\u0003)\u0019\b/\u0019:l\u0007>tg\rI\u0001\u0010a>dG.\u001b8h\u0013:$XM\u001d<bYV\t\u0001\t\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%I\u0001\u0003M_:<\u0017\u0001\u00059pY2LgnZ%oi\u0016\u0014h/\u00197!\u0003AYWOY3s]\u0016$Xm]\"mS\u0016tG/F\u0001J!\tQ5+D\u0001L\u0015\taU*\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001d>\u000b!b[;cKJtW\r^3t\u0015\t\u0001\u0016+A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003I\u000b!![8\n\u0005Q[%\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003QYWOY3s]\u0016$Xm]\"mS\u0016tGo\u0018\u0013fcR\u0011qK\u0017\t\u0003\u0003bK!!\u0017\"\u0003\tUs\u0017\u000e\u001e\u0005\b7\u001e\t\t\u00111\u0001J\u0003\rAH%M\u0001\u0012WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\u0003F\u0001\u0005_!\ty&-D\u0001a\u0015\t\tg%A\u0004n_\u000e\\\u0017\u000e^8\n\u0005\r\u0004'\u0001B'pG.\fQ\u0002]8e\u001fB,'/\u0019;j_:\u001cX#\u00014\u0011\u0005\u001dThB\u00015x\u001d\tIWO\u0004\u0002kg:\u00111N\u001d\b\u0003YFt!!\u001c9\u000e\u00039T!a\u001c\u0015\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0013BA\u0013'\u0013\t\u0019C%\u0003\u0002uE\u00051A-\u001a9m_fL!!\b<\u000b\u0005Q\u0014\u0013B\u0001=z\u000391\u0015M\u0019:jGb\nE.[1tKNT!!\b<\n\u0005md(\u0001\u0002)P\tNS!\u0001_=\u0002#A|Gm\u00149fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002X\u007f\"91LCA\u0001\u0002\u00041\u0017A\u00049pI>\u0003XM]1uS>t7\u000f\t\u0015\u0003\u0017y\u000b\u0001#\u00199q\u0013\u0012d\u0015MY3mK\u0012\u0004v\u000eZ:\u0016\u0005\u0005%\u0001cA4\u0002\f%\u0019\u0011Q\u0002?\u0003\u00191\u000b%)\u0012'F\t~\u0003v\nR*\u0002)\u0005\u0004\b/\u00133MC\n,G.\u001a3Q_\u0012\u001cx\fJ3r)\r9\u00161\u0003\u0005\t76\t\t\u00111\u0001\u0002\n\u0005\t\u0012\r\u001d9JI2\u000b'-\u001a7fIB{Gm\u001d\u0011)\u00059q\u0016aF3yK\u000e,Ho\u001c:S_2,G*\u00192fY\u0016$\u0007k\u001c3t\u0003m)\u00070Z2vi>\u0014(k\u001c7f\u0019\u0006\u0014W\r\\3e!>$7o\u0018\u0013fcR\u0019q+a\b\t\u0011m\u0003\u0012\u0011!a\u0001\u0003\u0013\t\u0001$\u001a=fGV$xN\u001d*pY\u0016d\u0015MY3mK\u0012\u0004v\u000eZ:!Q\t\tb,\u0001\u0006fm\u0016tG/U;fk\u0016,\"!!\u000b\u0011\u0007]\nY#C\u0002\u0002.q\u0011!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fa\"\u001a<f]R\fV/Z;f?\u0012*\u0017\u000fF\u0002X\u0003gA\u0001bW\n\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\fKZ,g\u000e^)vKV,\u0007\u0005\u000b\u0002\u0015=\u0006y\u0001o\u001c7mS:<W\t_3dkR|'/\u0006\u0002\u0002>A!\u0011qHA'\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013AC2p]\u000e,(O]3oi*!\u0011qIA%\u0003\ra\u0017N\u0019\u0006\u0004\u0003\u00172\u0013!\u00026n_\u000e\\\u0017\u0002BA(\u0003\u0003\u0012a\u0003R3uKJl\u0017N\\5ti&\u001c7k\u00195fIVdWM]\u0001\u0014a>dG.\u001b8h\u000bb,7-\u001e;pe~#S-\u001d\u000b\u0004/\u0006U\u0003\u0002C.\u0017\u0003\u0003\u0005\r!!\u0010\u0002!A|G\u000e\\5oO\u0016CXmY;u_J\u0004\u0013A\u00069pY2LgnZ*pkJ\u001cW-\u00168eKJ$Vm\u001d;\u0016\u0005\u0005u\u0003cA\u001c\u0002`%\u0019\u0011\u0011\r\u000f\u0003C\u0015CXmY;u_J\u0004v\u000eZ:Q_2d\u0017N\\4T]\u0006\u00048\u000f[8u'>,(oY3\u00025A|G\u000e\\5oON{WO]2f+:$WM\u001d+fgR|F%Z9\u0015\u0007]\u000b9\u0007\u0003\u0005\\3\u0005\u0005\t\u0019AA/\u0003]\u0001x\u000e\u001c7j]\u001e\u001cv.\u001e:dKVsG-\u001a:UKN$\b\u0005")
public class ExecutorPodsPollingSnapshotSourceSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final SparkConf sparkConf;
    private final long pollingInterval;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> appIdLabeledPods;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> executorRoleLabeledPods;
    @Mock
    private ExecutorPodsSnapshotsStore eventQueue;
    private DeterministicScheduler pollingExecutor;
    private ExecutorPodsPollingSnapshotSource pollingSourceUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private long pollingInterval() {
        return this.pollingInterval;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.podOperations = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> appIdLabeledPods() {
        return this.appIdLabeledPods;
    }

    private void appIdLabeledPods_$eq(FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> x$1) {
        this.appIdLabeledPods = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> executorRoleLabeledPods() {
        return this.executorRoleLabeledPods;
    }

    private void executorRoleLabeledPods_$eq(FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> x$1) {
        this.executorRoleLabeledPods = x$1;
    }

    private ExecutorPodsSnapshotsStore eventQueue() {
        return this.eventQueue;
    }

    private void eventQueue_$eq(ExecutorPodsSnapshotsStore x$1) {
        this.eventQueue = x$1;
    }

    private DeterministicScheduler pollingExecutor() {
        return this.pollingExecutor;
    }

    private void pollingExecutor_$eq(DeterministicScheduler x$1) {
        this.pollingExecutor = x$1;
    }

    private ExecutorPodsPollingSnapshotSource pollingSourceUnderTest() {
        return this.pollingSourceUnderTest;
    }

    private void pollingSourceUnderTest_$eq(ExecutorPodsPollingSnapshotSource x$1) {
        this.pollingSourceUnderTest = x$1;
    }

    public ExecutorPodsPollingSnapshotSourceSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.sparkConf = new SparkConf();
        this.pollingInterval = BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_INTERVAL()));
        this.before((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.initMocks((Object)((Object)this));
            this.pollingExecutor_$eq(new DeterministicScheduler());
            this.pollingSourceUnderTest_$eq(new ExecutorPodsPollingSnapshotSource(this.sparkConf(), this.kubernetesClient(), this.eventQueue(), (ScheduledExecutorService)this.pollingExecutor()));
            this.pollingSourceUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.appIdLabeledPods());
            return Mockito.when((Object)this.appIdLabeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.executorRoleLabeledPods());
        }, new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("Items returned by the API should be pushed to the event queue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.executorRoleLabeledPods().list()).thenReturn((Object)((PodListBuilder)new PodListBuilder().addToItems(new Pod[]{ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L), ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L)})).build());
            this.pollingExecutor().tick(this.pollingInterval(), TimeUnit.MILLISECONDS);
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).replaceSnapshot((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pod[]{ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L), ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L)})));
        }, new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }
}

