/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\f\u0018\u0001\u0011BQa\f\u0001\u0005\u0002AB\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001b\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013!\u0007\"C6\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011%a\u0007\u00011AA\u0002\u0013%Q\u000eC\u0005s\u0001\u0001\u0007\t\u0019!C\u0005g\"IQ\u000f\u0001a\u0001\u0002\u0003\u0006KA\u001c\u0005\n{\u0002\u0001\r\u00111A\u0005\nyD1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*!Q\u0011Q\u0006\u0001A\u0002\u0003\u0005\u000b\u0015B@\t\u0017\u0005E\u0002\u00011AA\u0002\u0013%\u00111\u0007\u0005\f\u0003w\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0004C\u0006\u0002B\u0001\u0001\r\u0011!Q!\n\u0005U\u0002bCA#\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fB1\"a\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002R!Y\u0011Q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA%\u0011-\t9\u0006\u0001a\u0001\u0002\u0004%I!!\u0017\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003O\u0002\u0001\u0019!A!B\u0013\tY\u0006C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~\t\tS\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u00148+^5uK*\u0011\u0001$G\u0001\u0004Wb\u001a(B\u0001\u000e\u001c\u0003\u001d\u0019G.^:uKJT!\u0001H\u000f\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!J\u0015\u0011\u0005\u0019:S\"A\u000f\n\u0005!j\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002+[5\t1F\u0003\u0002-C\u0005I1oY1mCR,7\u000f^\u0005\u0003]-\u0012aBQ3g_J,\u0017I\u001c3BMR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u0002/\u0005\tb.Y7fI\u0016CXmY;u_J\u0004v\u000eZ:\u0016\u0003U\u0002BAN\u001f@\u00156\tqG\u0003\u00029s\u00059Q.\u001e;bE2,'B\u0001\u001e<\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000e\u0002\u0004\u001b\u0006\u0004\bC\u0001!H\u001d\t\tU\t\u0005\u0002Cw5\t1I\u0003\u0002EG\u00051AH]8pizJ!AR\u001e\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rn\u0002Ba\u0013,YA6\tAJ\u0003\u0002N\u001d\u0006\u0019Am\u001d7\u000b\u0005=\u0003\u0016AB2mS\u0016tGO\u0003\u0002R%\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005M#\u0016a\u00024bEJL7\r\u000f\u0006\u0002+\u0006\u0011\u0011n\\\u0005\u0003/2\u00131\u0002U8e%\u0016\u001cx.\u001e:dKB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0006[>$W\r\u001c\u0006\u0003;B\u000b1!\u00199j\u0013\ty&LA\u0002Q_\u0012\u0004\"!W1\n\u0005\tT&a\u0003#p]\u0016\f'\r\\3Q_\u0012\fQC\\1nK\u0012,\u00050Z2vi>\u0014\bk\u001c3t?\u0012*\u0017\u000f\u0006\u0002fSB\u0011amZ\u0007\u0002w%\u0011\u0001n\u000f\u0002\u0005+:LG\u000fC\u0004k\u0007\u0005\u0005\t\u0019A\u001b\u0002\u0007a$\u0013'\u0001\noC6,G-\u0012=fGV$xN\u001d)pIN\u0004\u0013\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u+\u0005q\u0007CA8q\u001b\u0005q\u0015BA9O\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG/\u0001\u000blk\n,'O\\3uKN\u001cE.[3oi~#S-\u001d\u000b\u0003KRDqA\u001b\u0004\u0002\u0002\u0003\u0007a.A\tlk\n,'O\\3uKN\u001cE.[3oi\u0002B#aB<\u0011\u0005a\\X\"A=\u000b\u0005i\f\u0013aB7pG.LGo\\\u0005\u0003yf\u0014A!T8dW\u0006i\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N,\u0012a \t\u0005\u0003\u0003\t\tC\u0004\u0003\u0002\u0004\u0005ma\u0002BA\u0003\u0003/qA!a\u0002\u0002\u00149!\u0011\u0011BA\t\u001d\u0011\tY!a\u0004\u000f\u0007\t\u000bi!C\u0001#\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0019\u0011QC\u000f\u0002\r\u0011,\u0007\u000f\\8z\u0013\rA\u0012\u0011\u0004\u0006\u0004\u0003+i\u0012\u0002BA\u000f\u0003?\taBR1ce&\u001c\u0007(\u00117jCN,7OC\u0002\u0019\u00033IA!a\t\u0002&\t!\u0001k\u0014#T\u0015\u0011\ti\"a\b\u0002#A|Gm\u00149fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000fF\u0002f\u0003WAqA[\u0005\u0002\u0002\u0003\u0007q0\u0001\bq_\u0012|\u0005/\u001a:bi&|gn\u001d\u0011)\u0005)9\u0018\u0001E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e+\t\t)\u0004E\u00023\u0003oI1!!\u000f\u0018\u0005\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0003Q\u00198\r[3ek2,'OQ1dW\u0016tGm\u0018\u0013fcR\u0019Q-a\u0010\t\u0011)d\u0011\u0011!a\u0001\u0003k\t\u0011c]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3!Q\tiq/\u0001\bt]\u0006\u00048\u000f[8ugN#xN]3\u0016\u0005\u0005%\u0003c\u0001\u001a\u0002L%\u0019\u0011QJ\f\u0003O\u0011+G/\u001a:nS:L7\u000f^5d\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;t'R|'/Z\u0001\u0013g:\f\u0007o\u001d5piN\u001cFo\u001c:f?\u0012*\u0017\u000fF\u0002f\u0003'B\u0001B[\b\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0010g:\f\u0007o\u001d5piN\u001cFo\u001c:fA\u0005)RM^3oi\"\u000bg\u000e\u001a7feVsG-\u001a:UKN$XCAA.!\r\u0011\u0014QL\u0005\u0004\u0003?:\"\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM]\u0001\u001aKZ,g\u000e\u001e%b]\u0012dWM]+oI\u0016\u0014H+Z:u?\u0012*\u0017\u000fF\u0002f\u0003KB\u0001B\u001b\n\u0002\u0002\u0003\u0007\u00111L\u0001\u0017KZ,g\u000e\u001e%b]\u0012dWM]+oI\u0016\u0014H+Z:uA\u0005\tR\r_5u%\u0016\f7o\u001c8NKN\u001c\u0018mZ3\u0015\u000b}\ni'a\u001e\t\u000f\u0005=D\u00031\u0001\u0002r\u0005\u0001b-Y5mK\u0012,\u00050Z2vi>\u0014\u0018\n\u001a\t\u0004M\u0006M\u0014bAA;w\t\u0019\u0011J\u001c;\t\r\u0005eD\u00031\u0001Y\u0003%1\u0017-\u001b7fIB{G-A\boC6,G\rU8eg\u0006s7o^3s)\t\ty\bE\u0003\u0002\u0002\u0006\u001d%*\u0004\u0002\u0002\u0004*\u0019\u0011QQ=\u0002\u0011M$XO\u00192j]\u001eLA!!#\u0002\u0004\n1\u0011I\\:xKJ\u0004")
public class ExecutorPodsLifecycleManagerSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private Map<String, PodResource<Pod, DoneablePod>> namedExecutorPods;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations;
    @Mock
    private KubernetesClusterSchedulerBackend schedulerBackend;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    private ExecutorPodsLifecycleManager eventHandlerUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private Map<String, PodResource<Pod, DoneablePod>> namedExecutorPods() {
        return this.namedExecutorPods;
    }

    private void namedExecutorPods_$eq(Map<String, PodResource<Pod, DoneablePod>> x$1) {
        this.namedExecutorPods = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.podOperations = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackend() {
        return this.schedulerBackend;
    }

    private void schedulerBackend_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackend = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private ExecutorPodsLifecycleManager eventHandlerUnderTest() {
        return this.eventHandlerUnderTest;
    }

    private void eventHandlerUnderTest_$eq(ExecutorPodsLifecycleManager x$1) {
        this.eventHandlerUnderTest = x$1;
    }

    private String exitReasonMessage(int failedExecutorId, Pod failedPod) {
        Option reason = Option$.MODULE$.apply((Object)failedPod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)failedPod.getStatus().getMessage());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n       |The executor with id ").append(failedExecutorId).append(" exited with exit code 1.\n       |The API gave the following brief reason: ").append(reason.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following message: ").append(message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(failedPod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private Answer<PodResource<Pod, DoneablePod>> namedPodsAnswer() {
        return invocation -> {
            String podName = (String)invocation.getArgument(0);
            return (PodResource)this.namedExecutorPods().getOrElseUpdate((Object)podName, (Function0 & Serializable & scala.Serializable)() -> (PodResource)Mockito.mock(PodResource.class));
        };
    }

    public ExecutorPodsLifecycleManagerSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.initMocks((Object)((Object)this));
            Cache removedExecutorsCache = CacheBuilder.newBuilder().build();
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.namedExecutorPods_$eq((Map<String, PodResource<Pod, DoneablePod>>)Map$.MODULE$.empty());
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)Seq$.MODULE$.empty());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName((String)ArgumentMatchers.any(String.class))).thenAnswer(this.namedPodsAnswer());
            this.eventHandlerUnderTest_$eq(new ExecutorPodsLifecycleManager(new SparkConf(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), removedExecutorsCache));
            this.eventHandlerUnderTest().start(this.schedulerBackend());
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("When an executor reaches error states immediately, remove from the scheduler backend.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L);
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            return (Boolean)((Deletable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()))).delete();
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("Don't remove executors twice from Spark but remove from K8s repeatedly.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L);
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend(), (VerificationMode)Mockito.times((int)1))).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            return (Boolean)((Deletable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()), (VerificationMode)Mockito.times((int)2))).delete();
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("When the scheduler backend lists executor ids that aren't present in the cluster, remove those executors from Spark.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1"})));
            String msg = new StringBuilder(192).append("The executor with ID 1 was not found in the cluster but we didn't").append(" get a reason why. Marking the executor as failed. The executor may have been").append(" deleted but the driver missed the deletion event.").toString();
            ExecutorExited expectedLossReason = new ExecutorExited(-1, false, msg);
            this.snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Seq$.MODULE$.empty()));
            this.snapshotsStore().notifySubscribers();
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Keep executor pods in k8s if configured.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L);
            this.eventHandlerUnderTest().conf().set(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            return (Boolean)((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
    }
}

