/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0015+\u0001]BQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013%q\t\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019\t\u0007\u0001)A\u0005'\"9!\r\u0001b\u0001\n\u0013\u0019\u0007BB4\u0001A\u0003%A\rC\u0004i\u0001\t\u0007I\u0011B5\t\rA\u0004\u0001\u0015!\u0003k\u0011\u001d\t\bA1A\u0005\nIDaA\u001e\u0001!\u0002\u0013\u0019\bbB<\u0001\u0005\u0004%IA\u001d\u0005\u0007q\u0002\u0001\u000b\u0011B:\t\u000fe\u0004!\u0019!C\u0005u\"1a\u0010\u0001Q\u0001\nmD!b \u0001A\u0002\u0003\u0007I\u0011BA\u0001\u0011-\ty\u0001\u0001a\u0001\u0002\u0004%I!!\u0005\t\u0017\u0005u\u0001\u00011A\u0001B\u0003&\u00111\u0001\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0003C\u0006\u00020\u0001\u0001\r\u00111A\u0005\n\u0005E\u0002bCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GA1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H!Y\u0011q\u000f\u0001A\u0002\u0003\u0007I\u0011BA=\u0011-\ti\b\u0001a\u0001\u0002\u0003\u0006K!!\u0013\t\u0017\u0005\u0005\u0005\u00011AA\u0002\u0013%\u00111\u0011\u0005\f\u0003\u0017\u0003\u0001\u0019!a\u0001\n\u0013\ti\tC\u0006\u0002\u0012\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0005bCAK\u0001\u0001\u0007\t\u0019!C\u0005\u0003/C1\"a+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.\"Y\u0011\u0011\u0017\u0001A\u0002\u0003\u0005\u000b\u0015BAM\u0011-\t)\f\u0001a\u0001\u0002\u0004%I!a.\t\u0017\u0005}\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0019\u0005\f\u0003\u000b\u0004\u0001\u0019!A!B\u0013\tI\fC\u0006\u0002J\u0002\u0001\r\u00111A\u0005\n\u0005-\u0007bCAj\u0001\u0001\u0007\t\u0019!C\u0005\u0003+D1\"!7\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002N\"Y\u00111\u001c\u0001A\u0002\u0003\u0007I\u0011BAo\u0011-\t)\u000f\u0001a\u0001\u0002\u0004%I!a:\t\u0017\u0005-\b\u00011A\u0001B\u0003&\u0011q\u001c\u0005\b\u0003[\u0004A\u0011BAx\u0005i)\u00050Z2vi>\u0014\bk\u001c3t\u00032dwnY1u_J\u001cV/\u001b;f\u0015\tYC&A\u0002lqMT!!\f\u0018\u0002\u000f\rdWo\u001d;fe*\u0011q\u0006M\u0001\ng\u000eDW\rZ;mKJT!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\b\u0010\t\u0003sij\u0011\u0001M\u0005\u0003wA\u0012Qb\u00159be.4UO\\*vSR,\u0007CA\u001fA\u001b\u0005q$BA 5\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002B}\tq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001E!\t)\u0005!D\u0001+\u00035!'/\u001b<feB{GMT1nKV\t\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006!A.\u00198h\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014&\u0003\rM#(/\u001b8h\u00039!'/\u001b<feB{GMT1nK\u0002\n\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0016\u0003M\u0003\"\u0001V0\u000e\u0003US!AV,\u0002\u000b5|G-\u001a7\u000b\u0005aK\u0016aA1qS*\u0011!lW\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001/^\u0003\u001d1\u0017M\u0019:jGbR\u0011AX\u0001\u0003S>L!\u0001Y+\u0003\u0007A{G-\u0001\u0006ee&4XM\u001d)pI\u0002\nAaY8oMV\tA\r\u0005\u0002:K&\u0011a\r\r\u0002\n'B\f'o[\"p]\u001a\fQaY8oM\u0002\n\u0011\u0003]8e\u00032dwnY1uS>t7+\u001b>f+\u0005Q\u0007CA6o\u001b\u0005a'\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d'aA%oi\u0006\u0011\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3!\u0003I\u0001x\u000eZ!mY>\u001c\u0017\r^5p]\u0012+G.Y=\u0016\u0003M\u0004\"a\u001b;\n\u0005Ud'\u0001\u0002'p]\u001e\f1\u0003]8e\u00032dwnY1uS>tG)\u001a7bs\u0002\n!\u0003]8e\u0007J,\u0017\r^5p]RKW.Z8vi\u0006\u0019\u0002o\u001c3De\u0016\fG/[8o)&lWm\\;uA\u000511/Z2NOJ,\u0012a\u001f\t\u0003sqL!! \u0019\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJ\fqa]3d\u001b\u001e\u0014\b%\u0001\rxC&$hi\u001c:Fq\u0016\u001cW\u000f^8s!>$7o\u00117pG.,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u00031\u0003\u0011)H/\u001b7\n\t\u00055\u0011q\u0001\u0002\f\u001b\u0006tW/\u00197DY>\u001c7.\u0001\u000fxC&$hi\u001c:Fq\u0016\u001cW\u000f^8s!>$7o\u00117pG.|F%Z9\u0015\t\u0005M\u0011\u0011\u0004\t\u0004W\u0006U\u0011bAA\fY\n!QK\\5u\u0011%\tY\"EA\u0001\u0002\u0004\t\u0019!A\u0002yIE\n\u0011d^1ji\u001a{'/\u0012=fGV$xN\u001d)pIN\u001cEn\\2lA\u0005\u00012.\u001e2fe:,G/Z:DY&,g\u000e^\u000b\u0003\u0003G\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003SI\u0016AB2mS\u0016tG/\u0003\u0003\u0002.\u0005\u001d\"\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003QYWOY3s]\u0016$Xm]\"mS\u0016tGo\u0018\u0013fcR!\u00111CA\u001a\u0011%\tY\u0002FA\u0001\u0002\u0004\t\u0019#A\tlk\n,'O\\3uKN\u001cE.[3oi\u0002B3!FA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA i\u00059Qn\\2lSR|\u0017\u0002BA\"\u0003{\u0011A!T8dW\u0006i\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N,\"!!\u0013\u0011\t\u0005-\u0013\u0011\u000f\b\u0005\u0003\u001b\nYG\u0004\u0003\u0002P\u0005\u001dd\u0002BA)\u0003GrA!a\u0015\u0002b9!\u0011QKA0\u001d\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.m\u00051AH]8pizJ\u0011!N\u0005\u0003gQJ!!\r\u001a\n\u0007\u0005\u0015\u0004'\u0001\u0004eKBdw._\u0005\u0004W\u0005%$bAA3a%!\u0011QNA8\u000391\u0015M\u0019:jGb\nE.[1tKNT1aKA5\u0013\u0011\t\u0019(!\u001e\u0003\tA{Ei\u0015\u0006\u0005\u0003[\ny'A\tq_\u0012|\u0005/\u001a:bi&|gn]0%KF$B!a\u0005\u0002|!I\u00111D\f\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u000fa>$w\n]3sCRLwN\\:!Q\rA\u0012\u0011H\u0001\fY\u0006\u0014W\r\\3e!>$7/\u0006\u0002\u0002\u0006B!\u00111JAD\u0013\u0011\tI)!\u001e\u0003\u00191\u000b%)\u0012'F\t~\u0003v\nR*\u0002\u001f1\f'-\u001a7fIB{Gm]0%KF$B!a\u0005\u0002\u0010\"I\u00111\u0004\u000e\u0002\u0002\u0003\u0007\u0011QQ\u0001\rY\u0006\u0014W\r\\3e!>$7\u000f\t\u0015\u00047\u0005e\u0012a\u00053sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001cXCAAM!\u001d\tY*!)T\u0003Kk!!!(\u000b\t\u0005}\u0015qE\u0001\u0004INd\u0017\u0002BAR\u0003;\u00131\u0002U8e%\u0016\u001cx.\u001e:dKB\u0019A+a*\n\u0007\u0005%VKA\u0006E_:,\u0017M\u00197f!>$\u0017a\u00063sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001cx\fJ3r)\u0011\t\u0019\"a,\t\u0013\u0005mQ$!AA\u0002\u0005e\u0015\u0001\u00063sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001c\b\u0005K\u0002\u001f\u0003s\tq\"\u001a=fGV$xN\u001d\"vS2$WM]\u000b\u0003\u0003s\u00032!RA^\u0013\r\tiL\u000b\u0002\u001a\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'OQ;jY\u0012,'/A\nfq\u0016\u001cW\u000f^8s\u0005VLG\u000eZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005\r\u0007\"CA\u000eA\u0005\u0005\t\u0019AA]\u0003A)\u00070Z2vi>\u0014()^5mI\u0016\u0014\b\u0005K\u0002\"\u0003s\tab\u001d8baNDw\u000e^:Ti>\u0014X-\u0006\u0002\u0002NB\u0019Q)a4\n\u0007\u0005E'FA\u0014EKR,'/\\5oSN$\u0018nY#yK\u000e,Ho\u001c:Q_\u0012\u001c8K\\1qg\"|Go]*u_J,\u0017AE:oCB\u001c\bn\u001c;t'R|'/Z0%KF$B!a\u0005\u0002X\"I\u00111D\u0012\u0002\u0002\u0003\u0007\u0011QZ\u0001\u0010g:\f\u0007o\u001d5piN\u001cFo\u001c:fA\u00051\u0002o\u001c3t\u00032dwnY1u_J,f\u000eZ3s)\u0016\u001cH/\u0006\u0002\u0002`B\u0019Q)!9\n\u0007\u0005\r(FA\u000bFq\u0016\u001cW\u000f^8s!>$7/\u00117m_\u000e\fGo\u001c:\u00025A|Gm]!mY>\u001c\u0017\r^8s+:$WM\u001d+fgR|F%Z9\u0015\t\u0005M\u0011\u0011\u001e\u0005\n\u000371\u0013\u0011!a\u0001\u0003?\fq\u0003]8eg\u0006cGn\\2bi>\u0014XK\u001c3feR+7\u000f\u001e\u0011\u0002#\u0015DXmY;u_J\u0004v\u000eZ!og^,'\u000f\u0006\u0002\u0002rB1\u00111_A}\u0003{l!!!>\u000b\t\u0005]\u0018QH\u0001\tgR,(MY5oO&!\u00111`A{\u0005\u0019\ten]<feB!\u0011q B\u0001\u001b\t\ty'\u0003\u0003\u0003\u0004\u0005=$\u0001C*qCJ\\\u0007k\u001c3")
public class ExecutorPodsAllocatorSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String driverPodName;
    private final Pod driverPod;
    private final SparkConf conf;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long podCreationTimeout;
    private final SecurityManager secMgr;
    private ManualClock waitForExecutorPodsClock;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> labeledPods;
    @Mock
    private PodResource<Pod, DoneablePod> driverPodOperations;
    @Mock
    private KubernetesExecutorBuilder executorBuilder;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    private ExecutorPodsAllocator podsAllocatorUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private Pod driverPod() {
        return this.driverPod;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private SecurityManager secMgr() {
        return this.secMgr;
    }

    private ManualClock waitForExecutorPodsClock() {
        return this.waitForExecutorPodsClock;
    }

    private void waitForExecutorPodsClock_$eq(ManualClock x$1) {
        this.waitForExecutorPodsClock = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.podOperations = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> labeledPods() {
        return this.labeledPods;
    }

    private void labeledPods_$eq(FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> x$1) {
        this.labeledPods = x$1;
    }

    private PodResource<Pod, DoneablePod> driverPodOperations() {
        return this.driverPodOperations;
    }

    private void driverPodOperations_$eq(PodResource<Pod, DoneablePod> x$1) {
        this.driverPodOperations = x$1;
    }

    private KubernetesExecutorBuilder executorBuilder() {
        return this.executorBuilder;
    }

    private void executorBuilder_$eq(KubernetesExecutorBuilder x$1) {
        this.executorBuilder = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private ExecutorPodsAllocator podsAllocatorUnderTest() {
        return this.podsAllocatorUnderTest;
    }

    private void podsAllocatorUnderTest_$eq(ExecutorPodsAllocator x$1) {
        this.podsAllocatorUnderTest = x$1;
    }

    private Answer<SparkPod> executorPodAnswer() {
        return invocation -> {
            KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
            return ExecutorLifecycleTestUtils$.MODULE$.executorPodWithId(new StringOps(Predef$.MODULE$.augmentString(k8sConf.executorId())).toInt());
        };
    }

    public static final /* synthetic */ Pod $anonfun$new$3(ExecutorPodsAllocatorSuite $this, int nextId) {
        return (Pod)((Createable)Mockito.verify($this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(nextId));
    }

    public ExecutorPodsAllocatorSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.driverPodName = "driver";
        this.driverPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.driverPodName()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid("driver-pod-uid")).endMetadata()).build();
        this.conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.driverPodName());
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, 60000L);
        this.secMgr = new SecurityManager(this.conf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.initMocks((Object)((Object)this));
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName(this.driverPodName())).thenReturn(this.driverPodOperations());
            Mockito.when((Object)this.driverPodOperations().get()).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()))).thenAnswer(this.executorPodAnswer());
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.waitForExecutorPodsClock_$eq(new ManualClock(0L));
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(this.conf(), this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("Initially request executors in batches. Do not request another batch if the first has not finished.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors(this.podAllocationSize() + 1);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach((Function1 & Serializable & scala.Serializable)nextId -> ExecutorPodsAllocatorSuite.$anonfun$new$3(this, BoxesRunTime.unboxToInt((Object)nextId)));
            return (Pod)((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("Request executors in batches. Allow another batch to be requested if all pending executors start running.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors(this.podAllocationSize() + 1);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)execId -> this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId)));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.podAllocationSize()));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.podAllocationSize()));
            this.snapshotsStore().notifySubscribers();
            return (Pod)((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)(this.podAllocationSize() + 1)))).create(ArgumentMatchers.any(Pod.class));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("When a current batch reaches error states immediately, re-request them on the next batch.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors(this.podAllocationSize());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)execId -> this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId)));
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(this.podAllocationSize());
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            return (Pod)((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("When an executor is requested but the API does not report it in a reasonable time, retry requesting that executor.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"})).thenReturn(this.labeledPods());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors(1);
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L));
            this.waitForExecutorPodsClock().setTime(this.podCreationTimeout() + 1L);
            this.snapshotsStore().notifySubscribers();
            ((Deletable)Mockito.verify(this.labeledPods())).delete();
            return (Pod)((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("SPARK-28487: scale up and down on target executor count changes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors(1);
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)1))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors(4);
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L));
            ((Createable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(3L));
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)4))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors(1);
            this.snapshotsStore().notifySubscribers();
            ((Createable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)4))).create(ArgumentMatchers.any());
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"3", "4"});
            ((Deletable)Mockito.verify(this.podOperations())).delete();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("4"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"4\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(3L));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(4L));
            this.snapshotsStore().removeDeletedExecutors();
            this.snapshotsStore().notifySubscribers();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("4"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"4\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
    }
}

