/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.SparkPod;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class ExecutorLifecycleTestUtils$ {
    public static ExecutorLifecycleTestUtils$ MODULE$;
    private final String TEST_SPARK_APP_ID;

    static {
        new ExecutorLifecycleTestUtils$();
    }

    public String TEST_SPARK_APP_ID() {
        return this.TEST_SPARK_APP_ID;
    }

    public Pod failedExecutorWithoutDeletion(long executorId) {
        return ((PodBuilder)((PodFluent.StatusNested)((PodStatusFluent)((PodStatusFluent.ContainerStatusesNested)((ContainerStatusFluent.StateNested)((ContainerStateFluent.TerminatedNested)((PodStatusFluent)((PodStatusFluent.ContainerStatusesNested)((ContainerStatusFluent.StateNested)((ContainerStateFluent.TerminatedNested)new PodBuilder(this.podWithAttachedContainerForId(executorId)).editOrNewStatus().withPhase("failed").addNewContainerStatus().withName("spark-executor").withImage("k8s-spark").withNewState().withNewTerminated().withMessage("Failed").withExitCode(Predef$.MODULE$.int2Integer(1))).endTerminated()).endState()).endContainerStatus()).addNewContainerStatus().withName("spark-executor-sidecar").withImage("k8s-spark-sidecar").withNewState().withNewTerminated().withMessage("Failed").withExitCode(Predef$.MODULE$.int2Integer(1))).endTerminated()).endState()).endContainerStatus()).withMessage("Executor failed.").withReason("Executor failed because of a thrown error.")).endStatus()).build();
    }

    public Pod pendingExecutor(long executorId) {
        return ((PodBuilder)((PodFluent.StatusNested)new PodBuilder(this.podWithAttachedContainerForId(executorId)).editOrNewStatus().withPhase("pending")).endStatus()).build();
    }

    public Pod runningExecutor(long executorId) {
        return ((PodBuilder)((PodFluent.StatusNested)new PodBuilder(this.podWithAttachedContainerForId(executorId)).editOrNewStatus().withPhase("running")).endStatus()).build();
    }

    public Pod succeededExecutor(long executorId) {
        return ((PodBuilder)((PodFluent.StatusNested)new PodBuilder(this.podWithAttachedContainerForId(executorId)).editOrNewStatus().withPhase("succeeded")).endStatus()).build();
    }

    public Pod deletedExecutor(long executorId) {
        return ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(this.podWithAttachedContainerForId(executorId)).editOrNewMetadata().withDeletionTimestamp("523012521")).endMetadata()).build();
    }

    public Pod unknownExecutor(long executorId) {
        return ((PodBuilder)((PodFluent.StatusNested)new PodBuilder(this.podWithAttachedContainerForId(executorId)).editOrNewStatus().withPhase("unknown")).endStatus()).build();
    }

    public Pod podWithAttachedContainerForId(long executorId) {
        SparkPod sparkPod = this.executorPodWithId(executorId);
        Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(sparkPod.pod()).editOrNewSpec().addToContainers(new Container[]{sparkPod.container()})).endSpec()).build();
        return podWithAttachedContainer;
    }

    public SparkPod executorPodWithId(long executorId) {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(new StringBuilder(15).append("spark-executor-").append(executorId).toString()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()).addToLabels(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), ((Object)BoxesRunTime.boxToLong((long)executorId)).toString())).endMetadata()).build();
        Container container = ((ContainerBuilder)((ContainerFluentImpl)new ContainerBuilder().withName("spark-executor")).withImage("k8s-spark")).build();
        return new SparkPod(pod, container);
    }

    private ExecutorLifecycleTestUtils$() {
        MODULE$ = this;
        this.TEST_SPARK_APP_ID = "spark-app-id";
    }
}

