/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.submit.Client;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Stubber;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatestplus.mockito.MockitoSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001\u0002\u001f>\u0001)CQ!\u0016\u0001\u0005\u0002YCQ!\u0017\u0001\u0005\niCqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004v\u0001\u0001\u0006I!\u001c\u0005\bm\u0002\u0011\r\u0011\"\u0003m\u0011\u00199\b\u0001)A\u0005[\"9\u0001\u0010\u0001b\u0001\n\u0013a\u0007BB=\u0001A\u0003%Q\u000eC\u0004{\u0001\t\u0007I\u0011\u00027\t\rm\u0004\u0001\u0015!\u0003n\u0011\u001da\bA1A\u0005\n1Da! \u0001!\u0002\u0013i\u0007b\u0002@\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007\u007f\u0002\u0001\u000b\u0011B7\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0002\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u001c\u0001\u0001\u0006I!a\u0007\t\u0013\u0005e\u0002A1A\u0005\n\u0005m\u0002\u0002CA\"\u0001\u0001\u0006I!!\u0010\t\u0013\u0005\u0015\u0003A1A\u0005\n\u0005\u001d\u0003\u0002CA,\u0001\u0001\u0006I!!\u0013\t\u0013\u0005e\u0003A1A\u0005\n\u0005m\u0003\u0002CA3\u0001\u0001\u0006I!!\u0018\t\u0013\u0005\u001d\u0004A1A\u0005\n\u0005m\u0002\u0002CA5\u0001\u0001\u0006I!!\u0010\t\u0013\u0005-\u0004A1A\u0005\n\u0005e\u0001\u0002CA7\u0001\u0001\u0006I!a\u0007\t\u0013\u0005=\u0004A1A\u0005\n\u0005e\u0001\u0002CA9\u0001\u0001\u0006I!a\u0007\t\u0013\u0005M\u0004A1A\u0005\n\u0005\u001d\u0003\u0002CA;\u0001\u0001\u0006I!!\u0013\t\u0017\u0005]\u0004\u00011AA\u0002\u0013%\u0011\u0011\u0010\u0005\f\u0003\u000f\u0003\u0001\u0019!a\u0001\n\u0013\tI\tC\u0006\u0002\u0016\u0002\u0001\r\u0011!Q!\n\u0005m\u0004bCAQ\u0001\u0001\u0007\t\u0019!C\u0005\u0003GC1\"!4\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002P\"Y\u00111\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BAS\u0011-\t9\u000e\u0001a\u0001\u0002\u0004%I!!7\t\u0017\u00055\b\u00011AA\u0002\u0013%\u0011q\u001e\u0005\f\u0003g\u0004\u0001\u0019!A!B\u0013\tY\u000eC\u0006\u0002x\u0002\u0001\r\u00111A\u0005\n\u0005e\bb\u0003B\u0001\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u0007A1Ba\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002|\"Y!1\u0002\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0007\u0011-\u0011)\u0002\u0001a\u0001\u0002\u0004%IAa\u0006\t\u0017\tm\u0001\u00011A\u0001B\u0003&!q\u0002\u0005\f\u0005?\u0001\u0001\u0019!a\u0001\n\u0013\u0011\t\u0003C\u0006\u0003*\u0001\u0001\r\u00111A\u0005\n\t-\u0002b\u0003B\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u0005GA1Ba\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00036!Y!Q\b\u0001A\u0002\u0003\u0007I\u0011\u0002B \u0011-\u0011\u0019\u0005\u0001a\u0001\u0002\u0003\u0006KAa\u000e\t\u0017\t\u0015\u0003\u00011AA\u0002\u0013%!q\t\u0005\f\u0005\u001f\u0002\u0001\u0019!a\u0001\n\u0013\u0011\t\u0006C\u0006\u0003V\u0001\u0001\r\u0011!Q!\n\t%\u0003b\u0003B,\u0001\u0001\u0007\t\u0019!C\u0005\u00053B1Ba\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003f!Y!\u0011\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B.\u0005-\u0019E.[3oiN+\u0018\u000e^3\u000b\u0005yz\u0014AB:vE6LGO\u0003\u0002A\u0003\u0006\u00191\u000eO:\u000b\u0005\t\u001b\u0015A\u00023fa2|\u0017P\u0003\u0002E\u000b\u0006)1\u000f]1sW*\u0011aiR\u0001\u0007CB\f7\r[3\u000b\u0003!\u000b1a\u001c:h\u0007\u0001\u00192\u0001A&P!\taU*D\u0001D\u0013\tq5IA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u001e\u000b\u0011b]2bY\u0006$Xm\u001d;\n\u0005Q\u000b&A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0003\"\u0001\u0017\u0001\u000e\u0003u\n\u0001\u0002Z8SKR,(O\u001c\u000b\u00037\u000e\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\u0011M$XO\u00192j]\u001eT!\u0001Y$\u0002\u000f5|7m[5u_&\u0011!-\u0018\u0002\b'R,(MY3s\u0011\u0015!'\u00011\u0001f\u0003\u00151\u0018\r\\;f!\t1\u0017.D\u0001h\u0015\u0005A\u0017!B:dC2\f\u0017B\u00016h\u0005\r\te._\u0001\u000f\tJKe+\u0012*`!>#u,V%E+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\u0011a\u0017M\\4\u000b\u0003I\fAA[1wC&\u0011Ao\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002\u001f\u0011\u0013\u0016JV#S?B{EiX+J\t\u0002\na\u0003\u0012*J-\u0016\u0013v\fU(E?\u0006\u0003\u0016j\u0018,F%NKuJT\u0001\u0018\tJKe+\u0012*`!>#u,\u0011)J?Z+%kU%P\u001d\u0002\nq\u0002\u0012*J-\u0016\u0013v\fU(E?.Ke\nR\u0001\u0011\tJKe+\u0012*`!>#ulS%O\t\u0002\n!dS+C\u000bJsU\tV#T?J+5kT+S\u0007\u0016{\u0006KU#G\u0013b\u000b1dS+C\u000bJsU\tV#T?J+5kT+S\u0007\u0016{\u0006KU#G\u0013b\u0003\u0013\u0001\u0003)P\t~s\u0015)T#\u0002\u0013A{Ei\u0018(B\u001b\u0016\u0003\u0013AD\"P\u001dR\u000b\u0015JT#S?:\u000bU*R\u0001\u0010\u0007>sE+Q%O\u000bJ{f*Q'FA\u0005)\"+R*P\u0019Z+Ei\u0018&B-\u0006{v\n\u0015+J\u001f:\u001bVCAA\u0003!\u0019\t9!!\u0005n[6\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0005j[6,H/\u00192mK*\u0019\u0011qB4\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0014\u0005%!aA'ba\u00061\"+R*P\u0019Z+Ei\u0018&B-\u0006{v\n\u0015+J\u001f:\u001b\u0006%\u0001\tC+&cEk\u0018#S\u0013Z+%k\u0018)P\tV\u0011\u00111\u0004\t\u0005\u0003;\t\u0019$\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0015iw\u000eZ3m\u0015\u0011\t)#a\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002*\u0005-\u0012AC6vE\u0016\u0014h.\u001a;fg*!\u0011QFA\u0018\u0003\u001d1\u0017M\u0019:jGbR!!!\r\u0002\u0005%|\u0017\u0002BA\u001b\u0003?\u00111\u0001U8e\u0003E\u0011U+\u0013'U?\u0012\u0013\u0016JV#S?B{E\tI\u0001\u0017\u0005VKE\nV0E%&3VIU0D\u001f:#\u0016)\u0013(F%V\u0011\u0011Q\b\t\u0005\u0003;\ty$\u0003\u0003\u0002B\u0005}!!C\"p]R\f\u0017N\\3s\u0003]\u0011U+\u0013'U?\u0012\u0013\u0016JV#S?\u000e{e\nV!J\u001d\u0016\u0013\u0006%\u0001\u000bB\t\u0012KE+S(O\u00032{&+R*P+J\u001bUiU\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002N\u0005ESBAA\u0007\u0013\u0011\ty%!\u0004\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u001e\u0005M\u0013\u0002BA+\u0003?\u0011aaU3de\u0016$\u0018!F!E\t&#\u0016j\u0014(B\u0019~\u0013ViU(V%\u000e+5\u000bI\u0001\u0016\u0005VKE\nV0L+\n+%KT#U\u000bN{6\u000bU#D+\t\ti\u0006\u0005\u0003\u0002`\u0005\u0005T\"A \n\u0007\u0005\rtH\u0001\u000bLk\n,'O\\3uKN$%/\u001b<feN\u0003XmY\u0001\u0017\u0005VKE\nV0L+\n+%KT#U\u000bN{6\u000bU#DA\u00059b)\u0016'M?\u0016C\u0006+R\"U\u000b\u0012{6i\u0014(U\u0003&sUIU\u0001\u0019\rVcEjX#Y!\u0016\u001bE+\u0012#`\u0007>sE+Q%O\u000bJ\u0003\u0013!\u0005$V\u00192{V\t\u0017)F\u0007R+Ei\u0018)P\t\u0006\u0011b)\u0016'M?\u0016C\u0006+R\"U\u000b\u0012{\u0006k\u0014#!\u0003a\u0001v\nR0X\u0013RCulT,O\u000bJ{&+\u0012$F%\u0016s5)R\u0001\u001a!>#ulV%U\u0011~{uKT#S?J+e)\u0012*F\u001d\u000e+\u0005%\u0001\u0016B\t\u0012KE+S(O\u00032{&+R*P+J\u001bUiU0X\u0013RCulT,O\u000bJ{&+\u0012$F%\u0016s5)R*\u0002W\u0005#E)\u0013+J\u001f:\u000bEj\u0018*F'>+&kQ#T?^KE\u000bS0P/:+%k\u0018*F\r\u0016\u0013VIT\"F'\u0002\n\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u0007k!!a \u000b\t\u0005\u0005\u0015qE\u0001\u0007G2LWM\u001c;\n\t\u0005\u0015\u0015q\u0010\u0002\u0011\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\fAc[;cKJtW\r^3t\u00072LWM\u001c;`I\u0015\fH\u0003BAF\u0003#\u00032AZAG\u0013\r\tyi\u001a\u0002\u0005+:LG\u000fC\u0005\u0002\u0014\n\n\t\u00111\u0001\u0002|\u0005\u0019\u0001\u0010J\u0019\u0002#-,(-\u001a:oKR,7o\u00117jK:$\b\u0005K\u0002$\u00033\u0003B!a'\u0002\u001e6\tq,C\u0002\u0002 ~\u0013A!T8dW\u0006i\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N,\"!!*\u0011\t\u0005\u001d\u0016q\u0019\b\u0005\u0003S\u000b\u0019M\u0004\u0003\u0002,\u0006\u0005g\u0002BAW\u0003\u007fsA!a,\u0002>:!\u0011\u0011WA^\u001d\u0011\t\u0019,!/\u000e\u0005\u0005U&bAA\\\u0013\u00061AH]8pizJ\u0011\u0001S\u0005\u0003\r\u001eK!\u0001R#\n\u0005\t\u001b\u0015B\u0001!B\u0013\r\t)mP\u0001\u000f\r\u0006\u0014'/[29\u00032L\u0017m]3t\u0013\u0011\tI-a3\u0003\tA{Ei\u0015\u0006\u0004\u0003\u000b|\u0014!\u00059pI>\u0003XM]1uS>t7o\u0018\u0013fcR!\u00111RAi\u0011%\t\u0019*JA\u0001\u0002\u0004\t)+\u0001\bq_\u0012|\u0005/\u001a:bi&|gn\u001d\u0011)\u0007\u0019\nI*A\u0005oC6,G\rU8egV\u0011\u00111\u001c\t\t\u0003;\f\u0019/a\u0007\u0002h6\u0011\u0011q\u001c\u0006\u0005\u0003C\fy(A\u0002eg2LA!!:\u0002`\nY\u0001k\u001c3SKN|WO]2f!\u0011\ti\"!;\n\t\u0005-\u0018q\u0004\u0002\f\t>tW-\u00192mKB{G-A\u0007oC6,G\rU8eg~#S-\u001d\u000b\u0005\u0003\u0017\u000b\t\u0010C\u0005\u0002\u0014\"\n\t\u00111\u0001\u0002\\\u0006Qa.Y7fIB{Gm\u001d\u0011)\u0007%\nI*A\fm_\u001e<\u0017N\\4Q_\u0012\u001cF/\u0019;vg^\u000bGo\u00195feV\u0011\u00111 \t\u00041\u0006u\u0018bAA\u0000{\t9Bj\\4hS:<\u0007k\u001c3Ti\u0006$Xo],bi\u000eDWM]\u0001\u001cY><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJ|F%Z9\u0015\t\u0005-%Q\u0001\u0005\n\u0003'[\u0013\u0011!a\u0001\u0003w\f\u0001\u0004\\8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:!Q\ra\u0013\u0011T\u0001\u000eIJLg/\u001a:Ck&dG-\u001a:\u0016\u0005\t=\u0001c\u0001-\u0003\u0012%\u0019!1C\u001f\u0003/-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u0014()^5mI\u0016\u0014\u0018!\u00053sSZ,'OQ;jY\u0012,'o\u0018\u0013fcR!\u00111\u0012B\r\u0011%\t\u0019JLA\u0001\u0002\u0004\u0011y!\u0001\bee&4XM\u001d\"vS2$WM\u001d\u0011)\u0007=\nI*\u0001\u0007sKN|WO]2f\u0019&\u001cH/\u0006\u0002\u0003$A!\u0011q\u0015B\u0013\u0013\u0011\u00119#a3\u0003\u001bI+5kT+S\u0007\u0016{F*S*U\u0003A\u0011Xm]8ve\u000e,G*[:u?\u0012*\u0017\u000f\u0006\u0003\u0002\f\n5\u0002\"CAJc\u0005\u0005\t\u0019\u0001B\u0012\u00035\u0011Xm]8ve\u000e,G*[:uA!\u001a!'!'\u0002\u000b-\u001cwN\u001c4\u0016\u0005\t]\u0002\u0003BA0\u0005sI1Aa\u000f@\u0005QYUOY3s]\u0016$Xm\u001d#sSZ,'oQ8oM\u0006I1nY8oM~#S-\u001d\u000b\u0005\u0003\u0017\u0013\t\u0005C\u0005\u0002\u0014R\n\t\u00111\u0001\u00038\u000511nY8oM\u0002\n\u0001d\u0019:fCR,G\rU8e\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s+\t\u0011I\u0005\u0005\u0004\u0002\u001c\n-\u00131D\u0005\u0004\u0005\u001bz&AD!sOVlWM\u001c;DCB$xN]\u0001\u001dGJ,\u0017\r^3e!>$\u0017I]4v[\u0016tGoQ1qi>\u0014x\fJ3r)\u0011\tYIa\u0015\t\u0013\u0005Mu'!AA\u0002\t%\u0013!G2sK\u0006$X\r\u001a)pI\u0006\u0013x-^7f]R\u001c\u0015\r\u001d;pe\u0002\nad\u0019:fCR,GMU3t_V\u00148-Z:Be\u001e,X.\u001a8u\u0007\u0006\u0004Ho\u001c:\u0016\u0005\tm\u0003CBAN\u0005\u0017\u0012i\u0006\u0005\u0003\u0002\u001e\t}\u0013\u0002\u0002B1\u0003?\u00111\u0002S1t\u001b\u0016$\u0018\rZ1uC\u0006\u00113M]3bi\u0016$'+Z:pkJ\u001cWm]!sOVlWM\u001c;DCB$xN]0%KF$B!a#\u0003h!I\u00111\u0013\u001e\u0002\u0002\u0003\u0007!1L\u0001 GJ,\u0017\r^3e%\u0016\u001cx.\u001e:dKN\f%oZ;nK:$8)\u00199u_J\u0004\u0003")
public class ClientSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String DRIVER_POD_UID;
    private final String DRIVER_POD_API_VERSION;
    private final String DRIVER_POD_KIND;
    private final String KUBERNETES_RESOURCE_PREFIX;
    private final String POD_NAME;
    private final String CONTAINER_NAME;
    private final Map<String, String> RESOLVED_JAVA_OPTIONS;
    private final Pod BUILT_DRIVER_POD;
    private final Container BUILT_DRIVER_CONTAINER;
    private final Seq<Secret> ADDITIONAL_RESOURCES;
    private final KubernetesDriverSpec BUILT_KUBERNETES_SPEC;
    private final Container FULL_EXPECTED_CONTAINER;
    private final Pod FULL_EXPECTED_POD;
    private final Pod POD_WITH_OWNER_REFERENCE;
    private final Seq<Secret> ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations;
    @Mock
    private PodResource<Pod, DoneablePod> namedPods;
    @Mock
    private LoggingPodStatusWatcher loggingPodStatusWatcher;
    @Mock
    private KubernetesDriverBuilder driverBuilder;
    @Mock
    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> resourceList;
    private KubernetesDriverConf kconf;
    private ArgumentCaptor<Pod> createdPodArgumentCaptor;
    private ArgumentCaptor<HasMetadata> createdResourcesArgumentCaptor;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private Stubber doReturn(Object value) {
        return Mockito.doReturn((Object)value, (Object[])ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Seq$.MODULE$.empty()).toArray(ClassTag$.MODULE$.Any())));
    }

    private String DRIVER_POD_UID() {
        return this.DRIVER_POD_UID;
    }

    private String DRIVER_POD_API_VERSION() {
        return this.DRIVER_POD_API_VERSION;
    }

    private String DRIVER_POD_KIND() {
        return this.DRIVER_POD_KIND;
    }

    private String KUBERNETES_RESOURCE_PREFIX() {
        return this.KUBERNETES_RESOURCE_PREFIX;
    }

    private String POD_NAME() {
        return this.POD_NAME;
    }

    private String CONTAINER_NAME() {
        return this.CONTAINER_NAME;
    }

    private Map<String, String> RESOLVED_JAVA_OPTIONS() {
        return this.RESOLVED_JAVA_OPTIONS;
    }

    private Pod BUILT_DRIVER_POD() {
        return this.BUILT_DRIVER_POD;
    }

    private Container BUILT_DRIVER_CONTAINER() {
        return this.BUILT_DRIVER_CONTAINER;
    }

    private Seq<Secret> ADDITIONAL_RESOURCES() {
        return this.ADDITIONAL_RESOURCES;
    }

    private KubernetesDriverSpec BUILT_KUBERNETES_SPEC() {
        return this.BUILT_KUBERNETES_SPEC;
    }

    private Container FULL_EXPECTED_CONTAINER() {
        return this.FULL_EXPECTED_CONTAINER;
    }

    private Pod FULL_EXPECTED_POD() {
        return this.FULL_EXPECTED_POD;
    }

    private Pod POD_WITH_OWNER_REFERENCE() {
        return this.POD_WITH_OWNER_REFERENCE;
    }

    private Seq<Secret> ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES() {
        return this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.podOperations = x$1;
    }

    private PodResource<Pod, DoneablePod> namedPods() {
        return this.namedPods;
    }

    private void namedPods_$eq(PodResource<Pod, DoneablePod> x$1) {
        this.namedPods = x$1;
    }

    private LoggingPodStatusWatcher loggingPodStatusWatcher() {
        return this.loggingPodStatusWatcher;
    }

    private void loggingPodStatusWatcher_$eq(LoggingPodStatusWatcher x$1) {
        this.loggingPodStatusWatcher = x$1;
    }

    private KubernetesDriverBuilder driverBuilder() {
        return this.driverBuilder;
    }

    private void driverBuilder_$eq(KubernetesDriverBuilder x$1) {
        this.driverBuilder = x$1;
    }

    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> resourceList() {
        return this.resourceList;
    }

    private void resourceList_$eq(NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> x$1) {
        this.resourceList = x$1;
    }

    private KubernetesDriverConf kconf() {
        return this.kconf;
    }

    private void kconf_$eq(KubernetesDriverConf x$1) {
        this.kconf = x$1;
    }

    private ArgumentCaptor<Pod> createdPodArgumentCaptor() {
        return this.createdPodArgumentCaptor;
    }

    private void createdPodArgumentCaptor_$eq(ArgumentCaptor<Pod> x$1) {
        this.createdPodArgumentCaptor = x$1;
    }

    private ArgumentCaptor<HasMetadata> createdResourcesArgumentCaptor() {
        return this.createdResourcesArgumentCaptor;
    }

    private void createdResourcesArgumentCaptor_$eq(ArgumentCaptor<HasMetadata> x$1) {
        this.createdResourcesArgumentCaptor = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$new$4(Object x$1) {
        return x$1 instanceof Secret;
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Object x$2) {
        return x$2 instanceof ConfigMap;
    }

    public ClientSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.DRIVER_POD_UID = "pod-id";
        this.DRIVER_POD_API_VERSION = "v1";
        this.DRIVER_POD_KIND = "pod";
        this.KUBERNETES_RESOURCE_PREFIX = "resource-example";
        this.POD_NAME = "driver";
        this.CONTAINER_NAME = "container";
        this.RESOLVED_JAVA_OPTIONS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf1key"), (Object)"conf1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf2key"), (Object)"conf2value")}));
        this.BUILT_DRIVER_POD = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.POD_NAME())).endMetadata()).withNewSpec().withHostname("localhost")).endSpec()).build();
        this.BUILT_DRIVER_CONTAINER = ((ContainerBuilder)new ContainerBuilder().withName(this.CONTAINER_NAME())).build();
        this.ADDITIONAL_RESOURCES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Secret[]{((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName("secret")).endMetadata()).build()}));
        this.BUILT_KUBERNETES_SPEC = new KubernetesDriverSpec(new SparkPod(this.BUILT_DRIVER_POD(), this.BUILT_DRIVER_CONTAINER()), this.ADDITIONAL_RESOURCES(), this.RESOLVED_JAVA_OPTIONS());
        this.FULL_EXPECTED_CONTAINER = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(this.BUILT_DRIVER_CONTAINER()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        this.FULL_EXPECTED_POD = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(this.BUILT_DRIVER_POD()).editSpec().addToContainers(new Container[]{this.FULL_EXPECTED_CONTAINER()}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withNewConfigMap().withName(new StringBuilder(16).append(this.KUBERNETES_RESOURCE_PREFIX()).append("-driver-conf-map").toString())).endConfigMap()).endVolume()).endSpec()).build();
        this.POD_WITH_OWNER_REFERENCE = ((PodBuilder)((PodFluentImpl)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(this.FULL_EXPECTED_POD()).editMetadata().withUid(this.DRIVER_POD_UID())).endMetadata()).withApiVersion(this.DRIVER_POD_API_VERSION())).withKind(this.DRIVER_POD_KIND())).build();
        this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES = (Seq)this.ADDITIONAL_RESOURCES().map((Function1 & Serializable & scala.Serializable)secret -> ((SecretBuilder)((SecretFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new SecretBuilder(secret).editMetadata().addNewOwnerReference().withName(this.POD_NAME()).withApiVersion(this.DRIVER_POD_API_VERSION()).withKind(this.DRIVER_POD_KIND()).withController(Predef$.MODULE$.boolean2Boolean(true)).withUid(this.DRIVER_POD_UID())).endOwnerReference()).endMetadata()).build(), Seq$.MODULE$.canBuildFrom());
        this.before((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.initMocks((Object)((Object)this));
            Some x$1 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            SparkConf x$2 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$3 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$4 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            this.kconf_$eq(KubernetesTestConf$.MODULE$.createDriverConf(x$2, x$3, x$4, x$5, x$6, (Option<String>)x$1, x$7, x$8, x$9, x$10, x$11, x$12, x$13));
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(this.kconf(), this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName(this.POD_NAME())).thenReturn(this.namedPods());
            this.createdPodArgumentCaptor_$eq((ArgumentCaptor<Pod>)ArgumentCaptor.forClass(Pod.class));
            this.createdResourcesArgumentCaptor_$eq((ArgumentCaptor<HasMetadata>)ArgumentCaptor.forClass(HasMetadata.class));
            Mockito.when((Object)this.podOperations().create((Object)this.FULL_EXPECTED_POD())).thenReturn((Object)this.POD_WITH_OWNER_REFERENCE());
            Mockito.when((Object)this.namedPods().watch((Object)this.loggingPodStatusWatcher())).thenReturn(MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Watch.class)));
            return ((KubernetesClient)this.doReturn(this.resourceList()).when((Object)this.kubernetesClient())).resourceList(new HasMetadata[]{(HasMetadata)this.createdResourcesArgumentCaptor().capture()});
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("The client should configure the pod using the builder.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            return (Pod)((Createable)Mockito.verify(this.podOperations())).create((Object)this.FULL_EXPECTED_POD());
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("The client should create Kubernetes resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)otherCreatedResources.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            Seq secrets = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$4(x$1))))).toSeq();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(secrets);
            Seq<Secret> $org_scalatest_assert_macro_right2 = this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            ConfigMap[] configMaps = (ConfigMap[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$5(x$2))))).map((Function1 & Serializable & scala.Serializable)x$3 -> (ConfigMap)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConfigMap.class)));
            Seq $org_scalatest_assert_macro_left3 = secrets;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left4).nonEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            ConfigMap configMap = (ConfigMap)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configMaps)).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(configMap.getMetadata().getName());
            String $org_scalatest_assert_macro_right3 = new StringBuilder(16).append(this.KUBERNETES_RESOURCE_PREFIX()).append("-driver-conf-map").toString();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(configMap.getData().containsKey(Constants$.MODULE$.SPARK_CONF_FILE_NAME()), "configMap.getData().containsKey(org.apache.spark.deploy.k8s.Constants.SPARK_CONF_FILE_NAME)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            String $org_scalatest_assert_macro_left6 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right4 = "conf1key=conf1value";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            String $org_scalatest_assert_macro_left7 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right5 = "conf2key=conf2value";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("Waiting for app completion should stall on the watcher", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            ((LoggingPodStatusWatcher)Mockito.verify((Object)this.loggingPodStatusWatcher())).watchOrStop(new StringBuilder(7).append(this.kconf().namespace()).append(":driver").toString());
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
    }
}

