/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\taRj\\;oiZ{G.^7fg\u001a+\u0017\r^;sKN#X\r]*vSR,'B\u0001\u0003\u0006\u0003!1W-\u0019;ve\u0016\u001c(B\u0001\u0004\b\u0003\rY\u0007h\u001d\u0006\u0003\u0011%\ta\u0001Z3qY>L(B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011!C\u0005\u0003)%\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0004\u0001")
public class MountVolumesFeatureStepSuite
extends SparkFunSuite {
    public MountVolumesFeatureStepSuite() {
        this.test("Mounts hostPath volumes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesHostPathVolumeConf("/hostPath/tmp"));
            Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$2 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$3 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$4 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Seq<KubernetesVolumeSpec>)x$1);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getHostPath().getPath());
            String $org_scalatest_assert_macro_right2 = "/hostPath/tmp";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right4 = "/tmp";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right5 = "testVolume";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly());
            boolean $org_scalatest_assert_macro_right6 = false;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("Mounts pesistentVolumeClaims", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvcClaim"));
            Seq x$14 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$15 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$16 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$17 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, (Seq<KubernetesVolumeSpec>)x$14);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            PersistentVolumeClaimVolumeSource pvcClaim = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(pvcClaim.getClaimName());
            String $org_scalatest_assert_macro_right2 = "pvcClaim";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right4 = "/tmp";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right5 = "testVolume";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly()), "scala.Predef.Boolean2boolean(configuredPod.container.getVolumeMounts().get(0).getReadOnly())", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("Mounts emptyDir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)new Some((Object)"Memory"), (Option)new Some((Object)"6G")));
            Seq x$27 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$28 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$29 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$30 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$31 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$32 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$33 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$34 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$35 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$36 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$37 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$38 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$39 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, (Seq<KubernetesVolumeSpec>)x$27);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            EmptyDirVolumeSource emptyDir = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getEmptyDir();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(emptyDir.getMedium());
            String $org_scalatest_assert_macro_right2 = "Memory";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(emptyDir.getSizeLimit().getAmount());
            String $org_scalatest_assert_macro_right3 = "6";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(emptyDir.getSizeLimit().getFormat());
            String $org_scalatest_assert_macro_right4 = "G";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right6 = "/tmp";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right7 = "testVolume";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly());
            boolean $org_scalatest_assert_macro_right8 = false;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("Mounts emptyDir with no options", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$));
            Seq x$40 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$41 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$42 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$43 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$44 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$45 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$46 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$47 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$48 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$49 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$50 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$51 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$52 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, (Seq<KubernetesVolumeSpec>)x$40);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            EmptyDirVolumeSource emptyDir = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getEmptyDir();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(emptyDir.getMedium());
            String $org_scalatest_assert_macro_right2 = "";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(emptyDir.getSizeLimit());
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", null, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getMountPath());
            String $org_scalatest_assert_macro_right5 = "/tmp";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getName());
            String $org_scalatest_assert_macro_right6 = "testVolume";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((VolumeMount)configuredPod.container().getVolumeMounts().get(0)).getReadOnly());
            boolean $org_scalatest_assert_macro_right7 = false;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("Mounts multiple volumes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesVolumeSpec hpVolumeConf = new KubernetesVolumeSpec("hpVolume", "/tmp", "", false, (KubernetesVolumeSpecificConf)new KubernetesHostPathVolumeConf("/hostPath/tmp"));
            KubernetesVolumeSpec pvcVolumeConf = new KubernetesVolumeSpec("checkpointVolume", "/checkpoints", "", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvcClaim"));
            Seq x$53 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{hpVolumeConf, pvcVolumeConf}));
            SparkConf x$54 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$55 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$56 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$57 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$58 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$59 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$60 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$61 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$62 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$63 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$64 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$65 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, (Seq<KubernetesVolumeSpec>)x$53);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("Mounts subpath on emptyDir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "foo", false, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$));
            Seq x$66 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$67 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$68 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$69 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$70 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$71 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$72 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$73 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$74 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$75 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$76 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$77 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$78 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, (Seq<KubernetesVolumeSpec>)x$66);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            VolumeMount emptyDirMount = (VolumeMount)configuredPod.container().getVolumeMounts().get(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(emptyDirMount.getMountPath());
            String $org_scalatest_assert_macro_right2 = "/tmp";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(emptyDirMount.getName());
            String $org_scalatest_assert_macro_right3 = "testVolume";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(emptyDirMount.getSubPath());
            String $org_scalatest_assert_macro_right4 = "foo";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("Mounts subpath on persistentVolumeClaims", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesVolumeSpec volumeConf = new KubernetesVolumeSpec("testVolume", "/tmp", "bar", true, (KubernetesVolumeSpecificConf)new KubernetesPVCVolumeConf("pvcClaim"));
            Seq x$79 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{volumeConf}));
            SparkConf x$80 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$81 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$82 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$83 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$84 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$85 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$86 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$87 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$88 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$89 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$90 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$91 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, (Seq<KubernetesVolumeSpec>)x$79);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            PersistentVolumeClaimVolumeSource pvcClaim = ((Volume)configuredPod.pod().getSpec().getVolumes().get(0)).getPersistentVolumeClaim();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(pvcClaim.getClaimName());
            String $org_scalatest_assert_macro_right2 = "pvcClaim";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.container().getVolumeMounts().size()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            VolumeMount pvcMount = (VolumeMount)configuredPod.container().getVolumeMounts().get(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(pvcMount.getMountPath());
            String $org_scalatest_assert_macro_right4 = "/tmp";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(pvcMount.getName());
            String $org_scalatest_assert_macro_right5 = "testVolume";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(pvcMount.getSubPath());
            String $org_scalatest_assert_macro_right6 = "bar";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("Mounts multiple subpaths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesEmptyDirVolumeConf volumeConf = new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$);
            KubernetesVolumeSpec emptyDirSpec = new KubernetesVolumeSpec("testEmptyDir", "/tmp/foo", "foo", true, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$));
            KubernetesVolumeSpec pvcSpec = new KubernetesVolumeSpec("testPVC", "/tmp/bar", "bar", true, (KubernetesVolumeSpecificConf)new KubernetesEmptyDirVolumeConf((Option)None$.MODULE$, (Option)None$.MODULE$));
            Seq x$92 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesVolumeSpec[]{emptyDirSpec, pvcSpec}));
            SparkConf x$93 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$94 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$95 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$96 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$97 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$98 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$99 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$100 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$101 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$102 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$103 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$104 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$104, (Seq<KubernetesVolumeSpec>)x$92);
            MountVolumesFeatureStep step = new MountVolumesFeatureStep((KubernetesConf)kubernetesConf);
            SparkPod configuredPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configuredPod.pod().getSpec().getVolumes().size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            Buffer mounts = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(configuredPod.container().getVolumeMounts()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), (Ordering)Ordering.String$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mounts.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((VolumeMount)mounts.apply(0)).getName());
            String $org_scalatest_assert_macro_right3 = "testEmptyDir";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((VolumeMount)mounts.apply(0)).getMountPath());
            String $org_scalatest_assert_macro_right4 = "/tmp/foo";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((VolumeMount)mounts.apply(0)).getSubPath());
            String $org_scalatest_assert_macro_right5 = "foo";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((VolumeMount)mounts.apply(1)).getName());
            String $org_scalatest_assert_macro_right6 = "testPVC";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((VolumeMount)mounts.apply(1)).getMountPath());
            String $org_scalatest_assert_macro_right7 = "/tmp/bar";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((VolumeMount)mounts.apply(1)).getSubPath());
            String $org_scalatest_assert_macro_right8 = "bar";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        }, new Position("MountVolumesFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
    }
}

