/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SecretVolumeUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.MountSecretsFeatureStep;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000192A\u0001C\u0005\u0001-!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u0015\u0001A\u0003%\u0011\u0005C\u0004+\u0001\t\u0007I\u0011\u0002\u0011\t\r-\u0002\u0001\u0015!\u0003\"\u0011\u001da\u0003A1A\u0005\n\u0001Ba!\f\u0001!\u0002\u0013\t#\u0001H'pk:$8+Z2sKR\u001ch)Z1ukJ,7\u000b^3q'VLG/\u001a\u0006\u0003\u0015-\t\u0001BZ3biV\u0014Xm\u001d\u0006\u0003\u00195\t1a\u001b\u001dt\u0015\tqq\"\u0001\u0004eKBdw.\u001f\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sO\u000e\u00011C\u0001\u0001\u0018!\tA\u0012$D\u0001\u0010\u0013\tQrBA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003%\t!bU#D%\u0016#vLR(P+\u0005\t\u0003C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017M+5IU#U?\u001a{u\nI\u0001\u000b'\u0016\u001b%+\u0012+`\u0005\u0006\u0013\u0016aC*F\u0007J+Ek\u0018\"B%\u0002\n\u0011cU#D%\u0016#v,T(V\u001dR{\u0006+\u0011+I\u0003I\u0019Vi\u0011*F)~ku*\u0016(U?B\u000bE\u000b\u0013\u0011")
public class MountSecretsFeatureStepSuite
extends SparkFunSuite {
    private final String SECRET_FOO;
    private final String SECRET_BAR;
    private final String SECRET_MOUNT_PATH;

    private String SECRET_FOO() {
        return this.SECRET_FOO;
    }

    private String SECRET_BAR() {
        return this.SECRET_BAR;
    }

    private String SECRET_MOUNT_PATH() {
        return this.SECRET_MOUNT_PATH;
    }

    public MountSecretsFeatureStepSuite() {
        this.SECRET_FOO = "foo";
        this.SECRET_BAR = "bar";
        this.SECRET_MOUNT_PATH = "/etc/secrets/driver";
        this.test("mounts all given secrets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map secretNamesToMountPaths;
            SparkPod baseDriverPod = SparkPod$.MODULE$.initialPod();
            Map x$1 = secretNamesToMountPaths = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SECRET_FOO()), (Object)this.SECRET_MOUNT_PATH()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SECRET_BAR()), (Object)this.SECRET_MOUNT_PATH())}));
            SparkConf x$2 = KubernetesTestConf$.MODULE$.createExecutorConf$default$1();
            Option<Pod> x$3 = KubernetesTestConf$.MODULE$.createExecutorConf$default$2();
            Map<String, String> x$4 = KubernetesTestConf$.MODULE$.createExecutorConf$default$3();
            Map<String, String> x$5 = KubernetesTestConf$.MODULE$.createExecutorConf$default$4();
            Map<String, String> x$6 = KubernetesTestConf$.MODULE$.createExecutorConf$default$5();
            Map<String, String> x$7 = KubernetesTestConf$.MODULE$.createExecutorConf$default$6();
            Seq<KubernetesVolumeSpec> x$8 = KubernetesTestConf$.MODULE$.createExecutorConf$default$8();
            KubernetesExecutorConf kubernetesConf = KubernetesTestConf$.MODULE$.createExecutorConf(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
            MountSecretsFeatureStep step = new MountSecretsFeatureStep((KubernetesConf)kubernetesConf);
            Pod driverPodWithSecretsMounted = step.configurePod(baseDriverPod).pod();
            Container driverContainerWithSecretsMounted = step.configurePod(baseDriverPod).container();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(7).append(this.SECRET_FOO()).append("-volume").toString(), new StringBuilder(7).append(this.SECRET_BAR()).append("-volume").toString()}))).foreach((Function1 & Serializable & scala.Serializable)volumeName -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.podHasVolume(driverPodWithSecretsMounted, (String)volumeName), "org.apache.spark.deploy.k8s.SecretVolumeUtils.podHasVolume(driverPodWithSecretsMounted, volumeName)", Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountSecretsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(7).append(this.SECRET_FOO()).append("-volume").toString(), new StringBuilder(7).append(this.SECRET_BAR()).append("-volume").toString()}))).foreach((Function1 & Serializable & scala.Serializable)volumeName -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(driverContainerWithSecretsMounted, (String)volumeName, this.SECRET_MOUNT_PATH()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(driverContainerWithSecretsMounted, volumeName, MountSecretsFeatureStepSuite.this.SECRET_MOUNT_PATH)", Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MountSecretsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            });
        }, new Position("MountSecretsFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
    }
}

