/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class KubernetesFeaturesTestUtils$ {
    public static KubernetesFeaturesTestUtils$ MODULE$;

    static {
        new KubernetesFeaturesTestUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public <T extends KubernetesFeatureConfigStep> T getMockConfigStepForStepType(String stepType, Class<T> stepClass) {
        void var3_3;
        KubernetesFeatureConfigStep mockStep = (KubernetesFeatureConfigStep)Mockito.mock(stepClass);
        Mockito.when((Object)mockStep.getAdditionalKubernetesResources()).thenReturn(this.getSecretsForStepType(stepType));
        Mockito.when((Object)mockStep.getAdditionalPodSystemProperties()).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)stepType), (Object)stepType)})));
        Mockito.when((Object)mockStep.configurePod((SparkPod)ArgumentMatchers.any(SparkPod.class))).thenAnswer(invocation -> {
            SparkPod originalPod = (SparkPod)invocation.getArgument(0);
            Pod configuredPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(originalPod.pod()).editOrNewMetadata().addToLabels(stepType, stepType)).endMetadata()).build();
            return new SparkPod(configuredPod, originalPod.container());
        });
        return var3_3;
    }

    public <T extends KubernetesFeatureConfigStep> Seq<HasMetadata> getSecretsForStepType(String stepType) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Secret[]{((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(stepType)).endMetadata()).build()}));
    }

    public boolean containerHasEnvVar(Container container, String envVarName) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(container.getEnv()).asScala()).exists((Function1 & Serializable & scala.Serializable)envVar -> BoxesRunTime.boxToBoolean((boolean)KubernetesFeaturesTestUtils$.$anonfun$containerHasEnvVar$1(envVarName, envVar)));
    }

    public <T> Seq<T> filter(Seq<HasMetadata> list, ClassTag<T> evidence$1) {
        Class desired = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        return (Seq)((TraversableLike)list.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesFeaturesTestUtils$.$anonfun$filter$1(desired, x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$containerHasEnvVar$1(String envVarName$1, EnvVar envVar) {
        String string = envVar.getName();
        String string2 = envVarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$filter$1(Class desired$1, HasMetadata x$1) {
        Class<?> clazz = x$1.getClass();
        Class clazz2 = desired$1;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    private KubernetesFeaturesTestUtils$() {
        MODULE$ = this;
    }
}

