/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.net.InternetDomainName;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0003\u0006\u0001/!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003BB\u0018\u0001A\u0003%!\u0005C\u00041\u0001\t\u0007I\u0011B\u0019\t\r\u0005\u0003\u0001\u0015!\u00033\u0011\u001d\u0011\u0005A1A\u0005\nEBaa\u0011\u0001!\u0002\u0013\u0011\u0004\"\u0002#\u0001\t\u0013)%!\b#sSZ,'oU3sm&\u001cWMR3biV\u0014Xm\u0015;faN+\u0018\u000e^3\u000b\u0005-a\u0011\u0001\u00034fCR,(/Z:\u000b\u00055q\u0011aA69g*\u0011q\u0002E\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011DG\u0007\u0002!%\u00111\u0004\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005Q\u0011!\u0007'P\u001d\u001e{&+R*P+J\u001bUi\u0018(B\u001b\u0016{\u0006KU#G\u0013b+\u0012A\t\t\u0003G1r!\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0012A\u0002\u001fs_>$hHC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003&\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016)\u0003iauJT$`%\u0016\u001bv*\u0016*D\u000b~s\u0015)T#`!J+e)\u0013-!\u00035!%+\u0013,F%~c\u0015IQ#M'V\t!\u0007\u0005\u00034qiRT\"\u0001\u001b\u000b\u0005U2\u0014!C5n[V$\u0018M\u00197f\u0015\t9\u0004&\u0001\u0006d_2dWm\u0019;j_:L!!\u000f\u001b\u0003\u00075\u000b\u0007\u000f\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005!A.\u00198h\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\f\u001f\u0002\u001d\u0011\u0013\u0016JV#S?2\u000b%)\u0012'TA\u0005QBIU%W\u000bJ{6+\u0012*W\u0013\u000e+u,\u0011(O\u001fR\u000bE+S(O'\u0006YBIU%W\u000bJ{6+\u0012*W\u0013\u000e+u,\u0011(O\u001fR\u000bE+S(O'\u0002\nQB^3sS\u001aL8+\u001a:wS\u000e,GC\u0002$K\u001fF\u001bV\u000b\u0005\u0002H\u00116\t\u0001&\u0003\u0002JQ\t!QK\\5u\u0011\u0015Y\u0005\u00021\u0001M\u0003)!'/\u001b<feB{'\u000f\u001e\t\u0003\u000f6K!A\u0014\u0015\u0003\u0007%sG\u000fC\u0003Q\u0011\u0001\u0007A*\u0001\tcY>\u001c7.T1oC\u001e,'\u000fU8si\")!\u000b\u0003a\u0001\u0019\u0006YAM]5feVK\u0005k\u001c:u\u0011\u0015!\u0006\u00021\u0001#\u0003M)\u0007\u0010]3di\u0016$7+\u001a:wS\u000e,g*Y7f\u0011\u00151\u0006\u00021\u0001X\u0003\u001d\u0019XM\u001d<jG\u0016\u0004\"\u0001W2\u000e\u0003eS!AW.\u0002\u000b5|G-\u001a7\u000b\u0005qk\u0016aA1qS*\u0011alX\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u00011b\u0003\u001d1\u0017M\u0019:jGbR\u0011AY\u0001\u0003S>L!\u0001Z-\u0003\u000fM+'O^5dK\u0002")
public class DriverServiceFeatureStepSuite
extends SparkFunSuite {
    private final String LONG_RESOURCE_NAME_PREFIX = new StringOps(Predef$.MODULE$.augmentString("a")).$times(DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH() - DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX().length() + 1);
    private final Map<String, String> DRIVER_LABELS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label1key"), (Object)"label1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label2key"), (Object)"label2value")}));
    private final Map<String, String> DRIVER_SERVICE_ANNOTATIONS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"annotation1key"), (Object)"annotation1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"annotation2key"), (Object)"annotation2value")}));

    private String LONG_RESOURCE_NAME_PREFIX() {
        return this.LONG_RESOURCE_NAME_PREFIX;
    }

    private Map<String, String> DRIVER_LABELS() {
        return this.DRIVER_LABELS;
    }

    private Map<String, String> DRIVER_SERVICE_ANNOTATIONS() {
        return this.DRIVER_SERVICE_ANNOTATIONS;
    }

    private void verifyService(int driverPort, int blockManagerPort, int drierUIPort, String expectedServiceName, Service service) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getMetadata().getName());
        String $org_scalatest_assert_macro_right = expectedServiceName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(service.getSpec().getClusterIP());
        String $org_scalatest_assert_macro_right2 = "None";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.DRIVER_LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getSpec().getSelector().get(k));
            String $org_scalatest_assert_macro_right = v;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            return assertion;
        });
        this.DRIVER_SERVICE_ANNOTATIONS().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getMetadata().getAnnotations().get(k));
            String $org_scalatest_assert_macro_right = v;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            return assertion;
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)service.getSpec().getPorts().size()));
        int $org_scalatest_assert_macro_right3 = 3;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        Buffer driverServicePorts = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(service.getSpec().getPorts()).asScala();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((ServicePort)driverServicePorts.head()).getName());
        String $org_scalatest_assert_macro_right4 = Constants$.MODULE$.DRIVER_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.head()).getPort()));
        int $org_scalatest_assert_macro_right5 = driverPort;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((ServicePort)driverServicePorts.head()).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right6 = driverPort;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(1)).getName());
        String $org_scalatest_assert_macro_right7 = Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.apply(1)).getPort()));
        int $org_scalatest_assert_macro_right8 = blockManagerPort;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(1)).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right9 = blockManagerPort;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(2)).getName());
        String $org_scalatest_assert_macro_right10 = Constants$.MODULE$.UI_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.apply(2)).getPort()));
        int $org_scalatest_assert_macro_right11 = drierUIPort;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(2)).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right12 = drierUIPort;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$5(KubernetesDriverConf kconf$1, ManualClock clock$1, int x$1) {
        DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf$1, (Clock)clock$1);
        String serviceName = ((Service)configurationStep.getAdditionalKubernetesResources().head()).getMetadata().getName();
        String hostAddress = (String)configurationStep.getAdditionalPodSystemProperties().apply((Object)package$.MODULE$.DRIVER_HOST_ADDRESS().key());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)serviceName), (Object)hostAddress);
    }

    public DriverServiceFeatureStepSuite() {
        this.test("Headless service has a port for the driver RPC, the block manager and driver ui.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$1 = sparkConf = new SparkConf(false).set(package$.MODULE$.DRIVER_PORT(), (Object)BoxesRunTime.boxToInteger((int)9000)).set(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)8080)).set(UI$.MODULE$.UI_PORT(), (Object)BoxesRunTime.boxToInteger((int)4080));
            Map<String, String> x$2 = this.DRIVER_LABELS();
            Map<String, String> x$3 = this.DRIVER_SERVICE_ANNOTATIONS();
            String x$4 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$1, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10, x$3, x$11, x$12, x$13);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(configurationStep.configurePod(SparkPod$.MODULE$.initialPod()));
            SparkPod $org_scalatest_assert_macro_right = SparkPod$.MODULE$.initialPod();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)configurationStep.getAdditionalKubernetesResources().size()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            HasMetadata $org_scalatest_assert_macro_left3 = (HasMetadata)configurationStep.getAdditionalKubernetesResources().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "io.fabric8.kubernetes.api.model.Service", $org_scalatest_assert_macro_left3 instanceof Service, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Service driverService = (Service)configurationStep.getAdditionalKubernetesResources().head();
            this.verifyService(9000, 8080, 4080, new StringBuilder(0).append(kconf.resourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString(), driverService);
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("Hostname and ports are set according to the service name.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$14 = sparkConf = new SparkConf(false).set(package$.MODULE$.DRIVER_PORT(), (Object)BoxesRunTime.boxToInteger((int)9000)).set(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)8080)).set(Config$.MODULE$.KUBERNETES_NAMESPACE(), (Object)"my-namespace");
            Map<String, String> x$15 = this.DRIVER_LABELS();
            String x$16 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$17 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$14, x$16, x$17, x$18, x$19, x$20, x$15, x$21, x$22, x$23, x$24, x$25, x$26);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            String expectedServiceName = new StringBuilder(0).append(kconf.resourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
            String expectedHostName = new StringBuilder(17).append(expectedServiceName).append(".my-namespace.svc").toString();
            Map additionalProps = configurationStep.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(additionalProps.apply((Object)package$.MODULE$.DRIVER_HOST_ADDRESS().key()));
            String $org_scalatest_assert_macro_right = expectedHostName;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("Ports should resolve to defaults in SparkConf and in the service.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Map<String, String> x$27 = this.DRIVER_LABELS();
            Map<String, String> x$28 = this.DRIVER_SERVICE_ANNOTATIONS();
            SparkConf x$29 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$30 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$31 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$32 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$33 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Option<String> x$34 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
            Map<String, String> x$35 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$36 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$37 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$38 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$39 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$29, x$30, x$31, x$32, x$33, x$34, x$27, x$35, x$36, x$28, x$37, x$38, x$39);
            DriverServiceFeatureStep configurationStep = new DriverServiceFeatureStep(kconf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2());
            Service resolvedService = (Service)configurationStep.getAdditionalKubernetesResources().head();
            this.verifyService(Constants$.MODULE$.DEFAULT_DRIVER_PORT(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT(), BoxesRunTime.unboxToInt((Object)UI$.MODULE$.UI_PORT().defaultValue().get()), new StringBuilder(0).append(kconf.resourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString(), resolvedService);
            Map additionalProps = configurationStep.getAdditionalPodSystemProperties();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(additionalProps.apply((Object)package$.MODULE$.DRIVER_PORT().key()));
            String $org_scalatest_assert_macro_right = ((Object)BoxesRunTime.boxToInteger((int)Constants$.MODULE$.DEFAULT_DRIVER_PORT())).toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(additionalProps.apply((Object)package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key()));
            String $org_scalatest_assert_macro_right2 = ((Object)BoxesRunTime.boxToInteger((int)Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT())).toString();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("Long prefixes should switch to using a generated unique name.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$40 = sparkConf = new SparkConf(false).set(Config$.MODULE$.KUBERNETES_NAMESPACE(), (Object)"my-namespace");
            Some x$41 = new Some((Object)this.LONG_RESOURCE_NAME_PREFIX());
            Map<String, String> x$42 = this.DRIVER_LABELS();
            String x$43 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$44 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$45 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$46 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$47 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$48 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$49 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$50 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$51 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$52 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            KubernetesDriverConf kconf = KubernetesTestConf$.MODULE$.createDriverConf(x$40, x$43, x$44, x$45, x$46, (Option<String>)x$41, x$42, x$47, x$48, x$49, x$50, x$51, x$52);
            ManualClock clock = new ManualClock();
            Map services = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$1 -> DriverServiceFeatureStepSuite.$anonfun$new$5(kconf, clock, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)services.size()));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            services.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                String address = (String)tuple2._2();
                String $org_scalatest_assert_macro_left = name;
                String $org_scalatest_assert_macro_right = kconf.resourceNamePrefix();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
                String $org_scalatest_assert_macro_left2 = address;
                String $org_scalatest_assert_macro_right2 = kconf.resourceNamePrefix();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "startsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.startsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(InternetDomainName.isValid((String)address), "com.google.common.net.InternetDomainName.isValid(address)", Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                return assertion;
            });
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("Disallow bind address and driver host to be set explicitly.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false).set(package$.MODULE$.DRIVER_BIND_ADDRESS(), (Object)"host").set("spark.app.name", this.LONG_RESOURCE_NAME_PREFIX());
            IllegalArgumentException e1 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new DriverServiceFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13()), DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e1.getMessage());
            String $org_scalatest_assert_macro_right = new StringBuilder(137).append("requirement failed: ").append(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).append(" is").append(" not supported in Kubernetes mode, as the driver's bind address is managed").append(" and set to the driver pod's IP address.").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            sparkConf.remove(package$.MODULE$.DRIVER_BIND_ADDRESS());
            sparkConf.set(package$.MODULE$.DRIVER_HOST_ADDRESS(), (Object)"host");
            IllegalArgumentException e2 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new DriverServiceFeatureStep(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13()), DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(e2.getMessage());
            String $org_scalatest_assert_macro_right2 = new StringBuilder(124).append("requirement failed: ").append(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).append(" is").append(" not supported in Kubernetes mode, as the driver's hostname will be managed via").append(" a Kubernetes service.").toString();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("DriverServiceFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
    }
}

