/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.DriverCommandFeatureStep;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.deploy.k8s.submit.PythonMainAppResource;
import org.apache.spark.deploy.k8s.submit.RMainAppResource;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0005;!9!\tAI\u0001\n\u0013\u0019\u0005b\u0002(\u0001#\u0003%Ia\u0014\u0002\u001e\tJLg/\u001a:D_6l\u0017M\u001c3GK\u0006$XO]3Ti\u0016\u00048+^5uK*\u0011q\u0001C\u0001\tM\u0016\fG/\u001e:fg*\u0011\u0011BC\u0001\u0004Wb\u001a(BA\u0006\r\u0003\u0019!W\r\u001d7ps*\u0011QBD\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005a\u0011BA\f\r\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011AB\u0001\u0011CB\u0004H.\u001f$fCR,(/Z*uKB$BA\b\u0012+_A\u0011q\u0004I\u0007\u0002\u0011%\u0011\u0011\u0005\u0003\u0002\u0015\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u001c\u0006/Z2\t\u000b\r\u0012\u0001\u0019\u0001\u0013\u0002\u0011I,7o\\;sG\u0016\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0005\u0002\rM,(-\\5u\u0013\tIcEA\bNC&t\u0017\t\u001d9SKN|WO]2f\u0011\u001dY#\u0001%AA\u00021\nAaY8oMB\u0011Q#L\u0005\u0003]1\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000fA\u0012\u0001\u0013!a\u0001c\u00059\u0011\r\u001d9Be\u001e\u001c\bc\u0001\u001a6o5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0003BeJ\f\u0017\u0010\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003uMj\u0011a\u000f\u0006\u0003yI\ta\u0001\u0010:p_Rt\u0014B\u0001 4\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u001a\u0014AG1qa2Lh)Z1ukJ,7\u000b^3qI\u0011,g-Y;mi\u0012\u0012T#\u0001#+\u00051*5&\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015!C;oG\",7m[3e\u0015\tY5'\u0001\u0006b]:|G/\u0019;j_:L!!\u0014%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ebaBd\u0017PR3biV\u0014Xm\u0015;fa\u0012\"WMZ1vYR$3'F\u0001QU\t\tT\t")
public class DriverCommandFeatureStepSuite
extends SparkFunSuite {
    private KubernetesDriverSpec applyFeatureStep(MainAppResource resource, SparkConf conf, String[] appArgs) {
        SparkConf x$1 = conf;
        MainAppResource x$2 = resource;
        String[] x$3 = appArgs;
        String x$4 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
        String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
        Option<String> x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
        Map<String, String> x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
        Map<String, String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
        Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
        Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
        Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
        Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
        Seq<KubernetesVolumeSpec> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
        KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$1, x$4, x$2, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        DriverCommandFeatureStep step = new DriverCommandFeatureStep(kubernetesConf);
        SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
        Map props = step.getAdditionalPodSystemProperties();
        return new KubernetesDriverSpec(pod, (Seq)Nil$.MODULE$, props);
    }

    private SparkConf applyFeatureStep$default$2() {
        return new SparkConf(false);
    }

    private String[] applyFeatureStep$default$3() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public DriverCommandFeatureStepSuite() {
        this.test("java resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.jar";
            JavaMainAppResource x$1 = new JavaMainAppResource((Option)new Some((Object)mainResource));
            String[] x$2 = (String[])((Object[])new String[]{"5", "7"});
            SparkConf x$3 = this.applyFeatureStep$default$2();
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)x$1, x$3, x$2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("python resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.py";
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.PYSPARK_MAJOR_PYTHON_VERSION(), (Object)"2");
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)new PythonMainAppResource(mainResource), sparkConf, (String[])((Object[])new String[]{"5", "7", "9"}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7", "9"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Map envs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getEnv()).asScala()).map((Function1 & Serializable & scala.Serializable)env -> new Tuple2((Object)env.getName(), (Object)env.getValue()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_PYSPARK_MAJOR_PYTHON_VERSION()), (Object)"2")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(envs);
            Map $org_scalatest_assert_macro_right2 = expected;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("R resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.R";
            RMainAppResource x$4 = new RMainAppResource(mainResource);
            String[] x$5 = (String[])((Object[])new String[]{"5", "7", "9"});
            SparkConf x$6 = this.applyFeatureStep$default$2();
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)x$4, x$6, x$5);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7", "9"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }
}

