/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.net.InternetDomainName;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicExecutorFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils$;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.resource.TestResourceIDs$;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\u0011\"\u00019BQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004H\u0001\u0001\u0006Ia\u0010\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019\u0001\u0006\u0001)A\u0005\u0015\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006BB-\u0001A\u0003%1\u000bC\u0004[\u0001\t\u0007I\u0011\u0002 \t\rm\u0003\u0001\u0015!\u0003@\u0011\u001da\u0006A1A\u0005\nyBa!\u0018\u0001!\u0002\u0013y\u0004b\u00020\u0001\u0005\u0004%IA\u0010\u0005\u0007?\u0002\u0001\u000b\u0011B \t\u000f\u0001\u0004!\u0019!C\u0005}!1\u0011\r\u0001Q\u0001\n}BqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004m\u0001\u0001\u0006I\u0001\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0003o\u0011\u0019\u0019\b\u0001)A\u0005_\"9A\u000f\u0001b\u0001\n\u0013)\bbBA\u0006\u0001\u0001\u0006IA\u001e\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"a\u0006\u0001A\u0003%\u0011\u0011\u0003\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002C\u0006\u0002$\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0002bCA\u0019\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;Aq!a\r\u0001\t\u0013\t)\u0004C\u0005\u0002\\\u0001\t\n\u0011\"\u0003\u0002^!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003+\u0003A\u0011BAL\u0005u\u0011\u0015m]5d\u000bb,7-\u001e;pe\u001a+\u0017\r^;sKN#X\r]*vSR,'B\u0001\u0012$\u0003!1W-\u0019;ve\u0016\u001c(B\u0001\u0013&\u0003\rY\u0007h\u001d\u0006\u0003M\u001d\na\u0001Z3qY>L(B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aL\u001a\u0011\u0005A\nT\"A\u0014\n\u0005I:#!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u00025o5\tQG\u0003\u00027W\u0005I1oY1mCR,7\u000f^\u0005\u0003qU\u0012aBQ3g_J,\u0017I\u001c3BMR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002wA\u0011A\bA\u0007\u0002C\u0005yAIU%W\u000bJ{\u0006jT*U\u001d\u0006kU)F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003mC:<'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013aa\u0015;sS:<\u0017\u0001\u0005#S\u0013Z+%k\u0018%P'Rs\u0015)T#!\u0003-!%+\u0013,F%~\u0003vJ\u0015+\u0016\u0003)\u0003\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u00131!\u00138u\u00031!%+\u0013,F%~\u0003vJ\u0015+!\u00039!%+\u0013,F%~\u000bE\t\u0012*F'N+\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-\u001e\n1A\u001d9d\u0013\tAVK\u0001\nSa\u000e,e\u000e\u001a9pS:$\u0018\t\u001a3sKN\u001c\u0018a\u0004#S\u0013Z+%kX!E\tJ+5k\u0015\u0011\u0002\u001f\u0011\u0013\u0016JV#S?B{Ei\u0018(B\u001b\u0016\u000b\u0001\u0003\u0012*J-\u0016\u0013v\fU(E?:\u000bU*\u0012\u0011\u0002\u001d\u0011\u0013\u0016JV#S?B{EiX+J\t\u0006yAIU%W\u000bJ{\u0006k\u0014#`+&#\u0005%\u0001\u000bS\u000bN{UKU\"F?:\u000bU*R0Q%\u00163\u0015\nW\u0001\u0016%\u0016\u001bv*\u0016*D\u000b~s\u0015)T#`!J+e)\u0013-!\u00039)\u0005,R\"V)>\u0013v,S'B\u000f\u0016\u000bq\"\u0012-F\u0007V#vJU0J\u001b\u0006;U\tI\u0001\u0007\u0019\u0006\u0013U\tT*\u0016\u0003\u0011\u0004B!\u001a6@\u007f5\taM\u0003\u0002hQ\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003S2\u000b!bY8mY\u0016\u001cG/[8o\u0013\tYgMA\u0002NCB\fq\u0001T!C\u000b2\u001b\u0006%A\fU\u000bN#v,S'B\u000f\u0016{\u0006+\u0016'M?N+5IU#U'V\tq\u000eE\u0002qc~j\u0011\u0001[\u0005\u0003e\"\u00141aU3r\u0003a!Vi\u0015+`\u00136\u000bu)R0Q+2culU#D%\u0016#6\u000bI\u0001\u001f)\u0016\u001bFkX%N\u0003\u001e+u\fU+M\u0019~\u001bVi\u0011*F)~{%IS#D)N+\u0012A\u001e\t\u0004aF<\bc\u0001=\u0002\b5\t\u0011P\u0003\u0002{w\u0006)Qn\u001c3fY*\u0011A0`\u0001\u0004CBL'B\u0001@\u0000\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0005\u0003\u0003\t\u0019!A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0005\u0005\u0015\u0011AA5p\u0013\r\tI!\u001f\u0002\u0015\u0019>\u001c\u0017\r\\(cU\u0016\u001cGOU3gKJ,gnY3\u0002?Q+5\u000bV0J\u001b\u0006;Ui\u0018)V\u00192{6+R\"S\u000bR{vJ\u0011&F\u0007R\u001b\u0006%\u0001\u0006E%&3VIU0Q\u001f\u0012+\"!!\u0005\u0011\u0007a\f\u0019\"C\u0002\u0002\u0016e\u00141\u0001U8e\u0003-!%+\u0013,F%~\u0003v\n\u0012\u0011\u0002\u0011\t\f7/Z\"p]\u001a,\"!!\b\u0011\u0007A\ny\"C\u0002\u0002\"\u001d\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0019\t\f7/Z\"p]\u001a|F%Z9\u0015\t\u0005\u001d\u0012Q\u0006\t\u0004\u0017\u0006%\u0012bAA\u0016\u0019\n!QK\\5u\u0011%\ty#GA\u0001\u0002\u0004\ti\"A\u0002yIE\n\u0011BY1tK\u000e{gN\u001a\u0011\u0002\u001f9,w/\u0012=fGV$xN]\"p]\u001a$B!a\u000e\u0002@A!\u0011\u0011HA\u001e\u001b\u0005\u0019\u0013bAA\u001fG\t12*\u001e2fe:,G/Z:Fq\u0016\u001cW\u000f^8s\u0007>tg\rC\u0005\u0002Bm\u0001\n\u00111\u0001\u0002D\u0005YQM\u001c<je>tW.\u001a8u!!\t)%a\u0015\u0002X\u0005]c\u0002BA$\u0003\u001f\u00022!!\u0013M\u001b\t\tYEC\u0002\u0002N5\na\u0001\u0010:p_Rt\u0014bAA)\u0019\u00061\u0001K]3eK\u001aL1a[A+\u0015\r\t\t\u0006\u0014\t\u0005\u0003\u000b\nI&C\u0002G\u0003+\n\u0011D\\3x\u000bb,7-\u001e;pe\u000e{gN\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\f\u0016\u0005\u0003\u0007\n\tg\u000b\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!C;oG\",7m[3e\u0015\r\ti\u0007T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA9\u0003O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Q\u0019\u0007.Z2l\u001f^tWM\u001d*fM\u0016\u0014XM\\2fgR1\u0011qEA<\u0003wBq!!\u001f\u001e\u0001\u0004\t\t\"\u0001\u0005fq\u0016\u001cW\u000f^8s\u0011\u001d\ti(\ba\u0001\u0003/\nA\u0002\u001a:jm\u0016\u0014\bk\u001c3VS\u0012\f\u0001b\u00195fG.,eN\u001e\u000b\t\u0003O\t\u0019)!$\u0002\u0012\"9\u0011Q\u0011\u0010A\u0002\u0005\u001d\u0015aC3yK\u000e,Ho\u001c:Q_\u0012\u0004B!!\u000f\u0002\n&\u0019\u00111R\u0012\u0003\u0011M\u0003\u0018M]6Q_\u0012Dq!a$\u001f\u0001\u0004\ti\"\u0001\u0003d_:4\u0007bBAJ=\u0001\u0007\u00111I\u0001\u0012C\u0012$\u0017\u000e^5p]\u0006dWI\u001c<WCJ\u001c\u0018aD1n_VtG/\u00118e\r>\u0014X.\u0019;\u0015\t\u0005]\u0013\u0011\u0014\u0005\b\u00037{\u0002\u0019AAO\u0003!\tX/\u00198uSRL\bc\u0001=\u0002 &\u0019\u0011\u0011U=\u0003\u0011E+\u0018M\u001c;jif\u0004")
public class BasicExecutorFeatureStepSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String DRIVER_HOSTNAME;
    private final int DRIVER_PORT;
    private final RpcEndpointAddress DRIVER_ADDRESS;
    private final String DRIVER_POD_NAME;
    private final String DRIVER_POD_UID;
    private final String RESOURCE_NAME_PREFIX;
    private final String EXECUTOR_IMAGE;
    private final scala.collection.immutable.Map<String, String> LABELS;
    private final Seq<String> TEST_IMAGE_PULL_SECRETS;
    private final Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS;
    private final Pod DRIVER_POD;
    private SparkConf baseConf;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String DRIVER_HOSTNAME() {
        return this.DRIVER_HOSTNAME;
    }

    private int DRIVER_PORT() {
        return this.DRIVER_PORT;
    }

    private RpcEndpointAddress DRIVER_ADDRESS() {
        return this.DRIVER_ADDRESS;
    }

    private String DRIVER_POD_NAME() {
        return this.DRIVER_POD_NAME;
    }

    private String DRIVER_POD_UID() {
        return this.DRIVER_POD_UID;
    }

    private String RESOURCE_NAME_PREFIX() {
        return this.RESOURCE_NAME_PREFIX;
    }

    private String EXECUTOR_IMAGE() {
        return this.EXECUTOR_IMAGE;
    }

    private scala.collection.immutable.Map<String, String> LABELS() {
        return this.LABELS;
    }

    private Seq<String> TEST_IMAGE_PULL_SECRETS() {
        return this.TEST_IMAGE_PULL_SECRETS;
    }

    private Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS() {
        return this.TEST_IMAGE_PULL_SECRET_OBJECTS;
    }

    private Pod DRIVER_POD() {
        return this.DRIVER_POD;
    }

    private SparkConf baseConf() {
        return this.baseConf;
    }

    private void baseConf_$eq(SparkConf x$1) {
        this.baseConf = x$1;
    }

    private KubernetesExecutorConf newExecutorConf(scala.collection.immutable.Map<String, String> environment) {
        return KubernetesTestConf$.MODULE$.createExecutorConf(this.baseConf(), (Option<Pod>)new Some((Object)this.DRIVER_POD()), this.LABELS(), environment, KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
    }

    private scala.collection.immutable.Map<String, String> newExecutorConf$default$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private void checkOwnerReferences(Pod executor, String driverPodUid) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getMetadata().getOwnerReferences().size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getUid());
        String $org_scalatest_assert_macro_right2 = driverPodUid;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getController()), "scala.Predef.Boolean2boolean(executor.getMetadata().getOwnerReferences().get(0).getController())", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
    }

    private void checkEnv(SparkPod executorPod, SparkConf conf, scala.collection.immutable.Map<String, String> additionalEnvVars) {
        scala.collection.immutable.Map defaultEnvs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ID()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_DRIVER_URL()), (Object)this.DRIVER_ADDRESS().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY()), (Object)"1g"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR()), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_IP()), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_USER()), (Object)Utils$.MODULE$.getCurrentUserName())}));
        int extraJavaOptsStart = additionalEnvVars.keys().count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX())));
        Seq extraJavaOpts = Utils$.MODULE$.sparkJavaOpts(conf, (Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        scala.collection.immutable.Map extraJavaOptsEnvs = ((TraversableOnce)((TraversableLike)extraJavaOpts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String opt = (String)tuple2._1();
            int ind = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX()).append(ind + extraJavaOptsStart).toString()), (Object)opt);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map containerEnvs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(executorPod.container().getEnv()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)x.getName(), (Object)x.getValue()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map expectedEnvs = defaultEnvs.$plus$plus(additionalEnvVars).$plus$plus((GenTraversableOnce)extraJavaOptsEnvs);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(containerEnvs);
        scala.collection.immutable.Map $org_scalatest_assert_macro_right = expectedEnvs;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
    }

    private String amountAndFormat(Quantity quantity) {
        return new StringBuilder(0).append(quantity.getAmount()).append(quantity.getFormat()).toString();
    }

    public BasicExecutorFeatureStepSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.DRIVER_HOSTNAME = "localhost";
        this.DRIVER_PORT = 7098;
        this.DRIVER_ADDRESS = RpcEndpointAddress$.MODULE$.apply(this.DRIVER_HOSTNAME(), this.DRIVER_PORT(), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME());
        this.DRIVER_POD_NAME = "driver-pod";
        this.DRIVER_POD_UID = "driver-uid";
        this.RESOURCE_NAME_PREFIX = "base";
        this.EXECUTOR_IMAGE = "executor-image";
        this.LABELS = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label1key"), (Object)"label1value")}));
        this.TEST_IMAGE_PULL_SECRETS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my-1secret-1", "my-secret-2"}));
        this.TEST_IMAGE_PULL_SECRET_OBJECTS = (Seq)this.TEST_IMAGE_PULL_SECRETS().map((Function1 & Serializable & scala.Serializable)secret -> ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(secret)).build(), Seq$.MODULE$.canBuildFrom());
        this.DRIVER_POD = ((PodBuilder)((PodFluent.StatusNested)((PodFluentImpl)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.DRIVER_POD_NAME()).withUid(this.DRIVER_POD_UID())).endMetadata()).withNewSpec().withNodeName("some-node")).endSpec()).withNewStatus().withHostIP("192.168.99.100")).endStatus()).build();
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.baseConf_$eq(new SparkConf(false).set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.DRIVER_POD_NAME()).set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)this.RESOURCE_NAME_PREFIX()).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)this.EXECUTOR_IMAGE()).set(Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set(package$.MODULE$.DRIVER_HOST_ADDRESS(), (Object)this.DRIVER_HOSTNAME()).set(package$.MODULE$.DRIVER_PORT(), (Object)BoxesRunTime.boxToInteger((int)this.DRIVER_PORT())).set(Config$.MODULE$.IMAGE_PULL_SECRETS(), this.TEST_IMAGE_PULL_SECRETS()).set("spark.kubernetes.resource.type", "java")), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("test spark resource missing vendor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String error;
            this.baseConf().set(TestResourceIDs$.MODULE$.EXECUTOR_GPU_ID().amountConf(), "2");
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()));
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkPod sparkPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101))).getMessage();
            String $org_scalatest_assert_macro_right = "Resource: gpu was requested, but vendor was not specified";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("test spark resource missing amount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String error;
            this.baseConf().set(TestResourceIDs$.MODULE$.EXECUTOR_GPU_ID().vendorConf(), "nvidia.com");
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()));
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkPod sparkPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111))).getMessage();
            String $org_scalatest_assert_macro_right = "You must specify an amount for gpu";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("basic executor pod with resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ResourceID fpgaResourceID = new ResourceID(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), ResourceUtils$.MODULE$.FPGA());
            ResourceID gpuExecutorResourceID = new ResourceID(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), ResourceUtils$.MODULE$.GPU());
            scala.collection.immutable.Map gpuResources = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nvidia.com/gpu"), (Object)new KubernetesFeaturesTestUtils.TestResourceInformation(gpuExecutorResourceID, "2", "nvidia.com")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo.com/fpga"), (Object)new KubernetesFeaturesTestUtils.TestResourceInformation(fpgaResourceID, "1", "foo.com"))}));
            gpuResources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                this.baseConf().set(testRInfo.rId().amountConf(), testRInfo.count());
                SparkConf sparkConf = this.baseConf().set(testRInfo.rId().vendorConf(), testRInfo.vendor());
                return sparkConf;
            });
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()));
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right2 = "1408Mi";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            gpuResources.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k8sName = (String)tuple2._1();
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get(k8sName)));
                String $org_scalatest_assert_macro_right = testRInfo.count();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                return assertion;
            });
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("basic executor pod has reasonable defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()));
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(executor.pod().getMetadata().getName());
            String $org_scalatest_assert_macro_right = new StringBuilder(7).append(this.RESOURCE_NAME_PREFIX()).append("-exec-1").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            this.LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(executor.pod().getMetadata().getLabels().get(k));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                return assertion;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(executor.pod().getSpec().getImagePullSecrets()).asScala());
            Seq<LocalObjectReference> $org_scalatest_assert_macro_right2 = this.TEST_IMAGE_PULL_SECRET_OBJECTS();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(executor.container().getImage());
            String $org_scalatest_assert_macro_right3 = this.EXECUTOR_IMAGE();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            List $org_scalatest_assert_macro_left4 = executor.container().getVolumeMounts();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right5 = "1408Mi";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            Map $org_scalatest_assert_macro_left7 = executor.pod().getSpec().getNodeSelector();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            List $org_scalatest_assert_macro_left8 = executor.pod().getSpec().getVolumes();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            this.checkEnv(executor, this.baseConf(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            this.checkOwnerReferences(executor.pod(), this.DRIVER_POD_UID());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("executor pod hostnames get truncated to 63 characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String longPodNamePrefix = "loremipsumdolorsitametvimatelitrefficiendisuscipianturvixlegeresple";
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)longPodNamePrefix);
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec().getHostname().length()));
            int $org_scalatest_assert_macro_right = 63;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("hostname truncation generates valid host names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String invalidPrefix = "abcdef-*_/[]{}+==.,;'\"-----------------------------------------------";
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)invalidPrefix);
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()));
            String hostname = step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec().getHostname();
            int $org_scalatest_assert_macro_left = hostname.length();
            int $org_scalatest_assert_macro_right = 63;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(InternetDomainName.isValid((String)hostname), "com.google.common.net.InternetDomainName.isValid(hostname)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("classpath and extra java options get translated into environment variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.baseConf().set(package$.MODULE$.EXECUTOR_JAVA_OPTIONS(), (Object)"foo=bar");
            this.baseConf().set(package$.MODULE$.EXECUTOR_CLASS_PATH(), (Object)"bar=baz");
            KubernetesExecutorConf kconf = this.newExecutorConf((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")}))));
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(kconf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()));
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            this.checkEnv(executor, this.baseConf(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_JAVA_OPT_0"), (Object)"foo=bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_CLASSPATH()), (Object)"bar=baz"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")}))));
            this.checkOwnerReferences(executor.pod(), this.DRIVER_POD_UID());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("test executor pyspark memory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set("spark.kubernetes.resource.type", "python");
            this.baseConf().set(Python$.MODULE$.PYSPARK_EXECUTOR_MEMORY(), (Object)BoxesRunTime.boxToLong((long)42L));
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()));
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("memory")));
            String $org_scalatest_assert_macro_right = "1450Mi";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("auth secret propagation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = this.baseConf().clone().set(package$.MODULE$.NETWORK_AUTH_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set("spark.master", "k8s://127.0.0.1");
            SecurityManager secMgr = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
            secMgr.initializeAuth();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(KubernetesTestConf$.MODULE$.createExecutorConf(conf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8()), secMgr);
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            this.checkEnv(executor, conf, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityManager$.MODULE$.ENV_AUTH_SECRET()), (Object)secMgr.getSecretKey())}))));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("Auth secret shouldn't propagate if files are loaded.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File secretDir = Utils$.MODULE$.createTempDir("temp-secret", Utils$.MODULE$.createTempDir$default$2());
            File secretFile = new File(secretDir, "secret-file.txt");
            Files.write(secretFile.toPath(), "some-secret".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            SparkConf conf = this.baseConf().clone().set(package$.MODULE$.NETWORK_AUTH_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set(package$.MODULE$.AUTH_SECRET_FILE(), (Object)secretFile.getAbsolutePath()).set("spark.master", "k8s://127.0.0.1");
            SecurityManager secMgr = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
            secMgr.initializeAuth();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(KubernetesTestConf$.MODULE$.createExecutorConf(conf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8()), secMgr);
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(KubernetesFeaturesTestUtils$.MODULE$.containerHasEnvVar(executor.container(), SecurityManager$.MODULE$.ENV_AUTH_SECRET()), "KubernetesFeaturesTestUtils.containerHasEnvVar(executor.container, org.apache.spark.SecurityManager.ENV_AUTH_SECRET)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }
}

