/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.HostAliasBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TolerationBuilder;
import io.fabric8.kubernetes.api.model.TolerationFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.config.ConfigEntry;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I4QAC\u0006\u0002\u0002YAQa\u0007\u0001\u0005\u0002qAQa\b\u0001\u0007\u0012\u0001BQ\u0001\u000f\u0001\u0007\u0012eBqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004R\u0001\u0001\u0006Ia\u0010\u0005\u0006%\u0002!Ia\u0015\u0005\b=\u0002\t\n\u0011\"\u0003`\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u0015\u0001\b\u0001\"\u0003r\u0005=\u0001v\u000e\u001a\"vS2$WM]*vSR,'B\u0001\u0007\u000e\u0003\rY\u0007h\u001d\u0006\u0003\u001d=\ta\u0001Z3qY>L(B\u0001\t\u0012\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00112#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0006\t\u00031ei\u0011aD\u0005\u00035=\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\f\u0003A!X-\u001c9mCR,g)\u001b7f\u0007>tg-F\u0001\"a\t\u0011C\u0006E\u0002$Q)j\u0011\u0001\n\u0006\u0003K\u0019\naaY8oM&<'BA\u0014\u0010\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0015%\u0005-\u0019uN\u001c4jO\u0016sGO]=\u0011\u0005-bC\u0002\u0001\u0003\n[\t\t\t\u0011!A\u0003\u00029\u00121a\u0018\u00132#\tyS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0004O_RD\u0017N\\4\u0011\u0005A2\u0014BA\u001c2\u0005\r\te._\u0001\tEVLG\u000e\u001a)pIR\u0019!(\u0010\"\u0011\u0005yY\u0014B\u0001\u001f\f\u0005!\u0019\u0006/\u0019:l!>$\u0007\"\u0002 \u0004\u0001\u0004y\u0014!C:qCJ\\7i\u001c8g!\tA\u0002)\u0003\u0002B\u001f\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0006\u0007\u000e\u0001\r\u0001R\u0001\u0007G2LWM\u001c;\u0011\u0005\u0015kU\"\u0001$\u000b\u0005\r;%B\u0001%J\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003\u0015.\u000bqAZ1ce&\u001c\u0007HC\u0001M\u0003\tIw.\u0003\u0002O\r\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\tE\u0006\u001cXmQ8oMV\tq(A\u0005cCN,7i\u001c8gA\u0005!Rn\\2l\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R$\"\u0001\u0012+\t\u000fU3\u0001\u0013!a\u0001-\u0006\u0019\u0001o\u001c3\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016!B7pI\u0016d'BA.H\u0003\r\t\u0007/[\u0005\u0003;b\u00131\u0001U8e\u0003yiwnY6Lk\n,'O\\3uKN\u001cE.[3oi\u0012\"WMZ1vYR$\u0013'F\u0001aU\t1\u0016mK\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-A\u0005v]\u000eDWmY6fI*\u0011q-M\u0001\u000bC:tw\u000e^1uS>t\u0017BA5e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\nm\u0016\u0014\u0018NZ=Q_\u0012$\"\u0001\\8\u0011\u0005Aj\u0017B\u000182\u0005\u0011)f.\u001b;\t\u000bUC\u0001\u0019\u0001\u001e\u00021A|GmV5uQN+\b\u000f]8si\u0016$g)Z1ukJ,7\u000fF\u0001W\u0001")
public abstract class PodBuilderSuite
extends SparkFunSuite {
    private final SparkConf baseConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-executor:latest");

    public abstract ConfigEntry<?> templateFileConf();

    public abstract SparkPod buildPod(SparkConf var1, KubernetesClient var2);

    private SparkConf baseConf() {
        return this.baseConf;
    }

    /*
     * WARNING - void declaration
     */
    private KubernetesClient mockKubernetesClient(Pod pod) {
        void var2_2;
        KubernetesClient kubernetesClient = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        MixedOperation pods = (MixedOperation)Mockito.mock(MixedOperation.class);
        PodResource podResource = (PodResource)Mockito.mock(PodResource.class);
        Mockito.when((Object)kubernetesClient.pods()).thenReturn((Object)pods);
        Mockito.when((Object)pods.load((File)ArgumentMatchers.any(File.class))).thenReturn((Object)podResource);
        Mockito.when((Object)podResource.get()).thenReturn((Object)pod);
        return var2_2;
    }

    private Pod mockKubernetesClient$default$1() {
        return this.podWithSupportedFeatures();
    }

    private void verifyPod(SparkPod pod) {
        ObjectMeta metadata = pod.pod().getMetadata();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadata.getLabels().containsKey("test-label-key"), "metadata.getLabels().containsKey(\"test-label-key\")", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.getAnnotations().containsKey("test-annotation-key"), "metadata.getAnnotations().containsKey(\"test-annotation-key\")", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(metadata.getNamespace());
        String $org_scalatest_assert_macro_right = "namespace";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.getOwnerReferences()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$1(x$1))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.OwnerReference](metadata.getOwnerReferences()).asScala.exists(((x$1: io.fabric8.kubernetes.api.model.OwnerReference) => x$1.getName().==(\"owner-reference\")))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        PodSpec spec = pod.pod().getSpec();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getContainers()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$2(x$2))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.Container](spec.getContainers()).asScala.exists(((x$2: io.fabric8.kubernetes.api.model.Container) => x$2.getName().==(\"executor-container\")))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(spec.getDnsPolicy());
        String $org_scalatest_assert_macro_right2 = "dns-policy";
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getHostAliases()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$3(x$3))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.HostAlias](spec.getHostAliases()).asScala.exists(((x$3: io.fabric8.kubernetes.api.model.HostAlias) => scala.collection.JavaConverters.asScalaBufferConverter[String](x$3.getHostnames()).asScala.exists(((x$4: String) => x$4.==(\"hostname\")))))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getImagePullSecrets()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$5(x$5))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.LocalObjectReference](spec.getImagePullSecrets()).asScala.exists(((x$5: io.fabric8.kubernetes.api.model.LocalObjectReference) => x$5.getName().==(\"local-reference\")))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getInitContainers()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$6(x$6))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.Container](spec.getInitContainers()).asScala.exists(((x$6: io.fabric8.kubernetes.api.model.Container) => x$6.getName().==(\"init-container\")))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        String $org_scalatest_assert_macro_left3 = spec.getNodeName();
        String $org_scalatest_assert_macro_right3 = "node-name";
        String string = $org_scalatest_assert_macro_left3;
        String string2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(spec.getNodeSelector().get("node-selector-key"));
        String $org_scalatest_assert_macro_right4 = "node-selector-value";
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(spec.getSchedulerName());
        String $org_scalatest_assert_macro_right5 = "scheduler";
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(spec.getSecurityContext().getRunAsUser());
        long $org_scalatest_assert_macro_right6 = 1000L;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(spec.getServiceAccount());
        String $org_scalatest_assert_macro_right7 = "service-account";
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(spec.getSubdomain());
        String $org_scalatest_assert_macro_right8 = "subdomain";
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getTolerations()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$7(x$7))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.Toleration](spec.getTolerations()).asScala.exists(((x$7: io.fabric8.kubernetes.api.model.Toleration) => x$7.getKey().==(\"toleration-key\")))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getVolumes()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$8(x$8))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.Volume](spec.getVolumes()).asScala.exists(((x$8: io.fabric8.kubernetes.api.model.Volume) => x$8.getName().==(\"test-volume\")))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        Container container = pod.container();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(container.getName());
        String $org_scalatest_assert_macro_right9 = "executor-container";
        Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        java.util.List $org_scalatest_assert_macro_left10 = container.getArgs();
        String $org_scalatest_assert_macro_right10 = "arg";
        Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.contains($org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(((Object)container.getCommand()).equals(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"command", (List)Nil$.MODULE$)).asJava()), "container.getCommand().equals(scala.collection.JavaConverters.seqAsJavaListConverter[String](scala.collection.immutable.List.apply[String](\"command\")).asJava)", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(container.getEnv()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$9(x$9))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.EnvVar](container.getEnv()).asScala.exists(((x$9: io.fabric8.kubernetes.api.model.EnvVar) => x$9.getName().==(\"env-key\")))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(container.getResources().getLimits().get("gpu"));
        Quantity $org_scalatest_assert_macro_right11 = new Quantity("1");
        Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(container.getSecurityContext().getRunAsNonRoot()), "scala.Predef.Boolean2boolean(container.getSecurityContext().getRunAsNonRoot())", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(container.getStdin()), "scala.Predef.Boolean2boolean(container.getStdin())", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(container.getTerminationMessagePath());
        String $org_scalatest_assert_macro_right12 = "termination-message-path";
        Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(container.getTerminationMessagePolicy());
        String $org_scalatest_assert_macro_right13 = "termination-message-policy";
        Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.container().getVolumeMounts()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$10(x$10))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.VolumeMount](pod.container.getVolumeMounts()).asScala.exists(((x$10: io.fabric8.kubernetes.api.model.VolumeMount) => x$10.getName().==(\"test-volume\")))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }

    private Pod podWithSupportedFeatures() {
        return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent)((ContainerFluent.SecurityContextNested)((ContainerFluent)((ContainerFluent.ResourcesNested)((ContainerFluent)((ContainerFluent.EnvNested)((PodSpecFluent)((PodSpecFluent.VolumesNested)((VolumeFluent)((VolumeFluent.HostPathNested)((PodSpecFluent)((PodSpecFluent.SecurityContextNested)((PodFluentImpl)((PodFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new PodBuilder().withNewMetadata().addToLabels("test-label-key", "test-label-value").addToAnnotations("test-annotation-key", "test-annotation-value").withNamespace("namespace").addNewOwnerReference().withController(Predef$.MODULE$.boolean2Boolean(true)).withName("owner-reference")).endOwnerReference()).endMetadata()).withNewSpec().withDnsPolicy("dns-policy").withHostAliases(new HostAlias[]{((HostAliasBuilder)new HostAliasBuilder().withHostnames(new String[]{"hostname"})).build()}).withImagePullSecrets(new LocalObjectReference[]{((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName("local-reference")).build()}).withInitContainers(new Container[]{((ContainerBuilder)new ContainerBuilder().withName("init-container")).build()}).withNodeName("node-name").withNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"node-selector-key"), (Object)"node-selector-value")}))).asJava()).withSchedulerName("scheduler").withNewSecurityContext().withRunAsUser(Predef$.MODULE$.long2Long(1000L))).endSecurityContext()).withServiceAccount("service-account").withSubdomain("subdomain").withTolerations(new Toleration[]{((TolerationBuilder)((TolerationFluentImpl)((TolerationFluentImpl)new TolerationBuilder().withKey("toleration-key")).withOperator("Equal")).withEffect("NoSchedule")).build()}).addNewVolume().withNewHostPath().withPath("/test")).endHostPath()).withName("test-volume")).endVolume()).addNewContainer().withArgs(new String[]{"arg"}).withCommand(new String[]{"command"}).addNewEnv().withName("env-key").withValue("env-value")).endEnv()).withImagePullPolicy("Always").withName("executor-container").withNewResources().withLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gpu"), (Object)new Quantity("1"))}))).asJava())).endResources()).withNewSecurityContext().withRunAsNonRoot(Predef$.MODULE$.boolean2Boolean(true))).endSecurityContext()).withStdin(Predef$.MODULE$.boolean2Boolean(true)).withTerminationMessagePath("termination-message-path").withTerminationMessagePolicy("termination-message-policy").addToVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountFluentImpl)new VolumeMountBuilder().withName("test-volume")).withMountPath("/test")).build()})).endContainer()).endSpec()).build();
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$1(OwnerReference x$1) {
        String string = x$1.getName();
        String string2 = "owner-reference";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$2(Container x$2) {
        String string = x$2.getName();
        String string2 = "executor-container";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$4(String x$4) {
        String string = x$4;
        String string2 = "hostname";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$3(HostAlias x$3) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.getHostnames()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$4(x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$5(LocalObjectReference x$5) {
        String string = x$5.getName();
        String string2 = "local-reference";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$6(Container x$6) {
        String string = x$6.getName();
        String string2 = "init-container";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$7(Toleration x$7) {
        String string = x$7.getKey();
        String string2 = "toleration-key";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$8(Volume x$8) {
        String string = x$8.getName();
        String string2 = "test-volume";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$9(EnvVar x$9) {
        String string = x$9.getName();
        String string2 = "env-key";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$10(VolumeMount x$10) {
        String string = x$10.getName();
        String string2 = "test-volume";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PodBuilderSuite() {
        this.test("use empty initial pod if template is not specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
            this.buildPod(this.baseConf().clone(), client);
            return ((KubernetesClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).pods();
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("load pod template if specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(this.mockKubernetesClient$default$1());
            SparkConf sparkConf = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml");
            SparkPod pod = this.buildPod(sparkConf, client);
            this.verifyPod(pod);
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("complain about misconfigured pod template", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().addToLabels("test-label-key", "test-label-value")).endMetadata()).build());
            SparkConf sparkConf = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml");
            SparkException exception = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.buildPod(sparkConf, client), ClassTag$.MODULE$.apply(SparkException.class), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Could not load pod from template file.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }
}

