/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]2AAB\u0004\u0001%!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0013a\u0002BB\u0013\u0001A\u0003%Q\u0004C\u0004'\u0001\t\u0007I\u0011B\u0014\t\rY\u0002\u0001\u0015!\u0003)\u0005QYUOY3s]\u0016$Xm]+uS2\u001c8+^5uK*\u0011\u0001\"C\u0001\u0004Wb\u001a(B\u0001\u0006\f\u0003\u0019!W\r\u001d7ps*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005Y\u0011B\u0001\f\f\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011aB\u0001\u0005\u0011>\u001bF+F\u0001\u001e!\tq2%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003mC:<'\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I}\u0011aa\u0015;sS:<\u0017!\u0002%P'R\u0003\u0013a\u0001)P\tV\t\u0001\u0006\u0005\u0002*i5\t!F\u0003\u0002,Y\u0005)Qn\u001c3fY*\u0011QFL\u0001\u0004CBL'BA\u00181\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003cI\nqAZ1ce&\u001c\u0007HC\u00014\u0003\tIw.\u0003\u00026U\t\u0019\u0001k\u001c3\u0002\tA{E\t\t")
public class KubernetesUtilsSuite
extends SparkFunSuite {
    private final String HOST;
    private final Pod POD = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder().withNewSpec().withHostname(this.HOST()).withContainers(new Container[]{((ContainerBuilder)new ContainerBuilder().withName("first")).build(), ((ContainerBuilder)new ContainerBuilder().withName("second")).build()})).endSpec()).build();

    private String HOST() {
        return this.HOST;
    }

    private Pod POD() {
        return this.POD;
    }

    public KubernetesUtilsSuite() {
        this.HOST = "test-host";
        this.test("Selects the given container as spark container.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkPod sparkPod = KubernetesUtils$.MODULE$.selectSparkContainer(this.POD(), (Option)new Some((Object)"second"));
            String $org_scalatest_assert_macro_left = sparkPod.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right = this.HOST();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            List $org_scalatest_assert_macro_left2 = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(sparkPod.pod().getSpec().getContainers()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), List$.MODULE$.canBuildFrom());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"first", (List)Nil$.MODULE$);
            List list = $org_scalatest_assert_macro_left2;
            .colon.colon colon2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list != null ? !list.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            String $org_scalatest_assert_macro_left3 = sparkPod.container().getName();
            String $org_scalatest_assert_macro_right3 = "second";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("Selects the first container if no container name is given.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkPod sparkPod = KubernetesUtils$.MODULE$.selectSparkContainer(this.POD(), Option$.MODULE$.empty());
            String $org_scalatest_assert_macro_left = sparkPod.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right = this.HOST();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            List $org_scalatest_assert_macro_left2 = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(sparkPod.pod().getSpec().getContainers()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), List$.MODULE$.canBuildFrom());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"second", (List)Nil$.MODULE$);
            List list = $org_scalatest_assert_macro_left2;
            .colon.colon colon2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list != null ? !list.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            String $org_scalatest_assert_macro_left3 = sparkPod.container().getName();
            String $org_scalatest_assert_macro_right3 = "first";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("Falls back to the first container if given container name does not exist.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkPod sparkPod = KubernetesUtils$.MODULE$.selectSparkContainer(this.POD(), (Option)new Some((Object)"does-not-exist"));
            String $org_scalatest_assert_macro_left = sparkPod.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right = this.HOST();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            List $org_scalatest_assert_macro_left2 = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(sparkPod.pod().getSpec().getContainers()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), List$.MODULE$.canBuildFrom());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"second", (List)Nil$.MODULE$);
            List list = $org_scalatest_assert_macro_left2;
            .colon.colon colon2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list != null ? !list.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            String $org_scalatest_assert_macro_left3 = sparkPod.container().getName();
            String $org_scalatest_assert_macro_right3 = "first";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("constructs spark pod correctly with pod template with no containers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod noContainersPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(this.POD()).editSpec().withContainers(new Container[0])).endSpec()).build();
            SparkPod sparkPod = KubernetesUtils$.MODULE$.selectSparkContainer(noContainersPod, (Option)new Some((Object)"does-not-exist"));
            String $org_scalatest_assert_macro_left = sparkPod.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right = this.HOST();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            String $org_scalatest_assert_macro_left2 = sparkPod.container().getName();
            Object $org_scalatest_assert_macro_right2 = null;
            String string3 = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string3 != null ? !string3.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            SparkPod sparkPodWithNoContainerName = KubernetesUtils$.MODULE$.selectSparkContainer(noContainersPod, Option$.MODULE$.empty());
            String $org_scalatest_assert_macro_left3 = sparkPodWithNoContainerName.pod().getSpec().getHostname();
            String $org_scalatest_assert_macro_right3 = this.HOST();
            String string4 = $org_scalatest_assert_macro_left3;
            String string5 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string4 != null ? !string4.equals(string5) : string5 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            String $org_scalatest_assert_macro_left4 = sparkPodWithNoContainerName.container().getName();
            Object $org_scalatest_assert_macro_right4 = null;
            String string6 = $org_scalatest_assert_macro_left4;
            Object var19_18 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", null, !(string6 != null ? !string6.equals(var19_18) : var19_18 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("KubernetesUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
    }
}

