/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.InitContainerBootstrap;
import org.apache.spark.deploy.k8s.MountSecretsBootstrap;
import org.apache.spark.deploy.k8s.PodWithDetachedInitContainer;
import org.apache.spark.deploy.k8s.SecretVolumeUtils$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodFactory;
import org.mockito.AdditionalAnswers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001f\t9R\t_3dkR|'\u000fU8e\r\u0006\u001cGo\u001c:z'VLG/\u001a\u0006\u0003\u0007\u0011\t1a\u001b\u001dt\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011!C:dQ\u0016$W\u000f\\3s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t\u0001\"\u0003\u0002\u0014\u0011\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0007\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\r\u0017\u00059\u0011UMZ8sK\u0006sG-\u00114uKJ\u0004\"!F\u000e\n\u0005q1\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0002\t\u000f\r\u0002!\u0019!C\u0005I\u0005iAM]5wKJ\u0004v\u000e\u001a(b[\u0016,\u0012!\n\t\u0003M1r!a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\na\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111\u0006\u000b\u0005\u0007a\u0001\u0001\u000b\u0011B\u0013\u0002\u001d\u0011\u0014\u0018N^3s!>$g*Y7fA!9!\u0007\u0001b\u0001\n\u0013!\u0013\u0001\u00043sSZ,'\u000fU8e+&$\u0007B\u0002\u001b\u0001A\u0003%Q%A\u0007ee&4XM\u001d)pIVKG\r\t\u0005\bm\u0001\u0011\r\u0011\"\u0003%\u00039)\u00070Z2vi>\u0014\bK]3gSbDa\u0001\u000f\u0001!\u0002\u0013)\u0013aD3yK\u000e,Ho\u001c:Qe\u00164\u0017\u000e\u001f\u0011\t\u000fi\u0002!\u0019!C\u0005I\u0005iQ\r_3dkR|'/S7bO\u0016Da\u0001\u0010\u0001!\u0002\u0013)\u0013AD3yK\u000e,Ho\u001c:J[\u0006<W\r\t\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0003%!'/\u001b<feB{G-F\u0001A!\t\tE*D\u0001C\u0015\t\u0019E)A\u0003n_\u0012,GN\u0003\u0002F\r\u0006\u0019\u0011\r]5\u000b\u0005\u001dC\u0015AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0011JS\u0001\bM\u0006\u0014'/[29\u0015\u0005Y\u0015AA5p\u0013\ti%IA\u0002Q_\u0012Daa\u0014\u0001!\u0002\u0013\u0001\u0015A\u00033sSZ,'\u000fU8eA!I\u0011\u000b\u0001a\u0001\u0002\u0004%IAU\u0001\tE\u0006\u001cXmQ8oMV\t1\u000b\u0005\u0002\u0012)&\u0011Q\u000b\u0003\u0002\n'B\f'o[\"p]\u001aD\u0011b\u0016\u0001A\u0002\u0003\u0007I\u0011\u0002-\u0002\u0019\t\f7/Z\"p]\u001a|F%Z9\u0015\u0005ec\u0006CA\u0014[\u0013\tY\u0006F\u0001\u0003V]&$\bbB/W\u0003\u0003\u0005\raU\u0001\u0004q\u0012\n\u0004BB0\u0001A\u0003&1+A\u0005cCN,7i\u001c8gA!)\u0011\r\u0001C\u0005E\u0006!2\r[3dW>;h.\u001a:SK\u001a,'/\u001a8dKN$2!W2f\u0011\u0015!\u0007\r1\u0001A\u0003!)\u00070Z2vi>\u0014\b\"\u0002\u001aa\u0001\u0004)\u0003\"B4\u0001\t\u0013A\u0017\u0001C2iK\u000e\\WI\u001c<\u0015\u0007eK'\u000eC\u0003eM\u0002\u0007\u0001\tC\u0003lM\u0002\u0007A.A\tbI\u0012LG/[8oC2,eN\u001e,beN\u0004BAJ7&K%\u0011aN\f\u0002\u0004\u001b\u0006\u0004\b")
public class ExecutorPodFactorySuite
extends SparkFunSuite
implements BeforeAndAfter,
BeforeAndAfterEach {
    private final String org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodName;
    private final String org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid;
    private final String org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorPrefix;
    private final String org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorImage;
    private final Pod org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod;
    private SparkConf org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public String org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodName() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodName;
    }

    public String org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid;
    }

    public String org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorPrefix() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorPrefix;
    }

    public String org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorImage() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorImage;
    }

    public Pod org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod;
    }

    public SparkConf org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf;
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf_$eq(SparkConf x$1) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf = x$1;
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkOwnerReferences(Pod executor, String driverPodUid) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getMetadata().getOwnerReferences().size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getUid());
        String $org_scalatest_assert_macro_right2 = driverPodUid;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getController());
        boolean $org_scalatest_assert_macro_right3 = true;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkEnv(Pod executor, scala.collection.immutable.Map<String, String> additionalEnvVars) {
        scala.collection.immutable.Map defaultEnvs = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ID()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_DRIVER_URL()), (Object)"dummy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY()), (Object)"1g"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)"dummy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_IP()), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_MOUNTED_CLASSPATH()), (Object)"/var/spark-data/spark-jars/*")}))).$plus$plus(additionalEnvVars);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getSpec().getContainers().size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Container)executor.getSpec().getContainers().get(0)).getEnv().size()));
        int $org_scalatest_assert_macro_right2 = defaultEnvs.size();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        scala.collection.immutable.Map mapEnvs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((Container)executor.getSpec().getContainers().get(0)).getEnv()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(EnvVar x) {
                return new Tuple2((Object)x.getName(), (Object)x.getValue());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(defaultEnvs);
        scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = mapEnvs;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
    }

    public ExecutorPodFactorySuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodName = "driver-pod";
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid = "driver-uid";
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorPrefix = "base";
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorImage = "executor-image";
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod = ((PodBuilder)((PodFluent.StatusNested)((PodFluentImpl)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodName()).withUid(this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid())).endMetadata()).withNewSpec().withNodeName("some-node")).endSpec()).withNewStatus().withHostIP("192.168.99.100")).endStatus()).build();
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockitoAnnotations.initMocks((Object)((Object)this.$outer));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf_$eq(new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodName()).set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorPrefix()).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorImage()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("basic executor pod has reasonable defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExecutorPodFactory factory = new ExecutorPodFactory(this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
                Pod executor = factory.createExecutorPod("1", "dummy", "dummy", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(executor.getMetadata().getName());
                String $org_scalatest_assert_macro_right = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-exec-1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorPrefix()}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getMetadata().getLabels().size()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(executor.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()));
                String $org_scalatest_assert_macro_right3 = "1";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getSpec().getContainers().size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(((Container)executor.getSpec().getContainers().get(0)).getImage());
                String $org_scalatest_assert_macro_right5 = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$executorImage();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                List $org_scalatest_assert_macro_left6 = ((Container)executor.getSpec().getContainers().get(0)).getVolumeMounts();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Container)executor.getSpec().getContainers().get(0)).getResources().getLimits().size()));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(((Quantity)((Container)executor.getSpec().getContainers().get(0)).getResources().getLimits().get("memory")).getAmount());
                String $org_scalatest_assert_macro_right7 = "1408Mi";
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                Map $org_scalatest_assert_macro_left9 = executor.getSpec().getNodeSelector();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                List $org_scalatest_assert_macro_left10 = executor.getSpec().getVolumes();
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkEnv(executor, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkOwnerReferences(executor, this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("executor pod hostnames get truncated to 63 characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodFactorySuite $outer;

            public final Assertion apply() {
                SparkConf conf = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf().clone();
                conf.set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)"loremipsumdolorsitametvimatelitrefficiendisuscipianturvixlegeresple");
                ExecutorPodFactory factory = new ExecutorPodFactory(conf, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
                Pod executor = factory.createExecutorPod("1", "dummy", "dummy", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getSpec().getHostname().length()));
                int $org_scalatest_assert_macro_right = 63;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("classpath and extra java options get translated into environment variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf().clone();
                conf.set(package$.MODULE$.EXECUTOR_JAVA_OPTIONS(), (Object)"foo=bar");
                conf.set(package$.MODULE$.EXECUTOR_CLASS_PATH(), (Object)"bar=baz");
                ExecutorPodFactory factory = new ExecutorPodFactory(conf, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
                Pod executor = factory.createExecutorPod("1", "dummy", "dummy", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")})), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkEnv(executor, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_JAVA_OPT_0"), (Object)"foo=bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_CLASSPATH()), (Object)"bar=baz"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")}))));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkOwnerReferences(executor, this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("executor secrets get mounted", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf().clone();
                MountSecretsBootstrap secretsBootstrap = new MountSecretsBootstrap((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"secret1"), (Object)"/var/secret1")})));
                ExecutorPodFactory factory = new ExecutorPodFactory(conf, (Option)new Some((Object)secretsBootstrap), (Option)None$.MODULE$, (Option)None$.MODULE$);
                Pod executor = factory.createExecutorPod("1", "dummy", "dummy", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getSpec().getContainers().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Container)executor.getSpec().getContainers().get(0)).getVolumeMounts().size()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(((VolumeMount)((Container)executor.getSpec().getContainers().get(0)).getVolumeMounts().get(0)).getName());
                String $org_scalatest_assert_macro_right3 = "secret1-volume";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(((VolumeMount)((Container)executor.getSpec().getContainers().get(0)).getVolumeMounts().get(0)).getMountPath());
                String $org_scalatest_assert_macro_right4 = "/var/secret1";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getSpec().getVolumes().size()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(((Volume)executor.getSpec().getVolumes().get(0)).getSecret().getSecretName());
                String $org_scalatest_assert_macro_right6 = "secret1";
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkOwnerReferences(executor, this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("init-container bootstrap step adds an init container", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf().clone();
                InitContainerBootstrap initContainerBootstrap = (InitContainerBootstrap)Mockito.mock(InitContainerBootstrap.class);
                Mockito.when((Object)initContainerBootstrap.bootstrapInitContainer((PodWithDetachedInitContainer)Matchers.any(PodWithDetachedInitContainer.class))).thenAnswer(AdditionalAnswers.returnsFirstArg());
                ExecutorPodFactory factory = new ExecutorPodFactory(conf, (Option)None$.MODULE$, (Option)new Some((Object)initContainerBootstrap), (Option)None$.MODULE$);
                Pod executor = factory.createExecutorPod("1", "dummy", "dummy", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getSpec().getInitContainers().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkOwnerReferences(executor, this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("init-container with secrets mount bootstrap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$baseConf().clone();
                InitContainerBootstrap initContainerBootstrap = (InitContainerBootstrap)Mockito.mock(InitContainerBootstrap.class);
                Mockito.when((Object)initContainerBootstrap.bootstrapInitContainer((PodWithDetachedInitContainer)Matchers.any(PodWithDetachedInitContainer.class))).thenAnswer(AdditionalAnswers.returnsFirstArg());
                MountSecretsBootstrap secretsBootstrap = new MountSecretsBootstrap((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"secret1"), (Object)"/var/secret1")})));
                ExecutorPodFactory factory = new ExecutorPodFactory(conf, (Option)new Some((Object)secretsBootstrap), (Option)new Some((Object)initContainerBootstrap), (Option)new Some((Object)secretsBootstrap));
                Pod executor = factory.createExecutorPod("1", "dummy", "dummy", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPod(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getSpec().getVolumes().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.podHasVolume(executor, "secret1-volume"), "org.apache.spark.deploy.k8s.SecretVolumeUtils.podHasVolume(executor, \"secret1-volume\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume((Container)executor.getSpec().getContainers().get(0), "secret1-volume", "/var/secret1"), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(executor.getSpec().getContainers().get(0), \"secret1-volume\", \"/var/secret1\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getSpec().getInitContainers().size()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume((Container)executor.getSpec().getInitContainers().get(0), "secret1-volume", "/var/secret1"), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(executor.getSpec().getInitContainers().get(0), \"secret1-volume\", \"/var/secret1\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$checkOwnerReferences(executor, this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactorySuite$$driverPodUid());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorPodFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }
}

