/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit.steps;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec$;
import org.apache.spark.deploy.k8s.submit.steps.DriverServiceBootstrapStep;
import org.apache.spark.deploy.k8s.submit.steps.DriverServiceBootstrapStep$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001E\u0011q\u0004\u0012:jm\u0016\u00148+\u001a:wS\u000e,'i\\8ugR\u0014\u0018\r]*uKB\u001cV/\u001b;f\u0015\t\u0019A!A\u0003ti\u0016\u00048O\u0003\u0002\u0006\r\u000511/\u001e2nSRT!a\u0002\u0005\u0002\u0007-D4O\u0003\u0002\n\u0015\u00051A-\u001a9m_fT!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!C\u0006\t\u0003'Qi\u0011AC\u0005\u0003+)\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\f\u001b\u001b\u0005A\"BA\r\u000f\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u001c1\tq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\n\r\n!d\u0015%P%R{&+R*P+J\u001bUi\u0018(B\u001b\u0016{\u0006KU#G\u0013b+\u0012\u0001\n\t\u0003K-r!AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\n\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\u0013\u00027MCuJ\u0015+`%\u0016\u001bv*\u0016*D\u000b~s\u0015)T#`!J+e)\u0013-!\u0011\u001d\t\u0004A1A\u0005\n\r\n\u0011\u0004T(O\u000f~\u0013ViU(V%\u000e+uLT!N\u000b~\u0003&+\u0012$J1\"11\u0007\u0001Q\u0001\n\u0011\n!\u0004T(O\u000f~\u0013ViU(V%\u000e+uLT!N\u000b~\u0003&+\u0012$J1\u0002Bq!\u000e\u0001C\u0002\u0013%a'A\u0007E%&3VIU0M\u0003\n+EjU\u000b\u0002oA!\u0001(P @\u001b\u0005I$B\u0001\u001e<\u0003%IW.\\;uC\ndWM\u0003\u0002=O\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005yJ$aA'baB\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0005Y\u0006twMC\u0001E\u0003\u0011Q\u0017M^1\n\u00051\n\u0005BB$\u0001A\u0003%q'\u0001\bE%&3VIU0M\u0003\n+Ej\u0015\u0011\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0013Q\u0015!B2m_\u000e\\W#A&\u0011\u00051{U\"A'\u000b\u00059S\u0011\u0001B;uS2L!\u0001U'\u0003\u000b\rcwnY6\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0016!C2m_\u000e\\w\fJ3r)\t!v\u000b\u0005\u0002'+&\u0011ak\n\u0002\u0005+:LG\u000fC\u0004Y#\u0006\u0005\t\u0019A&\u0002\u0007a$\u0013\u0007\u0003\u0004[\u0001\u0001\u0006KaS\u0001\u0007G2|7m\u001b\u0011)\u0005ec\u0006CA/a\u001b\u0005q&BA0\u000f\u0003\u001diwnY6ji>L!!\u00190\u0003\t5{7m\u001b\u0005\nG\u0002\u0001\r\u00111A\u0005\n\u0011\f\u0011b\u001d9be.\u001cuN\u001c4\u0016\u0003\u0015\u0004\"a\u00054\n\u0005\u001dT!!C*qCJ\\7i\u001c8g\u0011%I\u0007\u00011AA\u0002\u0013%!.A\u0007ta\u0006\u00148nQ8oM~#S-\u001d\u000b\u0003).Dq\u0001\u00175\u0002\u0002\u0003\u0007Q\r\u0003\u0004n\u0001\u0001\u0006K!Z\u0001\u000bgB\f'o[\"p]\u001a\u0004\u0003\"B8\u0001\t\u0013\u0001\u0018!\u0004<fe&4\u0017pU3sm&\u001cW\rF\u0003UcZD(\u0010C\u0003s]\u0002\u00071/\u0001\u0006ee&4XM\u001d)peR\u0004\"A\n;\n\u0005U<#aA%oi\")qO\u001ca\u0001g\u0006\u0001\"\r\\8dW6\u000bg.Y4feB{'\u000f\u001e\u0005\u0006s:\u0004\r\u0001J\u0001\u0014Kb\u0004Xm\u0019;fIN+'O^5dK:\u000bW.\u001a\u0005\u0006w:\u0004\r\u0001`\u0001\bg\u0016\u0014h/[2f!\ri\u0018\u0011C\u0007\u0002}*\u0019q0!\u0001\u0002\u000b5|G-\u001a7\u000b\t\u0005\r\u0011QA\u0001\u0004CBL'\u0002BA\u0004\u0003\u0013\t!b[;cKJtW\r^3t\u0015\u0011\tY!!\u0004\u0002\u000f\u0019\f'M]5dq)\u0011\u0011qB\u0001\u0003S>L1!a\u0005\u007f\u0005\u001d\u0019VM\u001d<jG\u0016Dq!a\u0006\u0001\t\u0013\tI\"\u0001\rwKJLg-_*qCJ\\7i\u001c8g\u0011>\u001cHOT1nKN$R\u0001VA\u000e\u0003?Aq!!\b\u0002\u0016\u0001\u0007Q-A\bee&4XM]*qCJ\\7i\u001c8g\u0011\u001d\t\t#!\u0006A\u0002\u0011\n\u0001#\u001a=qK\u000e$X\r\u001a%pgRt\u0015-\\3")
public class DriverServiceBootstrapStepSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX;
    private final String org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$LONG_RESOURCE_NAME_PREFIX;
    private final Map<String, String> org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS;
    @Mock
    private Clock org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock;
    private SparkConf org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public String org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX;
    }

    public String org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$LONG_RESOURCE_NAME_PREFIX() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$LONG_RESOURCE_NAME_PREFIX;
    }

    public Map<String, String> org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS;
    }

    public Clock org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock;
    }

    private void org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock_$eq(Clock x$1) {
        this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock = x$1;
    }

    public SparkConf org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf;
    }

    public void org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf_$eq(SparkConf x$1) {
        this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf = x$1;
    }

    public void org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$verifyService(int driverPort, int blockManagerPort, String expectedServiceName, Service service) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(service.getMetadata().getName());
        String $org_scalatest_assert_macro_right = expectedServiceName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(service.getSpec().getClusterIP());
        String $org_scalatest_assert_macro_right2 = "None";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(service.getSpec().getSelector()).asScala());
        Map<String, String> $org_scalatest_assert_macro_right3 = this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)service.getSpec().getPorts().size()));
        int $org_scalatest_assert_macro_right4 = 2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        Buffer driverServicePorts = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(service.getSpec().getPorts()).asScala();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((ServicePort)driverServicePorts.head()).getName());
        String $org_scalatest_assert_macro_right5 = Constants$.MODULE$.DRIVER_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.head()).getPort()));
        int $org_scalatest_assert_macro_right6 = driverPort;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((ServicePort)driverServicePorts.head()).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right7 = driverPort;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(1)).getName());
        String $org_scalatest_assert_macro_right8 = Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME();
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ServicePort)driverServicePorts.apply(1)).getPort()));
        int $org_scalatest_assert_macro_right9 = blockManagerPort;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(((ServicePort)driverServicePorts.apply(1)).getTargetPort().getIntVal());
        int $org_scalatest_assert_macro_right10 = blockManagerPort;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
    }

    public void org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$verifySparkConfHostNames(SparkConf driverSparkConf, String expectedHostName) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(driverSparkConf.get(package$.MODULE$.DRIVER_HOST_ADDRESS()));
        String $org_scalatest_assert_macro_right = expectedHostName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
    }

    public DriverServiceBootstrapStepSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX = new StringOps(Predef$.MODULE$.augmentString("a")).$times(DriverServiceBootstrapStep$.MODULE$.MAX_SERVICE_NAME_LENGTH() - DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX().length());
        this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$LONG_RESOURCE_NAME_PREFIX = new StringOps(Predef$.MODULE$.augmentString("a")).$times(DriverServiceBootstrapStep$.MODULE$.MAX_SERVICE_NAME_LENGTH() - DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX().length() + 1);
        this.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label1key"), (Object)"label1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label2key"), (Object)"label2value")}));
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceBootstrapStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MockitoAnnotations.initMocks((Object)((Object)this.$outer));
                this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf_$eq(new SparkConf(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("Headless service has a port for the driver RPC and the block manager.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceBootstrapStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DriverServiceBootstrapStep configurationStep = new DriverServiceBootstrapStep(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().set("spark.driver.port", "9000").set(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)8080)), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock());
                KubernetesDriverSpec baseDriverSpec = KubernetesDriverSpec$.MODULE$.initialSpec(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().clone());
                KubernetesDriverSpec resolvedDriverSpec = configurationStep.configureDriver(baseDriverSpec);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)resolvedDriverSpec.otherKubernetesResources().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
                HasMetadata $org_scalatest_assert_macro_left2 = (HasMetadata)resolvedDriverSpec.otherKubernetesResources().head();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "io.fabric8.kubernetes.api.model.Service", $org_scalatest_assert_macro_left2 instanceof Service, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                Service driverService = (Service)resolvedDriverSpec.otherKubernetesResources().head();
                this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$verifyService(9000, 8080, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX()})), driverService);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("Hostname and ports are set according to the service name.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceBootstrapStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DriverServiceBootstrapStep configurationStep = new DriverServiceBootstrapStep(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().set("spark.driver.port", "9000").set(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)8080)).set(Config$.MODULE$.KUBERNETES_NAMESPACE(), (Object)"my-namespace"), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock());
                KubernetesDriverSpec baseDriverSpec = KubernetesDriverSpec$.MODULE$.initialSpec(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().clone());
                KubernetesDriverSpec resolvedDriverSpec = configurationStep.configureDriver(baseDriverSpec);
                String expectedServiceName = new StringBuilder().append((Object)this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX()).append((Object)DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
                String expectedHostName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".my-namespace.svc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedServiceName}));
                this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$verifySparkConfHostNames(resolvedDriverSpec.driverSparkConf(), expectedHostName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("Ports should resolve to defaults in SparkConf and in the service.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceBootstrapStepSuite $outer;

            public final Assertion apply() {
                DriverServiceBootstrapStep configurationStep = new DriverServiceBootstrapStep(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock());
                KubernetesDriverSpec baseDriverSpec = KubernetesDriverSpec$.MODULE$.initialSpec(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().clone());
                KubernetesDriverSpec resolvedDriverSpec = configurationStep.configureDriver(baseDriverSpec);
                this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$verifyService(Constants$.MODULE$.DEFAULT_DRIVER_PORT(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$SHORT_RESOURCE_NAME_PREFIX(), DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX()})), (Service)resolvedDriverSpec.otherKubernetesResources().head());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(resolvedDriverSpec.driverSparkConf().get("spark.driver.port"));
                String $org_scalatest_assert_macro_right = ((Object)BoxesRunTime.boxToInteger((int)Constants$.MODULE$.DEFAULT_DRIVER_PORT())).toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(resolvedDriverSpec.driverSparkConf().get(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT()));
                int $org_scalatest_assert_macro_right2 = Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Long prefixes should switch to using a generated name.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceBootstrapStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DriverServiceBootstrapStep configurationStep = new DriverServiceBootstrapStep(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$LONG_RESOURCE_NAME_PREFIX(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().set(Config$.MODULE$.KUBERNETES_NAMESPACE(), (Object)"my-namespace"), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock());
                Mockito.when((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock().getTimeMillis())).thenReturn((Object)BoxesRunTime.boxToLong((long)10000L));
                KubernetesDriverSpec baseDriverSpec = KubernetesDriverSpec$.MODULE$.initialSpec(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().clone());
                KubernetesDriverSpec resolvedDriverSpec = configurationStep.configureDriver(baseDriverSpec);
                Service driverService = (Service)resolvedDriverSpec.otherKubernetesResources().head();
                String expectedServiceName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-10000", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX()}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(driverService.getMetadata().getName());
                String $org_scalatest_assert_macro_right = expectedServiceName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                String expectedHostName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".my-namespace.svc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedServiceName}));
                this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$verifySparkConfHostNames(resolvedDriverSpec.driverSparkConf(), expectedHostName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("Disallow bind address and driver host to be set explicitly.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverServiceBootstrapStepSuite $outer;

            public final Object apply() {
                DriverServiceBootstrapStep configurationStep = new DriverServiceBootstrapStep(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$LONG_RESOURCE_NAME_PREFIX(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$DRIVER_LABELS(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().set(package$.MODULE$.DRIVER_BIND_ADDRESS(), (Object)"host"), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$clock());
                try {
                    configurationStep.configureDriver(KubernetesDriverSpec$.MODULE$.initialSpec(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf()));
                    throw this.$outer.fail("The driver bind address should not be allowed.", new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                }
                catch (Throwable throwable) {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(throwable.getMessage());
                    String $org_scalatest_assert_macro_right = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requirement failed: ", " is"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DriverServiceBootstrapStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()}))).append((Object)" not supported in Kubernetes mode, as the driver's bind address is managed").append((Object)" and set to the driver pod's IP address.").toString();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                    this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().remove(package$.MODULE$.DRIVER_BIND_ADDRESS());
                    this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf().set(package$.MODULE$.DRIVER_HOST_ADDRESS(), (Object)"host");
                    try {
                        configurationStep.configureDriver(KubernetesDriverSpec$.MODULE$.initialSpec(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverServiceBootstrapStepSuite$$sparkConf()));
                        throw this.$outer.fail("The driver host address should not be allowed.", new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
                    }
                    catch (Throwable throwable2) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(throwable2.getMessage());
                        String $org_scalatest_assert_macro_right2 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requirement failed: ", " is"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DriverServiceBootstrapStep$.MODULE$.DRIVER_HOST_KEY()}))).append((Object)" not supported in Kubernetes mode, as the driver's hostname will be managed via").append((Object)" a Kubernetes service.").toString();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverServiceBootstrapStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }
}

