/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit.steps;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.steps.DriverKubernetesCredentialsStep;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001#\t!CI]5wKJ\\UOY3s]\u0016$Xm]\"sK\u0012,g\u000e^5bYN\u001cF/\u001a9Tk&$XM\u0003\u0002\u0004\t\u0005)1\u000f^3qg*\u0011QAB\u0001\u0007gV\u0014W.\u001b;\u000b\u0005\u001dA\u0011aA69g*\u0011\u0011BC\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9\"$D\u0001\u0019\u0015\tIb\"A\u0005tG\u0006d\u0017\r^3ti&\u00111\u0004\u0007\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002?-+&)\u0012*O\u000bR+5k\u0018*F'>+&kQ#`\u001d\u0006kUi\u0018)S\u000b\u001aK\u0005,F\u0001%!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003mC:<'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012aa\u0015;sS:<\u0007BB\u0017\u0001A\u0003%A%\u0001\u0011L+\n+%KT#U\u000bN{&+R*P+J\u001bUi\u0018(B\u001b\u0016{\u0006KU#G\u0013b\u0003\u0003\"C\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u00031\u0003a\u0019'/\u001a3f]RL\u0017\r\\:UK6\u0004H)\u001b:fGR|'/_\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011A\u0007K\u0001\u0003S>L!AN\u001a\u0003\t\u0019KG.\u001a\u0005\nq\u0001\u0001\r\u00111A\u0005\ne\nAd\u0019:fI\u0016tG/[1mgR+W\u000e\u001d#je\u0016\u001cGo\u001c:z?\u0012*\u0017\u000f\u0006\u0002;\u0001B\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t!QK\\5u\u0011\u001d\tu'!AA\u0002E\n1\u0001\u001f\u00132\u0011\u0019\u0019\u0005\u0001)Q\u0005c\u0005I2M]3eK:$\u0018.\u00197t)\u0016l\u0007\u000fR5sK\u000e$xN]=!\u0011\u001d)\u0005A1A\u0005\n\u0019\u000b\u0001CQ!T\u000b~#%+\u0013,F%~\u001b\u0006+R\"\u0016\u0003\u001d\u0003\"\u0001S%\u000e\u0003\u0011I!A\u0013\u0003\u0003)-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u00148\u000b]3d\u0011\u0019a\u0005\u0001)A\u0005\u000f\u0006\t\")Q*F?\u0012\u0013\u0016JV#S?N\u0003Vi\u0011\u0011\t\u000b9\u0003A\u0011B(\u0002!]\u0014\u0018\u000e^3De\u0016$WM\u001c;jC2\u001cHcA\u0019Q1\")\u0011+\u0014a\u0001%\u0006\u00192M]3eK:$\u0018.\u00197t\r&dWMT1nKB\u00111K\u0016\b\u0003wQK!!\u0016\u001f\u0002\rA\u0013X\rZ3g\u0013\tYsK\u0003\u0002Vy!)\u0011,\u0014a\u0001%\u0006\u00192M]3eK:$\u0018.\u00197t\u0007>tG/\u001a8ug\u0002")
public class DriverKubernetesCredentialsStepSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$KUBERNETES_RESOURCE_NAME_PREFIX;
    private File org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$credentialsTempDirectory;
    private final KubernetesDriverSpec org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public String org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$KUBERNETES_RESOURCE_NAME_PREFIX() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$KUBERNETES_RESOURCE_NAME_PREFIX;
    }

    public File org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$credentialsTempDirectory() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$credentialsTempDirectory;
    }

    public void org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$credentialsTempDirectory_$eq(File x$1) {
        this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$credentialsTempDirectory = x$1;
    }

    public KubernetesDriverSpec org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC;
    }

    /*
     * WARNING - void declaration
     */
    public File org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$writeCredentials(String credentialsFileName, String credentialsContents) {
        void var3_3;
        File credentialsFile = new File(this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$credentialsTempDirectory(), credentialsFileName);
        Files.write((CharSequence)credentialsContents, (File)credentialsFile, (Charset)Charsets.UTF_8);
        return var3_3;
    }

    public DriverKubernetesCredentialsStepSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$KUBERNETES_RESOURCE_NAME_PREFIX = "spark";
        Pod x$1 = new PodBuilder().build();
        Container x$2 = new ContainerBuilder().build();
        SparkConf x$3 = new SparkConf(false);
        Seq x$4 = (Seq)Seq$.MODULE$.empty();
        this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC = new KubernetesDriverSpec(x$1, x$2, x$4, x$3);
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverKubernetesCredentialsStepSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$credentialsTempDirectory_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.after((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverKubernetesCredentialsStepSuite $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$credentialsTempDirectory().delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("Don't set any credentials", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverKubernetesCredentialsStepSuite $outer;

            public final Assertion apply() {
                DriverKubernetesCredentialsStep kubernetesCredentialsStep = new DriverKubernetesCredentialsStep(new SparkConf(false), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$KUBERNETES_RESOURCE_NAME_PREFIX());
                KubernetesDriverSpec preparedDriverSpec = kubernetesCredentialsStep.configureDriver(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(preparedDriverSpec.driverPod());
                Pod $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC().driverPod();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(preparedDriverSpec.driverContainer());
                Container $org_scalatest_assert_macro_right2 = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC().driverContainer();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
                Seq $org_scalatest_assert_macro_left3 = preparedDriverSpec.otherKubernetesResources();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
                ArrayOps $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])preparedDriverSpec.driverSparkConf().getAll());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Only set credentials that are manually mounted.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverKubernetesCredentialsStepSuite $outer;

            public final Assertion apply() {
                SparkConf submissionSparkConf = new SparkConf(false).set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()})), "/mnt/secrets/my-token.txt").set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()})), "/mnt/secrets/my-key.pem").set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()})), "/mnt/secrets/my-cert.pem").set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()})), "/mnt/secrets/my-ca.pem");
                DriverKubernetesCredentialsStep kubernetesCredentialsStep = new DriverKubernetesCredentialsStep(submissionSparkConf, this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$KUBERNETES_RESOURCE_NAME_PREFIX());
                KubernetesDriverSpec preparedDriverSpec = kubernetesCredentialsStep.configureDriver(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(preparedDriverSpec.driverPod());
                Pod $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC().driverPod();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(preparedDriverSpec.driverContainer());
                Container $org_scalatest_assert_macro_right2 = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC().driverContainer();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                Seq $org_scalatest_assert_macro_left3 = preparedDriverSpec.otherKubernetesResources();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])preparedDriverSpec.driverSparkConf().getAll()).toMap(Predef$.MODULE$.$conforms()));
                Map $org_scalatest_assert_macro_right3 = Predef$.MODULE$.refArrayOps((Object[])submissionSparkConf.getAll()).toMap(Predef$.MODULE$.$conforms());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("Mount credentials from the submission client as a secret.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverKubernetesCredentialsStepSuite $outer;

            public final Assertion apply() {
                File caCertFile = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$writeCredentials("ca.pem", "ca-cert");
                File clientKeyFile = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$writeCredentials("key.pem", "key");
                File clientCertFile = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$writeCredentials("cert.pem", "cert");
                SparkConf submissionSparkConf = new SparkConf(false).set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()})), "token").set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()})), clientKeyFile.getAbsolutePath()).set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()})), clientCertFile.getAbsolutePath()).set(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()})), caCertFile.getAbsolutePath());
                DriverKubernetesCredentialsStep kubernetesCredentialsStep = new DriverKubernetesCredentialsStep(submissionSparkConf, this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$KUBERNETES_RESOURCE_NAME_PREFIX());
                SparkConf x$5 = submissionSparkConf;
                Pod x$6 = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC().copy$default$1();
                Container x$7 = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC().copy$default$2();
                Seq x$8 = this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC().copy$default$3();
                KubernetesDriverSpec preparedDriverSpec = kubernetesCredentialsStep.configureDriver(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$BASE_DRIVER_SPEC().copy(x$6, x$7, x$8, x$5));
                Map expectedSparkConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()}))), (Object)"<present_but_redacted>"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()}))), (Object)Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_PATH()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()}))), (Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_PATH()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()}))), (Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_PATH()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()}))), (Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_PATH()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()}))), (Object)clientKeyFile.getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()}))), (Object)clientCertFile.getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()}))), (Object)caCertFile.getAbsolutePath())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])preparedDriverSpec.driverSparkConf().getAll()).toMap(Predef$.MODULE$.$conforms()));
                Map $org_scalatest_assert_macro_right = expectedSparkConf;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)preparedDriverSpec.otherKubernetesResources().size()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                Secret credentialsSecret = (Secret)preparedDriverSpec.otherKubernetesResources().head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(credentialsSecret.getMetadata().getName());
                String $org_scalatest_assert_macro_right3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-kubernetes-credentials"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStepSuite$$KUBERNETES_RESOURCE_NAME_PREFIX()}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                scala.collection.mutable.Map decodedSecretData = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(credentialsSecret.getData()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(Tuple2<String, String> data) {
                        return new Tuple2(data._1(), (Object)new String(BaseEncoding.base64().decode((CharSequence)data._2()), Charsets.UTF_8));
                    }
                }, Map$.MODULE$.canBuildFrom());
                Map expectedSecretData = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_SECRET_NAME()), (Object)"ca-cert"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_SECRET_NAME()), (Object)"token"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_SECRET_NAME()), (Object)"key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_SECRET_NAME()), (Object)"cert")}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(decodedSecretData);
                Map $org_scalatest_assert_macro_right4 = expectedSecretData;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                Buffer driverPodVolumes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(preparedDriverSpec.driverPod().getSpec().getVolumes()).asScala();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverPodVolumes.size()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(((Volume)driverPodVolumes.head()).getName());
                String $org_scalatest_assert_macro_right6 = Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
                SecretVolumeSource $org_scalatest_assert_macro_left7 = ((Volume)driverPodVolumes.head()).getSecret();
                Object $org_scalatest_assert_macro_right7 = null;
                SecretVolumeSource secretVolumeSource = $org_scalatest_assert_macro_left7;
                Object var37_36 = null;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "!=", null, secretVolumeSource != null ? !secretVolumeSource.equals(var37_36) : var37_36 != null, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(((Volume)driverPodVolumes.head()).getSecret().getSecretName());
                String $org_scalatest_assert_macro_right8 = credentialsSecret.getMetadata().getName();
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                Buffer driverContainerVolumeMount = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(preparedDriverSpec.driverContainer().getVolumeMounts()).asScala();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverContainerVolumeMount.size()));
                int $org_scalatest_assert_macro_right9 = 1;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(((VolumeMount)driverContainerVolumeMount.head()).getName());
                String $org_scalatest_assert_macro_right10 = Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME();
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(((VolumeMount)driverContainerVolumeMount.head()).getMountPath());
                String $org_scalatest_assert_macro_right11 = Constants$.MODULE$.DRIVER_CREDENTIALS_SECRETS_BASE_DIR();
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DriverKubernetesCredentialsStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }
}

