/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit.steps;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.steps.DependencyResolutionStep;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001#\tiB)\u001a9f]\u0012,gnY=SKN|G.\u001e;j_:\u001cF/\u001a9Tk&$XM\u0003\u0002\u0004\t\u0005)1\u000f^3qg*\u0011QAB\u0001\u0007gV\u0014W.\u001b;\u000b\u0005\u001dA\u0011aA69g*\u0011\u0011BC\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001b\u0002\u000f\u0001\u0005\u0004%I!H\u0001\u000b'B\u000b%kS0K\u0003J\u001bV#\u0001\u0010\u0011\u0007}!c%D\u0001!\u0015\t\t#%\u0001\u0006d_2dWm\u0019;j_:T\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\u0001\u00121aU3r!\t9C&D\u0001)\u0015\tI#&\u0001\u0003mC:<'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012aa\u0015;sS:<\u0007BB\u0018\u0001A\u0003%a$A\u0006T!\u0006\u00136j\u0018&B%N\u0003\u0003bB\u0019\u0001\u0005\u0004%I!H\u0001\f'B\u000b%kS0G\u00132+5\u000b\u0003\u00044\u0001\u0001\u0006IAH\u0001\r'B\u000b%kS0G\u00132+5\u000b\t\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0003IQ\u0015IU*`\t>;f\nT(B\t~\u0003\u0016\t\u0016%\u0016\u0003\u0019Ba\u0001\u000f\u0001!\u0002\u00131\u0013a\u0005&B%N{FiT,O\u0019>\u000bEi\u0018)B)\"\u0003\u0003b\u0002\u001e\u0001\u0005\u0004%IAN\u0001\u0014\r&cUiU0E\u001f^sEjT!E?B\u000bE\u000b\u0013\u0005\u0007y\u0001\u0001\u000b\u0011\u0002\u0014\u0002)\u0019KE*R*`\t>;f\nT(B\t~\u0003\u0016\t\u0016%!\u0001")
public class DependencyResolutionStepSuite
extends SparkFunSuite {
    private final Seq<String> org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$SPARK_JARS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://localhost:9000/apps/jars/jar1.jar", "file:///home/user/apps/jars/jar2.jar", "local:///var/apps/jars/jar3.jar"}));
    private final Seq<String> org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$SPARK_FILES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file:///home/user/apps/files/file1.txt", "hdfs://localhost:9000/apps/files/file2.txt", "local:///var/apps/files/file3.txt"}));
    private final String org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$JARS_DOWNLOAD_PATH;
    private final String org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$FILES_DOWNLOAD_PATH;

    public Seq<String> org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$SPARK_JARS() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$SPARK_JARS;
    }

    public Seq<String> org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$SPARK_FILES() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$SPARK_FILES;
    }

    public String org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$JARS_DOWNLOAD_PATH() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$JARS_DOWNLOAD_PATH;
    }

    public String org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$FILES_DOWNLOAD_PATH() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$FILES_DOWNLOAD_PATH;
    }

    public DependencyResolutionStepSuite() {
        this.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$JARS_DOWNLOAD_PATH = "/mnt/spark-data/jars";
        this.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$FILES_DOWNLOAD_PATH = "/mnt/spark-data/files";
        this.test("Added dependencies should be resolved in Spark configuration and environment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DependencyResolutionStepSuite $outer;

            public final Assertion apply() {
                Pod driverPod;
                DependencyResolutionStep dependencyResolutionStep = new DependencyResolutionStep(this.$outer.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$SPARK_JARS(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$SPARK_FILES(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$JARS_DOWNLOAD_PATH(), this.$outer.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$FILES_DOWNLOAD_PATH());
                Pod x$1 = driverPod = new PodBuilder().build();
                Container x$2 = new ContainerBuilder().build();
                SparkConf x$3 = new SparkConf(false);
                Seq x$4 = (Seq)Seq$.MODULE$.empty();
                KubernetesDriverSpec baseDriverSpec = new KubernetesDriverSpec(x$1, x$2, x$4, x$3);
                KubernetesDriverSpec preparedDriverSpec = dependencyResolutionStep.configureDriver(baseDriverSpec);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(preparedDriverSpec.driverPod());
                Pod $org_scalatest_assert_macro_right = driverPod;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DependencyResolutionStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
                Seq $org_scalatest_assert_macro_left2 = preparedDriverSpec.otherKubernetesResources();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DependencyResolutionStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
                Set resolvedSparkJars = Predef$.MODULE$.refArrayOps((Object[])preparedDriverSpec.driverSparkConf().get("spark.jars").split(",")).toSet();
                Set expectedResolvedSparkJars = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://localhost:9000/apps/jars/jar1.jar", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/jar2.jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$JARS_DOWNLOAD_PATH()})), "/var/apps/jars/jar3.jar"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(resolvedSparkJars);
                Set $org_scalatest_assert_macro_right2 = expectedResolvedSparkJars;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DependencyResolutionStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
                Set resolvedSparkFiles = Predef$.MODULE$.refArrayOps((Object[])preparedDriverSpec.driverSparkConf().get("spark.files").split(",")).toSet();
                Set expectedResolvedSparkFiles = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/file1.txt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$FILES_DOWNLOAD_PATH()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://localhost:9000/apps/files/file2.txt"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/var/apps/files/file3.txt"})).s((Seq)Nil$.MODULE$)}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(resolvedSparkFiles);
                Set $org_scalatest_assert_macro_right3 = expectedResolvedSparkFiles;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DependencyResolutionStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
                Buffer driverEnv = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(preparedDriverSpec.driverContainer().getEnv()).asScala();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverEnv.size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DependencyResolutionStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(((EnvVar)driverEnv.head()).getName());
                String $org_scalatest_assert_macro_right5 = Constants$.MODULE$.ENV_MOUNTED_CLASSPATH();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DependencyResolutionStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                Set resolvedDriverClasspath = Predef$.MODULE$.refArrayOps((Object[])((EnvVar)driverEnv.head()).getValue().split(File.pathSeparator)).toSet();
                Set expectedResolvedDriverClasspath = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/jar1.jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$JARS_DOWNLOAD_PATH()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/jar2.jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$steps$DependencyResolutionStepSuite$$JARS_DOWNLOAD_PATH()})), "/var/apps/jars/jar3.jar"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(resolvedDriverClasspath);
                Set $org_scalatest_assert_macro_right6 = expectedResolvedDriverClasspath;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DependencyResolutionStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DependencyResolutionStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
    }
}

