/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import com.google.common.collect.Iterables;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.Client;
import org.apache.spark.deploy.k8s.submit.ClientSuite$;
import org.apache.spark.deploy.k8s.submit.FirstTestConfigurationStep$;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.deploy.k8s.submit.SecondTestConfigurationStep$;
import org.apache.spark.deploy.k8s.submit.steps.DriverConfigurationStep;
import org.apache.spark.internal.config.package$;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.mockito.MockitoSugar$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u0001=\u00111b\u00117jK:$8+^5uK*\u00111\u0001B\u0001\u0007gV\u0014W.\u001b;\u000b\u0005\u00151\u0011aA69g*\u0011q\u0001C\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Q\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t)\u0002$D\u0001\u0017\u0015\t9B\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011D\u0006\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\u001d\u0011\u0013\u0016JV#S?B{EiX+J\tV\t!\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005!A.\u00198h\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\rM#(/\u001b8h\u0011\u0019Y\u0003\u0001)A\u0005E\u0005yAIU%W\u000bJ{\u0006k\u0014#`+&#\u0005\u0005C\u0004.\u0001\t\u0007I\u0011B\u0011\u0002-\u0011\u0013\u0016JV#S?B{EiX!Q\u0013~3VIU*J\u001f:Caa\f\u0001!\u0002\u0013\u0011\u0013a\u0006#S\u0013Z+%k\u0018)P\t~\u000b\u0005+S0W\u000bJ\u001b\u0016j\u0014(!\u0011\u001d\t\u0004A1A\u0005\n\u0005\nq\u0002\u0012*J-\u0016\u0013v\fU(E?.Ke\n\u0012\u0005\u0007g\u0001\u0001\u000b\u0011\u0002\u0012\u0002!\u0011\u0013\u0016JV#S?B{EiX&J\u001d\u0012\u0003S\u0001B\u001b\u0001\tY\u0012ABU3t_V\u00148-\u001a'jgR\u0004Ba\u000e\"E\u00196\t\u0001H\u0003\u0002:u\u0005\u0019Am\u001d7\u000b\u0005mb\u0014AB2mS\u0016tGO\u0003\u0002>}\u0005Q1.\u001e2fe:,G/Z:\u000b\u0005}\u0002\u0015a\u00024bEJL7\r\u000f\u0006\u0002\u0003\u0006\u0011\u0011n\\\u0005\u0003\u0007b\u00121HT1nKN\u0004\u0018mY3MSN$h+[:ji\u001a\u0013x.\\*feZ,'oR3u\t\u0016dW\r^3SK\u000e\u0014X-\u0019;f/\u0006LG/\u00119qY&\u001c\u0017M\u00197f!\t)%*D\u0001G\u0015\t9\u0005*A\u0003n_\u0012,GN\u0003\u0002Jy\u0005\u0019\u0011\r]5\n\u0005-3%a\u0003%bg6+G/\u00193bi\u0006\u0004\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013qAQ8pY\u0016\fg.\u0002\u0003T\u0001\u0011!&\u0001\u0002)pIN\u0004baN+X5v\u0003\u0017B\u0001,9\u00059i\u0015\u000e_3e\u001fB,'/\u0019;j_:\u0004\"!\u0012-\n\u0005e3%a\u0001)pIB\u0011QiW\u0005\u00039\u001a\u0013q\u0001U8e\u0019&\u001cH\u000f\u0005\u0002F=&\u0011qL\u0012\u0002\f\t>tW-\u00192mKB{G\r\u0005\u00038C^k\u0016B\u000129\u0005-\u0001v\u000e\u001a*fg>,(oY3\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0013)\u0017\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u+\u00051\u0007CA4i\u001b\u0005Q\u0014BA5;\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG\u000fC\u0005l\u0001\u0001\u0007\t\u0019!C\u0005Y\u0006!2.\u001e2fe:,G/Z:DY&,g\u000e^0%KF$\"!\u001c9\u0011\u00055s\u0017BA8O\u0005\u0011)f.\u001b;\t\u000fET\u0017\u0011!a\u0001M\u0006\u0019\u0001\u0010J\u0019\t\rM\u0004\u0001\u0015)\u0003g\u0003EYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\t\u0015\u0003eV\u0004\"A^=\u000e\u0003]T!\u0001\u001f\u0007\u0002\u000f5|7m[5u_&\u0011!p\u001e\u0002\u0005\u001b>\u001c7\u000eC\u0005}\u0001\u0001\u0007\t\u0019!C\u0005{\u0006i\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N,\u0012A \t\u0003\u007fJk\u0011\u0001\u0001\u0005\f\u0003\u0007\u0001\u0001\u0019!a\u0001\n\u0013\t)!A\tq_\u0012|\u0005/\u001a:bi&|gn]0%KF$2!\\A\u0004\u0011!\t\u0018\u0011AA\u0001\u0002\u0004q\bbBA\u0006\u0001\u0001\u0006KA`\u0001\u000fa>$w\n]3sCRLwN\\:!Q\r\tI!\u001e\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\"A\u0005oC6,G\rU8egV\t\u0001\rC\u0006\u0002\u0018\u0001\u0001\r\u00111A\u0005\n\u0005e\u0011!\u00048b[\u0016$\u0007k\u001c3t?\u0012*\u0017\u000fF\u0002n\u00037A\u0001\"]A\u000b\u0003\u0003\u0005\r\u0001\u0019\u0005\b\u0003?\u0001\u0001\u0015)\u0003a\u0003)q\u0017-\\3e!>$7\u000f\t\u0015\u0004\u0003;)\bbCA\u0013\u0001\u0001\u0007\t\u0019!C\u0005\u0003O\tq\u0003\\8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:\u0016\u0005\u0005%\u0002c\u0001\u0010\u0002,%\u0019\u0011Q\u0006\u0002\u0003/1{wmZ5oOB{Gm\u0015;biV\u001cx+\u0019;dQ\u0016\u0014\bbCA\u0019\u0001\u0001\u0007\t\u0019!C\u0005\u0003g\t1\u0004\\8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:`I\u0015\fHcA7\u00026!I\u0011/a\f\u0002\u0002\u0003\u0007\u0011\u0011\u0006\u0005\t\u0003s\u0001\u0001\u0015)\u0003\u0002*\u0005ABn\\4hS:<\u0007k\u001c3Ti\u0006$Xo],bi\u000eDWM\u001d\u0011)\u0007\u0005]R\u000fC\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0013\u0001\u0004:fg>,(oY3MSN$XCAA\"!\tyH\u0007C\u0006\u0002H\u0001\u0001\r\u00111A\u0005\n\u0005%\u0013\u0001\u0005:fg>,(oY3MSN$x\fJ3r)\ri\u00171\n\u0005\nc\u0006\u0015\u0013\u0011!a\u0001\u0003\u0007B\u0001\"a\u0014\u0001A\u0003&\u00111I\u0001\u000ee\u0016\u001cx.\u001e:dK2K7\u000f\u001e\u0011)\u0007\u00055S\u000fC\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X\u0005y1/\u001e2nSN\u001c\u0018n\u001c8Ti\u0016\u00048/\u0006\u0002\u0002ZA1\u00111LA1\u0003Kj!!!\u0018\u000b\u0007\u0005}c*\u0001\u0006d_2dWm\u0019;j_:LA!a\u0019\u0002^\t\u00191+Z9\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b\u0003\u0003\u0015\u0019H/\u001a9t\u0013\u0011\ty'!\u001b\u0003/\u0011\u0013\u0018N^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8Ti\u0016\u0004\b\u0002CA:\u0001\u0001\u0006I!!\u0017\u0002!M,(-\\5tg&|gn\u0015;faN\u0004\u0003bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003s\n\u0001d\u0019:fCR,G\rU8e\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s+\t\tY\b\u0005\u0003w\u0003{:\u0016bAA@o\nq\u0011I]4v[\u0016tGoQ1qi>\u0014\bbCAB\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000b\u000bAd\u0019:fCR,G\rU8e\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s?\u0012*\u0017\u000fF\u0002n\u0003\u000fC\u0011\"]AA\u0003\u0003\u0005\r!a\u001f\t\u0011\u0005-\u0005\u0001)Q\u0005\u0003w\n\u0011d\u0019:fCR,G\rU8e\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8sA!Y\u0011q\u0012\u0001A\u0002\u0003\u0007I\u0011BAI\u0003y\u0019'/Z1uK\u0012\u0014Vm]8ve\u000e,7/\u0011:hk6,g\u000e^\"baR|'/\u0006\u0002\u0002\u0014B!a/! E\u0011-\t9\n\u0001a\u0001\u0002\u0004%I!!'\u0002E\r\u0014X-\u0019;fIJ+7o\\;sG\u0016\u001c\u0018I]4v[\u0016tGoQ1qi>\u0014x\fJ3r)\ri\u00171\u0014\u0005\nc\u0006U\u0015\u0011!a\u0001\u0003'C\u0001\"a(\u0001A\u0003&\u00111S\u0001 GJ,\u0017\r^3e%\u0016\u001cx.\u001e:dKN\f%oZ;nK:$8)\u00199u_J\u0004\u0003")
public class ClientSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_UID;
    private final String org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_API_VERSION;
    private final String org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_KIND;
    @Mock
    private KubernetesClient org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations;
    @Mock
    private PodResource<Pod, DoneablePod> org$apache$spark$deploy$k8s$submit$ClientSuite$$namedPods;
    @Mock
    private LoggingPodStatusWatcher org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher;
    @Mock
    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> org$apache$spark$deploy$k8s$submit$ClientSuite$$resourceList;
    private final Seq<DriverConfigurationStep> org$apache$spark$deploy$k8s$submit$ClientSuite$$submissionSteps;
    private ArgumentCaptor<Pod> org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor;
    private ArgumentCaptor<HasMetadata> org$apache$spark$deploy$k8s$submit$ClientSuite$$createdResourcesArgumentCaptor;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public String org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_UID() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_UID;
    }

    public String org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_API_VERSION() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_API_VERSION;
    }

    public String org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_KIND() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_KIND;
    }

    public KubernetesClient org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient;
    }

    private void org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient_$eq(KubernetesClient x$1) {
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient = x$1;
    }

    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations;
    }

    private void org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations_$eq(MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> x$1) {
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations = x$1;
    }

    public PodResource<Pod, DoneablePod> org$apache$spark$deploy$k8s$submit$ClientSuite$$namedPods() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$namedPods;
    }

    private void org$apache$spark$deploy$k8s$submit$ClientSuite$$namedPods_$eq(PodResource<Pod, DoneablePod> x$1) {
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$namedPods = x$1;
    }

    public LoggingPodStatusWatcher org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher;
    }

    private void org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher_$eq(LoggingPodStatusWatcher x$1) {
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher = x$1;
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> org$apache$spark$deploy$k8s$submit$ClientSuite$$resourceList() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$resourceList;
    }

    private void org$apache$spark$deploy$k8s$submit$ClientSuite$$resourceList_$eq(NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Object> x$1) {
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$resourceList = x$1;
    }

    public Seq<DriverConfigurationStep> org$apache$spark$deploy$k8s$submit$ClientSuite$$submissionSteps() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$submissionSteps;
    }

    public ArgumentCaptor<Pod> org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor;
    }

    public void org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor_$eq(ArgumentCaptor<Pod> x$1) {
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor = x$1;
    }

    public ArgumentCaptor<HasMetadata> org$apache$spark$deploy$k8s$submit$ClientSuite$$createdResourcesArgumentCaptor() {
        return this.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdResourcesArgumentCaptor;
    }

    public void org$apache$spark$deploy$k8s$submit$ClientSuite$$createdResourcesArgumentCaptor_$eq(ArgumentCaptor<HasMetadata> x$1) {
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdResourcesArgumentCaptor = x$1;
    }

    public ClientSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_UID = "pod-id";
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_API_VERSION = "v1";
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_KIND = "pod";
        this.org$apache$spark$deploy$k8s$submit$ClientSuite$$submissionSteps = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DriverConfigurationStep[]{FirstTestConfigurationStep$.MODULE$, SecondTestConfigurationStep$.MODULE$}));
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSuite $outer;

            public final NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> apply() {
                MockitoAnnotations.initMocks((Object)((Object)this.$outer));
                Mockito.when((Object)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient().pods()).thenReturn(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations());
                Mockito.when((Object)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations().withName(FirstTestConfigurationStep$.MODULE$.podName())).thenReturn(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$namedPods());
                this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor_$eq((ArgumentCaptor<Pod>)ArgumentCaptor.forClass(Pod.class));
                this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdResourcesArgumentCaptor_$eq((ArgumentCaptor<HasMetadata>)ArgumentCaptor.forClass(HasMetadata.class));
                Mockito.when((Object)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations().create((Object[])new Pod[]{(Pod)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor().capture()})).thenAnswer((Answer)new Answer<Pod>(this){
                    private final /* synthetic */ $anonfun$3 $outer;

                    public Pod answer(InvocationOnMock invocation) {
                        return ((PodBuilder)((PodFluentImpl)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder((Pod)invocation.getArgumentAt(0, Pod.class)).editMetadata().withUid(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer().org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_UID())).endMetadata()).withApiVersion(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer().org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_API_VERSION())).withKind(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer().org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_KIND())).build();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Mockito.when((Object)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$podOperations().withName(FirstTestConfigurationStep$.MODULE$.podName())).thenReturn(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$namedPods());
                Mockito.when((Object)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$namedPods().watch((Object)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher())).thenReturn(MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Watch.class)));
                return ((KubernetesClient)Mockito.doReturn(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$resourceList()).when((Object)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient())).resourceList(new HasMetadata[]{(HasMetadata)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdResourcesArgumentCaptor().capture()});
            }

            public /* synthetic */ ClientSuite org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("The client should configure the pod with the submission steps.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSuite $outer;

            public final Assertion apply() {
                Client submissionClient = new Client(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$submissionSteps(), new SparkConf(false), this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient(), false, "spark", this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher());
                submissionClient.run();
                Pod createdPod = (Pod)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor().getValue();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(createdPod.getMetadata().getName());
                String $org_scalatest_assert_macro_right = FirstTestConfigurationStep$.MODULE$.podName();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(createdPod.getMetadata().getLabels()).asScala());
                Map $org_scalatest_assert_macro_right2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FirstTestConfigurationStep$.MODULE$.labelKey()), (Object)FirstTestConfigurationStep$.MODULE$.labelValue())}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(createdPod.getMetadata().getAnnotations()).asScala());
                Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecondTestConfigurationStep$.MODULE$.annotationKey()), (Object)SecondTestConfigurationStep$.MODULE$.annotationValue())}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)createdPod.getSpec().getContainers().size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(((Container)createdPod.getSpec().getContainers().get(0)).getName());
                String $org_scalatest_assert_macro_right5 = SecondTestConfigurationStep$.MODULE$.containerName();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("The client should create the secondary Kubernetes resources.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSuite $outer;

            public final Assertion apply() {
                Client submissionClient = new Client(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$submissionSteps(), new SparkConf(false), this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient(), false, "spark", this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher());
                submissionClient.run();
                Pod createdPod = (Pod)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor().getValue();
                List otherCreatedResources = this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdResourcesArgumentCaptor().getAllValues();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)otherCreatedResources.size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                Secret createdResource = (Secret)Iterables.getOnlyElement((Iterable)otherCreatedResources);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(createdResource.getMetadata().getName());
                String $org_scalatest_assert_macro_right2 = FirstTestConfigurationStep$.MODULE$.secretName();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(createdResource.getData()).asScala());
                Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FirstTestConfigurationStep$.MODULE$.secretKey()), (Object)FirstTestConfigurationStep$.MODULE$.secretData())}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
                OwnerReference ownerReference = (OwnerReference)Iterables.getOnlyElement((Iterable)createdResource.getMetadata().getOwnerReferences());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(ownerReference.getName());
                String $org_scalatest_assert_macro_right4 = createdPod.getMetadata().getName();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(ownerReference.getKind());
                String $org_scalatest_assert_macro_right5 = this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_KIND();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(ownerReference.getUid());
                String $org_scalatest_assert_macro_right6 = this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_UID();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(ownerReference.getApiVersion());
                String $org_scalatest_assert_macro_right7 = this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$DRIVER_POD_API_VERSION();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("The client should attach the driver container with the appropriate JVM options.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf sparkConf = new SparkConf(false).set("spark.logConf", "true").set(package$.MODULE$.DRIVER_JAVA_OPTIONS(), (Object)"-XX:+HeapDumpOnOutOfMemoryError -XX:+PrintGCDetails");
                Client submissionClient = new Client(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$submissionSteps(), sparkConf, this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient(), false, "spark", this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher());
                submissionClient.run();
                Pod createdPod = (Pod)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$createdPodArgumentCaptor().getValue();
                Container driverContainer = (Container)Iterables.getOnlyElement((Iterable)createdPod.getSpec().getContainers());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(driverContainer.getName());
                String $org_scalatest_assert_macro_right = SecondTestConfigurationStep$.MODULE$.containerName();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                Buffer driverJvmOptsEnvs = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(driverContainer.getEnv()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(EnvVar env) {
                        return env.getName().startsWith(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX());
                    }
                })).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(EnvVar x$1) {
                        return x$1.getName();
                    }
                }, (Ordering)Ordering.String$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)driverJvmOptsEnvs.size()));
                int $org_scalatest_assert_macro_right2 = 4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
                Seq expectedJvmOptsValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Dspark.logConf=true", new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SecondTestConfigurationStep$.MODULE$.sparkConfKey()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SecondTestConfigurationStep$.MODULE$.sparkConfValue()}))).toString(), "-XX:+HeapDumpOnOutOfMemoryError", "-XX:+PrintGCDetails"}));
                ((IterableLike)((IterableLike)driverJvmOptsEnvs.zip((GenIterable)expectedJvmOptsValues, Buffer$.MODULE$.canBuildFrom())).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Assertion apply(Tuple2<Tuple2<EnvVar, String>, Object> x0$1) {
                        Tuple2<Tuple2<EnvVar, String>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            if (tuple22 != null) {
                                EnvVar resolvedEnv = (EnvVar)tuple22._1();
                                String expectedJvmOpt = (String)tuple22._2();
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer().convertToEqualizer(resolvedEnv.getName());
                                String $org_scalatest_assert_macro_right = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.ENV_JAVA_OPT_PREFIX(), BoxesRunTime.boxToInteger((int)index)}));
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer().convertToEqualizer(resolvedEnv.getValue());
                                String $org_scalatest_assert_macro_right2 = expectedJvmOpt;
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                Assertion assertion = this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                                return assertion;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ClientSuite org$apache$spark$deploy$k8s$submit$ClientSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("Waiting for app completion should stall on the watcher", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Client submissionClient = new Client(this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$submissionSteps(), new SparkConf(false), this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$kubernetesClient(), true, "spark", this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher());
                submissionClient.run();
                ((LoggingPodStatusWatcher)Mockito.verify((Object)this.$outer.org$apache$spark$deploy$k8s$submit$ClientSuite$$loggingPodStatusWatcher())).awaitCompletion();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
    }
}

