/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io.cloud;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.spark.sql.execution.streaming.AbstractFileContextBasedCheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\n\u0014\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)q\b\u0001C\u0001\u0001\u001a!Q\t\u0001\u0001G\u0011%iFA!A!\u0002\u0013q\u0016\r\u0003\u0005d\t\t\u0005\t\u0015!\u0003e\u0011!yCA!A!\u0002\u0013\u0001\u0004\u0002C4\u0005\u0005\u0003\u0005\u000b\u0011\u00025\t\u000b}\"A\u0011\u00018\t\u000fU$\u0001\u0019!C\u0005m\"9q\u000f\u0002a\u0001\n\u0013A\bB\u0002@\u0005A\u0003&\u0001\u000eC\u0004\u0002\b\u0011!\t%!\u0003\t\u000f\u0005-A\u0001\"\u0011\u0002\n!9\u0011Q\u0002\u0003\u0005B\u0005=\u0001\"DA\u0011\tA\u0005\u0019\u0011!A\u0005\n\u0005\r\u0012\rC\u0004\u00024\u0001!\t%!\u000e\u0003S\u0005\u0013wN\u001d;bE2,7\u000b\u001e:fC6\u0014\u0015m]3e\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s\u0015\t!R#A\u0003dY>,HM\u0003\u0002\u0017/\u0005\u0011\u0011n\u001c\u0006\u00031e\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"WA\u0011!%K\u0007\u0002G)\u0011A%J\u0001\ngR\u0014X-Y7j]\u001eT!AJ\u0014\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0015\u001a\u0003\r\u0019\u0018\u000f\\\u0005\u0003U\r\u0012Q&\u00112tiJ\f7\r\u001e$jY\u0016\u001cuN\u001c;fqR\u0014\u0015m]3e\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s!\taS&D\u0001\u0018\u0013\tqsCA\u0004M_\u001e<\u0017N\\4\u0002\tA\fG\u000f\u001b\t\u0003cYj\u0011A\r\u0006\u0003gQ\n!AZ:\u000b\u0005UZ\u0012A\u00025bI>|\u0007/\u0003\u00028e\t!\u0001+\u0019;i\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003yQ\nAaY8oM&\u0011ah\u000f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r\t5\t\u0012\t\u0003\u0005\u0002i\u0011a\u0005\u0005\u0006_\r\u0001\r\u0001\r\u0005\u0006q\r\u0001\r!\u000f\u0002'\u0003\n|'\u000f^1cY\u0016\u001cFO]3b[\n\u000b7/\u001a3G'\u0012\u000bG/Y(viB,Ho\u0015;sK\u0006l7C\u0001\u0003H!\tA%L\u0004\u0002J1:\u0011!j\u0016\b\u0003\u0017Zs!\u0001T+\u000f\u00055#fB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tv$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A$H\u0005\u00035mI!\u0001K\r\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\tI6%A\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\n\u0005mc&!H\"b]\u000e,G\u000e\\1cY\u001645\u000bR1uC>+H\u000f];u'R\u0014X-Y7\u000b\u0005e\u001b\u0013A\u00054t\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6\u0004\"!M0\n\u0005\u0001\u0014$A\u0005$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6L!A\u0019.\u0002!UtG-\u001a:ms&twm\u0015;sK\u0006l\u0017A\u00014d!\t\tT-\u0003\u0002ge\tYa)\u001b7f\u0007>tG/\u001a=u\u0003Myg/\u001a:xe&$X-\u00134Q_N\u001c\u0018N\u00197f!\tIG.D\u0001k\u0015\u0005Y\u0017!B:dC2\f\u0017BA7k\u0005\u001d\u0011un\u001c7fC:$Ra\\9sgR\u0004\"\u0001\u001d\u0003\u000e\u0003\u0001AQ!X\u0005A\u0002yCQaY\u0005A\u0002\u0011DQaL\u0005A\u0002ABQaZ\u0005A\u0002!\f!\u0002^3s[&t\u0017\r^3e+\u0005A\u0017A\u0004;fe6Lg.\u0019;fI~#S-\u001d\u000b\u0003sr\u0004\"!\u001b>\n\u0005mT'\u0001B+oSRDq!`\u0006\u0002\u0002\u0003\u0007\u0001.A\u0002yIE\n1\u0002^3s[&t\u0017\r^3eA!\u001aA\"!\u0001\u0011\u0007%\f\u0019!C\u0002\u0002\u0006)\u0014\u0001B^8mCRLG.Z\u0001\u0007G\u0006t7-\u001a7\u0015\u0003e\fQa\u00197pg\u0016\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001c9!\u0011QCA\f!\ty%.C\u0002\u0002\u001a)\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u000f\u0003?\u0011aa\u0015;sS:<'bAA\rU\u000612/\u001e9fe\u0012*h\u000eZ3sYfLgnZ*ue\u0016\fW.\u0006\u0002\u0002&A!\u0011qEA\u0018\u001b\t\tICC\u0002\u0017\u0003WQ!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\tIC\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0007de\u0016\fG/Z!u_6L7\rF\u0003H\u0003o\tI\u0004C\u00030#\u0001\u0007\u0001\u0007C\u0003h#\u0001\u0007\u0001\u000e")
public class AbortableStreamBasedCheckpointFileManager
extends AbstractFileContextBasedCheckpointFileManager {
    private final Path path;

    public CheckpointFileManager.CancellableFSDataOutputStream createAtomic(Path path, boolean overwriteIfPossible) {
        EnumSet<CreateFlag> createFlag = overwriteIfPossible ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE);
        return new AbortableStreamBasedFSDataOutputStream(this, this.fc().create(path, createFlag, new Options.CreateOpts[0]), this.fc(), path, overwriteIfPossible);
    }

    public AbortableStreamBasedCheckpointFileManager(Path path, Configuration hadoopConf) {
        this.path = path;
        super(path, hadoopConf);
        if (!this.fc().hasPathCapability(path, "fs.capability.outputstream.abortable")) {
            throw new UnsupportedFileSystemException(new StringBuilder(50).append("AbortableStreamBasedCheckpointFileManager requires").append(new StringBuilder(45).append(" an fs (path: ").append(path).append(") with abortable stream support").toString()).toString());
        }
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(48).append("Writing atomically to ").append($this.path).append(" based on abortable stream").toString());
    }

    public class AbortableStreamBasedFSDataOutputStream
    extends CheckpointFileManager.CancellableFSDataOutputStream {
        private final FileContext fc;
        private final Path path;
        private final boolean overwriteIfPossible;
        private volatile boolean terminated;
        public final /* synthetic */ AbortableStreamBasedCheckpointFileManager $outer;

        private /* synthetic */ OutputStream super$underlyingStream() {
            return super.underlyingStream();
        }

        private boolean terminated() {
            return this.terminated;
        }

        private void terminated_$eq(boolean x$1) {
            this.terminated = x$1;
        }

        public synchronized void cancel() {
            block7: {
                if (this.terminated()) {
                    return;
                }
                try {
                    try {
                        ((FSDataOutputStream)super.underlyingStream()).abort();
                        ((FSDataOutputStream)super.underlyingStream()).close();
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().logWarning((Function0 & Serializable)() -> new StringBuilder(37).append("Error cancelling write to ").append($this.path).append(" (stream: ").append((FSDataOutputStream)this.super$underlyingStream()).append(")").toString(), e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.terminated_$eq(true);
                }
            }
        }

        public synchronized void close() {
            block8: {
                if (this.terminated()) {
                    return;
                }
                try {
                    try {
                        if (!this.overwriteIfPossible && this.fc.util().exists(this.path)) {
                            ((FSDataOutputStream)super.underlyingStream()).abort();
                            throw new FileAlreadyExistsException(new StringBuilder(0).append(new StringBuilder(40).append("Failed to close atomic stream ").append(this.path).append(" (stream: ").toString()).append(new StringBuilder(31).append((FSDataOutputStream)super.underlyingStream()).append(") as destination already exists").toString()).toString());
                        }
                        ((FSDataOutputStream)super.underlyingStream()).close();
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().logWarning((Function0 & Serializable)() -> new StringBuilder(25).append("Error closing ").append($this.path).append(" (stream: ").append((FSDataOutputStream)this.super$underlyingStream()).append(")").toString(), e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block8;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.terminated_$eq(true);
                }
            }
        }

        public String toString() {
            return ((FSDataOutputStream)super.underlyingStream()).toString();
        }

        public /* synthetic */ AbortableStreamBasedCheckpointFileManager org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer() {
            return this.$outer;
        }

        public AbortableStreamBasedFSDataOutputStream(AbortableStreamBasedCheckpointFileManager $outer, FSDataOutputStream fsDataOutputStream, FileContext fc, Path path, boolean overwriteIfPossible) {
            this.fc = fc;
            this.path = path;
            this.overwriteIfPossible = overwriteIfPossible;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super((OutputStream)fsDataOutputStream);
            this.terminated = false;
        }
    }
}

