/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.jdbc.DatabaseOnDocker;
import org.apache.spark.sql.jdbc.DockerJDBCIntegrationSuite;
import org.apache.spark.sql.jdbc.MySQLIntegrationSuite$;
import org.apache.spark.tags.DockerTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DockerTest
@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001b\t)R*_*R\u0019&sG/Z4sCRLwN\\*vSR,'BA\u0002\u0005\u0003\u0011QGMY2\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005i!unY6fe*#%iQ%oi\u0016<'/\u0019;j_:\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0010\u0001!9q\u0003\u0001b\u0001\n\u0003B\u0012A\u00013c+\u0005I\u0002CA\b\u001b\u0013\tY\"A\u0001\tECR\f'-Y:f\u001f:$unY6fe\"1Q\u0004\u0001Q\u0001\ne\t1\u0001\u001a2!\u0011\u0015y\u0002\u0001\"\u0011!\u0003=!\u0017\r^1Qe\u0016\u0004\u0018M]1uS>tGCA\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;\t\u000b!r\u0002\u0019A\u0015\u0002\t\r|gN\u001c\t\u0003U9j\u0011a\u000b\u0006\u0003\u000b1R\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020W\tQ1i\u001c8oK\u000e$\u0018n\u001c8)\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0007\u0003\u0011!\u0018mZ:\n\u0005Y\u001a$A\u0003#pG.,'\u000fV3ti\u0002")
public class MySQLIntegrationSuite
extends DockerJDBCIntegrationSuite {
    private final DatabaseOnDocker db = new $anon$1(this);

    @Override
    public DatabaseOnDocker db() {
        return this.db;
    }

    @Override
    public void dataPreparation(Connection conn) {
        conn.prepareStatement("CREATE DATABASE foo").executeUpdate();
        conn.prepareStatement("CREATE TABLE tbl (x INTEGER, y TEXT(8))").executeUpdate();
        conn.prepareStatement("INSERT INTO tbl VALUES (42,'fred')").executeUpdate();
        conn.prepareStatement("INSERT INTO tbl VALUES (17,'dave')").executeUpdate();
        conn.prepareStatement("CREATE TABLE numbers (onebit BIT(1), tenbits BIT(10), small SMALLINT, med MEDIUMINT, nor INT, big BIGINT, deci DECIMAL(40,20), flt FLOAT, dbl DOUBLE)").executeUpdate();
        conn.prepareStatement("INSERT INTO numbers VALUES (b'0', b'1000100101', 17, 77777, 123456789, 123456789012345, 123456789012345.123456789012345, 42.75, 1.0000000000000002)").executeUpdate();
        conn.prepareStatement("CREATE TABLE dates (d DATE, t TIME, dt DATETIME, ts TIMESTAMP, yr YEAR)").executeUpdate();
        conn.prepareStatement("INSERT INTO dates VALUES ('1991-11-09', '13:31:24', '1996-01-01 01:23:45', '2009-02-13 23:31:30', '2001')").executeUpdate();
        conn.prepareStatement("CREATE TABLE strings (a CHAR(10), b VARCHAR(10), c TINYTEXT, d TEXT, e MEDIUMTEXT, f LONGTEXT, g BINARY(4), h VARBINARY(10), i BLOB)").executeUpdate();
        conn.prepareStatement("INSERT INTO strings VALUES ('the', 'quick', 'brown', 'fox', 'jumps', 'over', 'the', 'lazy', 'dog')").executeUpdate();
    }

    public MySQLIntegrationSuite() {
        this.test("Basic test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLIntegrationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq types;
                Row[] rows;
                DataFrame df = this.$outer.sqlContext().read().jdbc(this.$outer.jdbcUrl(), "tbl", new Properties());
                Row[] $org_scalatest_assert_macro_left = rows = df.collect();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq $org_scalatest_assert_macro_left2 = types = (Seq)rows[0].toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x) {
                        return x.getClass().toString();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (long)$org_scalatest_assert_macro_left2.length(), (long)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(0)).equals("class java.lang.Integer"), "types.apply(0).equals(\"class java.lang.Integer\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(1)).equals("class java.lang.String"), "types.apply(1).equals(\"class java.lang.String\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Numeric types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLIntegrationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq types;
                Row[] rows;
                DataFrame df = this.$outer.sqlContext().read().jdbc(this.$outer.jdbcUrl(), "numbers", new Properties());
                Row[] $org_scalatest_assert_macro_left = rows = df.collect();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq $org_scalatest_assert_macro_left2 = types = (Seq)rows[0].toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x) {
                        return x.getClass().toString();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                int $org_scalatest_assert_macro_right2 = 9;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (long)$org_scalatest_assert_macro_left2.length(), (long)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(0)).equals("class java.lang.Boolean"), "types.apply(0).equals(\"class java.lang.Boolean\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(1)).equals("class java.lang.Long"), "types.apply(1).equals(\"class java.lang.Long\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(2)).equals("class java.lang.Integer"), "types.apply(2).equals(\"class java.lang.Integer\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(3)).equals("class java.lang.Integer"), "types.apply(3).equals(\"class java.lang.Integer\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(4)).equals("class java.lang.Integer"), "types.apply(4).equals(\"class java.lang.Integer\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(5)).equals("class java.lang.Long"), "types.apply(5).equals(\"class java.lang.Long\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(6)).equals("class java.math.BigDecimal"), "types.apply(6).equals(\"class java.math.BigDecimal\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(7)).equals("class java.lang.Double"), "types.apply(7).equals(\"class java.lang.Double\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(8)).equals("class java.lang.Double"), "types.apply(8).equals(\"class java.lang.Double\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                boolean $org_scalatest_assert_macro_left3 = rows[0].getBoolean(0);
                boolean $org_scalatest_assert_macro_right3 = false;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                long $org_scalatest_assert_macro_left4 = rows[0].getLong(1);
                int $org_scalatest_assert_macro_right4 = 549;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                int $org_scalatest_assert_macro_left5 = rows[0].getInt(2);
                int $org_scalatest_assert_macro_right5 = 17;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                int $org_scalatest_assert_macro_left6 = rows[0].getInt(3);
                int $org_scalatest_assert_macro_right6 = 77777;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                int $org_scalatest_assert_macro_left7 = rows[0].getInt(4);
                int $org_scalatest_assert_macro_right7 = 123456789;
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                long $org_scalatest_assert_macro_left8 = rows[0].getLong(5);
                long $org_scalatest_assert_macro_right8 = 123456789012345L;
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                BigDecimal bd = new BigDecimal("123456789012345.12345678901234500000");
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(((BigDecimal)rows[0].getAs(6)).equals(bd), "rows.apply(0).getAs[java.math.BigDecimal](6).equals(bd)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                double $org_scalatest_assert_macro_left9 = rows[0].getDouble(7);
                double $org_scalatest_assert_macro_right9 = 42.75;
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                double $org_scalatest_assert_macro_left10 = rows[0].getDouble(8);
                double $org_scalatest_assert_macro_right10 = 1.0000000000000002;
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Date types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLIntegrationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq types;
                Row[] rows;
                DataFrame df = this.$outer.sqlContext().read().jdbc(this.$outer.jdbcUrl(), "dates", new Properties());
                Row[] $org_scalatest_assert_macro_left = rows = df.collect();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq $org_scalatest_assert_macro_left2 = types = (Seq)rows[0].toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x) {
                        return x.getClass().toString();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                int $org_scalatest_assert_macro_right2 = 5;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (long)$org_scalatest_assert_macro_left2.length(), (long)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(0)).equals("class java.sql.Date"), "types.apply(0).equals(\"class java.sql.Date\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(1)).equals("class java.sql.Timestamp"), "types.apply(1).equals(\"class java.sql.Timestamp\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(2)).equals("class java.sql.Timestamp"), "types.apply(2).equals(\"class java.sql.Timestamp\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(3)).equals("class java.sql.Timestamp"), "types.apply(3).equals(\"class java.sql.Timestamp\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(4)).equals("class java.sql.Date"), "types.apply(4).equals(\"class java.sql.Date\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(((java.util.Date)rows[0].getAs(0)).equals(Date.valueOf("1991-11-09")), "rows.apply(0).getAs[java.sql.Date](0).equals(java.sql.Date.valueOf(\"1991-11-09\"))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((Timestamp)rows[0].getAs(1)).equals(Timestamp.valueOf("1970-01-01 13:31:24")), "rows.apply(0).getAs[java.sql.Timestamp](1).equals(java.sql.Timestamp.valueOf(\"1970-01-01 13:31:24\"))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(((Timestamp)rows[0].getAs(2)).equals(Timestamp.valueOf("1996-01-01 01:23:45")), "rows.apply(0).getAs[java.sql.Timestamp](2).equals(java.sql.Timestamp.valueOf(\"1996-01-01 01:23:45\"))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(((Timestamp)rows[0].getAs(3)).equals(Timestamp.valueOf("2009-02-13 23:31:30")), "rows.apply(0).getAs[java.sql.Timestamp](3).equals(java.sql.Timestamp.valueOf(\"2009-02-13 23:31:30\"))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(((java.util.Date)rows[0].getAs(4)).equals(Date.valueOf("2001-01-01")), "rows.apply(0).getAs[java.sql.Date](4).equals(java.sql.Date.valueOf(\"2001-01-01\"))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("String types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLIntegrationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq types;
                Row[] rows;
                DataFrame df = this.$outer.sqlContext().read().jdbc(this.$outer.jdbcUrl(), "strings", new Properties());
                Row[] $org_scalatest_assert_macro_left = rows = df.collect();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq $org_scalatest_assert_macro_left2 = types = (Seq)rows[0].toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x) {
                        return x.getClass().toString();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                int $org_scalatest_assert_macro_right2 = 9;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (long)$org_scalatest_assert_macro_left2.length(), (long)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(0)).equals("class java.lang.String"), "types.apply(0).equals(\"class java.lang.String\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(1)).equals("class java.lang.String"), "types.apply(1).equals(\"class java.lang.String\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(2)).equals("class java.lang.String"), "types.apply(2).equals(\"class java.lang.String\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(3)).equals("class java.lang.String"), "types.apply(3).equals(\"class java.lang.String\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(4)).equals("class java.lang.String"), "types.apply(4).equals(\"class java.lang.String\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(5)).equals("class java.lang.String"), "types.apply(5).equals(\"class java.lang.String\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(6)).equals("class [B"), "types.apply(6).equals(\"class [B\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(7)).equals("class [B"), "types.apply(7).equals(\"class [B\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(((String)types.apply(8)).equals("class [B"), "types.apply(8).equals(\"class [B\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(0).equals("the"), "rows.apply(0).getString(0).equals(\"the\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(1).equals("quick"), "rows.apply(0).getString(1).equals(\"quick\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(2).equals("brown"), "rows.apply(0).getString(2).equals(\"brown\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(3).equals("fox"), "rows.apply(0).getString(3).equals(\"fox\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(4).equals("jumps"), "rows.apply(0).getString(4).equals(\"jumps\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(rows[0].getString(5).equals("over"), "rows.apply(0).getString(5).equals(\"over\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(Arrays.equals((byte[])rows[0].getAs(6), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{116, 104, 101, 0}), ClassTag$.MODULE$.Byte())), "java.util.Arrays.equals(rows.apply(0).getAs[Array[Byte]](6), scala.Array.apply[Byte](116, 104, 101, 0)(ClassTag.Byte))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(Arrays.equals((byte[])rows[0].getAs(7), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{108, 97, 122, 121}), ClassTag$.MODULE$.Byte())), "java.util.Arrays.equals(rows.apply(0).getAs[Array[Byte]](7), scala.Array.apply[Byte](108, 97, 122, 121)(ClassTag.Byte))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(Arrays.equals((byte[])rows[0].getAs(8), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{100, 111, 103}), ClassTag$.MODULE$.Byte())), "java.util.Arrays.equals(rows.apply(0).getAs[Array[Byte]](8), scala.Array.apply[Byte](100, 111, 103)(ClassTag.Byte))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Basic write test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLIntegrationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DataFrame df1 = this.$outer.sqlContext().read().jdbc(this.$outer.jdbcUrl(), "numbers", new Properties());
                DataFrame df2 = this.$outer.sqlContext().read().jdbc(this.$outer.jdbcUrl(), "dates", new Properties());
                DataFrame df3 = this.$outer.sqlContext().read().jdbc(this.$outer.jdbcUrl(), "strings", new Properties());
                df1.write().jdbc(this.$outer.jdbcUrl(), "numberscopy", new Properties());
                df2.write().jdbc(this.$outer.jdbcUrl(), "datescopy", new Properties());
                df3.write().jdbc(this.$outer.jdbcUrl(), "stringscopy", new Properties());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

