/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.spark.sql.connect.client.Artifact$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\u0013'\u0001MB\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005y!Aq\t\u0001BC\u0002\u0013\u0005\u0001\nC\u0005\u0002x\u0001\u0011\t\u0011)A\u0005\u0013\"1q\n\u0001C\u0005\u0003sB\u0001B\u001e\u0001\t\u0006\u0004%\ta^\u0004\u0006\u0019\u001aB\t!\u0014\u0004\u0006K\u0019B\tA\u0014\u0005\u0006\u001f\"!\t\u0001\u0015\u0005\b#\"\u0011\r\u0011\"\u0001<\u0011\u0019\u0011\u0006\u0002)A\u0005y!91\u000b\u0003b\u0001\n\u0003Y\u0004B\u0002+\tA\u0003%A\bC\u0004V\u0011\t\u0007I\u0011A\u001e\t\rYC\u0001\u0015!\u0003=\u0011\u00159\u0006\u0002\"\u0001Y\u0011\u001d\tY\u0002\u0003C\u0001\u0003;Aq!a\t\t\t\u0003\t)\u0003C\u0004\u0002,!!\t!!\f\t\u000f\u0005U\u0002\u0002\"\u0001\u00028!9\u00111\f\u0005\u0005\n\u0005u\u0003bBA4\u0011\u0011%\u0011\u0011\u000e\u0004\bY\"\u0001\n1%\tn\u0011\u0015qwC\"\u0001p\u0011\u00151xC\"\u0001x\r\u0019\t\t\u0002\u0003\u0001\u0002\u0014!A!H\u0007BC\u0002\u0013\u00051\b\u0003\u0005G5\t\u0005\t\u0015!\u0003=\u0011\u0019y%\u0004\"\u0001\u0002\u0016!)aO\u0007C!o\")aN\u0007C!_\u001a!A\u0010\u0003\u0001~\u0011!q\bE!A!\u0002\u0013y\bBB(!\t\u0003\tY\u0001C\u0003wA\u0011\u0005s\u000fC\u0003oA\u0011\u0005sN\u0001\u0005BeRLg-Y2u\u0015\t9\u0003&\u0001\u0004dY&,g\u000e\u001e\u0006\u0003S)\nqaY8o]\u0016\u001cGO\u0003\u0002,Y\u0005\u00191/\u001d7\u000b\u00055r\u0013!B:qCJ\\'BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001iA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t1\u0011I\\=SK\u001a\fA\u0001]1uQV\tA\b\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006!a-\u001b7f\u0015\t\t%)A\u0002oS>T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F}\t!\u0001+\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u0003\u001d\u0019Ho\u001c:bO\u0016,\u0012!\u0013\t\u0003\u0015^q!aS\u0004\u000e\u0003\u0019\n\u0001\"\u0011:uS\u001a\f7\r\u001e\t\u0003\u0017\"\u0019\"\u0001\u0003\u001b\u0002\rqJg.\u001b;?)\u0005i\u0015\u0001D\"M\u0003N\u001bv\f\u0015*F\r&C\u0016!D\"M\u0003N\u001bv\f\u0015*F\r&C\u0006%\u0001\u0006K\u0003J{\u0006KU#G\u0013b\u000b1BS!S?B\u0013VIR%YA\u0005a1)Q\"I\u000b~\u0003&+\u0012$J1\u0006i1)Q\"I\u000b~\u0003&+\u0012$J1\u0002\n\u0001D\\3x\u0003J$\u0018NZ1di\u001a\u0013x.\\#yi\u0016t7/[8o)\u0011I&lZ5\u0011\u0005-\u0003\u0001\"B.\u0011\u0001\u0004a\u0016\u0001\u00034jY\u0016t\u0015-\\3\u0011\u0005u#gB\u00010c!\tyf'D\u0001a\u0015\t\t''\u0001\u0004=e>|GOP\u0005\u0003GZ\na\u0001\u0015:fI\u00164\u0017BA3g\u0005\u0019\u0019FO]5oO*\u00111M\u000e\u0005\u0006QB\u0001\r\u0001P\u0001\u000fi\u0006\u0014x-\u001a;GS2,\u0007+\u0019;i\u0011\u00159\u0005\u00031\u0001k!\tYw#D\u0001\t\u0005%aunY1m\t\u0006$\u0018m\u0005\u0002\u0018i\u000511\u000f\u001e:fC6,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g\n\u000b!![8\n\u0005U\u0014(aC%oaV$8\u000b\u001e:fC6\fAa]5{KV\t\u0001\u0010\u0005\u00026s&\u0011!P\u000e\u0002\u0005\u0019>tw-K\u0002\u0018Ai\u0011\u0001\"\u00138NK6|'/_\n\u0004AQR\u0017!\u00022zi\u0016\u001c\b#B\u001b\u0002\u0002\u0005\u0015\u0011bAA\u0002m\t)\u0011I\u001d:bsB\u0019Q'a\u0002\n\u0007\u0005%aG\u0001\u0003CsR,G\u0003BA\u0007\u0003\u001f\u0001\"a\u001b\u0011\t\u000by\u0014\u0003\u0019A@\u0003\u00131{7-\u00197GS2,7c\u0001\u000e5UR!\u0011qCA\r!\tY'\u0004C\u0003;;\u0001\u0007A(\u0001\boK^T\u0015M]!si&4\u0017m\u0019;\u0015\u000be\u000by\"!\t\t\u000b!\f\u0002\u0019\u0001\u001f\t\u000b\u001d\u000b\u0002\u0019\u00016\u0002!9,wo\u00117bgN\f%\u000f^5gC\u000e$H#B-\u0002(\u0005%\u0002\"\u00025\u0013\u0001\u0004a\u0004\"B$\u0013\u0001\u0004Q\u0017\u0001\u00058fo\u000e\u000b7\r[3BeRLg-Y2u)\u0015I\u0016qFA\u001a\u0011\u0019\t\td\u0005a\u00019\u0006\u0011\u0011\u000e\u001a\u0005\u0006\u000fN\u0001\rA[\u0001\u0010]\u0016<\u0018J^=BeRLg-Y2ugR!\u0011\u0011HA&!\u0015\tY$!\u0012Z\u001d\u0011\ti$!\u0011\u000f\u0007}\u000by$C\u00018\u0013\r\t\u0019EN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9%!\u0013\u0003\u0007M+\u0017OC\u0002\u0002DYBq!!\u0014\u0015\u0001\u0004\ty%A\u0002ve&\u0004B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+\u0012\u0015a\u00018fi&!\u0011\u0011LA*\u0005\r)&+S\u0001\u0011G>t7-\u0019;f]\u0006$X\rU1uQN$R\u0001PA0\u0003GBa!!\u0019\u0016\u0001\u0004a\u0014\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\t\r\u0005\u0015T\u00031\u0001=\u0003%yG\u000f[3s!\u0006$\b.A\u0006oK^\f%\u000f^5gC\u000e$H#C-\u0002l\u0005=\u00141OA;\u0011\u0019\tiG\u0006a\u0001y\u00051\u0001O]3gSbDa!!\u001d\u0017\u0001\u0004a\u0016A\u0004:fcVL'/\u001a3Tk\u001a4\u0017\u000e\u001f\u0005\u0006QZ\u0001\r\u0001\u0010\u0005\u0006\u000fZ\u0001\rA[\u0001\tgR|'/Y4fAQ)\u0011,a\u001f\u0002~!)!(\u0002a\u0001y!)q)\u0002a\u0001\u0013\u0002")
public class Artifact {
    private long size;
    private final Path path;
    private final LocalData storage;
    private volatile boolean bitmap$0;

    public static Seq<Artifact> newIvyArtifacts(URI uri) {
        return Artifact$.MODULE$.newIvyArtifacts(uri);
    }

    public static Artifact newCacheArtifact(String id, LocalData storage) {
        return Artifact$.MODULE$.newCacheArtifact(id, storage);
    }

    public static Artifact newClassArtifact(Path targetFilePath, LocalData storage) {
        return Artifact$.MODULE$.newClassArtifact(targetFilePath, storage);
    }

    public static Artifact newJarArtifact(Path targetFilePath, LocalData storage) {
        return Artifact$.MODULE$.newJarArtifact(targetFilePath, storage);
    }

    public static Artifact newArtifactFromExtension(String fileName, Path targetFilePath, LocalData storage) {
        return Artifact$.MODULE$.newArtifactFromExtension(fileName, targetFilePath, storage);
    }

    public static Path CACHE_PREFIX() {
        return Artifact$.MODULE$.CACHE_PREFIX();
    }

    public static Path JAR_PREFIX() {
        return Artifact$.MODULE$.JAR_PREFIX();
    }

    public static Path CLASS_PREFIX() {
        return Artifact$.MODULE$.CLASS_PREFIX();
    }

    public Path path() {
        return this.path;
    }

    public LocalData storage() {
        return this.storage;
    }

    private long size$lzycompute() {
        Artifact artifact = this;
        synchronized (artifact) {
            if (!this.bitmap$0) {
                LocalData localData = this.storage();
                if (localData == null) {
                    throw new MatchError((Object)localData);
                }
                LocalData localData2 = localData;
                this.size = localData2.size();
                this.bitmap$0 = true;
            }
        }
        return this.size;
    }

    public long size() {
        if (!this.bitmap$0) {
            return this.size$lzycompute();
        }
        return this.size;
    }

    public Artifact(Path path, LocalData storage) {
        this.path = path;
        this.storage = storage;
        Predef$.MODULE$.require(!path.isAbsolute(), (Function0 & Serializable)() -> "Bad path: " + this.path());
    }

    public static class InMemory
    implements LocalData {
        private final byte[] bytes;

        @Override
        public long size() {
            return this.bytes.length;
        }

        @Override
        public InputStream stream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public InMemory(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    public static interface LocalData {
        public InputStream stream();

        public long size();
    }

    public static class LocalFile
    implements LocalData {
        private final Path path;

        public Path path() {
            return this.path;
        }

        @Override
        public long size() {
            return Files.size(this.path());
        }

        @Override
        public InputStream stream() {
            return Files.newInputStream(this.path(), new OpenOption[0]);
        }

        public LocalFile(Path path) {
            this.path = path;
        }
    }
}

