/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.connect.proto.ExamplePluginCommand;
import org.apache.spark.connect.proto.ExamplePluginExpression;
import org.apache.spark.connect.proto.ExamplePluginRelation;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.StorageLevel;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.PlanGenerationTestSuite$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.test.ConnectFunSuite;
import org.apache.spark.sql.test.IntegrationTestUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.util.SparkFileUtils$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.collection.mutable.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\t\re\u0001\u0002!B\u0001)CQA\u001a\u0001\u0005\u0002\u001dDqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004s\u0001\u0001\u0006I\u0001\u001c\u0005\bg\u0002\u0011\r\u0011\"\u0003l\u0011\u0019!\b\u0001)A\u0005Y\"9Q\u000f\u0001b\u0001\n#1\bbBA\u0002\u0001\u0001\u0006Ia\u001e\u0005\t\u0003\u000b\u0001!\u0019!C\tm\"9\u0011q\u0001\u0001!\u0002\u00139\b\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\t\t\u0005\u0001Q\u0001\n\u00055\u0001\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\t\t\u0006\u0001Q\u0001\n\u0005\u001d\u0003bCA*\u0001\u0001\u0007\t\u0019!C\u0005\u0003+B1\"!\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002`!Y\u00111\u000e\u0001A\u0002\u0003\u0005\u000b\u0015BA,\u0011\u001d\ti\u0007\u0001C)\u0003_Bq!!\u001d\u0001\t#\ny\u0007C\u0004\u0002t\u0001!\t&a\u001c\t\u000f\u0005U\u0004\u0001\"\u0003\u0002p!1a\u000b\u0001C\u0005\u0003oBq!a.\u0001\t\u0013\tI\fC\u0004\u0002P\u0002!I!!5\t\u0013\u0005e\u0007A1A\u0005\n\u0005m\u0007\u0002CAt\u0001\u0001\u0006I!!8\t\u0013\u0005%\bA1A\u0005\n\u0005-\b\u0002CA}\u0001\u0001\u0006I!!<\t\u0013\u0005m\bA1A\u0005\n\u0005u\b\u0002CA\u0000\u0001\u0001\u0006I!a*\t\u0013\t\u0005\u0001A1A\u0005\n\u0005-\b\u0002\u0003B\u0002\u0001\u0001\u0006I!!<\t\u0013\t\u0015\u0001A1A\u0005\n\u0005u\b\u0002\u0003B\u0004\u0001\u0001\u0006I!a*\t\u0013\t%\u0001A1A\u0005\n\u0005-\b\u0002\u0003B\u0006\u0001\u0001\u0006I!!<\t\u0013\t5\u0001A1A\u0005\n\u0005u\b\u0002\u0003B\b\u0001\u0001\u0006I!a*\t\u0013\tE\u0001A1A\u0005\n\u0005-\b\u0002\u0003B\n\u0001\u0001\u0006I!!<\t\u0013\tU\u0001A1A\u0005\n\u0005u\b\u0002\u0003B\f\u0001\u0001\u0006I!a*\t\u0013\te\u0001A1A\u0005\n\u0005-\b\u0002\u0003B\u000e\u0001\u0001\u0006I!!<\t\u0013\tu\u0001A1A\u0005\n\u0005u\b\u0002\u0003B\u0010\u0001\u0001\u0006I!a*\t\u0013\t\u0005\u0002A1A\u0005\n\u0005-\b\u0002\u0003B\u0012\u0001\u0001\u0006I!!<\t\u0013\t\u0015\u0002A1A\u0005\n\u0005u\b\u0002\u0003B\u0014\u0001\u0001\u0006I!a*\t\u000f\t%\u0002\u0001\"\u0003\u0003,!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B\"\u0001\u0011%!\u0011\t\u0005\b\u0005\u000b\u0002A\u0011\u0002B!\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0003BqA!\u0013\u0001\t\u0013\u0011\t\u0005C\u0004\u0003L\u0001!IA!\u0011\t\u000f\t5\u0003\u0001\"\u0003\u0003B!9!q\n\u0001\u0005\n\tE\u0003b\u0002B1\u0001\u0011%!1\r\u0005\b\u0005W\u0002A\u0011\u0002B7\u0011\u001d\u0011)\b\u0001C\u0005\u0005oB\u0011Ba \u0001\u0005\u0004%I!!@\t\u0011\t\u0005\u0005\u0001)A\u0005\u0003O\u0013q\u0003\u00157b]\u001e+g.\u001a:bi&|g\u000eV3tiN+\u0018\u000e^3\u000b\u0005\t\u001b\u0015aA:rY*\u0011A)R\u0001\u0006gB\f'o\u001b\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001Y5+W/a!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0005gk:\u001cX/\u001b;f\u0015\t\u0001v)A\u0005tG\u0006d\u0017\r^3ti&\u0011!+\u0014\u0002\f\u0003:Lh)\u001e8Tk&$X\r\u0005\u0002U/6\tQK\u0003\u0002W\u0003\u0006!A/Z:u\u0013\tAVKA\bD_:tWm\u0019;Gk:\u001cV/\u001b;f!\tQ6,D\u0001P\u0013\tavJA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\u0004\"A\u00170\n\u0005}{%A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\u0004\"!\u00193\u000e\u0003\tT!aY\"\u0002\u0011%tG/\u001a:oC2L!!\u001a2\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u001b\t\u0003S\u0002i\u0011!Q\u0001\u0016e\u0016<WM\\3sCR,wi\u001c7eK:4\u0015\u000e\\3t+\u0005a\u0007CA7q\u001b\u0005q'\"A8\u0002\u000bM\u001c\u0017\r\\1\n\u0005Et'a\u0002\"p_2,\u0017M\\\u0001\u0017e\u0016<WM\\3sCR,wi\u001c7eK:4\u0015\u000e\\3tA\u0005A2\r\\3b]>\u0013\b\u000f[1oK\u0012<u\u000e\u001c3f]\u001aKG.Z:\u00023\rdW-\u00198PeBD\u0017M\\3e\u000f>dG-\u001a8GS2,7\u000fI\u0001\u000ecV,'/\u001f$jY\u0016\u0004\u0016\r\u001e5\u0016\u0003]\u0004\"\u0001_@\u000e\u0003eT!A_>\u0002\t\u0019LG.\u001a\u0006\u0003yv\f1A\\5p\u0015\u0005q\u0018\u0001\u00026bm\u0006L1!!\u0001z\u0005\u0011\u0001\u0016\r\u001e5\u0002\u001dE,XM]=GS2,\u0007+\u0019;iA\u0005aA/Z:u\t\u0006$\u0018\rU1uQ\u0006iA/Z:u\t\u0006$\u0018\rU1uQ\u0002\n\u0001B]3hSN$(/_\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002<9!\u0011\u0011CA\u001b\u001d\u0011\t\u0019\"a\f\u000f\t\u0005U\u0011\u0011\u0006\b\u0005\u0003/\t\u0019C\u0004\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\"S\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005\u0005\u0012aA2p[&!\u0011QEA\u0014\u0003\u00199wn\\4mK*\u0011\u0011\u0011E\u0005\u0005\u0003W\ti#\u0001\u0005qe>$xNY;g\u0015\u0011\t)#a\n\n\t\u0005E\u00121G\u0001\u0005kRLGN\u0003\u0003\u0002,\u00055\u0012\u0002BA\u001c\u0003s\t!BS:p]\u001a{'/\\1u\u0015\u0011\t\t$a\r\n\t\u0005u\u0012q\b\u0002\r)f\u0004XMU3hSN$(/\u001f\u0006\u0005\u0003o\tI$A\u0005sK\u001eL7\u000f\u001e:zA\u00059\u0001O]5oi\u0016\u0014XCAA$!\u0011\tI%!\u0014\u000f\t\u0005-\u0013QG\u0007\u0003\u0003sIA!a\u0014\u0002@\t9\u0001K]5oi\u0016\u0014\u0018\u0001\u00039sS:$XM\u001d\u0011\u0002\u000fM,7o]5p]V\u0011\u0011q\u000b\t\u0004S\u0006e\u0013bAA.\u0003\na1\u000b]1sWN+7o]5p]\u0006Y1/Z:tS>tw\fJ3r)\u0011\t\t'a\u001a\u0011\u00075\f\u0019'C\u0002\u0002f9\u0014A!\u00168ji\"I\u0011\u0011N\b\u0002\u0002\u0003\u0007\u0011qK\u0001\u0004q\u0012\n\u0014\u0001C:fgNLwN\u001c\u0011\u0002\u0013\t,gm\u001c:f\u00032dGCAA1\u0003)\u0011WMZ8sK\u0016\u000b7\r[\u0001\tC\u001a$XM]!mY\u000692\r\\3b]>\u0013\b\u000f[1oK\u0012<u\u000e\u001c3f]\u001aKG.\u001a\u000b\u0005\u0003s\n\u0019\u000b\u0006\u0003\u0002b\u0005m\u0004\u0002CA?+\u0011\u0005\r!a \u0002\u0003\u0019\u0004R!\\AA\u0003\u000bK1!a!o\u0005!a$-\u001f8b[\u0016t\u0004\u0007BAD\u0003#\u0003R![AE\u0003\u001bK1!a#B\u0005\u001d!\u0015\r^1tKR\u0004B!a$\u0002\u00122\u0001A\u0001DAJ\u0003w\n\t\u0011!A\u0003\u0002\u0005U%aA0%cE!\u0011qSAO!\ri\u0017\u0011T\u0005\u0004\u00037s'a\u0002(pi\"Lgn\u001a\t\u0004[\u0006}\u0015bAAQ]\n\u0019\u0011I\\=\t\u000f\u0005\u0015V\u00031\u0001\u0002(\u0006!a.Y7f!\u0011\tI+!-\u000f\t\u0005-\u0016Q\u0016\t\u0004\u00033q\u0017bAAX]\u00061\u0001K]3eK\u001aLA!a-\u00026\n11\u000b\u001e:j]\u001eT1!a,o\u00031\u0011X-\u00193SK2\fG/[8o)\u0011\tY,a3\u0011\t\u0005u\u0016qY\u0007\u0003\u0003\u007fSA!!1\u0002D\u0006)\u0001O]8u_*\u0019\u0011QY\"\u0002\u000f\r|gN\\3di&!\u0011\u0011ZA`\u0005!\u0011V\r\\1uS>t\u0007BBAg-\u0001\u0007q/\u0001\u0003qCRD\u0017aD<sSR,wi\u001c7eK:4\u0015\u000e\\3\u0015\r\u0005\u0005\u00141[Ak\u0011\u0019\tim\u0006a\u0001o\"9\u0011q[\fA\u0002\u0005m\u0016\u0001\u0003:fY\u0006$\u0018n\u001c8\u0002%U\u0014HnV5uQV\u001bXM]!oIB\u000b7o]\u000b\u0003\u0003;\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003Gl\u0018\u0001\u00027b]\u001eLA!a-\u0002b\u0006\u0019RO\u001d7XSRDWk]3s\u0003:$\u0007+Y:tA\u0005a1/[7qY\u0016\u001c6\r[3nCV\u0011\u0011Q\u001e\t\u0005\u0003_\f)0\u0004\u0002\u0002r*\u0019\u00111_!\u0002\u000bQL\b/Z:\n\t\u0005]\u0018\u0011\u001f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!D:j[BdWmU2iK6\f\u0007%\u0001\ntS6\u0004H.Z*dQ\u0016l\u0017m\u0015;sS:<WCAAT\u0003M\u0019\u0018.\u001c9mKN\u001b\u0007.Z7b'R\u0014\u0018N\\4!\u0003-yG\u000f[3s'\u000eDW-\\1\u0002\u0019=$\b.\u001a:TG\",W.\u0019\u0011\u0002#=$\b.\u001a:TG\",W.Y*ue&tw-\u0001\npi\",'oU2iK6\f7\u000b\u001e:j]\u001e\u0004\u0013!D2p[BdW\r_*dQ\u0016l\u0017-\u0001\bd_6\u0004H.\u001a=TG\",W.\u0019\u0011\u0002'\r|W\u000e\u001d7fqN\u001b\u0007.Z7b'R\u0014\u0018N\\4\u0002)\r|W\u000e\u001d7fqN\u001b\u0007.Z7b'R\u0014\u0018N\\4!\u00031\u0011\u0017N\\1ssN\u001b\u0007.Z7b\u00035\u0011\u0017N\\1ssN\u001b\u0007.Z7bA\u0005\u0011\"-\u001b8bef\u001c6\r[3nCN#(/\u001b8h\u0003M\u0011\u0017N\\1ssN\u001b\u0007.Z7b'R\u0014\u0018N\\4!\u0003=!X-\u001c9pe\u0006d7oU2iK6\f\u0017\u0001\u0005;f[B|'/\u00197t'\u000eDW-\\1!\u0003U!X-\u001c9pe\u0006d7oU2iK6\f7\u000b\u001e:j]\u001e\fa\u0003^3na>\u0014\u0018\r\\:TG\",W.Y*ue&tw\rI\u0001\u000eE>|G.Z1o'\u000eDW-\\1\u0002\u001d\t|w\u000e\\3b]N\u001b\u0007.Z7bA\u0005\u0019\"m\\8mK\u0006t7k\u00195f[\u0006\u001cFO]5oO\u0006!\"m\\8mK\u0006t7k\u00195f[\u0006\u001cFO]5oO\u0002\n1c\u0019:fCR,Gj\\2bYJ+G.\u0019;j_:$BA!\f\u0003<A!!q\u0006B\u001b\u001d\rI'\u0011G\u0005\u0004\u0005g\t\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005o\u0011IDA\u0005ECR\fgI]1nK*\u0019!1G!\t\u000f\tu\"\u00071\u0001\u0002(\u000611o\u00195f[\u0006\faa]5na2,WC\u0001B\u0017\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u000f\r|W\u000e\u001d7fq\u00061!-\u001b8bef\f\u0011\u0002^3na>\u0014\u0018\r\\:\u0002\u000f\t|w\u000e\\3b]\u0006Q1m\u001c7v[:$Vm\u001d;\u0015\t\tM#q\f\u000b\u0005\u0003C\u0012)\u0006\u0003\u0005\u0002~i\"\t\u0019\u0001B,!\u0015i\u0017\u0011\u0011B-!\rI'1L\u0005\u0004\u0005;\n%AB\"pYVlg\u000eC\u0004\u0002&j\u0002\r!a*\u0002\u001f=\u0014H-\u001a:D_2,XN\u001c+fgR$BA!\u001a\u0003jQ!\u0011\u0011\rB4\u0011!\tih\u000fCA\u0002\t]\u0003bBASw\u0001\u0007\u0011qU\u0001\rMVt7\r^5p]R+7\u000f\u001e\u000b\u0005\u0005_\u0012\u0019\b\u0006\u0003\u0002b\tE\u0004\u0002CA?y\u0011\u0005\rAa\u0016\t\u000f\u0005\u0015F\b1\u0001\u0002(\u0006!B/Z7q_J\fGNR;oGRLwN\u001c+fgR$BA!\u001f\u0003~Q!\u0011\u0011\rB>\u0011!\ti(\u0010CA\u0002\t]\u0003bBAS{\u0001\u0007\u0011qU\u0001\u0011i\u0016\u001cH\u000fR3tG\u001aKG.\u001a)bi\"\f\u0011\u0003^3ti\u0012+7o\u0019$jY\u0016\u0004\u0016\r\u001e5!\u0001")
public class PlanGenerationTestSuite
extends AnyFunSuite
implements ConnectFunSuite,
BeforeAndAfterAll,
BeforeAndAfterEach,
Logging {
    private final boolean regenerateGoldenFiles;
    private final boolean cleanOrphanedGoldenFiles;
    private final Path queryFilePath;
    private final Path testDataPath;
    private final JsonFormat.TypeRegistry registry;
    private final JsonFormat.Printer printer;
    private SparkSession session;
    private final String urlWithUserAndPass;
    private final StructType simpleSchema;
    private final String simpleSchemaString;
    private final StructType otherSchema;
    private final String otherSchemaString;
    private final StructType complexSchema;
    private final String complexSchemaString;
    private final StructType binarySchema;
    private final String binarySchemaString;
    private final StructType temporalsSchema;
    private final String temporalsSchemaString;
    private final StructType booleanSchema;
    private final String booleanSchemaString;
    private final String testDescFilePath;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private Path baseResourcePath;
    private Path commonResourcePath;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private boolean regenerateGoldenFiles() {
        return this.regenerateGoldenFiles;
    }

    private boolean cleanOrphanedGoldenFiles() {
        return this.cleanOrphanedGoldenFiles;
    }

    public Path queryFilePath() {
        return this.queryFilePath;
    }

    public Path testDataPath() {
        return this.testDataPath;
    }

    private JsonFormat.TypeRegistry registry() {
        return this.registry;
    }

    private JsonFormat.Printer printer() {
        return this.printer;
    }

    private SparkSession session() {
        return this.session;
    }

    private void session_$eq(SparkSession x$1) {
        this.session = x$1;
    }

    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
        SparkConnectClient client = SparkConnectClient$.MODULE$.apply(InProcessChannelBuilder.forName((String)"/dev/null").build());
        this.session_$eq(new SparkSession(client, SparkSession$.MODULE$.cleaner(), new AtomicLong()));
    }

    public void beforeEach() {
        this.session().resetPlanIdGenerator();
    }

    public void afterAll() {
        this.session().close();
        if (this.cleanOrphanedGoldenFiles()) {
            this.cleanOrphanedGoldenFile();
        }
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    private void cleanOrphanedGoldenFile() {
        Set allTestNames = (Set)this.testNames().map((Function1 & Serializable)x$2 -> x$2.replace(' ', '_'));
        File[] orphans = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])SparkFileUtils$.MODULE$.recursiveList(this.queryFilePath().toFile())), (Function1 & Serializable)g -> BoxesRunTime.boxToBoolean((boolean)PlanGenerationTestSuite.$anonfun$cleanOrphanedGoldenFile$2(g)))), (Function1 & Serializable)g -> BoxesRunTime.boxToBoolean((boolean)PlanGenerationTestSuite.$anonfun$cleanOrphanedGoldenFile$3(allTestNames, g)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])orphans), (Function1 & Serializable)file -> {
            SparkFileUtils$.MODULE$.deleteRecursively(file);
            return BoxedUnit.UNIT;
        });
    }

    private void test(String name, Function0<Dataset<?>> f) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)name, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Relation actual = ((Dataset)f.apply()).plan().getRoot();
            Path goldenFile = this.queryFilePath().resolve(new StringBuilder(10).append(name.replace(' ', '_')).append(".proto.bin").toString());
            boolean bl = false;
            Success success = null;
            boolean bl2 = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.readRelation(goldenFile));
            if (try_ instanceof Success) {
                Relation expected;
                bl = true;
                success = (Success)try_;
                Relation relation = expected = (Relation)success.value();
                Relation relation2 = actual;
                if (relation == null) {
                    if (relation2 == null) return BoxedUnit.UNIT;
                } else if (relation.equals(relation2)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (bl && this.regenerateGoldenFiles()) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Rewriting Golden File");
                this.writeGoldenFile(goldenFile, actual);
                return BoxedUnit.UNIT;
            }
            if (bl) {
                Relation expected = (Relation)success.value();
                throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n             |Expected and actual plans do not match:\n             |\n             |=== Expected Plan ===\n             |").append(expected).append("\n             |\n             |=== Actual Plan ===\n             |").append(actual).append("\n             |").toString())), new Position("PlanGenerationTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            }
            if (try_ instanceof Failure) {
                bl2 = true;
                failure = (Failure)try_;
                if (this.regenerateGoldenFiles()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Writing Golden File");
                    this.writeGoldenFile(goldenFile, actual);
                    return BoxedUnit.UNIT;
                }
            }
            if (!bl2) throw new MatchError((Object)try_);
            throw this.fail("No golden file found. Please re-run this test with the SPARK_GENERATE_GOLDEN_FILES=1 environment variable set", new Position("PlanGenerationTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        }, (Position)new Position("PlanGenerationTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    private Relation readRelation(Path path) {
        Relation relation;
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            relation = Relation.parseFrom((InputStream)input);
        }
        return relation;
    }

    private void writeGoldenFile(Path path, Relation relation) {
        try (OutputStream output = Files.newOutputStream(path, new OpenOption[0]);){
            relation.writeTo(output);
        }
        Path jsonPath = path.getParent().resolve(new StringBuilder(5).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((Object)path.getFileName()).toString()), ".proto.bin")).append(".json").toString());
        try (BufferedWriter writer = Files.newBufferedWriter(jsonPath, new OpenOption[0]);){
            writer.write(this.printer().print((MessageOrBuilder)relation));
        }
    }

    private String urlWithUserAndPass() {
        return this.urlWithUserAndPass;
    }

    private StructType simpleSchema() {
        return this.simpleSchema;
    }

    private String simpleSchemaString() {
        return this.simpleSchemaString;
    }

    private StructType otherSchema() {
        return this.otherSchema;
    }

    private String otherSchemaString() {
        return this.otherSchemaString;
    }

    private StructType complexSchema() {
        return this.complexSchema;
    }

    private String complexSchemaString() {
        return this.complexSchemaString;
    }

    private StructType binarySchema() {
        return this.binarySchema;
    }

    private String binarySchemaString() {
        return this.binarySchemaString;
    }

    private StructType temporalsSchema() {
        return this.temporalsSchema;
    }

    private String temporalsSchemaString() {
        return this.temporalsSchemaString;
    }

    private StructType booleanSchema() {
        return this.booleanSchema;
    }

    private String booleanSchemaString() {
        return this.booleanSchemaString;
    }

    private Dataset<Row> createLocalRelation(String schema) {
        return this.session().newDataFrame((Function1 & Serializable)builder -> {
            PlanGenerationTestSuite.$anonfun$createLocalRelation$1(schema, builder);
            return BoxedUnit.UNIT;
        });
    }

    private Dataset<Row> simple() {
        return this.createLocalRelation(this.simpleSchemaString());
    }

    private Dataset<Row> left() {
        return this.simple();
    }

    private Dataset<Row> right() {
        return this.createLocalRelation(this.otherSchemaString());
    }

    private Dataset<Row> complex() {
        return this.createLocalRelation(this.complexSchemaString());
    }

    private Dataset<Row> binary() {
        return this.createLocalRelation(this.binarySchemaString());
    }

    private Dataset<Row> temporals() {
        return this.createLocalRelation(this.temporalsSchemaString());
    }

    private Dataset<Row> boolean() {
        return this.createLocalRelation(this.booleanSchemaString());
    }

    private void columnTest(String name, Function0<Column> f) {
        this.test(new StringBuilder(7).append("column ").append(name).toString(), (Function0 & Serializable)() -> this.complex().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)f.apply()})));
    }

    private void orderColumnTest(String name, Function0<Column> f) {
        this.test(new StringBuilder(7).append("column ").append(name).toString(), (Function0 & Serializable)() -> this.complex().orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)f.apply()})));
    }

    private void functionTest(String name, Function0<Column> f) {
        this.test(new StringBuilder(9).append("function ").append(name).toString(), (Function0 & Serializable)() -> this.complex().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)f.apply()})));
    }

    private void temporalFunctionTest(String name, Function0<Column> f) {
        this.test(new StringBuilder(9).append("function ").append(name).toString(), (Function0 & Serializable)() -> this.temporals().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)f.apply()})));
    }

    private String testDescFilePath() {
        return this.testDescFilePath;
    }

    public static final /* synthetic */ boolean $anonfun$cleanOrphanedGoldenFile$2(File g) {
        return g.getAbsolutePath().endsWith(".proto.bin") || g.getAbsolutePath().endsWith(".json");
    }

    public static final /* synthetic */ boolean $anonfun$cleanOrphanedGoldenFile$3(Set allTestNames$1, File g) {
        return !allTestNames$1.contains((Object)StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(g.getName()), ".proto.bin")) && !allTestNames$1.contains((Object)StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(g.getName()), ".json"));
    }

    public static final /* synthetic */ void $anonfun$createLocalRelation$1(String schema$1, Relation.Builder builder) {
        builder.getLocalRelationBuilder().setSchema(schema$1);
    }

    public static final /* synthetic */ byte $anonfun$new$331(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ byte $anonfun$new$349(int x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ char $anonfun$new$662(int i) {
        return (char)(65 + i);
    }

    public static final /* synthetic */ byte $anonfun$new$663(int i) {
        return (byte)(i + 120);
    }

    public static final /* synthetic */ char $anonfun$new$665(int i) {
        return (char)(65 + i);
    }

    public static final /* synthetic */ char $anonfun$new$666(int i) {
        return (char)(66 + i);
    }

    public static final /* synthetic */ char $anonfun$new$668(int i) {
        return (char)(65 + i);
    }

    public static final /* synthetic */ byte $anonfun$new$669(int i) {
        return (byte)(i + 120);
    }

    public PlanGenerationTestSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        Logging.$init$((Logging)this);
        String string = System.getenv("SPARK_GENERATE_GOLDEN_FILES");
        String string2 = "1";
        this.regenerateGoldenFiles = !(string != null ? !string.equals(string2) : string2 != null);
        String string3 = System.getenv("SPARK_CLEAN_ORPHANED_GOLDEN_FILES");
        String string4 = "1";
        this.cleanOrphanedGoldenFiles = !(string3 != null ? !string3.equals(string4) : string4 != null);
        this.queryFilePath = this.commonResourcePath().resolve("query-tests/queries");
        this.testDataPath = Paths.get("../", "common", "src", "test", "resources", "query-tests", "test-data");
        this.registry = JsonFormat.TypeRegistry.newBuilder().add(ExamplePluginRelation.getDescriptor()).add(ExamplePluginExpression.getDescriptor()).add(ExamplePluginCommand.getDescriptor()).build();
        this.printer = JsonFormat.printer().usingTypeRegistry(this.registry());
        this.urlWithUserAndPass = "jdbc:h2:mem:testdb0;user=testUser;password=testPass";
        this.simpleSchema = new StructType().add("id", "long").add("a", "int").add("b", "double");
        this.simpleSchemaString = this.simpleSchema().catalogString();
        this.otherSchema = new StructType().add("a", "int").add("id", "long").add("payload", "binary");
        this.otherSchemaString = this.otherSchema().catalogString();
        this.complexSchema = this.simpleSchema().add("d", (DataType)this.simpleSchema()).add("e", "array<int>").add("f", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.simpleSchema())).add("g", "string");
        this.complexSchemaString = this.complexSchema().catalogString();
        this.binarySchema = new StructType().add("id", "long").add("bytes", "binary");
        this.binarySchemaString = this.binarySchema().catalogString();
        this.temporalsSchema = new StructType().add("d", "date").add("t", "timestamp").add("s", "string").add("x", "bigint").add("wt", (DataType)new StructType().add("start", "timestamp").add("end", "timestamp"));
        this.temporalsSchemaString = this.temporalsSchema().catalogString();
        this.booleanSchema = new StructType().add("id", "long").add("flag", "boolean");
        this.booleanSchemaString = this.booleanSchema().catalogString();
        this.test("range", (Function0 & Serializable)() -> this.session().range(1L, 10L, 1L, 2));
        this.test("read", (Function0 & Serializable)() -> {
            StructField structField = new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("age", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("job", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            return this.session().read().format("csv").schema(StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField))).option("header", "true").options((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delimiter"), (Object)";")}))).load(((Object)this.testDataPath().resolve("people.csv")).toString());
        });
        this.test("read jdbc", (Function0 & Serializable)() -> this.session().read().jdbc(this.urlWithUserAndPass(), "TEST.TIMETYPES", new Properties()));
        this.test("read jdbc with partition", (Function0 & Serializable)() -> this.session().read().jdbc(this.urlWithUserAndPass(), "TEST.EMP", "THEID", 0L, 4L, 3, new Properties()));
        this.test("read jdbc with predicates", (Function0 & Serializable)() -> {
            String[] parts = (String[])((Object[])new String[]{"THEID < 2", "THEID >= 2"});
            return this.session().read().jdbc(this.urlWithUserAndPass(), "TEST.PEOPLE", parts, new Properties());
        });
        this.test("read json", (Function0 & Serializable)() -> this.session().read().json(((Object)this.testDataPath().resolve("people.json")).toString()));
        this.test("json from dataset", (Function0 & Serializable)() -> this.session().read().schema(new StructType().add("c1", (DataType)StringType$.MODULE$).add("c2", (DataType)IntegerType$.MODULE$)).option("allowSingleQuotes", "true").json(this.session().emptyDataset((Encoder)AgnosticEncoders.StringEncoder$.MODULE$)));
        this.test("toJSON", (Function0 & Serializable)() -> this.complex().toJSON());
        this.test("read csv", (Function0 & Serializable)() -> this.session().read().csv(((Object)this.testDataPath().resolve("people.csv")).toString()));
        this.test("csv from dataset", (Function0 & Serializable)() -> this.session().read().schema(new StructType().add("c1", (DataType)StringType$.MODULE$).add("c2", (DataType)IntegerType$.MODULE$)).option("header", "true").csv(this.session().emptyDataset((Encoder)AgnosticEncoders.StringEncoder$.MODULE$)));
        this.test("read parquet", (Function0 & Serializable)() -> this.session().read().parquet(((Object)this.testDataPath().resolve("users.parquet")).toString()));
        this.test("read orc", (Function0 & Serializable)() -> this.session().read().orc(((Object)this.testDataPath().resolve("users.orc")).toString()));
        this.test("read table", (Function0 & Serializable)() -> this.session().read().table("myTable"));
        this.test("table", (Function0 & Serializable)() -> this.session().table("myTable"));
        this.test("read text", (Function0 & Serializable)() -> this.session().read().text(((Object)this.testDataPath().resolve("people.txt")).toString()));
        this.test("select", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id")})));
        this.test("select typed 1-arg", (Function0 & Serializable)() -> {
            JavaUniverse $u = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator1$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator1$1(null)));
            return this.simple().select(functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")})).as((Encoder)encoder));
        });
        this.test("select typed 2-arg", (Function0 & Serializable)() -> {
            JavaUniverse $u = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator2$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator2$1(null)));
            JavaUniverse $u2 = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator3$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder2 = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator3$1(null)));
            Column col = functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")}));
            Column col2 = functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("b")}));
            return this.simple().select(col.as((Encoder)encoder), col2.as((Encoder)encoder2));
        });
        this.test("select typed 3-arg", (Function0 & Serializable)() -> {
            JavaUniverse $u = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator4$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator4$1(null)));
            JavaUniverse $u2 = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator5$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder2 = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator5$1(null)));
            Column col = functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")}));
            Column col2 = functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("b")}));
            return this.simple().select(col.as((Encoder)encoder), col2.as((Encoder)encoder2), col.as((Encoder)encoder));
        });
        this.test("select typed 4-arg", (Function0 & Serializable)() -> {
            JavaUniverse $u = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator6$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator6$1(null)));
            Column col = functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")}));
            return this.simple().select(col.as((Encoder)encoder), col.as((Encoder)encoder), col.as((Encoder)encoder), col.as((Encoder)encoder));
        });
        this.test("select typed 5-arg", (Function0 & Serializable)() -> {
            JavaUniverse $u = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator7$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator7$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator7$1(null)));
            JavaUniverse $u2 = ScalaReflection$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = ScalaReflection$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator8$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator8$1(PlanGenerationTestSuite $outer) {
                }
            }
            AgnosticEncoder encoder2 = ScalaReflection$.MODULE$.encoderFor(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator8$1(null)));
            Column col = functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")}));
            Column col2 = functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("b")}));
            return this.simple().select(col.as((Encoder)encoder), col2.as((Encoder)encoder2), col.as((Encoder)encoder), col.as((Encoder)encoder), col2.as((Encoder)encoder2));
        });
        this.test("limit", (Function0 & Serializable)() -> this.simple().limit(10));
        this.test("filter", (Function0 & Serializable)() -> this.simple().filter(functions$.MODULE$.col("id").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)10L)))));
        this.test("toDF", (Function0 & Serializable)() -> this.simple().toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x1", "x2", "x3"})));
        this.test("to", (Function0 & Serializable)() -> this.simple().to(new StructType().add("b", "double").add("id", "int")));
        this.test("join inner_no_condition", (Function0 & Serializable)() -> this.left().join(this.right()));
        this.test("join inner_using_single_col", (Function0 & Serializable)() -> this.left().join(this.right(), "id"));
        this.test("join inner_using_multiple_col_array", (Function0 & Serializable)() -> this.left().join(this.right(), (String[])((Object[])new String[]{"id", "a"})));
        this.test("join inner_using_multiple_col_seq", (Function0 & Serializable)() -> this.left().join(this.right(), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a"}))));
        this.test("join using_single_col", (Function0 & Serializable)() -> this.left().join(this.right(), "id", "left_semi"));
        this.test("join using_multiple_col_array", (Function0 & Serializable)() -> this.left().join(this.right(), (String[])((Object[])new String[]{"id", "a"}), "full_outer"));
        this.test("join using_multiple_col_seq", (Function0 & Serializable)() -> this.left().join(this.right(), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a"})), "right_outer"));
        this.test("join inner_condition", (Function0 & Serializable)() -> this.left().alias("l").join(this.right().alias("r"), functions$.MODULE$.col("l.a").$eq$eq$eq((Object)functions$.MODULE$.col("r.a"))));
        this.test("join condition", (Function0 & Serializable)() -> this.left().as("l").join(this.right().as("r"), functions$.MODULE$.col("l.id").$eq$eq$eq((Object)functions$.MODULE$.col("r.id")), "left_anti"));
        this.test("crossJoin", (Function0 & Serializable)() -> this.left().crossJoin(this.right()));
        this.test("sortWithinPartitions strings", (Function0 & Serializable)() -> this.simple().sortWithinPartitions("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"})));
        this.test("sortWithinPartitions columns", (Function0 & Serializable)() -> this.simple().sortWithinPartitions((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("b")})));
        this.test("sort strings", (Function0 & Serializable)() -> this.simple().sort("b", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
        this.test("sort columns", (Function0 & Serializable)() -> this.simple().sort((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("b")})));
        this.test("orderBy strings", (Function0 & Serializable)() -> this.simple().sort("b", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a"})));
        this.test("orderBy columns", (Function0 & Serializable)() -> this.simple().sort((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("b"), functions$.MODULE$.col("a")})));
        this.test("apply", (Function0 & Serializable)() -> {
            Dataset<Row> stable = this.simple();
            return stable.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{stable.apply("a")}));
        });
        this.test("hint", (Function0 & Serializable)() -> this.simple().hint("coalesce", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100)})));
        this.test("col", (Function0 & Serializable)() -> {
            Dataset<Row> stable = this.simple();
            return stable.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{stable.col("id"), stable.col("b")}));
        });
        this.test("colRegex", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.simple().colRegex("`a|id`")})));
        this.test("as string", (Function0 & Serializable)() -> this.simple().as("foo"));
        this.test("as symbol", (Function0 & Serializable)() -> this.simple().as((Symbol)SymbolLiteral.bootstrap("apply", "bar")));
        this.test("alias string", (Function0 & Serializable)() -> this.simple().alias("fooz"));
        this.test("alias symbol", (Function0 & Serializable)() -> this.simple().alias("bob"));
        this.test("select strings", (Function0 & Serializable)() -> this.simple().select("id", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
        this.test("selectExpr", (Function0 & Serializable)() -> this.simple().selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a + 10 as x", "id % 10 as grp"})));
        this.test("filter expr", (Function0 & Serializable)() -> this.simple().filter("exp(a) < 10.0"));
        this.test("where column", (Function0 & Serializable)() -> this.simple().where(functions$.MODULE$.col("id").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)1L)))));
        this.test("where expr", (Function0 & Serializable)() -> this.simple().where("a + id < 1000"));
        this.test("unpivot values", (Function0 & Serializable)() -> this.simple().unpivot((Column[])((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")}), (Column[])((Object[])new Column[]{functions$.MODULE$.col("b")}), "name", "value"));
        this.test("unpivot no_values", (Function0 & Serializable)() -> this.simple().unpivot((Column[])((Object[])new Column[]{functions$.MODULE$.col("id")}), "name", "value"));
        this.test("melt values", (Function0 & Serializable)() -> this.simple().unpivot((Column[])((Object[])new Column[]{functions$.MODULE$.col("a")}), (Column[])((Object[])new Column[]{functions$.MODULE$.col("id")}), "name", "value"));
        this.test("melt no_values", (Function0 & Serializable)() -> this.simple().melt((Column[])((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a")}), "name", "value"));
        this.test("offset", (Function0 & Serializable)() -> this.simple().offset(1000));
        this.test("union", (Function0 & Serializable)() -> this.simple().union(this.simple()));
        this.test("unionAll", (Function0 & Serializable)() -> this.simple().union(this.simple()));
        this.test("unionByName", (Function0 & Serializable)() -> this.simple().drop("b").unionByName(this.right().drop("payload")));
        this.test("unionByName allowMissingColumns", (Function0 & Serializable)() -> this.simple().unionByName(this.right(), true));
        this.test("intersect", (Function0 & Serializable)() -> this.simple().intersect(this.simple()));
        this.test("intersectAll", (Function0 & Serializable)() -> this.simple().intersectAll(this.simple()));
        this.test("except", (Function0 & Serializable)() -> this.simple().except(this.simple()));
        this.test("exceptAll", (Function0 & Serializable)() -> this.simple().exceptAll(this.simple()));
        this.test("sample fraction_seed", (Function0 & Serializable)() -> this.simple().sample(0.43, 9890823L));
        this.test("sample withReplacement_fraction_seed", (Function0 & Serializable)() -> this.simple().sample(true, 0.23, 898L));
        this.test("withColumn single", (Function0 & Serializable)() -> this.simple().withColumn("z", functions$.MODULE$.expr("a + 100")));
        this.test("withColumns scala_map", (Function0 & Serializable)() -> this.simple().withColumns((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"b", (Object)functions$.MODULE$.lit((Object)"redacted")), new Tuple2((Object)"z", (Object)functions$.MODULE$.expr("a + 100"))}))));
        this.test("withColumns java_map", (Function0 & Serializable)() -> {
            HashMap<String, Column> map = new HashMap<String, Column>();
            map.put("g", functions$.MODULE$.col("id"));
            map.put("a", functions$.MODULE$.lit((Object)"123"));
            return this.simple().withColumns(map);
        });
        this.test("withColumnRenamed single", (Function0 & Serializable)() -> this.simple().withColumnRenamed("id", "nid"));
        this.test("withColumnRenamed scala_map", (Function0 & Serializable)() -> this.simple().withColumnsRenamed((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)"alpha"), new Tuple2((Object)"b", (Object)"beta")}))));
        this.test("withColumnRenamed java_map", (Function0 & Serializable)() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", "nid");
            map.put("b", "bravo");
            return this.simple().withColumnsRenamed(map);
        });
        this.test("withMetadata", (Function0 & Serializable)() -> {
            MetadataBuilder builder = new MetadataBuilder();
            builder.putString("description", "unique identifier");
            return this.simple().withMetadata("id", builder.build());
        });
        this.test("drop single string", (Function0 & Serializable)() -> this.simple().drop("a"));
        this.test("drop multiple strings", (Function0 & Serializable)() -> this.simple().drop((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b"})));
        this.test("drop single column", (Function0 & Serializable)() -> this.simple().drop(functions$.MODULE$.col("b")));
        this.test("drop multiple column", (Function0 & Serializable)() -> this.simple().drop(functions$.MODULE$.col("b"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id")})));
        this.test("dropDuplicates", (Function0 & Serializable)() -> this.simple().dropDuplicates());
        this.test("dropDuplicates names seq", (Function0 & Serializable)() -> this.simple().dropDuplicates((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)"b").$colon$colon((Object)"a")));
        this.test("dropDuplicates names array", (Function0 & Serializable)() -> this.simple().dropDuplicates((String[])((Object[])new String[]{"a", "id"})));
        this.test("dropDuplicates varargs", (Function0 & Serializable)() -> this.simple().dropDuplicates("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "id"})));
        this.test("describe", (Function0 & Serializable)() -> this.simple().describe((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "b"})));
        this.test("summary", (Function0 & Serializable)() -> this.simple().summary((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "min"})));
        this.test("repartition", (Function0 & Serializable)() -> this.simple().repartition(24));
        this.test("repartition num_partitions_expressions", (Function0 & Serializable)() -> this.simple().repartition(22, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("id")})));
        this.test("repartition expressions", (Function0 & Serializable)() -> this.simple().repartition((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("b")})));
        this.test("repartitionByRange num_partitions_expressions", (Function0 & Serializable)() -> this.simple().repartitionByRange(33, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("b"), functions$.MODULE$.col("id").desc_nulls_first()})));
        this.test("repartitionByRange expressions", (Function0 & Serializable)() -> this.simple().repartitionByRange((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a").asc(), functions$.MODULE$.col("id").desc_nulls_first()})));
        this.test("coalesce", (Function0 & Serializable)() -> this.simple().coalesce(5));
        this.test("distinct", (Function0 & Serializable)() -> this.simple().distinct());
        this.columnTest("apply", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("f").apply((Object)"super_duper_key"));
        this.columnTest("unary minus", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)).unary_$minus());
        this.columnTest("not", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).unary_$bang());
        this.columnTest("equals", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$eq$eq$eq((Object)functions$.MODULE$.col("b")));
        this.columnTest("not equals", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$eq$bang$eq((Object)functions$.MODULE$.col("b")));
        this.columnTest("gt", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$greater((Object)functions$.MODULE$.col("b")));
        this.columnTest("lt", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$less((Object)functions$.MODULE$.col("b")));
        this.columnTest("geq", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$greater$eq((Object)functions$.MODULE$.col("b")));
        this.columnTest("leq", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$less$eq((Object)functions$.MODULE$.col("b")));
        this.columnTest("eqNullSafe", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$less$eq$greater((Object)functions$.MODULE$.col("b")));
        this.columnTest("when otherwise", (Function0<Column>)(Function0 & Serializable)() -> {
            Column a = functions$.MODULE$.col("a");
            return functions$.MODULE$.when(a.$less((Object)BoxesRunTime.boxToInteger((int)10)), (Object)"low").when(a.$less((Object)BoxesRunTime.boxToInteger((int)20)), (Object)"medium").otherwise((Object)"high");
        });
        this.columnTest("between", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").between((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)20)));
        this.columnTest("isNaN", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("b").isNaN());
        this.columnTest("isNull", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").isNull());
        this.columnTest("isNotNull", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").isNotNull());
        this.columnTest("and", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$greater((Object)BoxesRunTime.boxToInteger((int)10)).$amp$amp((Object)functions$.MODULE$.col("b").$less((Object)BoxesRunTime.boxToDouble((double)0.5))));
        this.columnTest("or", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$greater((Object)BoxesRunTime.boxToInteger((int)10)).$bar$bar((Object)functions$.MODULE$.col("b").$less((Object)BoxesRunTime.boxToDouble((double)0.5))));
        this.columnTest("add", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$plus((Object)functions$.MODULE$.col("b")));
        this.columnTest("subtract", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$minus((Object)functions$.MODULE$.col("b")));
        this.columnTest("multiply", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$times((Object)functions$.MODULE$.col("b")));
        this.columnTest("divide", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$div((Object)functions$.MODULE$.col("b")));
        this.columnTest("modulo", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").$percent((Object)BoxesRunTime.boxToInteger((int)10)));
        this.columnTest("isin", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").isin((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"hello", "world", "foo"})));
        this.columnTest("like", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").like("%bob%"));
        this.columnTest("rlike", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").like("^[0-9]*$"));
        this.columnTest("ilike", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").like("%fOb%"));
        this.columnTest("getItem", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("e").getItem((Object)BoxesRunTime.boxToInteger((int)3)));
        this.columnTest("withField", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("d").withField("x", functions$.MODULE$.lit((Object)"xq")));
        this.columnTest("dropFields", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("d").dropFields((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})));
        this.columnTest("getField", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("d").getItem((Object)"b"));
        this.columnTest("substr", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").substr(8, 3));
        this.columnTest("contains", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").contains((Object)"baz"));
        this.columnTest("startsWith", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").startsWith("prefix_"));
        this.columnTest("endsWith", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("g").endsWith("suffix_"));
        this.columnTest("alias", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").name("b"));
        this.columnTest("as multi", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.expr("inline(map_values(f))").as((String[])((Object[])new String[]{"v1", "v2", "v3"})));
        this.columnTest("as with metadata", (Function0<Column>)(Function0 & Serializable)() -> {
            MetadataBuilder builder = new MetadataBuilder();
            builder.putString("comment", "modified E field");
            return functions$.MODULE$.col("e").as("e_mod", builder.build());
        });
        this.columnTest("cast", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").cast("long"));
        this.orderColumnTest("desc", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("b").desc());
        this.orderColumnTest("desc_nulls_first", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("b").desc_nulls_first());
        this.orderColumnTest("desc_nulls_last", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("b").desc_nulls_last());
        this.orderColumnTest("asc", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").asc());
        this.orderColumnTest("asc_nulls_first", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").asc_nulls_first());
        this.orderColumnTest("asc_nulls_last", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").asc_nulls_last());
        this.columnTest("bitwiseOR", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").bitwiseOR((Object)BoxesRunTime.boxToInteger((int)7)));
        this.columnTest("bitwiseAND", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").bitwiseAND((Object)BoxesRunTime.boxToInteger((int)255)));
        this.columnTest("bitwiseXOR", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("a").bitwiseXOR((Object)BoxesRunTime.boxToInteger((int)78)));
        this.columnTest("star", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("*"));
        this.columnTest("star with target", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("d.*"));
        this.functionTest("col", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.col("id"));
        this.functionTest("asc", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.asc("a"));
        this.functionTest("asc_nulls_first", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.asc_nulls_first("a"));
        this.functionTest("asc_nulls_last", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.asc_nulls_last("a"));
        this.functionTest("desc", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.desc("a"));
        this.functionTest("desc_nulls_first", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.desc_nulls_first("a"));
        this.functionTest("desc_nulls_last", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.desc_nulls_last("a"));
        this.functionTest("approx_count_distinct", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.approx_count_distinct("a"));
        this.functionTest("approx_count_distinct rsd", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.approx_count_distinct("a", 0.1));
        this.functionTest("avg", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.avg("a"));
        this.functionTest("collect_list", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.collect_list("a"));
        this.functionTest("collect_set", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.collect_set("a"));
        this.functionTest("corr", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.corr("a", "b"));
        this.functionTest("count", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.count(functions$.MODULE$.col("a")));
        this.test("function count typed", (Function0 & Serializable)() -> this.simple().select(functions$.MODULE$.count("a")));
        this.functionTest("countDistinct", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.countDistinct("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"g"})));
        this.functionTest("covar_pop", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.covar_pop("a", "b"));
        this.functionTest("covar_samp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.covar_samp("a", "b"));
        this.functionTest("first with ignore nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.first("a", true));
        this.functionTest("first with respect nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.first("a"));
        this.functionTest("first_value with ignore nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.first_value(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        this.functionTest("first_value with respect nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.first_value(functions$.MODULE$.col("a")));
        this.functionTest("any_value with ignore nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.any_value(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        this.functionTest("any_value with respect nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.any_value(functions$.MODULE$.col("a")));
        this.functionTest("kurtosis", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.kurtosis("a"));
        this.functionTest("last with ignore nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.last("a", true));
        this.functionTest("last with respect nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.last("a"));
        this.functionTest("last_value with ignore nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.last_value(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        this.functionTest("last_value with respect nulls", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.last_value(functions$.MODULE$.col("a")));
        this.functionTest("count_if", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.count_if(functions$.MODULE$.col("a").gt((Object)BoxesRunTime.boxToInteger((int)0))));
        this.functionTest("histogram_numeric", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.histogram_numeric(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("bit_and", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bit_and(functions$.MODULE$.col("a")));
        this.functionTest("bit_or", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bit_or(functions$.MODULE$.col("a")));
        this.functionTest("bit_xor", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bit_xor(functions$.MODULE$.col("a")));
        this.functionTest("mode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.mode(functions$.MODULE$.col("a")));
        this.test("function max", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max("id")})));
        this.functionTest("max_by", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.max_by(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("median", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.median(functions$.MODULE$.col("a")));
        this.functionTest("min", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.min("a"));
        this.functionTest("min_by", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.min_by(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("percentile without frequency", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.percentile(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.3))));
        this.functionTest("percentile with frequency", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.percentile(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.3)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.functionTest("percentile_approx", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.percentile_approx(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.3)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)20))));
        this.functionTest("approx_percentile", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.approx_percentile(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.3)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)20))));
        this.functionTest("product", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.product(functions$.MODULE$.col("a")));
        this.functionTest("skewness", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.skewness("a"));
        this.functionTest("stddev", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.stddev("a"));
        this.functionTest("std", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.std(functions$.MODULE$.col("a")));
        this.functionTest("stddev_samp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.stddev_samp("a"));
        this.functionTest("stddev_pop", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.stddev_pop("a"));
        this.functionTest("sum", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sum("a"));
        this.functionTest("sum_distinct", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sum_distinct(functions$.MODULE$.col("a")));
        this.functionTest("variance", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.variance("a"));
        this.functionTest("var_samp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.var_samp("a"));
        this.functionTest("var_pop", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.var_pop("a"));
        this.functionTest("regr_avgx", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_avgx(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("regr_avgy", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_avgy(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("regr_count", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_count(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("regr_intercept", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_intercept(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("regr_r2", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_r2(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("regr_slope", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_slope(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("regr_sxx", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_sxx(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("regr_sxy", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_sxy(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("regr_syy", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regr_syy(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.test("function every", (Function0 & Serializable)() -> this.boolean().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.every(functions$.MODULE$.col("flag"))})));
        this.test("function bool_and", (Function0 & Serializable)() -> this.boolean().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.bool_and(functions$.MODULE$.col("flag"))})));
        this.test("function some", (Function0 & Serializable)() -> this.boolean().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.some(functions$.MODULE$.col("flag"))})));
        this.test("function any", (Function0 & Serializable)() -> this.boolean().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.any(functions$.MODULE$.col("flag"))})));
        this.test("function bool_or", (Function0 & Serializable)() -> this.boolean().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.bool_or(functions$.MODULE$.col("flag"))})));
        this.functionTest("array", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
        this.functionTest("map", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)22)), functions$.MODULE$.lit((Object)"dummy")})));
        this.functionTest("map_from_arrays", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_from_arrays(functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))})), functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"one"), functions$.MODULE$.lit((Object)"two")}))));
        this.functionTest("coalesce", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)3))})));
        this.functionTest("input_file_name", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.input_file_name());
        this.functionTest("isnan", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.isnan(functions$.MODULE$.col("b")));
        this.functionTest("isnull", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.isnull(functions$.MODULE$.col("a")));
        this.functionTest("monotonically_increasing_id", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.monotonically_increasing_id());
        this.functionTest("nanvl", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.nanvl(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), functions$.MODULE$.col("a")));
        this.functionTest("negate", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.negate(functions$.MODULE$.col("a")));
        this.functionTest("rand with seed", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.rand(133L));
        this.functionTest("randn with seed", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.randn(133L));
        this.functionTest("spark_partition_id", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.spark_partition_id());
        this.functionTest("sqrt", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sqrt("b"));
        this.functionTest("try_add", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_add(functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("try_avg", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_avg(functions$.MODULE$.col("a")));
        this.functionTest("try_divide", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_divide(functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("try_multiply", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_multiply(functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("try_subtract", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_subtract(functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("try_sum", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_sum(functions$.MODULE$.col("a")));
        this.functionTest("try_to_timestamp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_to_timestamp(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("try_to_timestamp without format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_to_timestamp(functions$.MODULE$.col("g")));
        this.functionTest("try_to_binary", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_to_binary(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"format")));
        this.functionTest("try_to_binary without format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_to_binary(functions$.MODULE$.col("g")));
        this.functionTest("try_to_number", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_to_number(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"99,999")));
        this.functionTest("try_element_at array", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_element_at(functions$.MODULE$.col("e"), functions$.MODULE$.col("a")));
        this.functionTest("try_element_at map", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_element_at(functions$.MODULE$.col("f"), functions$.MODULE$.col("g")));
        this.functionTest("struct", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.struct("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
        this.functionTest("bitwise_not", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bitwise_not(functions$.MODULE$.col("a")));
        this.functionTest("bit_count", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bit_count(functions$.MODULE$.col("a")));
        this.functionTest("bit_get", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bit_get(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))));
        this.functionTest("getbit", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.getbit(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))));
        this.functionTest("expr", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.expr("a + 1"));
        this.functionTest("abs", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.abs(functions$.MODULE$.col("a")));
        this.functionTest("acos", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.acos("b"));
        this.functionTest("acosh", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.acosh("b"));
        this.functionTest("asin", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.asin("b"));
        this.functionTest("asinh", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.asinh("b"));
        this.functionTest("atan", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.atan("b"));
        this.functionTest("atan2", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.atan2(functions$.MODULE$.col("a").cast("double"), "b"));
        this.functionTest("atanh", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.atanh("b"));
        this.functionTest("bin", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bin("b"));
        this.functionTest("ceil", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ceil("b"));
        this.functionTest("ceil scale", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ceil(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.functionTest("ceiling", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ceiling(functions$.MODULE$.col("b")));
        this.functionTest("ceiling scale", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ceiling(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.functionTest("conv", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.conv(functions$.MODULE$.col("b"), 10, 16));
        this.functionTest("cos", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.cos("b"));
        this.functionTest("cosh", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.cosh("b"));
        this.functionTest("cot", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.cot(functions$.MODULE$.col("b")));
        this.functionTest("csc", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.csc(functions$.MODULE$.col("b")));
        this.functionTest("e", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.e());
        this.functionTest("exp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.exp("b"));
        this.functionTest("expm1", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.expm1("b"));
        this.functionTest("factorial", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.factorial(functions$.MODULE$.col("a").$percent((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("floor", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.floor("b"));
        this.functionTest("floor scale", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.floor(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.functionTest("greatest", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.greatest((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("d").getItem((Object)"a")})));
        this.functionTest("hex", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.hex(functions$.MODULE$.col("a")));
        this.functionTest("unhex", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.unhex(functions$.MODULE$.col("a")));
        this.functionTest("hypot", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.hypot(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("least", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.least((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("d").getItem((Object)"a")})));
        this.functionTest("log", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.log("b"));
        this.functionTest("ln", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ln(functions$.MODULE$.col("b")));
        this.functionTest("log with base", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.log(2.0, "b"));
        this.functionTest("log10", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.log10("b"));
        this.functionTest("log1p", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.log1p("a"));
        this.functionTest("log2", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.log2("a"));
        this.functionTest("negative", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.negative(functions$.MODULE$.col("a")));
        this.functionTest("pi", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.pi());
        this.functionTest("positive", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.positive(functions$.MODULE$.col("a")));
        this.functionTest("pow", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.pow("a", "b"));
        this.functionTest("power", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.power(functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("pmod", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.pmod(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("rint", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.rint("b"));
        this.functionTest("round", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.round(functions$.MODULE$.col("b"), 2));
        this.functionTest("bround", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.round(functions$.MODULE$.col("b"), 2));
        this.functionTest("sec", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sec(functions$.MODULE$.col("b")));
        this.functionTest("shiftleft", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.shiftleft(functions$.MODULE$.col("b"), 2));
        this.functionTest("shiftright", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.shiftright(functions$.MODULE$.col("b"), 2));
        this.functionTest("shiftrightunsigned", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.shiftrightunsigned(functions$.MODULE$.col("b"), 2));
        this.functionTest("signum", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.signum("b"));
        this.functionTest("sign", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sign(functions$.MODULE$.col("b")));
        this.functionTest("sin", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sin("b"));
        this.functionTest("sinh", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sinh("b"));
        this.functionTest("tan", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.tan("b"));
        this.functionTest("tanh", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.tanh("b"));
        this.functionTest("degrees", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.degrees("b"));
        this.functionTest("radians", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.radians("b"));
        this.functionTest("current_catalog", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.current_catalog());
        this.functionTest("current_database", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.current_database());
        this.functionTest("current_schema", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.current_schema());
        this.functionTest("current_user", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.current_user());
        this.functionTest("user", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.user());
        this.functionTest("md5", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.md5(functions$.MODULE$.col("g").cast("binary")));
        this.functionTest("sha1", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sha1(functions$.MODULE$.col("g").cast("binary")));
        this.functionTest("sha2", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sha2(functions$.MODULE$.col("g").cast("binary"), 512));
        this.functionTest("crc32", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.crc32(functions$.MODULE$.col("g").cast("binary")));
        this.functionTest("hash", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.hash((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("b"), functions$.MODULE$.col("id")})));
        this.functionTest("xxhash64", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xxhash64((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id"), functions$.MODULE$.col("a"), functions$.MODULE$.col("d"), functions$.MODULE$.col("g")})));
        this.functionTest("assert_true with message", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.assert_true(functions$.MODULE$.col("id").$greater((Object)BoxesRunTime.boxToInteger((int)0)), functions$.MODULE$.lit((Object)"id negative!")));
        this.functionTest("raise_error", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"kaboom")));
        this.functionTest("ascii", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ascii(functions$.MODULE$.col("g")));
        this.functionTest("base64", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.base64(functions$.MODULE$.col("g").cast("binary")));
        this.functionTest("bit_length", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bit_length(functions$.MODULE$.col("g")));
        this.functionTest("concat_ws", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.concat_ws("-", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)"world"), functions$.MODULE$.col("id")})));
        this.functionTest("decode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.decode(functions$.MODULE$.col("g").cast("binary"), "UTF-8"));
        this.functionTest("encode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.encode(functions$.MODULE$.col("g"), "UTF-8"));
        this.functionTest("format_number", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.format_number(functions$.MODULE$.col("b"), 1));
        this.functionTest("initcap", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.initcap(functions$.MODULE$.col("g")));
        this.functionTest("length", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.length(functions$.MODULE$.col("g")));
        this.functionTest("len", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.len(functions$.MODULE$.col("g")));
        this.functionTest("lower", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.lower(functions$.MODULE$.col("g")));
        this.functionTest("levenshtein", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.levenshtein(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"bob")));
        this.functionTest("levenshtein with threshold", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.levenshtein(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"bob"), 2));
        this.functionTest("locate", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.locate("jar", functions$.MODULE$.col("g")));
        this.functionTest("locate with pos", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.locate("jar", functions$.MODULE$.col("g"), 10));
        this.functionTest("lpad", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.lpad(functions$.MODULE$.col("g"), 10, "-"));
        this.test("function lpad binary", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lpad(functions$.MODULE$.col("bytes"), 5, (byte[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(new int[]{12, 10, 15, 14}), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToByte((byte)PlanGenerationTestSuite.$anonfun$new$331(BoxesRunTime.unboxToInt((Object)x$3))), (ClassTag)ClassTag$.MODULE$.Byte()))})));
        this.functionTest("ltrim", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ltrim(functions$.MODULE$.col("g")));
        this.functionTest("ltrim with pattern", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ltrim(functions$.MODULE$.col("g"), "xxx"));
        this.functionTest("octet_length", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.octet_length(functions$.MODULE$.col("g")));
        this.functionTest("rlike", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.rlike(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"[a-z]+b")));
        this.functionTest("regexp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"[a-z]+b")));
        this.functionTest("regexp_like", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_like(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"[a-z]+b")));
        this.functionTest("regexp_count", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_count(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"\\d+")));
        this.functionTest("regexp_extract", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_extract(functions$.MODULE$.col("g"), "(\\d+)-(\\d+)", 1));
        this.functionTest("regexp_extract_all without regex group index", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_extract_all(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"(\\d+)([a-z]+)")));
        this.functionTest("regexp_extract_all with regex group index", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_extract_all(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"(\\d+)([a-z]+)"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("regexp_replace", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_replace(functions$.MODULE$.col("g"), "(\\d+)", "XXX"));
        this.functionTest("regexp_substr", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_substr(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"\\d{2}(a|b|m)")));
        this.functionTest("regexp_instr without regex group index", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_instr(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"\\d+(a|b|m)")));
        this.functionTest("regexp_instr with regex group index", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.regexp_instr(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"\\d+(a|b|m)"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("unbase64", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.unbase64(functions$.MODULE$.col("g")));
        this.functionTest("rpad", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.rpad(functions$.MODULE$.col("g"), 10, "-"));
        this.test("function rpad binary", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.rpad(functions$.MODULE$.col("bytes"), 5, (byte[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(new int[]{11, 10, 11, 14}), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToByte((byte)PlanGenerationTestSuite.$anonfun$new$349(BoxesRunTime.unboxToInt((Object)x$4))), (ClassTag)ClassTag$.MODULE$.Byte()))})));
        this.functionTest("rtrim", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.rtrim(functions$.MODULE$.col("g")));
        this.functionTest("rtrim with pattern", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.rtrim(functions$.MODULE$.col("g"), "yyy"));
        this.functionTest("split", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.split(functions$.MODULE$.col("g"), ";"));
        this.functionTest("split with limit", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.split(functions$.MODULE$.col("g"), ";", 10));
        this.functionTest("substring", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.substring(functions$.MODULE$.col("g"), 4, 5));
        this.functionTest("substring_index", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.substring_index(functions$.MODULE$.col("g"), ";", 5));
        this.functionTest("overlay", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.overlay(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)"foo"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)4))));
        this.functionTest("overlay with len", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.overlay(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)"foo"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)4)), functions$.MODULE$.lit((Object)"3")));
        this.functionTest("sentences", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sentences(functions$.MODULE$.col("g")));
        this.functionTest("sentences with locale", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sentences(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"en"), functions$.MODULE$.lit((Object)"US")));
        this.functionTest("translate", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.translate(functions$.MODULE$.col("g"), "foo", "bar"));
        this.functionTest("trim", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.trim(functions$.MODULE$.col("g")));
        this.functionTest("trim with pattern", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.trim(functions$.MODULE$.col("g"), "---"));
        this.functionTest("upper", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.upper(functions$.MODULE$.col("g")));
        this.functionTest("years", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.years(Column$.MODULE$.apply("a")));
        this.functionTest("months", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.months(Column$.MODULE$.apply("a")));
        this.functionTest("days", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.days(Column$.MODULE$.apply("a")));
        this.functionTest("hours", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.hours(Column$.MODULE$.apply("a")));
        this.temporalFunctionTest("convert_timezone with source time zone", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.convert_timezone(functions$.MODULE$.lit((Object)"\"Africa/Dakar\""), functions$.MODULE$.lit((Object)"\"Asia/Urumqi\""), functions$.MODULE$.col("t")));
        this.temporalFunctionTest("convert_timezone without source time zone", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.convert_timezone(functions$.MODULE$.lit((Object)"\"Asia/Urumqi\""), functions$.MODULE$.col("t")));
        this.functionTest("make_dt_interval days hours mins secs", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_dt_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("make_dt_interval days hours mins", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_dt_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("make_dt_interval days hours", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_dt_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("make_dt_interval days", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_dt_interval(functions$.MODULE$.col("a")));
        this.functionTest("make_dt_interval", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_dt_interval());
        this.functionTest("make_interval years months weeks days hours mins secs", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("make_interval years months weeks days hours mins", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("make_interval years months weeks days hours", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("make_interval years months weeks days", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("make_interval years months weeks", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("make_interval years months", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("make_interval years", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_interval(functions$.MODULE$.col("a")));
        this.functionTest("make_interval", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_interval());
        this.functionTest("make_timestamp with timezone", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_timestamp(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("b"), functions$.MODULE$.col("g")));
        this.functionTest("make_timestamp without timezone", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_timestamp(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("make_timestamp_ltz with timezone", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_timestamp_ltz(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("b"), functions$.MODULE$.col("g")));
        this.functionTest("make_timestamp_ltz without timezone", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_timestamp_ltz(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("make_timestamp_ntz", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_timestamp_ntz(functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a"), functions$.MODULE$.col("b")));
        this.functionTest("make_ym_interval years months", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_ym_interval(functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("make_ym_interval years", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_ym_interval(functions$.MODULE$.col("a")));
        this.functionTest("make_ym_interval", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_ym_interval());
        this.functionTest("bucket", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bucket(3, Column$.MODULE$.apply("a")));
        this.functionTest("cume_dist", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.cume_dist().over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("dense_rank", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.dense_rank().over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("lag", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.lag(Column$.MODULE$.apply("g"), 1, null, true).over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("lead", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.lead(Column$.MODULE$.apply("g"), 2, (Object)"dv", true).over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("nth_value", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.nth_value(Column$.MODULE$.apply("g"), 3, true).over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("ntile", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ntile(4).over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("percent_rank", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.percent_rank().over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("rank", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.rank().over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("row_number", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.row_number().over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a")})).orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")}))));
        this.functionTest("bitmap_bucket_number", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bitmap_bit_position(functions$.MODULE$.col("id")));
        this.functionTest("bitmap_bit_position", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bitmap_bit_position(functions$.MODULE$.col("id")));
        this.functionTest("bitmap_construct_agg", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.bitmap_construct_agg(functions$.MODULE$.col("id")));
        this.test("function bitmap_count", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.bitmap_count(functions$.MODULE$.col("bytes"))})));
        this.test("function bitmap_or_agg", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.bitmap_or_agg(functions$.MODULE$.col("bytes"))})));
        this.temporalFunctionTest("add_months", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.add_months(functions$.MODULE$.col("d"), 2));
        this.temporalFunctionTest("curdate", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.curdate());
        this.temporalFunctionTest("current_date", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.current_date());
        this.temporalFunctionTest("current_timezone", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.current_timezone());
        this.temporalFunctionTest("current_timestamp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.current_timestamp());
        this.temporalFunctionTest("now", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.now());
        this.temporalFunctionTest("localtimestamp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.localtimestamp());
        this.temporalFunctionTest("date_format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.date_format(functions$.MODULE$.col("d"), "yyyy-MM-dd"));
        this.temporalFunctionTest("date_add", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.date_add(functions$.MODULE$.col("d"), 2));
        this.temporalFunctionTest("dateadd", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.dateadd(functions$.MODULE$.col("d"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.temporalFunctionTest("date_sub", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.date_sub(functions$.MODULE$.col("d"), 2));
        this.temporalFunctionTest("datediff", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.datediff(functions$.MODULE$.col("d"), functions$.MODULE$.make_date(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2020)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)))));
        this.temporalFunctionTest("date_diff", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.date_diff(functions$.MODULE$.col("d"), functions$.MODULE$.make_date(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2020)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)))));
        this.temporalFunctionTest("date_from_unix_date", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.date_from_unix_date(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10))));
        this.temporalFunctionTest("year", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.year(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("quarter", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.quarter(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("month", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.month(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("dayofweek", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.dayofweek(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("dayofmonth", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.dayofmonth(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("day", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.day(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("dayofyear", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.dayofyear(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("hour", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.hour(functions$.MODULE$.col("t")));
        this.temporalFunctionTest("last_day", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.last_day(functions$.MODULE$.col("t")));
        this.temporalFunctionTest("minute", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.minute(functions$.MODULE$.col("t")));
        this.temporalFunctionTest("weekday", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.weekday(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("make_date", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.make_date(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2018)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)5)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)14))));
        this.temporalFunctionTest("months_between", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.months_between(functions$.MODULE$.current_date(), functions$.MODULE$.col("d")));
        this.temporalFunctionTest("months_between with roundoff", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.months_between(functions$.MODULE$.current_date(), functions$.MODULE$.col("d"), true));
        this.temporalFunctionTest("next_day", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.next_day(functions$.MODULE$.col("d"), "Mon"));
        this.temporalFunctionTest("second", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.second(functions$.MODULE$.col("t")));
        this.temporalFunctionTest("weekofyear", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.weekofyear(functions$.MODULE$.col("d")));
        this.temporalFunctionTest("extract", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.extract(functions$.MODULE$.lit((Object)"year"), functions$.MODULE$.col("d")));
        this.temporalFunctionTest("date_part", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.date_part(functions$.MODULE$.lit((Object)"year"), functions$.MODULE$.col("d")));
        this.temporalFunctionTest("datepart", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.datepart(functions$.MODULE$.lit((Object)"year"), functions$.MODULE$.col("d")));
        this.temporalFunctionTest("from_unixtime", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.from_unixtime(functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)1L))));
        this.temporalFunctionTest("unix_timestamp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.unix_timestamp());
        this.temporalFunctionTest("unix_timestamp with format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.unix_timestamp(functions$.MODULE$.col("s"), "yyyy-MM-dd HH:mm:ss.SSSS"));
        this.temporalFunctionTest("to_timestamp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_timestamp(functions$.MODULE$.col("s")));
        this.temporalFunctionTest("to_timestamp with format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_timestamp(functions$.MODULE$.col("s"), "yyyy-MM-dd HH:mm:ss.SSSS"));
        this.temporalFunctionTest("to_date", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_date(functions$.MODULE$.col("s")));
        this.temporalFunctionTest("to_date with format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_date(functions$.MODULE$.col("s"), "yyyy-MM-dd"));
        this.temporalFunctionTest("xpath", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b/text()")));
        this.temporalFunctionTest("xpath_boolean", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath_boolean(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b")));
        this.temporalFunctionTest("xpath_double", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath_double(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b")));
        this.temporalFunctionTest("xpath_number", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath_number(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b")));
        this.temporalFunctionTest("xpath_float", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath_float(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b")));
        this.temporalFunctionTest("xpath_int", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath_int(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b")));
        this.temporalFunctionTest("xpath_long", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath_long(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b")));
        this.temporalFunctionTest("xpath_short", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath_short(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b")));
        this.temporalFunctionTest("xpath_string", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.xpath_string(functions$.MODULE$.col("s"), functions$.MODULE$.lit((Object)"a/b")));
        this.temporalFunctionTest("unix_date", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.unix_date(functions$.MODULE$.to_date(functions$.MODULE$.col("s"), "yyyy-MM-dd")));
        this.temporalFunctionTest("unix_seconds", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.unix_seconds(functions$.MODULE$.to_timestamp(functions$.MODULE$.col("s"), "yyyy-MM-dd HH:mm:ss.SSSS")));
        this.temporalFunctionTest("unix_millis", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.unix_millis(functions$.MODULE$.to_timestamp(functions$.MODULE$.col("s"), "yyyy-MM-dd HH:mm:ss.SSSS")));
        this.temporalFunctionTest("unix_micros", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.unix_micros(functions$.MODULE$.to_timestamp(functions$.MODULE$.col("s"), "yyyy-MM-dd HH:mm:ss.SSSS")));
        this.temporalFunctionTest("trunc", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.trunc(functions$.MODULE$.col("d"), "mm"));
        this.temporalFunctionTest("date_trunc", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.trunc(functions$.MODULE$.col("t"), "minute"));
        this.temporalFunctionTest("from_utc_timestamp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.from_utc_timestamp(functions$.MODULE$.col("t"), "-08:00"));
        this.temporalFunctionTest("to_utc_timestamp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_utc_timestamp(functions$.MODULE$.col("t"), "-04:00"));
        this.temporalFunctionTest("window", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.window(functions$.MODULE$.col("t"), "1 second"));
        this.test("function window_time", (Function0 & Serializable)() -> {
            Metadata metadata = new MetadataBuilder().putBoolean("spark.timeWindow", true).build();
            return this.temporals().withMetadata("wt", metadata).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.window_time(functions$.MODULE$.col("wt"))}));
        });
        this.temporalFunctionTest("session_window", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.session_window(functions$.MODULE$.col("t"), "10 minutes"));
        this.temporalFunctionTest("timestamp_seconds", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.timestamp_seconds(functions$.MODULE$.col("x")));
        this.temporalFunctionTest("timestamp_millis", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.timestamp_millis(functions$.MODULE$.col("x")));
        this.temporalFunctionTest("timestamp_micros", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.timestamp_micros(functions$.MODULE$.col("x")));
        this.functionTest("array_contains", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_contains(functions$.MODULE$.col("e"), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("array_append", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_append(functions$.MODULE$.col("e"), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("arrays_overlap", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.arrays_overlap(functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))}))));
        this.functionTest("slice", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.slice(functions$.MODULE$.col("e"), 0, 5));
        this.functionTest("array_join", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_join(functions$.MODULE$.col("e"), ";"));
        this.functionTest("array_join with null replacement", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_join(functions$.MODULE$.col("e"), ";", "null"));
        this.functionTest("concat", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))})), functions$.MODULE$.sequence(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)33)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)40)))})));
        this.functionTest("array_position", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_position(functions$.MODULE$.col("e"), (Object)BoxesRunTime.boxToInteger((int)10)));
        this.functionTest("element_at", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.element_at(functions$.MODULE$.col("f"), (Object)"bob"));
        this.functionTest("get", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.get(functions$.MODULE$.col("e"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))));
        this.functionTest("array_sort", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_sort(functions$.MODULE$.col("e")));
        this.functionTest("array_sort with comparator", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_sort(functions$.MODULE$.col("e"), (Function2 & Serializable)(l, r) -> l.$minus(r)));
        this.functionTest("array_remove", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_remove(functions$.MODULE$.col("e"), (Object)BoxesRunTime.boxToInteger((int)314)));
        this.functionTest("array_compact", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_compact(functions$.MODULE$.col("e")));
        this.functionTest("array_distinct", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_distinct(functions$.MODULE$.col("e")));
        this.functionTest("array_prepend", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_prepend(functions$.MODULE$.col("e"), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("array_intersect", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_intersect(functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)4))}))));
        this.functionTest("array_insert", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_insert(functions$.MODULE$.col("e"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("array_union", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_union(functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)3))}))));
        this.functionTest("array_except", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_except(functions$.MODULE$.col("e"), functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)4))}))));
        this.functionTest("transform", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.transform(functions$.MODULE$.col("e"), (Function1 & Serializable)x -> x.$plus((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("transform with index", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.transform(functions$.MODULE$.col("e"), (Function2 & Serializable)(x, i) -> x.$plus(i)));
        this.functionTest("exists", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.exists(functions$.MODULE$.col("e"), (Function1 & Serializable)x -> x.$greater((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("forall", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.forall(functions$.MODULE$.col("e"), (Function1 & Serializable)x -> x.$greater((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("filter", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.filter(functions$.MODULE$.col("e"), (Function1 & Serializable)x -> x.$greater((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("filter with pair input", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.filter(functions$.MODULE$.col("e"), (Function2 & Serializable)(x, i) -> x.$greater((Object)BoxesRunTime.boxToInteger((int)10)).$amp$amp((Object)i.$greater((Object)BoxesRunTime.boxToInteger((int)2)))));
        this.functionTest("aggregate", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aggregate(functions$.MODULE$.col("e"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable)(x, y) -> x.$plus(y)));
        this.functionTest("reduce", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.reduce(functions$.MODULE$.col("e"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable)(x, y) -> x.$plus(y)));
        this.functionTest("zip_with", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.zip_with(functions$.MODULE$.col("e"), functions$.MODULE$.col("e"), (Function2 & Serializable)(x, y) -> x.$plus(y)));
        this.functionTest("transform_keys", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.transform_keys(functions$.MODULE$.col("f"), (Function2 & Serializable)(k, v) -> functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{k, v.getItem((Object)"id")}))));
        this.functionTest("transform_values", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.transform_values(functions$.MODULE$.col("f"), (Function2 & Serializable)(k, v) -> v.withField("key", k)));
        this.functionTest("map_filter", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_filter(functions$.MODULE$.col("f"), (Function2 & Serializable)(k, x$5) -> k.contains((Object)functions$.MODULE$.lit((Object)"baz"))));
        this.functionTest("map_zip_with", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_zip_with(functions$.MODULE$.col("f"), functions$.MODULE$.col("f"), (Function3 & Serializable)(x$6, v1, v2) -> v1.getItem((Object)"id").$plus((Object)v2.getItem((Object)"id"))));
        this.functionTest("explode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.explode(functions$.MODULE$.col("e")));
        this.functionTest("explode_outer", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.explode_outer(functions$.MODULE$.col("e")));
        this.functionTest("posexplode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.posexplode(functions$.MODULE$.col("e")));
        this.functionTest("posexplode_outer", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.posexplode_outer(functions$.MODULE$.col("e")));
        this.functionTest("inline", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.inline(functions$.MODULE$.map_values(functions$.MODULE$.col("f"))));
        this.functionTest("inline_outer", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.inline_outer(functions$.MODULE$.map_values(functions$.MODULE$.col("f"))));
        this.functionTest("get_json_object", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.get_json_object(functions$.MODULE$.col("g"), "$.device_type"));
        this.functionTest("json_tuple", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.json_tuple(functions$.MODULE$.col("g"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "id"})));
        this.functionTest("from_json", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.from_json(functions$.MODULE$.col("g"), this.simpleSchema()));
        this.functionTest("schema_of_json", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.schema_of_json(functions$.MODULE$.lit((Object)"[{\"col\":01}]")));
        this.functionTest("schema_of_json with options", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.schema_of_json(functions$.MODULE$.lit((Object)"[{\"col\":01}]"), Collections.singletonMap("allowNumericLeadingZeros", "true")));
        this.functionTest("to_json", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_json(functions$.MODULE$.col("d"), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"timestampFormat", (Object)"dd/MM/yyyy")}))));
        this.functionTest("size", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.size(functions$.MODULE$.col("f")));
        this.functionTest("sort_array", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sort_array(functions$.MODULE$.col("e")));
        this.functionTest("array_min", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_min(functions$.MODULE$.col("e")));
        this.functionTest("array_max", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_max(functions$.MODULE$.col("e")));
        this.functionTest("reverse", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.reverse(functions$.MODULE$.col("e")));
        this.functionTest("flatten", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.flatten(functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("e"), functions$.MODULE$.sequence(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)))}))));
        this.functionTest("sequence", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sequence(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10))));
        this.functionTest("array_repeat", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_repeat(functions$.MODULE$.col("a"), 10));
        this.functionTest("map_contains_key", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_contains_key(functions$.MODULE$.col("f"), (Object)"xyz"));
        this.functionTest("map_keys", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_keys(functions$.MODULE$.col("f")));
        this.functionTest("map_values", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_values(functions$.MODULE$.col("f")));
        this.functionTest("map_entries", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_entries(functions$.MODULE$.col("f")));
        this.functionTest("map_from_entries", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_from_entries(functions$.MODULE$.transform(functions$.MODULE$.col("e"), (Function2 & Serializable)(x, i) -> functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{i, x})))));
        this.functionTest("arrays_zip", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.arrays_zip((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("e"), functions$.MODULE$.sequence(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)20)))})));
        this.functionTest("map_concat", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.map_concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("f"), functions$.MODULE$.map((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"foo"), functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)12L)).as("id"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)68)).as("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)Math.E)).as("b")}))}))})));
        this.functionTest("from_csv", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.from_csv(functions$.MODULE$.col("g"), this.simpleSchema(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"mode", (Object)"FAILFAST")}))));
        this.functionTest("schema_of_csv", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.schema_of_csv(functions$.MODULE$.lit((Object)"1|abc"), Collections.singletonMap("sep", "|")));
        this.functionTest("to_csv", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_csv(functions$.MODULE$.col("d"), Collections.singletonMap("sep", "|")));
        this.functionTest("str_to_map", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.str_to_map(functions$.MODULE$.col("g")));
        this.functionTest("str_to_map with pair delimiter", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.str_to_map(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)","), functions$.MODULE$.lit((Object)"=")));
        this.functionTest("str_to_map with pair and keyValue delimiter", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.str_to_map(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)",")));
        this.functionTest("to_binary", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_binary(functions$.MODULE$.col("g")));
        this.functionTest("to_binary with format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_binary(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"utf-8")));
        this.functionTest("to_char", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_char(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)"$99.99")));
        this.functionTest("to_varchar", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_varchar(functions$.MODULE$.col("b"), functions$.MODULE$.lit((Object)"$99.99")));
        this.functionTest("to_number", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_number(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)"$99.99")));
        this.functionTest("replace", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.replace(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("replace with specified string", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.replace(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("split_part", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.split_part(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("a")));
        this.functionTest("substr", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.substr(functions$.MODULE$.col("g"), functions$.MODULE$.col("a")));
        this.functionTest("substr with len", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.substr(functions$.MODULE$.col("g"), functions$.MODULE$.col("a"), functions$.MODULE$.col("a")));
        this.functionTest("parse_url", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.parse_url(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("parse_url with key", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.parse_url(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("printf", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.printf(functions$.MODULE$.col("g"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("g")})));
        this.functionTest("url_decode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.url_decode(functions$.MODULE$.col("g")));
        this.functionTest("url_encode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.url_encode(functions$.MODULE$.col("g")));
        this.functionTest("position", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.position(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("position with start", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.position(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("a")));
        this.functionTest("endswith", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.endswith(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("startswith", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.startswith(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("to_timestamp_ltz", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_timestamp_ltz(functions$.MODULE$.col("g")));
        this.functionTest("to_timestamp_ltz with format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_timestamp_ltz(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("to_timestamp_ntz", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_timestamp_ntz(functions$.MODULE$.col("g")));
        this.functionTest("to_timestamp_ntz with format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_timestamp_ntz(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("to_unix_timestamp", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_unix_timestamp(functions$.MODULE$.col("g")));
        this.functionTest("to_unix_timestamp with format", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.to_unix_timestamp(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("ifnull", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ifnull(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("isnotnull", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.isnotnull(functions$.MODULE$.col("g")));
        this.functionTest("equal_null", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.equal_null(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("nullif", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.nullif(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("nvl", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.nvl(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("nvl2", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.nvl2(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("char", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.char(functions$.MODULE$.col("a")));
        this.functionTest("btrim", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.btrim(functions$.MODULE$.col("g")));
        this.functionTest("btrim with specified trim string", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.btrim(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("char_length", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.char_length(functions$.MODULE$.col("g")));
        this.functionTest("character_length", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.character_length(functions$.MODULE$.col("g")));
        this.functionTest("chr", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.chr(functions$.MODULE$.col("a")));
        this.functionTest("contains", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.contains(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("elt", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.elt((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")})));
        this.functionTest("find_in_set", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.find_in_set(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("like", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.like(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("like with escape", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.like(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'/'))));
        this.functionTest("ilike", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ilike(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("ilike with escape", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ilike(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'/'))));
        this.functionTest("lcase", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.lcase(functions$.MODULE$.col("g")));
        this.functionTest("ucase", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.ucase(functions$.MODULE$.col("g")));
        this.functionTest("left", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.left(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("right", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.right(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("array_agg", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_agg(functions$.MODULE$.col("a")));
        this.functionTest("array_size", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.array_size(functions$.MODULE$.col("e")));
        this.functionTest("cardinality", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.cardinality(functions$.MODULE$.col("f")));
        this.functionTest("count_min_sketch", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.count_min_sketch(functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.95)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)11))));
        this.functionTest("named_struct", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.named_struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"x"), functions$.MODULE$.col("a"), functions$.MODULE$.lit((Object)"y"), functions$.MODULE$.col("id")})));
        this.functionTest("json_array_length", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.json_array_length(functions$.MODULE$.col("g")));
        this.functionTest("json_object_keys", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.json_object_keys(functions$.MODULE$.col("g")));
        this.functionTest("mask with specific upperChar lowerChar digitChar otherChar", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.mask(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'X')), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'x')), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'n')), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'*'))));
        this.functionTest("mask with specific upperChar lowerChar digitChar", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.mask(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'X')), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'x')), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'n'))));
        this.functionTest("mask with specific upperChar lowerChar", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.mask(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'X')), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'x'))));
        this.functionTest("mask with specific upperChar", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.mask(functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'X'))));
        this.functionTest("mask", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.mask(functions$.MODULE$.col("g")));
        this.functionTest("aes_encrypt with mode padding iv aad", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_encrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)new byte[]{(byte)67, (byte)68, (byte)69}), functions$.MODULE$.col("g")));
        this.functionTest("aes_encrypt with mode padding iv", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_encrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.lit((Object)new byte[]{(byte)67, (byte)68, (byte)69})));
        this.functionTest("aes_encrypt with mode padding", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_encrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("aes_encrypt with mode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_encrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("aes_encrypt", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_encrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("aes_decrypt with mode padding aad", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_decrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("aes_decrypt with mode padding", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_decrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("aes_decrypt with mode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_decrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("aes_decrypt", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.aes_decrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("try_aes_decrypt with mode padding aad", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_aes_decrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("try_aes_decrypt with mode padding", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_aes_decrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("try_aes_decrypt with mode", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_aes_decrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("try_aes_decrypt", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.try_aes_decrypt(functions$.MODULE$.col("g"), functions$.MODULE$.col("g")));
        this.functionTest("sha", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.sha(functions$.MODULE$.col("g")));
        this.functionTest("input_file_block_length", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.input_file_block_length());
        this.functionTest("input_file_block_start", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.input_file_block_start());
        this.functionTest("reflect", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.reflect((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"java.util.UUID"), functions$.MODULE$.lit((Object)"fromString"), functions$.MODULE$.col("g")})));
        this.functionTest("java_method", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.java_method((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"java.util.UUID"), functions$.MODULE$.lit((Object)"fromString"), functions$.MODULE$.col("g")})));
        this.functionTest("typeof", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.typeof(functions$.MODULE$.col("g")));
        this.functionTest("stack", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.stack((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)), functions$.MODULE$.col("g"), functions$.MODULE$.col("g"), functions$.MODULE$.col("g")})));
        this.functionTest("random with seed", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.random(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        this.functionTest("call_function", (Function0<Column>)(Function0 & Serializable)() -> functions$.MODULE$.call_function("lower", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("g")})));
        this.test("hll_sketch_agg with column lgConfigK", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_sketch_agg(functions$.MODULE$.col("bytes"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)))})));
        this.test("hll_sketch_agg with column lgConfigK_int", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_sketch_agg(functions$.MODULE$.col("bytes"), 0)})));
        this.test("hll_sketch_agg with columnName lgConfigK_int", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_sketch_agg("bytes", 0)})));
        this.test("hll_sketch_agg", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_sketch_agg(functions$.MODULE$.col("bytes"))})));
        this.test("hll_sketch_agg with columnName", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_sketch_agg("bytes")})));
        this.test("hll_union_agg with column allowDifferentLgConfigK", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_union_agg(functions$.MODULE$.col("bytes"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false)))})));
        this.test("hll_union_agg with column allowDifferentLgConfigK_boolean", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_union_agg(functions$.MODULE$.col("bytes"), false)})));
        this.test("hll_union_agg with columnName allowDifferentLgConfigK_boolean", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_union_agg("bytes", false)})));
        this.test("hll_union_agg", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_union_agg(functions$.MODULE$.col("bytes"))})));
        this.test("hll_union_agg with columnName", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hll_union_agg("bytes")})));
        this.test("groupby agg", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"max"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"stddev"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"std"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"mean"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"average"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"avg"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)"size"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"count")})));
        this.test("groupby agg string", (Function0 & Serializable)() -> this.simple().groupBy("id", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"max"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"count")})));
        this.test("groupby agg columns", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).agg(functions$.MODULE$.max("a"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("b")})));
        this.test("groupby max", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).max((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby min", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).min((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby mean", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).mean((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby avg", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).avg((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby sum", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).sum((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
        this.test("groupby count", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).count());
        this.test("rollup column", (Function0 & Serializable)() -> this.simple().rollup((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a"), Column$.MODULE$.apply("b")})).count());
        this.test("cube column", (Function0 & Serializable)() -> this.simple().cube((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a"), Column$.MODULE$.apply("b")})).count());
        this.test("rollup string", (Function0 & Serializable)() -> this.simple().rollup("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).count());
        this.test("cube string", (Function0 & Serializable)() -> this.simple().cube("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).count());
        this.test("grouping and grouping_id", (Function0 & Serializable)() -> this.simple().cube("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).agg(functions$.MODULE$.grouping("a"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.grouping("b"), functions$.MODULE$.grouping_id("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))})));
        this.test("pivot", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).pivot("a", (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).agg(functions$.MODULE$.count(Column$.MODULE$.apply("b")), (Seq)Nil$.MODULE$));
        this.test("pivot without column values", (Function0 & Serializable)() -> this.simple().groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("id")})).pivot("a").agg(functions$.MODULE$.count(Column$.MODULE$.apply("b")), (Seq)Nil$.MODULE$));
        this.test("width_bucket", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.width_bucket(functions$.MODULE$.col("b"), functions$.MODULE$.col("b"), functions$.MODULE$.col("b"), functions$.MODULE$.col("a"))})));
        this.test("test broadcast", (Function0 & Serializable)() -> this.left().join(functions$.MODULE$.broadcast(this.right()), "id"));
        this.test("function lit", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)functions$.MODULE$.col("id")), functions$.MODULE$.lit((Object)SymbolLiteral.bootstrap("apply", "id")), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToByte((byte)((byte)68))), functions$.MODULE$.lit((Object)BoxesRunTime.boxToShort((short)((short)9872))), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-8726532)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)7834609328726532L)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)Math.E)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToFloat((float)-0.8f)), functions$.MODULE$.lit((Object)scala.package$.MODULE$.BigDecimal().apply(8997620L, 5)), functions$.MODULE$.lit((Object)scala.package$.MODULE$.BigDecimal().apply(898897667231L, 7).bigDecimal()), functions$.MODULE$.lit((Object)"connect!"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'T')), functions$.MODULE$.lit(Array$.MODULE$.tabulate(10, (Function1 & Serializable)i -> BoxesRunTime.boxToCharacter((char)PlanGenerationTestSuite.$anonfun$new$662(BoxesRunTime.unboxToInt((Object)i))), (ClassTag)ClassTag$.MODULE$.Char())), functions$.MODULE$.lit(Array$.MODULE$.tabulate(23, (Function1 & Serializable)i -> BoxesRunTime.boxToByte((byte)PlanGenerationTestSuite.$anonfun$new$663(BoxesRunTime.unboxToInt((Object)i))), (ClassTag)ClassTag$.MODULE$.Byte())), functions$.MODULE$.lit((Object)package$.MODULE$.WrappedArray().make((Object)new byte[]{(byte)8, (byte)6})), functions$.MODULE$.lit(null), functions$.MODULE$.lit((Object)LocalDate.of(2020, 10, 10)), functions$.MODULE$.lit((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(8997620L, 6))), functions$.MODULE$.lit((Object)Instant.ofEpochMilli(1677155519808L)), functions$.MODULE$.lit((Object)new Timestamp(12345L)), functions$.MODULE$.lit((Object)LocalDateTime.of(2023, 2, 23, 20, 36)), functions$.MODULE$.lit((Object)Date.valueOf("2023-02-23")), functions$.MODULE$.lit((Object)Duration.ofSeconds(200L)), functions$.MODULE$.lit((Object)Period.ofDays(100)), functions$.MODULE$.lit((Object)new CalendarInterval(2, 20, 100L))})));
        this.test("function lit array", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)Array$.MODULE$.emptyDoubleArray()), functions$.MODULE$.lit((Object)((Object[])new int[][]{{1}, {2}, {3}})), functions$.MODULE$.lit((Object)((Object[])new int[][][]{(int[][])((Object[])new int[][]{{1}}), (int[][])((Object[])new int[][]{{2}}), (int[][])((Object[])new int[][]{{3}})})), functions$.MODULE$.lit((Object)new boolean[]{true, false}), functions$.MODULE$.lit((Object)new byte[]{(byte)67, (byte)68, (byte)69}), functions$.MODULE$.lit((Object)new short[]{(short)9872, (short)9873, (short)9874}), functions$.MODULE$.lit((Object)new int[]{-8726532, 8726532, -8726533}), functions$.MODULE$.lit((Object)new long[]{7834609328726531L, 7834609328726532L, 7834609328726533L}), functions$.MODULE$.lit((Object)new double[]{Math.E, 1.0, 2}), functions$.MODULE$.lit((Object)new float[]{-0.8f, -0.7f, -0.9f}), functions$.MODULE$.lit((Object)new scala.math.BigDecimal[]{scala.package$.MODULE$.BigDecimal().apply(8997620L, 5), scala.package$.MODULE$.BigDecimal().apply(8997621L, 5)}), functions$.MODULE$.lit((Object)new BigDecimal[]{scala.package$.MODULE$.BigDecimal().apply(898897667231L, 7).bigDecimal(), scala.package$.MODULE$.BigDecimal().apply(898897667231L, 7).bigDecimal()}), functions$.MODULE$.lit((Object)new String[]{"connect!", "disconnect!"}), functions$.MODULE$.lit((Object)new char[]{'T', 'F'}), functions$.MODULE$.lit((Object)((Object[])new char[][]{(char[])Array$.MODULE$.tabulate(10, (Function1 & Serializable)i -> BoxesRunTime.boxToCharacter((char)PlanGenerationTestSuite.$anonfun$new$665(BoxesRunTime.unboxToInt((Object)i))), (ClassTag)ClassTag$.MODULE$.Char()), (char[])Array$.MODULE$.tabulate(10, (Function1 & Serializable)i -> BoxesRunTime.boxToCharacter((char)PlanGenerationTestSuite.$anonfun$new$666(BoxesRunTime.unboxToInt((Object)i))), (ClassTag)ClassTag$.MODULE$.Char())})), functions$.MODULE$.lit((Object)new LocalDate[]{LocalDate.of(2020, 10, 10), LocalDate.of(2020, 10, 11)}), functions$.MODULE$.lit((Object)new Instant[]{Instant.ofEpochMilli(1677155519808L), Instant.ofEpochMilli(1677155519809L)}), functions$.MODULE$.lit((Object)new Timestamp[]{new Timestamp(12345L), new Timestamp(23456L)}), functions$.MODULE$.lit((Object)new LocalDateTime[]{LocalDateTime.of(2023, 2, 23, 20, 36), LocalDateTime.of(2023, 2, 23, 21, 36)}), functions$.MODULE$.lit((Object)new Date[]{Date.valueOf("2023-02-23"), Date.valueOf("2023-03-01")}), functions$.MODULE$.lit((Object)new Duration[]{Duration.ofSeconds(100L), Duration.ofSeconds(200L)}), functions$.MODULE$.lit((Object)new Period[]{Period.ofDays(100), Period.ofDays(200)}), functions$.MODULE$.lit((Object)new CalendarInterval[]{new CalendarInterval(2, 20, 100L), new CalendarInterval(2, 21, 200L)})})));
        this.test("function typedLit", (Function0 & Serializable)() -> {
            Column[] columnArray = new Column[42];
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator9$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.Column").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator9$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[0] = functions$.MODULE$.typedLit((Object)functions$.MODULE$.col("id"), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator9$1(null)));
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("scala.Symbol").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator10$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[1] = functions$.MODULE$.typedLit((Object)SymbolLiteral.bootstrap("apply", "id"), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator10$1(null)));
            columnArray[2] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToInteger((int)1), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int());
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator11$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator11$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[3] = functions$.MODULE$.typedLit(null, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator11$1(null)));
            columnArray[4] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToBoolean((boolean)true), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Boolean());
            columnArray[5] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToByte((byte)((byte)68)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Byte());
            columnArray[6] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToShort((short)((short)9872)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Short());
            columnArray[7] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToInteger((int)-8726532), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int());
            columnArray[8] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToLong((long)7834609328726532L), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Long());
            columnArray[9] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToDouble((double)Math.E), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double());
            columnArray[10] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToFloat((float)-0.8f), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Float());
            JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator12$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("scala.math.BigDecimal").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator12$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[11] = functions$.MODULE$.typedLit((Object)scala.package$.MODULE$.BigDecimal().apply(8997620L, 5), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator12$1(null)));
            JavaUniverse $u5 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m5 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator13$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator13$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[12] = functions$.MODULE$.typedLit((Object)scala.package$.MODULE$.BigDecimal().apply(898897667231L, 7).bigDecimal(), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator13$1(null)));
            JavaUniverse $u6 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m6 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator14$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator14$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[13] = functions$.MODULE$.typedLit((Object)"connect!", ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator14$1(null)));
            columnArray[14] = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToCharacter((char)'T'), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Char());
            JavaUniverse $u7 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m7 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator15$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Char").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator15$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[15] = functions$.MODULE$.typedLit(Array$.MODULE$.tabulate(10, (Function1 & Serializable)i -> BoxesRunTime.boxToCharacter((char)PlanGenerationTestSuite.$anonfun$new$668(BoxesRunTime.unboxToInt((Object)i))), (ClassTag)ClassTag$.MODULE$.Char()), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator15$1(null)));
            JavaUniverse $u8 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m8 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator16$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[16] = functions$.MODULE$.typedLit(Array$.MODULE$.tabulate(23, (Function1 & Serializable)i -> BoxesRunTime.boxToByte((byte)PlanGenerationTestSuite.$anonfun$new$669(BoxesRunTime.unboxToInt((Object)i))), (ClassTag)ClassTag$.MODULE$.Byte()), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator16$1(null)));
            JavaUniverse $u9 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m9 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator17$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.mutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.mutable.ArraySeq"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator17$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[17] = functions$.MODULE$.typedLit((Object)package$.MODULE$.WrappedArray().make((Object)new byte[]{(byte)8, (byte)6}), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator17$1(null)));
            columnArray[18] = functions$.MODULE$.typedLit(null, ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Null());
            JavaUniverse $u10 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m10 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator18$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.LocalDate").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator18$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[19] = functions$.MODULE$.typedLit((Object)LocalDate.of(2020, 10, 10), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator18$1(null)));
            JavaUniverse $u11 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m11 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator19$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.types.Decimal").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator19$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[20] = functions$.MODULE$.typedLit((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(8997620L, 6)), ((TypeTags)$u11).TypeTag().apply((Mirror)$m11, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator19$1(null)));
            JavaUniverse $u12 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m12 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.Instant").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator20$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[21] = functions$.MODULE$.typedLit((Object)Instant.ofEpochMilli(1677155519808L), ((TypeTags)$u12).TypeTag().apply((Mirror)$m12, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator20$1(null)));
            JavaUniverse $u13 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m13 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator21$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator21$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[22] = functions$.MODULE$.typedLit((Object)new Timestamp(12345L), ((TypeTags)$u13).TypeTag().apply((Mirror)$m13, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator21$1(null)));
            JavaUniverse $u14 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m14 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator22$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.LocalDateTime").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator22$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[23] = functions$.MODULE$.typedLit((Object)LocalDateTime.of(2023, 2, 23, 20, 36), ((TypeTags)$u14).TypeTag().apply((Mirror)$m14, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator22$1(null)));
            JavaUniverse $u15 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m15 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator23$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.sql.Date").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator23$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[24] = functions$.MODULE$.typedLit((Object)Date.valueOf("2023-02-23"), ((TypeTags)$u15).TypeTag().apply((Mirror)$m15, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator23$1(null)));
            JavaUniverse $u16 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m16 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator24$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.Duration").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator24$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[25] = functions$.MODULE$.typedLit((Object)Duration.ofSeconds(200L), ((TypeTags)$u16).TypeTag().apply((Mirror)$m16, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator24$1(null)));
            JavaUniverse $u17 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m17 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator25$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.Period").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator25$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[26] = functions$.MODULE$.typedLit((Object)Period.ofDays(100), ((TypeTags)$u17).TypeTag().apply((Mirror)$m17, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator25$1(null)));
            JavaUniverse $u18 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m18 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.unsafe.types.CalendarInterval").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator26$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[27] = functions$.MODULE$.typedLit((Object)new CalendarInterval(2, 20, 100L), ((TypeTags)$u18).TypeTag().apply((Mirror)$m18, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator26$1(null)));
            JavaUniverse $u19 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m19 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator27$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Some"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator27$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[28] = functions$.MODULE$.typedLit((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), ((TypeTags)$u19).TypeTag().apply((Mirror)$m19, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator27$1(null)));
            JavaUniverse $u20 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m20 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator28$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator28$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[29] = functions$.MODULE$.typedLit((Object)new int[]{1, 2, 3}, ((TypeTags)$u20).TypeTag().apply((Mirror)$m20, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator28$1(null)));
            JavaUniverse $u21 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m21 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator29$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator29$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[30] = functions$.MODULE$.typedLit((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), ((TypeTags)$u21).TypeTag().apply((Mirror)$m21, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator29$1(null)));
            JavaUniverse $u22 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m22 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator30$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[31] = functions$.MODULE$.typedLit(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})), ((TypeTags)$u22).TypeTag().apply((Mirror)$m22, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator30$1(null)));
            JavaUniverse $u23 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m23 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator31$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator31$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[32] = functions$.MODULE$.typedLit((Object)new Tuple3((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)1.0)), ((TypeTags)$u23).TypeTag().apply((Mirror)$m23, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator31$1(null)));
            JavaUniverse $u24 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m24 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator32$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator32$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[33] = functions$.MODULE$.typedLit((Object)None$.MODULE$, ((TypeTags)$u24).TypeTag().apply((Mirror)$m24, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator32$1(null)));
            JavaUniverse $u25 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m25 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator33$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator33$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[34] = functions$.MODULE$.typedLit((Object)new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)1))}, ((TypeTags)$u25).TypeTag().apply((Mirror)$m25, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator33$1(null)));
            JavaUniverse $u26 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m26 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator34$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator34$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[35] = functions$.MODULE$.typedlit(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)None$.MODULE$)})), ((TypeTags)$u26).TypeTag().apply((Mirror)$m26, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator34$1(null)));
            JavaUniverse $u27 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m27 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator35$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.mutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.mutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator35$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[36] = functions$.MODULE$.typedlit(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)None$.MODULE$)})), ((TypeTags)$u27).TypeTag().apply((Mirror)$m27, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator35$1(null)));
            JavaUniverse $u28 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m28 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator36$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[37] = functions$.MODULE$.typedlit(scala.collection.immutable.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)None$.MODULE$)})), ((TypeTags)$u28).TypeTag().apply((Mirror)$m28, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator36$1(null)));
            JavaUniverse $u29 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m29 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator37$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator37$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[38] = functions$.MODULE$.typedLit((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))})), ((TypeTags)$u29).TypeTag().apply((Mirror)$m29, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator37$1(null)));
            JavaUniverse $u30 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m30 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator38$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator38$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[39] = functions$.MODULE$.typedLit((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)4))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)6))}))})), ((TypeTags)$u30).TypeTag().apply((Mirror)$m30, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator38$1(null)));
            JavaUniverse $u31 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m31 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator39$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator39$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[40] = functions$.MODULE$.typedLit(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)4))})))})), ((TypeTags)$u31).TypeTag().apply((Mirror)$m31, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator39$1(null)));
            JavaUniverse $u32 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m32 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PlanGenerationTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator40$1(PlanGenerationTestSuite $outer) {
                }
            }
            columnArray[41] = functions$.MODULE$.typedLit((Object)new Tuple3((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Object)new Tuple2((Object)"a", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b")})))), ((TypeTags)$u32).TypeTag().apply((Mirror)$m32, (TypeCreator)new Org_apache_spark_sql_PlanGenerationTestSuite$$typecreator40$1(null)));
            return this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])columnArray));
        });
        this.test("window", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.min("id").over(Window$.MODULE$.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a"), Column$.MODULE$.apply("b")}))), functions$.MODULE$.min("id").over(Window$.MODULE$.partitionBy("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))), functions$.MODULE$.min("id").over(Window$.MODULE$.orderBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply("a"), Column$.MODULE$.apply("b")}))), functions$.MODULE$.min("id").over(Window$.MODULE$.orderBy("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))), functions$.MODULE$.min("id").over(Window$.MODULE$.orderBy("a", (Seq)Nil$.MODULE$).rowsBetween(2L, 3L)), functions$.MODULE$.min("id").over(Window$.MODULE$.orderBy("a", (Seq)Nil$.MODULE$).rangeBetween(2L, 3L)), functions$.MODULE$.count(Column$.MODULE$.apply("id")).over()})));
        this.test("relation extension", (Function0 & Serializable)() -> {
            ExamplePluginRelation input = ExamplePluginRelation.newBuilder().setInput(this.simple().plan().getRoot()).build();
            return this.session().newDataFrame(Any.pack((Message)input));
        });
        this.test("expression extension", (Function0 & Serializable)() -> {
            ExamplePluginExpression extension = ExamplePluginExpression.newBuilder().setChild(Expression.newBuilder().setUnresolvedAttribute(Expression.UnresolvedAttribute.newBuilder().setUnparsedIdentifier("id"))).setCustomField("abc").build();
            return this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply(Any.pack((Message)extension))}));
        });
        this.test("crosstab", (Function0 & Serializable)() -> this.simple().stat().crosstab("a", "b"));
        this.test("freqItems", (Function0 & Serializable)() -> this.simple().stat().freqItems((String[])((Object[])new String[]{"id", "a"}), 0.1));
        this.test("sampleBy", (Function0 & Serializable)() -> this.simple().stat().sampleBy("id", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)0.2))})), 0L));
        this.test("drop", (Function0 & Serializable)() -> this.simple().na().drop(5, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a"}))));
        this.test("fill", (Function0 & Serializable)() -> this.simple().na().fill(8L, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))));
        this.test("replace", (Function0 & Serializable)() -> this.simple().na().replace("id", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToLong((long)8L))}))));
        this.test("table API with options", (Function0 & Serializable)() -> this.session().read().options((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p1"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p2"), (Object)"v2")}))).table("tempdb.myTable"));
        this.test("streaming table API with options", (Function0 & Serializable)() -> this.session().readStream().options((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p1"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p2"), (Object)"v2")}))).table("tempdb.myStreamingTable"));
        this.test("from_avro with options", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.avro.functions$.MODULE$.from_avro(functions$.MODULE$.col("bytes"), "{\"type\": \"int\", \"name\": \"id\"}", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"FAILFAST"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression"), (Object)"zstandard")}))).asJava())})));
        this.test("from_avro without options", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.avro.functions$.MODULE$.from_avro(functions$.MODULE$.col("bytes"), "{\"type\": \"string\", \"name\": \"name\"}")})));
        this.test("to_avro with schema", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.avro.functions$.MODULE$.to_avro(functions$.MODULE$.col("a"), "{\"type\": \"int\", \"name\": \"id\"}")})));
        this.test("to_avro without schema", (Function0 & Serializable)() -> this.simple().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.avro.functions$.MODULE$.to_avro(functions$.MODULE$.col("id"))})));
        this.testDescFilePath = new StringBuilder(60).append(new StringBuilder(11).append(IntegrationTestUtils$.MODULE$.sparkHome()).append("/connector/").toString()).append("connect/common/src/test/resources/protobuf-tests/common.desc").toString();
        this.ignore("from_protobuf messageClassName", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.protobuf.functions$.MODULE$.from_protobuf(functions$.MODULE$.col("bytes"), StorageLevel.class.getName())})), new Position("PlanGenerationTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3236));
        this.ignore("from_protobuf messageClassName options", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.protobuf.functions$.MODULE$.from_protobuf(functions$.MODULE$.col("bytes"), StorageLevel.class.getName(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recursive.fields.max.depth"), (Object)"2")}))).asJava())})), new Position("PlanGenerationTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3242));
        this.test("from_protobuf messageClassName descFilePath options", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.protobuf.functions$.MODULE$.from_protobuf(functions$.MODULE$.col("bytes"), "StorageLevel", this.testDescFilePath(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recursive.fields.max.depth"), (Object)"2")}))).asJava())})));
        this.test("from_protobuf messageClassName descFilePath", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.protobuf.functions$.MODULE$.from_protobuf(functions$.MODULE$.col("bytes"), "StorageLevel", this.testDescFilePath())})));
        this.test("to_protobuf messageClassName", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.protobuf.functions$.MODULE$.to_protobuf(functions$.MODULE$.col("bytes"), StorageLevel.class.getName())})));
        this.test("to_protobuf messageClassName options", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.protobuf.functions$.MODULE$.to_protobuf(functions$.MODULE$.col("bytes"), StorageLevel.class.getName(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recursive.fields.max.depth"), (Object)"2")}))).asJava())})));
        this.test("to_protobuf messageClassName descFilePath options", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.protobuf.functions$.MODULE$.to_protobuf(functions$.MODULE$.col("bytes"), "StorageLevel", this.testDescFilePath(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recursive.fields.max.depth"), (Object)"2")}))).asJava())})));
        this.test("to_protobuf messageClassName descFilePath", (Function0 & Serializable)() -> this.binary().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.protobuf.functions$.MODULE$.to_protobuf(functions$.MODULE$.col("bytes"), "StorageLevel", this.testDescFilePath())})));
        Statics.releaseFence();
    }
}

