/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.protobuf.functions$;
import org.apache.spark.sql.test.ConnectFunSuite;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005U3Aa\u0003\u0007\u0001+!)A\u0005\u0001C\u0001K!)\u0001\u0006\u0001C\u0005S!9Q\t\u0001b\u0001\n\u00131\u0005BB$\u0001A\u0003%!\tC\u0004I\u0001\t\u0007I\u0011\u0002$\t\r%\u0003\u0001\u0015!\u0003C\u0011\u001dQ\u0005A1A\u0005\n\u0019Caa\u0013\u0001!\u0002\u0013\u0011\u0005b\u0002'\u0001\u0005\u0004%I!\u0014\u0005\u0007)\u0002\u0001\u000b\u0011\u0002(\u0003#\u0019+hn\u0019;j_:$Vm\u001d;Tk&$XM\u0003\u0002\u000e\u001d\u0005\u00191/\u001d7\u000b\u0005=\u0001\u0012!B:qCJ\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-y\u0001\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u0011\u0019,hn];ji\u0016T!a\u0007\n\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u000f\u0019\u0005-\te.\u001f$v]N+\u0018\u000e^3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005b\u0011\u0001\u0002;fgRL!a\t\u0011\u0003\u001f\r{gN\\3di\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005\u001d\u0002Q\"\u0001\u0007\u0002\u0015Q,7\u000f^#rk\u0006d7\u000fF\u0002+au\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\")\u0011G\u0001a\u0001e\u0005!a.Y7f!\t\u0019$H\u0004\u00025qA\u0011Q\u0007L\u0007\u0002m)\u0011q\u0007F\u0001\u0007yI|w\u000e\u001e \n\u0005eb\u0013A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\u0017\t\u000by\u0012\u0001\u0019A \u0002\u000f\r|G.^7ogB\u00191\u0006\u0011\"\n\u0005\u0005c#A\u0003\u001fsKB,\u0017\r^3e}A\u0011qeQ\u0005\u0003\t2\u0011aaQ8mk6t\u0017!A1\u0016\u0003\t\u000b!!\u0019\u0011\u0002\u0003\t\f!A\u0019\u0011\u0002\u0003\r\f!a\u0019\u0011\u0002\rM\u001c\u0007.Z7b+\u0005q\u0005CA(S\u001b\u0005\u0001&BA)\r\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0006K\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa]2iK6\f\u0007\u0005")
public class FunctionTestSuite
extends AnyFunSuite
implements ConnectFunSuite {
    private final Column a;
    private final Column b;
    private final Column c;
    private final StructType schema;
    private Path baseResourcePath;
    private Path commonResourcePath;

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    private void testEquals(String name, Seq<Column> columns) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq unique;
            Seq $org_scalatest_assert_macro_left = columns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            Seq $org_scalatest_assert_macro_left2 = unique = (Seq)columns.distinct();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
    }

    private Column a() {
        return this.a;
    }

    private Column b() {
        return this.b;
    }

    private Column c() {
        return this.c;
    }

    private StructType schema() {
        return this.schema;
    }

    public FunctionTestSuite() {
        ConnectFunSuite.$init$(this);
        this.a = org.apache.spark.sql.functions$.MODULE$.col("a");
        this.b = org.apache.spark.sql.functions$.MODULE$.col("b");
        this.c = org.apache.spark.sql.functions$.MODULE$.col("c");
        this.schema = new StructType().add("key", "long").add("value", "string");
        this.testEquals("col/column", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), org.apache.spark.sql.functions$.MODULE$.column("a")}));
        this.testEquals("asc/asc_nulls_first", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.asc("a"), org.apache.spark.sql.functions$.MODULE$.asc_nulls_first("a")}));
        this.testEquals("desc/desc_nulls_last", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.desc("a"), org.apache.spark.sql.functions$.MODULE$.desc_nulls_last("a")}));
        this.testEquals("approx_count_distinct", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.approxCountDistinct(this.a()), org.apache.spark.sql.functions$.MODULE$.approxCountDistinct("a"), org.apache.spark.sql.functions$.MODULE$.approx_count_distinct("a"), org.apache.spark.sql.functions$.MODULE$.approx_count_distinct(this.a())}));
        this.testEquals("approx_count_distinct rsd", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.approxCountDistinct(this.a(), 0.1), org.apache.spark.sql.functions$.MODULE$.approxCountDistinct("a", 0.1), org.apache.spark.sql.functions$.MODULE$.approx_count_distinct("a", 0.1), org.apache.spark.sql.functions$.MODULE$.approx_count_distinct(this.a(), 0.1)}));
        this.testEquals("avg/mean", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.avg("a"), org.apache.spark.sql.functions$.MODULE$.avg(this.a()), org.apache.spark.sql.functions$.MODULE$.mean(this.a()), org.apache.spark.sql.functions$.MODULE$.mean("a")}));
        this.testEquals("collect_list", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.collect_list("a"), org.apache.spark.sql.functions$.MODULE$.collect_list(this.a())}));
        this.testEquals("collect_set", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.collect_set("a"), org.apache.spark.sql.functions$.MODULE$.collect_set(this.a())}));
        this.testEquals("corr", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.corr("a", "b"), org.apache.spark.sql.functions$.MODULE$.corr(this.a(), this.b())}));
        this.testEquals("count_distinct", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.countDistinct(this.a(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.b(), this.c()})), org.apache.spark.sql.functions$.MODULE$.countDistinct("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"})), org.apache.spark.sql.functions$.MODULE$.count_distinct(this.a(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.b(), this.c()}))}));
        this.testEquals("covar_pop", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.covar_pop(this.a(), this.b()), org.apache.spark.sql.functions$.MODULE$.covar_pop("a", "b")}));
        this.testEquals("covar_samp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.covar_samp(this.a(), this.b()), org.apache.spark.sql.functions$.MODULE$.covar_samp("a", "b")}));
        this.testEquals("first", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.first("a"), org.apache.spark.sql.functions$.MODULE$.first(this.a()), org.apache.spark.sql.functions$.MODULE$.first("a", false), org.apache.spark.sql.functions$.MODULE$.first(this.a(), false)}));
        this.testEquals("grouping", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.grouping("a"), org.apache.spark.sql.functions$.MODULE$.grouping(this.a())}));
        this.testEquals("grouping_id", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.grouping_id("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), org.apache.spark.sql.functions$.MODULE$.grouping_id((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.b()}))}));
        this.testEquals("kurtosis", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.kurtosis("a"), org.apache.spark.sql.functions$.MODULE$.kurtosis(this.a())}));
        this.testEquals("last", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.last("a"), org.apache.spark.sql.functions$.MODULE$.last(this.a()), org.apache.spark.sql.functions$.MODULE$.last("a", false), org.apache.spark.sql.functions$.MODULE$.last(this.a(), false)}));
        this.testEquals("max", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.max("a"), org.apache.spark.sql.functions$.MODULE$.max(this.a())}));
        this.testEquals("min", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.min("a"), org.apache.spark.sql.functions$.MODULE$.min(this.a())}));
        this.testEquals("skewness", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.skewness("a"), org.apache.spark.sql.functions$.MODULE$.skewness(this.a())}));
        this.testEquals("stddev", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.stddev("a"), org.apache.spark.sql.functions$.MODULE$.stddev(this.a())}));
        this.testEquals("stddev_samp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.stddev_samp("a"), org.apache.spark.sql.functions$.MODULE$.stddev_samp(this.a())}));
        this.testEquals("stddev_pop", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.stddev_pop("a"), org.apache.spark.sql.functions$.MODULE$.stddev_pop(this.a())}));
        this.testEquals("sum", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.sum("a"), org.apache.spark.sql.functions$.MODULE$.sum(this.a())}));
        this.testEquals("sum_distinct", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.sumDistinct("a"), org.apache.spark.sql.functions$.MODULE$.sumDistinct(this.a()), org.apache.spark.sql.functions$.MODULE$.sum_distinct(this.a())}));
        this.testEquals("variance", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.variance("a"), org.apache.spark.sql.functions$.MODULE$.variance(this.a())}));
        this.testEquals("var_samp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.var_samp("a"), org.apache.spark.sql.functions$.MODULE$.var_samp(this.a())}));
        this.testEquals("var_pop", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.var_pop("a"), org.apache.spark.sql.functions$.MODULE$.var_pop(this.a())}));
        this.testEquals("array", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.array((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.b(), this.c()})), org.apache.spark.sql.functions$.MODULE$.array("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))}));
        this.testEquals("monotonicallyIncreasingId", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.monotonicallyIncreasingId(), org.apache.spark.sql.functions$.MODULE$.monotonically_increasing_id()}));
        this.testEquals("sqrt", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.sqrt("a"), org.apache.spark.sql.functions$.MODULE$.sqrt(this.a())}));
        this.testEquals("struct", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.c(), this.b()})), org.apache.spark.sql.functions$.MODULE$.struct("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c", "b"}))}));
        this.testEquals("bitwise_not", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.bitwiseNOT(this.a()), org.apache.spark.sql.functions$.MODULE$.bitwise_not(this.a())}));
        this.testEquals("acos", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.acos("a"), org.apache.spark.sql.functions$.MODULE$.acos(this.a())}));
        this.testEquals("acosh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.acosh("a"), org.apache.spark.sql.functions$.MODULE$.acosh(this.a())}));
        this.testEquals("asin", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.asin("a"), org.apache.spark.sql.functions$.MODULE$.asin(this.a())}));
        this.testEquals("asinh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.asinh("a"), org.apache.spark.sql.functions$.MODULE$.asinh(this.a())}));
        this.testEquals("atan", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.atan("a"), org.apache.spark.sql.functions$.MODULE$.atan(this.a())}));
        this.testEquals("atan2", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.atan2(this.a(), this.b()), org.apache.spark.sql.functions$.MODULE$.atan2(this.a(), "b"), org.apache.spark.sql.functions$.MODULE$.atan2("a", this.b()), org.apache.spark.sql.functions$.MODULE$.atan2("a", "b")}));
        this.testEquals("atanh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.atanh("a"), org.apache.spark.sql.functions$.MODULE$.atanh(this.a())}));
        this.testEquals("bin", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.bin("a"), org.apache.spark.sql.functions$.MODULE$.bin(this.a())}));
        this.testEquals("cbrt", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.cbrt("a"), org.apache.spark.sql.functions$.MODULE$.cbrt(this.a())}));
        this.testEquals("ceil", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.ceil(this.a()), org.apache.spark.sql.functions$.MODULE$.ceil("a")}));
        this.testEquals("cos", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.cos("a"), org.apache.spark.sql.functions$.MODULE$.cos(this.a())}));
        this.testEquals("cosh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.cosh("a"), org.apache.spark.sql.functions$.MODULE$.cosh(this.a())}));
        this.testEquals("exp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.exp("a"), org.apache.spark.sql.functions$.MODULE$.exp(this.a())}));
        this.testEquals("expm1", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.expm1("a"), org.apache.spark.sql.functions$.MODULE$.expm1(this.a())}));
        this.testEquals("floor", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.floor(this.a()), org.apache.spark.sql.functions$.MODULE$.floor("a")}));
        this.testEquals("greatest", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.greatest((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.b(), this.c()})), org.apache.spark.sql.functions$.MODULE$.greatest("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))}));
        this.testEquals("hypot", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.hypot(this.a(), this.b()), org.apache.spark.sql.functions$.MODULE$.hypot("a", this.b()), org.apache.spark.sql.functions$.MODULE$.hypot(this.a(), "b"), org.apache.spark.sql.functions$.MODULE$.hypot("a", "b")}));
        this.testEquals("hypot right fixed", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.hypot(org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)3.0)), this.a()), org.apache.spark.sql.functions$.MODULE$.hypot(org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)3.0)), "a"), org.apache.spark.sql.functions$.MODULE$.hypot(3.0, this.a()), org.apache.spark.sql.functions$.MODULE$.hypot(3.0, "a")}));
        this.testEquals("hypot left fixed", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.hypot(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)4.0))), org.apache.spark.sql.functions$.MODULE$.hypot(this.a(), 4.0), org.apache.spark.sql.functions$.MODULE$.hypot("a", org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)4.0))), org.apache.spark.sql.functions$.MODULE$.hypot("a", 4.0)}));
        this.testEquals("least", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.least((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.a(), this.b(), this.c()})), org.apache.spark.sql.functions$.MODULE$.least("a", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))}));
        this.testEquals("log", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.log("a"), org.apache.spark.sql.functions$.MODULE$.log(this.a())}));
        this.testEquals("log base", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.log(2.0, "a"), org.apache.spark.sql.functions$.MODULE$.log(2.0, this.a())}));
        this.testEquals("log10", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.log10("a"), org.apache.spark.sql.functions$.MODULE$.log10(this.a())}));
        this.testEquals("log1p", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.log1p("a"), org.apache.spark.sql.functions$.MODULE$.log1p(this.a())}));
        this.testEquals("log2", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.log2("a"), org.apache.spark.sql.functions$.MODULE$.log2(this.a())}));
        this.testEquals("pow", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.pow(this.a(), this.b()), org.apache.spark.sql.functions$.MODULE$.pow(this.a(), "b"), org.apache.spark.sql.functions$.MODULE$.pow("a", this.b()), org.apache.spark.sql.functions$.MODULE$.pow("a", "b")}));
        this.testEquals("pow left fixed", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.pow(org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)7.0)), this.b()), org.apache.spark.sql.functions$.MODULE$.pow(org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)7.0)), "b"), org.apache.spark.sql.functions$.MODULE$.pow(7.0, this.b()), org.apache.spark.sql.functions$.MODULE$.pow(7.0, "b")}));
        this.testEquals("pow right fixed", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.pow(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)9.0))), org.apache.spark.sql.functions$.MODULE$.pow(this.a(), 9.0), org.apache.spark.sql.functions$.MODULE$.pow("a", org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)9.0))), org.apache.spark.sql.functions$.MODULE$.pow("a", 9.0)}));
        this.testEquals("rint", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.rint(this.a()), org.apache.spark.sql.functions$.MODULE$.rint("a")}));
        this.testEquals("round", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.round(this.a()), org.apache.spark.sql.functions$.MODULE$.round(this.a(), 0)}));
        this.testEquals("bround", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.bround(this.a()), org.apache.spark.sql.functions$.MODULE$.bround(this.a(), 0)}));
        this.testEquals("shiftleft", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.shiftLeft(this.a(), 2), org.apache.spark.sql.functions$.MODULE$.shiftleft(this.a(), 2)}));
        this.testEquals("shiftright", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.shiftRight(this.a(), 3), org.apache.spark.sql.functions$.MODULE$.shiftright(this.a(), 3)}));
        this.testEquals("shiftrightunsigned", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.shiftRightUnsigned(this.a(), 3), org.apache.spark.sql.functions$.MODULE$.shiftrightunsigned(this.a(), 3)}));
        this.testEquals("signum", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.signum("a"), org.apache.spark.sql.functions$.MODULE$.signum(this.a())}));
        this.testEquals("sin", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.sin("a"), org.apache.spark.sql.functions$.MODULE$.sin(this.a())}));
        this.testEquals("sinh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.sinh("a"), org.apache.spark.sql.functions$.MODULE$.sinh(this.a())}));
        this.testEquals("tan", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.tan("a"), org.apache.spark.sql.functions$.MODULE$.tan(this.a())}));
        this.testEquals("tanh", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.tanh("a"), org.apache.spark.sql.functions$.MODULE$.tanh(this.a())}));
        this.testEquals("degrees", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.toDegrees(this.a()), org.apache.spark.sql.functions$.MODULE$.toDegrees("a"), org.apache.spark.sql.functions$.MODULE$.degrees(this.a()), org.apache.spark.sql.functions$.MODULE$.degrees("a")}));
        this.testEquals("radians", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.toRadians(this.a()), org.apache.spark.sql.functions$.MODULE$.toRadians("a"), org.apache.spark.sql.functions$.MODULE$.radians(this.a()), org.apache.spark.sql.functions$.MODULE$.radians("a")}));
        this.testEquals("regexp_replace", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.regexp_replace(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)"foo"), org.apache.spark.sql.functions$.MODULE$.lit((Object)"bar")), org.apache.spark.sql.functions$.MODULE$.regexp_replace(this.a(), "foo", "bar")}));
        this.testEquals("add_months", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.add_months(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))), org.apache.spark.sql.functions$.MODULE$.add_months(this.a(), 1)}));
        this.testEquals("date_add", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.date_add(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))), org.apache.spark.sql.functions$.MODULE$.date_add(this.a(), 2)}));
        this.testEquals("date_sub", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.date_sub(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))), org.apache.spark.sql.functions$.MODULE$.date_sub(this.a(), 2)}));
        this.testEquals("next_day", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.next_day(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)"Mon")), org.apache.spark.sql.functions$.MODULE$.next_day(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)"Mon"))}));
        this.testEquals("unix_timestamp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.unix_timestamp(), org.apache.spark.sql.functions$.MODULE$.unix_timestamp(org.apache.spark.sql.functions$.MODULE$.current_timestamp())}));
        this.testEquals("from_utc_timestamp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.from_utc_timestamp(this.a(), "GMT"), org.apache.spark.sql.functions$.MODULE$.from_utc_timestamp(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)"GMT"))}));
        this.testEquals("to_utc_timestamp", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.to_utc_timestamp(this.a(), "GMT"), org.apache.spark.sql.functions$.MODULE$.to_utc_timestamp(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)"GMT"))}));
        this.testEquals("window", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.window(this.a(), "10 seconds", "10 seconds", "0 second"), org.apache.spark.sql.functions$.MODULE$.window(this.a(), "10 seconds", "10 seconds"), org.apache.spark.sql.functions$.MODULE$.window(this.a(), "10 seconds")}));
        this.testEquals("session_window", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.session_window(this.a(), "1 second"), org.apache.spark.sql.functions$.MODULE$.session_window(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)"1 second"))}));
        this.testEquals("slice", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.slice(this.a(), 1, 2), org.apache.spark.sql.functions$.MODULE$.slice(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)))}));
        this.testEquals("bucket", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.bucket(org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)3)), this.a()), org.apache.spark.sql.functions$.MODULE$.bucket(3, this.a())}));
        this.testEquals("lag", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.lag(this.a(), 1), org.apache.spark.sql.functions$.MODULE$.lag("a", 1), org.apache.spark.sql.functions$.MODULE$.lag(this.a(), 1, null), org.apache.spark.sql.functions$.MODULE$.lag("a", 1, null), org.apache.spark.sql.functions$.MODULE$.lag(this.a(), 1, null, false)}));
        this.testEquals("lead", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.lead(this.a(), 2), org.apache.spark.sql.functions$.MODULE$.lead("a", 2), org.apache.spark.sql.functions$.MODULE$.lead(this.a(), 2, null), org.apache.spark.sql.functions$.MODULE$.lead("a", 2, null), org.apache.spark.sql.functions$.MODULE$.lead(this.a(), 2, null, false)}));
        this.testEquals("aggregate", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.aggregate(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable)(l, r) -> l.$plus(r)), org.apache.spark.sql.functions$.MODULE$.aggregate(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable)(l, r) -> l.$plus(r), (Function1 & Serializable)id -> id)}));
        this.testEquals("from_json", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), (DataType)this.schema()), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), this.schema()), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)this.schema().json())), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), this.schema().json(), Predef$.MODULE$.Map().empty()), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), this.schema().json(), Collections.emptyMap()), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), (DataType)this.schema(), Predef$.MODULE$.Map().empty()), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), (DataType)this.schema(), Collections.emptyMap()), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), this.schema(), Predef$.MODULE$.Map().empty()), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), this.schema(), Collections.emptyMap()), org.apache.spark.sql.functions$.MODULE$.from_json(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)this.schema().json()), Collections.emptyMap())}));
        this.testEquals("schema_of_json", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.schema_of_json(org.apache.spark.sql.functions$.MODULE$.lit((Object)"x,y")), org.apache.spark.sql.functions$.MODULE$.schema_of_json("x,y")}));
        this.testEquals("to_json", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.to_json(this.a()), org.apache.spark.sql.functions$.MODULE$.to_json(this.a(), Collections.emptyMap()), org.apache.spark.sql.functions$.MODULE$.to_json(this.a(), Predef$.MODULE$.Map().empty())}));
        this.testEquals("sort_array", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.sort_array(this.a()), org.apache.spark.sql.functions$.MODULE$.sort_array(this.a(), true)}));
        this.testEquals("sequence", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.sequence(org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10))), org.apache.spark.sql.functions$.MODULE$.sequence(org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)), org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)1L)))}));
        this.testEquals("from_csv", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.from_csv(this.a(), org.apache.spark.sql.functions$.MODULE$.lit((Object)this.schema().toDDL()), Collections.emptyMap()), org.apache.spark.sql.functions$.MODULE$.from_csv(this.a(), this.schema(), Predef$.MODULE$.Map().empty())}));
        this.testEquals("schema_of_csv", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.schema_of_csv(org.apache.spark.sql.functions$.MODULE$.lit((Object)"x,y")), org.apache.spark.sql.functions$.MODULE$.schema_of_csv("x,y"), org.apache.spark.sql.functions$.MODULE$.schema_of_csv(org.apache.spark.sql.functions$.MODULE$.lit((Object)"x,y"), Collections.emptyMap())}));
        this.testEquals("to_csv", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.to_csv(this.a()), org.apache.spark.sql.functions$.MODULE$.to_csv(this.a(), Collections.emptyMap())}));
        this.testEquals("from_avro", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.avro.functions$.MODULE$.from_avro(this.a(), "{\"type\": \"int\", \"name\": \"id\"}"), org.apache.spark.sql.avro.functions$.MODULE$.from_avro(this.a(), "{\"type\": \"int\", \"name\": \"id\"}", Collections.emptyMap())}));
        this.testEquals("from_protobuf", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_protobuf(this.a(), "FakeMessage", "fakeBytes".getBytes(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava()), functions$.MODULE$.from_protobuf(this.a(), "FakeMessage", "fakeBytes".getBytes())}));
        this.testEquals("to_protobuf", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_protobuf(this.a(), "FakeMessage", "fakeBytes".getBytes(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava()), functions$.MODULE$.to_protobuf(this.a(), "FakeMessage", "fakeBytes".getBytes())}));
        this.testEquals("call_udf", (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.callUDF("bob", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))})), org.apache.spark.sql.functions$.MODULE$.call_udf("bob", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))}))}));
        this.test("assert_true no message", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression e = org.apache.spark.sql.functions$.MODULE$.assert_true(this.a()).expr();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(e.hasUnresolvedFunction(), "e.hasUnresolvedFunction()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            Expression.UnresolvedFunction fn = e.getUnresolvedFunction();
            String $org_scalatest_assert_macro_left = fn.getFunctionName();
            String $org_scalatest_assert_macro_right = "assert_true";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            int $org_scalatest_assert_macro_left2 = fn.getArgumentsCount();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            Expression $org_scalatest_assert_macro_left3 = fn.getArguments(0);
            Expression $org_scalatest_assert_macro_right3 = this.a().expr();
            Expression expression = $org_scalatest_assert_macro_left3;
            Expression expression2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(expression != null ? !expression.equals(expression2) : expression2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        }, new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("json_tuple zero args", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> org.apache.spark.sql.functions$.MODULE$.json_tuple(this.a(), (Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264)), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("rand no seed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression e = org.apache.spark.sql.functions$.MODULE$.rand().expr();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(e.hasUnresolvedFunction(), "e.hasUnresolvedFunction()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            Expression.UnresolvedFunction fn = e.getUnresolvedFunction();
            String $org_scalatest_assert_macro_left = fn.getFunctionName();
            String $org_scalatest_assert_macro_right = "rand";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            int $org_scalatest_assert_macro_left2 = fn.getArgumentsCount();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        }, new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("randn no seed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression e = org.apache.spark.sql.functions$.MODULE$.randn().expr();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(e.hasUnresolvedFunction(), "e.hasUnresolvedFunction()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            Expression.UnresolvedFunction fn = e.getUnresolvedFunction();
            String $org_scalatest_assert_macro_left = fn.getFunctionName();
            String $org_scalatest_assert_macro_right = "randn";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            int $org_scalatest_assert_macro_left2 = fn.getArgumentsCount();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        }, new Position("FunctionTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        Statics.releaseFence();
    }
}

