/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import org.apache.spark.util.VersionUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005e1AAA\u0002\u0001\u0019!)Q\u0003\u0001C\u0001-\t\tb+\u001a:tS>tW\u000b^5mgN+\u0018\u000e^3\u000b\u0005\u0011)\u0011\u0001B;uS2T!AB\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005!I\u0011AB1qC\u000eDWMC\u0001\u000b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f'5\tqB\u0003\u0002\u0011#\u0005Aa-\u001e8tk&$XM\u0003\u0002\u0013\u0013\u0005I1oY1mCR,7\u000f^\u0005\u0003)=\u00111\"\u00118z\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011a\u0001")
public class VersionUtilsSuite
extends AnyFunSuite {
    public VersionUtilsSuite() {
        this.test("Parse Spark major version", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)VersionUtils$.MODULE$.majorVersion("2.0")));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)VersionUtils$.MODULE$.majorVersion("12.10.11")));
            int $org_scalatest_assert_macro_right2 = 12;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)VersionUtils$.MODULE$.majorVersion("2.0.1-SNAPSHOT")));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)VersionUtils$.MODULE$.majorVersion("2.0.x")));
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
            this.withClue("majorVersion parsing should fail for invalid major version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> VersionUtils$.MODULE$.majorVersion("2z.0"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32)));
            return (IllegalArgumentException)this.withClue("majorVersion parsing should fail for invalid minor version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> VersionUtils$.MODULE$.majorVersion("2.0z"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37)));
        }, new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("Parse Spark minor version", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)VersionUtils$.MODULE$.minorVersion("2.0")));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)VersionUtils$.MODULE$.minorVersion("12.10.11")));
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)VersionUtils$.MODULE$.minorVersion("2.0.1-SNAPSHOT")));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)VersionUtils$.MODULE$.minorVersion("2.0.x")));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            this.withClue("minorVersion parsing should fail for invalid major version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> VersionUtils$.MODULE$.minorVersion("2z.0"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49)));
            return (IllegalArgumentException)this.withClue("minorVersion parsing should fail for invalid minor version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> VersionUtils$.MODULE$.minorVersion("2.0z"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54)));
        }, new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("Parse Spark major and minor versions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(VersionUtils$.MODULE$.majorMinorVersion("2.0"));
            Tuple2.mcII.sp $org_scalatest_assert_macro_right = new Tuple2.mcII.sp(2, 0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(VersionUtils$.MODULE$.majorMinorVersion("12.10.11"));
            Tuple2.mcII.sp $org_scalatest_assert_macro_right2 = new Tuple2.mcII.sp(12, 10);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(VersionUtils$.MODULE$.majorMinorVersion("2.0.1-SNAPSHOT"));
            Tuple2.mcII.sp $org_scalatest_assert_macro_right3 = new Tuple2.mcII.sp(2, 0);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(VersionUtils$.MODULE$.majorMinorVersion("2.0.x"));
            Tuple2.mcII.sp $org_scalatest_assert_macro_right4 = new Tuple2.mcII.sp(2, 0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            this.withClue("majorMinorVersion parsing should fail for invalid major version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> VersionUtils$.MODULE$.majorMinorVersion("2z.0"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66)));
            return (IllegalArgumentException)this.withClue("majorMinorVersion parsing should fail for invalid minor version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> VersionUtils$.MODULE$.majorMinorVersion("2.0z"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71)));
        }, new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("Return short version number", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(VersionUtils$.MODULE$.shortVersion("3.0.0"));
            String $org_scalatest_assert_macro_right = "3.0.0";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(VersionUtils$.MODULE$.shortVersion("3.0.0-SNAPSHOT"));
            String $org_scalatest_assert_macro_right2 = "3.0.0";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            this.withClue("shortVersion parsing should fail for missing maintenance version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> VersionUtils$.MODULE$.shortVersion("3.0"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81)));
            this.withClue("shortVersion parsing should fail for invalid major version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> VersionUtils$.MODULE$.shortVersion("x.0.0"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86)));
            this.withClue("shortVersion parsing should fail for invalid minor version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> VersionUtils$.MODULE$.shortVersion("3.x.0"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91)));
            return (IllegalArgumentException)this.withClue("shortVersion parsing should fail for invalid maintenance version number", (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> VersionUtils$.MODULE$.shortVersion("3.0.x"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96)));
        }, new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("SPARK-33212: retrieve major/minor/patch version parts", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = VersionUtils$.MODULE$.majorMinorPatchVersion("3.2.2");
            Tuple3 $org_scalatest_assert_macro_right = new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Option $org_scalatest_assert_macro_left2 = VersionUtils$.MODULE$.majorMinorPatchVersion("3.2.2.4");
            Tuple3 $org_scalatest_assert_macro_right2 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            Option $org_scalatest_assert_macro_left3 = VersionUtils$.MODULE$.majorMinorPatchVersion("3.2.2-SNAPSHOT");
            Tuple3 $org_scalatest_assert_macro_right3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            Option $org_scalatest_assert_macro_left4 = VersionUtils$.MODULE$.majorMinorPatchVersion("3.2.2.4XXX");
            Tuple3 $org_scalatest_assert_macro_right4 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            Option $org_scalatest_assert_macro_left5 = VersionUtils$.MODULE$.majorMinorPatchVersion("3.2");
            Tuple3 $org_scalatest_assert_macro_right5 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            Option $org_scalatest_assert_macro_left6 = VersionUtils$.MODULE$.majorMinorPatchVersion("3");
            Tuple3 $org_scalatest_assert_macro_right6 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            new .colon.colon((Object)"ABC", (List)new .colon.colon((Object)"3X", (List)new .colon.colon((Object)"3.2-SNAPSHOT", (List)new .colon.colon((Object)"3.2ABC", (List)new .colon.colon((Object)"3-ABC", (List)new .colon.colon((Object)"3.2.4XYZ", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)version -> {
                Option $org_scalatest_assert_macro_left = VersionUtils$.MODULE$.majorMinorPatchVersion(version);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("version " + version), Prettifier$.MODULE$.default(), new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            });
        }, new Position("VersionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }
}

