/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.DeadlineWithTimeSource;
import org.apache.spark.internal.DeadlineWithTimeSource$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogThrottler;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.NanoTimeTimeSource;
import org.apache.spark.util.MockedNanoTime;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.funsuite.AnyFunSuite;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005}1AAA\u0002\u0001\u0019!)1\u0004\u0001C\u00019\t\u0011Bj\\4UQJ|G\u000f\u001e7j]\u001e\u001cV/\u001b;f\u0015\t!Q!\u0001\u0003vi&d'B\u0001\u0004\b\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0011\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!D\u000b\u0011\u00059\u0019R\"A\b\u000b\u0005A\t\u0012\u0001\u00034v]N,\u0018\u000e^3\u000b\u0005II\u0011!C:dC2\fG/Z:u\u0013\t!rBA\u0006B]f4UO\\*vSR,\u0007C\u0001\f\u001a\u001b\u00059\"B\u0001\r\u0006\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u000e\u0018\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0002")
public class LogThrottlingSuite
extends AnyFunSuite
implements Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private final boolean executeThrottled$1(long expectedSkipped, LogThrottler throttler$6) {
        BooleanRef executed = BooleanRef.create((boolean)false);
        throttler$6.throttled((Function1)(JFunction1.mcVJ.sp & Serializable)skipped -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
            long $org_scalatest_assert_macro_right = expectedSkipped;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            executed$1.elem = true;
        });
        return executed.elem;
    }

    private static final long executeThrottled$default$1$1() {
        return 0L;
    }

    public LogThrottlingSuite() {
        Logging.$init$((Logging)this);
        this.test("time control", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MockedNanoTime nanoTimeControl = new MockedNanoTime();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)nanoTimeControl.nanoTime()));
            long $org_scalatest_assert_macro_right = 0L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)nanoTimeControl.nanoTime()));
            long $org_scalatest_assert_macro_right2 = 0L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
            nanoTimeControl.advance(new package.DurationLong(package$.MODULE$.DurationLong(112L)).nanos());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)nanoTimeControl.nanoTime()));
            long $org_scalatest_assert_macro_right3 = 112L;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)nanoTimeControl.nanoTime()));
            long $org_scalatest_assert_macro_right4 = 112L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("deadline with time control", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MockedNanoTime nanoTimeControl = new MockedNanoTime();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DeadlineWithTimeSource$.MODULE$.now((NanoTimeTimeSource)nanoTimeControl).isOverdue(), "org.apache.spark.internal.DeadlineWithTimeSource.now(nanoTimeControl).isOverdue()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            DeadlineWithTimeSource deadline = DeadlineWithTimeSource$.MODULE$.now((NanoTimeTimeSource)nanoTimeControl).$plus(new package.DurationInt(package$.MODULE$.DurationInt(5)).nanos());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(deadline.isOverdue(), "deadline.isOverdue()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(5)).nanos());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(deadline.isOverdue(), "deadline.isOverdue()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(5)).nanos());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(deadline.isOverdue(), "deadline.isOverdue()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(deadline.$plus(new package.DurationInt(package$.MODULE$.DurationInt(0)).nanos()));
            DeadlineWithTimeSource $org_scalatest_assert_macro_right = deadline;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            DeadlineWithTimeSource increasedDeadline = deadline.$plus(new package.DurationInt(package$.MODULE$.DurationInt(10)).nanos());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(increasedDeadline.isOverdue(), "increasedDeadline.isOverdue()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(5)).nanos());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(increasedDeadline.isOverdue(), "increasedDeadline.isOverdue()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            this.assertThrows((Function0 & Serializable)() -> deadline.$plus(new package.DurationLong(package$.MODULE$.DurationLong(Long.MAX_VALUE)).nanos()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(deadline.$minus(deadline));
            FiniteDuration $org_scalatest_assert_macro_right2 = new package.DurationInt(package$.MODULE$.DurationInt(0)).nanos();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(increasedDeadline.$minus(deadline));
            FiniteDuration $org_scalatest_assert_macro_right3 = new package.DurationInt(package$.MODULE$.DurationInt(10)).nanos();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            FiniteDuration $org_scalatest_assert_macro_left4 = increasedDeadline.$minus(deadline);
            FiniteDuration $org_scalatest_assert_macro_right4 = new package.DurationInt(package$.MODULE$.DurationInt(9)).nanos();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            FiniteDuration $org_scalatest_assert_macro_left5 = increasedDeadline.$minus(deadline);
            FiniteDuration $org_scalatest_assert_macro_right5 = new package.DurationInt(package$.MODULE$.DurationInt(11)).nanos();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "<", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$less((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(deadline.$minus(increasedDeadline));
            FiniteDuration $org_scalatest_assert_macro_right6 = new package.DurationInt(package$.MODULE$.DurationInt(-10)).nanos();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            FiniteDuration $org_scalatest_assert_macro_left7 = deadline.$minus(increasedDeadline);
            FiniteDuration $org_scalatest_assert_macro_right7 = new package.DurationInt(package$.MODULE$.DurationInt(-9)).nanos();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "<", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$less((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            FiniteDuration $org_scalatest_assert_macro_left8 = deadline.$minus(increasedDeadline);
            FiniteDuration $org_scalatest_assert_macro_right8 = new package.DurationInt(package$.MODULE$.DurationInt(-11)).nanos();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, ">", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$greater((Object)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("unthrottled, no burst", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MockedNanoTime nanotTimeControl = new MockedNanoTime();
            LogThrottler throttler = new LogThrottler(1, new package.DurationInt(package$.MODULE$.DurationInt(5)).nanos(), (NanoTimeTimeSource)nanotTimeControl);
            int numInvocations = 100;
            IntRef timesExecuted = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numInvocations).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                throttler.throttled((Function1)(JFunction1.mcVJ.sp & Serializable)skipped -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                    long $org_scalatest_assert_macro_right = 0L;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                    ++timesExecuted$1.elem;
                });
                nanotTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(5)).nanos());
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)timesExecuted.elem));
            int $org_scalatest_assert_macro_right = numInvocations;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("unthrottled, burst", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MockedNanoTime nanotTimeControl = new MockedNanoTime();
            LogThrottler throttler = new LogThrottler(100, new package.DurationInt(package$.MODULE$.DurationInt(1000000)).nanos(), (NanoTimeTimeSource)nanotTimeControl);
            int numInvocations = 100;
            IntRef timesExecuted = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numInvocations).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                int n = x$1;
                throttler.throttled((Function1)(JFunction1.mcVJ.sp & Serializable)skipped -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                    long $org_scalatest_assert_macro_right = 0L;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
                    ++timesExecuted$2.elem;
                });
                nanotTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(5)).nanos());
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)timesExecuted.elem));
            int $org_scalatest_assert_macro_right = numInvocations;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("throttled, no burst", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MockedNanoTime nanoTimeControl = new MockedNanoTime();
            LogThrottler throttler = new LogThrottler(1, new package.DurationInt(package$.MODULE$.DurationInt(5)).nanos(), (NanoTimeTimeSource)nanoTimeControl);
            int numInvocations = 100;
            IntRef timesExecuted = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numInvocations).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                throttler.throttled((Function1)(JFunction1.mcVJ.sp & Serializable)skipped -> {
                    if (timesExecuted$3.elem == 0) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                        long $org_scalatest_assert_macro_right = 0L;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
                    } else {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                        long $org_scalatest_assert_macro_right = 4L;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
                    }
                    ++timesExecuted$3.elem;
                });
                nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(1)).nanos());
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)timesExecuted.elem));
            int $org_scalatest_assert_macro_right = numInvocations / 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("throttled, single burst", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MockedNanoTime nanoTimeControl = new MockedNanoTime();
            LogThrottler throttler = new LogThrottler(5, new package.DurationInt(package$.MODULE$.DurationInt(10)).nanos(), (NanoTimeTimeSource)nanoTimeControl);
            int numInvocations = 100;
            IntRef timesExecuted = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numInvocations).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                throttler.throttled((Function1)(JFunction1.mcVJ.sp & Serializable)skipped -> {
                    if (i < 5) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                        long $org_scalatest_assert_macro_right = 0L;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                    } else if (i == 10) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                        long $org_scalatest_assert_macro_right = 5L;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                    } else {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                        long $org_scalatest_assert_macro_right = 9L;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                    }
                    ++timesExecuted$4.elem;
                });
                nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(1)).nano());
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)timesExecuted.elem));
            int $org_scalatest_assert_macro_right = 5 + (numInvocations - 10) / 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }, new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("throttled, bursty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MockedNanoTime nanoTimeControl = new MockedNanoTime();
            LogThrottler throttler = new LogThrottler(5, new package.DurationInt(package$.MODULE$.DurationInt(10)).nanos(), (NanoTimeTimeSource)nanoTimeControl);
            int numBursts = 10;
            int numInvocationsPerBurst = 10;
            IntRef timesExecuted = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBursts).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)burst -> {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numInvocationsPerBurst).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    throttler.throttled((Function1)(JFunction1.mcVJ.sp & Serializable)skipped -> {
                        if (i == 0 && burst != 0) {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                            long $org_scalatest_assert_macro_right = 5L;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
                        } else {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)skipped));
                            long $org_scalatest_assert_macro_right = 0L;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                        }
                        ++timesExecuted$5.elem;
                    });
                    nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(1)).nano());
                });
                nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(100)).nanos());
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)timesExecuted.elem));
            int $org_scalatest_assert_macro_right = 5 * numBursts;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        }, new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("wraparound", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MockedNanoTime nanoTimeControl = new MockedNanoTime();
            LogThrottler throttler = new LogThrottler(1, new package.DurationInt(package$.MODULE$.DurationInt(100)).nanos(), (NanoTimeTimeSource)nanoTimeControl);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.executeThrottled$1(LogThrottlingSuite.executeThrottled$default$1$1(), throttler), "executeThrottled(executeThrottled$default$1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.executeThrottled$1(LogThrottlingSuite.executeThrottled$default$1$1(), throttler), "executeThrottled(executeThrottled$default$1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            nanoTimeControl.advance(new package.DurationLong(package$.MODULE$.DurationLong(0x7FFFFFFFFFFFFFFEL)).nanos());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.executeThrottled$1(1L, throttler), "executeThrottled(1L)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.executeThrottled$1(LogThrottlingSuite.executeThrottled$default$1$1(), throttler), "executeThrottled(executeThrottled$default$1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(1)).nano());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.executeThrottled$1(LogThrottlingSuite.executeThrottled$default$1$1(), throttler), "executeThrottled(executeThrottled$default$1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(1)).nano());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.executeThrottled$1(LogThrottlingSuite.executeThrottled$default$1$1(), throttler), "executeThrottled(executeThrottled$default$1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            nanoTimeControl.advance(new package.DurationInt(package$.MODULE$.DurationInt(100)).nanos());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.executeThrottled$1(3L, throttler), "executeThrottled(3L)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        }, new Position("LogThrottlingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
    }
}

