/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.util.ArrayImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.funsuite.AnyFunSuite;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u00054A\u0001C\u0005\u0001%!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u000bM!9a\t\u0001b\u0001\n\u00139\u0005BB&\u0001A\u0003%\u0001\nC\u0004M\u0001\t\u0007I\u0011B'\t\r9\u0003\u0001\u0015!\u0003(\u0011\u0015y\u0005\u0001\"\u0003Q\u00051aunZ&fsN\u001cV/\u001b;f\u0015\tQ1\"\u0001\u0003vi&d'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\u000e\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001\u00034v]N,\u0018\u000e^3\u000b\u0005ay\u0011!C:dC2\fG/Z:u\u0013\tQRCA\u0006B]f4UO\\*vSR,\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\f\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0011\u001e\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"A\u0005\u0002)\u001d,GoV8sWN\u0004\u0018mY3GS2,\u0007+\u0019;i)\r9\u0013\u0007\u0011\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nAAZ5mK*\u0011A&L\u0001\u0004]&|'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a%\u0012A\u0001U1uQ\")!G\u0001a\u0001g\u0005)a-\u001b:tiB\u0011A'\u0010\b\u0003km\u0002\"AN\u001d\u000e\u0003]R!\u0001O\t\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qJ\u0004\"B!\u0003\u0001\u0004\u0011\u0015\u0001B7pe\u0016\u00042a\u0011#4\u001b\u0005I\u0014BA#:\u0005)a$/\u001a9fCR,GMP\u0001\u0016e\u0016<WM\\3sCR,wi\u001c7eK:4\u0015\u000e\\3t+\u0005A\u0005CA\"J\u0013\tQ\u0015HA\u0004C_>dW-\u00198\u0002-I,w-\u001a8fe\u0006$XmR8mI\u0016tg)\u001b7fg\u0002\na\u0002\\8h\u0017\u0016Lh)\u001b7f!\u0006$\b.F\u0001(\u0003=awnZ&fs\u001aKG.\u001a)bi\"\u0004\u0013\u0001\u0006:fO\u0016tWM]1uK2{wmS3z\r&dW\rF\u0002R)~\u0003\"a\u0011*\n\u0005MK$\u0001B+oSRDQ!V\u0004A\u0002Y\u000bAb\u001c:jO&t\u0017\r\\&fsN\u00042a\u0016/4\u001d\tA&L\u0004\u000273&\t!(\u0003\u0002\\s\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\r\u0019V-\u001d\u0006\u00037fBQ\u0001Y\u0004A\u0002Y\u000b!b]8si\u0016$7*Z=t\u0001")
public class LogKeysSuite
extends AnyFunSuite
implements Logging {
    private final boolean regenerateGoldenFiles;
    private final Path logKeyFilePath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public final Path getWorkspaceFilePath(String first, Seq<String> more) {
        if (!package$.MODULE$.props().contains("spark.test.home") && !package$.MODULE$.env().contains((Object)"SPARK_HOME")) {
            throw this.fail("spark.test.home or SPARK_HOME is not set.", new Position("LogKeysSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        }
        String sparkHome = (String)package$.MODULE$.props().getOrElse((Object)"spark.test.home", (Function0 & Serializable)() -> (String)package$.MODULE$.env().apply((Object)"SPARK_HOME"));
        String string = first;
        return Paths.get(sparkHome, (String[])((IterableOnceOps)more.$plus$colon((Object)string)).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private boolean regenerateGoldenFiles() {
        return this.regenerateGoldenFiles;
    }

    private Path logKeyFilePath() {
        return this.logKeyFilePath;
    }

    private void regenerateLogKeyFile(Seq<String> originalKeys, Seq<String> sortedKeys) {
        Seq<String> seq = originalKeys;
        Seq<String> seq2 = sortedKeys;
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            File logKeyFile = this.logKeyFilePath().toFile();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Regenerating the file " + logKeyFile);
            Buffer originalContents = CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(logKeyFile.toPath(), StandardCharsets.UTF_8)).asScala();
            int beforeFirstIndex = originalContents.indexWhere((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("public enum LogKeys implements LogKey")));
            String content = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(((IterableOnceOps)originalContents.take(beforeFirstIndex + 1)).mkString("\n") + "\n           |" + ((IterableOnceOps)sortedKeys.map((Function1 & Serializable)key -> "  " + key)).mkString(",\n") + "\n           |}\n           |"));
            Files.delete(logKeyFile.toPath());
            Files.writeString(logKeyFile.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            return;
        }
    }

    public LogKeysSuite() {
        Logging.$init$((Logging)this);
        String string = System.getenv("SPARK_GENERATE_GOLDEN_FILES");
        String string2 = "1";
        this.regenerateGoldenFiles = !(string != null ? !string.equals(string2) : string2 != null);
        this.logKeyFilePath = this.getWorkspaceFilePath("common", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"utils", "src", "main", "java", "org", "apache", "spark", "internal", "LogKeys.java"}));
        this.test("The members of LogKeys are correctly sorted", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArraySeq originalKeys = ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])LogKeys.values()), (Function1 & Serializable)x$2 -> x$2.name(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq();
            ArraySeq sortedKeys = originalKeys.sorted((Ordering)Ordering.String$.MODULE$);
            if (this.regenerateGoldenFiles()) {
                this.regenerateLogKeyFile((Seq<String>)originalKeys, (Seq<String>)sortedKeys);
                return BoxedUnit.UNIT;
            }
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(originalKeys);
            ArraySeq $org_scalatest_assert_macro_right = sortedKeys;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The members of LogKeys must be sorted alphabetically", Prettifier$.MODULE$.default(), new Position("LogKeysSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("LogKeysSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
    }
}

