/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.GlobPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.FileSystemResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.MavenUtils;
import org.apache.spark.util.SparkEnvUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class MavenUtils$
implements Logging {
    public static final MavenUtils$ MODULE$ = new MavenUtils$();
    private static final String JAR_IVY_SETTING_PATH_KEY;
    private static final Seq<String> IVY_DEFAULT_EXCLUDES;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
        JAR_IVY_SETTING_PATH_KEY = "spark.jars.ivySettings";
        IVY_DEFAULT_EXCLUDES = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"catalyst_", "core_", "graphx_", "kvstore_", "launcher_", "mllib_", "mllib-local_", "network-common_", "network-shuffle_", "repl_", "sketch_", "sql_", "streaming_", "tags_", "unsafe_"}));
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$(this, sc);
    }

    @Override
    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$(this, context, body);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    @Override
    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, entry, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    @Override
    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, entry, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    @Override
    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, entry, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    @Override
    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, entry, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    @Override
    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, entry, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String JAR_IVY_SETTING_PATH_KEY() {
        return JAR_IVY_SETTING_PATH_KEY;
    }

    public Seq<String> IVY_DEFAULT_EXCLUDES() {
        return IVY_DEFAULT_EXCLUDES;
    }

    public Seq<MavenUtils.MavenCoordinate> extractMavenCoordinates(String coordinates) {
        return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])coordinates.split(",")), (Function1 & Serializable)p -> {
            String[] splits = p.replace("/", ":").split(":");
            Predef$.MODULE$.require(splits.length == 3, (Function0 & Serializable)() -> "Provided Maven Coordinates must be in the form 'groupId:artifactId:version'. The coordinate provided is: " + p);
            Predef$.MODULE$.require(splits[0] != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(splits[0].trim())), (Function0 & Serializable)() -> "The groupId cannot be null or be whitespace. The groupId provided is: " + splits[0]);
            Predef$.MODULE$.require(splits[1] != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(splits[1].trim())), (Function0 & Serializable)() -> "The artifactId cannot be null or be whitespace. The artifactId provided is: " + splits[1]);
            Predef$.MODULE$.require(splits[2] != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(splits[2].trim())), (Function0 & Serializable)() -> "The version cannot be null or be whitespace. The version provided is: " + splits[2]);
            return new MavenUtils.MavenCoordinate(splits[0], splits[1], splits[2]);
        }, ClassTag$.MODULE$.apply(MavenUtils.MavenCoordinate.class))).toImmutableArraySeq();
    }

    public File m2Path() {
        if (SparkEnvUtils$.MODULE$.isTesting()) {
            return new File("dummy", ".m2" + File.separator + "repository");
        }
        return new File(System.getProperty("user.home"), ".m2" + File.separator + "repository");
    }

    public ChainResolver createRepoResolvers(File defaultIvyUserDir, boolean useLocalM2AsCache) {
        ChainResolver cr = new ChainResolver();
        cr.setName("spark-list");
        if (useLocalM2AsCache) {
            IBiblioResolver localM2 = new IBiblioResolver();
            localM2.setM2compatible(true);
            localM2.setRoot(this.m2Path().toURI().toString());
            localM2.setUsepoms(true);
            localM2.setName("local-m2-cache");
            cr.add((DependencyResolver)localM2);
        }
        FileSystemResolver localIvy = new FileSystemResolver();
        File localIvyRoot = new File(defaultIvyUserDir, "local");
        localIvy.setLocal(true);
        localIvy.setRepository((Repository)new FileRepository(localIvyRoot));
        String ivyPattern = new .colon.colon((Object)localIvyRoot.getAbsolutePath(), (List)new .colon.colon((Object)"[organisation]", (List)new .colon.colon((Object)"[module]", (List)new .colon.colon((Object)"[revision]", (List)new .colon.colon((Object)"ivys", (List)new .colon.colon((Object)"ivy.xml", (List)Nil$.MODULE$)))))).mkString(File.separator);
        localIvy.addIvyPattern(ivyPattern);
        String artifactPattern = new .colon.colon((Object)localIvyRoot.getAbsolutePath(), (List)new .colon.colon((Object)"[organisation]", (List)new .colon.colon((Object)"[module]", (List)new .colon.colon((Object)"[revision]", (List)new .colon.colon((Object)"[type]s", (List)new .colon.colon((Object)"[artifact](-[classifier]).[ext]", (List)Nil$.MODULE$)))))).mkString(File.separator);
        localIvy.addArtifactPattern(artifactPattern);
        localIvy.setName("local-ivy-cache");
        cr.add((DependencyResolver)localIvy);
        IBiblioResolver br = new IBiblioResolver();
        br.setM2compatible(true);
        br.setUsepoms(true);
        Option defaultInternalRepo = scala.sys.package$.MODULE$.env().get((Object)"DEFAULT_ARTIFACT_REPOSITORY");
        br.setRoot((String)defaultInternalRepo.getOrElse((Function0 & Serializable)() -> "https://repo1.maven.org/maven2/"));
        br.setName("central");
        cr.add((DependencyResolver)br);
        IBiblioResolver sp2 = new IBiblioResolver();
        sp2.setM2compatible(true);
        sp2.setUsepoms(true);
        sp2.setRoot((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"DEFAULT_ARTIFACT_REPOSITORY", (Function0 & Serializable)() -> "https://repos.spark-packages.org/"));
        sp2.setName("spark-packages");
        cr.add((DependencyResolver)sp2);
        return cr;
    }

    public boolean createRepoResolvers$default$2() {
        return true;
    }

    public Seq<String> resolveDependencyPaths(Object[] artifacts, File cacheDirectory) {
        return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(artifacts), (Function1 & Serializable)x$1 -> (Artifact)x$1, ClassTag$.MODULE$.apply(Artifact.class))), (Function1 & Serializable)artifactInfo -> BoxesRunTime.boxToBoolean((boolean)MavenUtils$.$anonfun$resolveDependencyPaths$2(artifactInfo)))), (Function1 & Serializable)artifactInfo -> {
            ModuleRevisionId artifact = artifactInfo.getModuleRevisionId();
            Map extraAttrs = artifactInfo.getExtraAttributes();
            String classifier = extraAttrs.containsKey("classifier") ? "-" + extraAttrs.get("classifier") : "";
            return cacheDirectory.getAbsolutePath() + File.separator + artifact.getOrganisation() + "_" + artifact.getName() + "-" + artifact.getRevision() + classifier + ".jar";
        }, ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq();
    }

    public void addDependenciesToIvy(DefaultModuleDescriptor md, Seq<MavenUtils.MavenCoordinate> artifacts, String ivyConfName, PrintStream printStream) {
        artifacts.foreach((Function1 & Serializable)mvn -> {
            MavenUtils$.$anonfun$addDependenciesToIvy$1(ivyConfName, printStream, md, mvn);
            return BoxedUnit.UNIT;
        });
    }

    private void addExclusionRules(IvySettings ivySettings, String ivyConfName, DefaultModuleDescriptor md) {
        md.addExcludeRule(this.createExclusion("*:scala-library:*", ivySettings, ivyConfName));
        this.IVY_DEFAULT_EXCLUDES().foreach((Function1 & Serializable)comp -> {
            md.addExcludeRule(MavenUtils$.MODULE$.createExclusion("org.apache.spark:spark-" + comp + "*:*", ivySettings, ivyConfName));
            return BoxedUnit.UNIT;
        });
    }

    public IvySettings buildIvySettings(Option<String> remoteRepos, Option<String> ivyPath, boolean useLocalM2AsCache, PrintStream printStream) {
        IvySettings ivySettings = new IvySettings();
        this.processIvyPathArg(ivySettings, ivyPath);
        ivySettings.addMatcher((PatternMatcher)new GlobPatternMatcher());
        ChainResolver repoResolver = this.createRepoResolvers(ivySettings.getDefaultIvyUserDir(), useLocalM2AsCache);
        ivySettings.addResolver((DependencyResolver)repoResolver);
        ivySettings.setDefaultResolver(repoResolver.getName());
        this.processRemoteRepoArg(ivySettings, remoteRepos, printStream);
        ivySettings.setVariable("ivy.maven.lookup.sources", "false");
        ivySettings.setVariable("ivy.maven.lookup.javadoc", "false");
        return ivySettings;
    }

    public boolean buildIvySettings$default$3() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IvySettings loadIvySettings(String settingsFile, Option<String> remoteRepos, Option<String> ivyPath, PrintStream printStream) {
        URI uri = new URI(settingsFile);
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable)() -> "file");
        File file = switch (string == null ? 0 : string.hashCode()) {
            case 3143036 -> {
                if (!"file".equals(string)) throw new IllegalArgumentException("Scheme " + string + " not supported in " + this.JAR_IVY_SETTING_PATH_KEY());
                yield new File(uri.getPath());
            }
            default -> throw new IllegalArgumentException("Scheme " + string + " not supported in " + this.JAR_IVY_SETTING_PATH_KEY());
        };
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable)() -> "Ivy settings file " + file + " does not exist");
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable)() -> "Ivy settings file " + file + " is not a normal file");
        IvySettings ivySettings = new IvySettings();
        try {
            ivySettings.load(file);
            if (ivySettings.getDefaultIvyUserDir() == null && ivySettings.getDefaultCache() == null) {
                String alternateIvyDir = System.getProperty("ivy.home", System.getProperty("user.home") + File.separator + ".ivy2.5.2");
                ivySettings.setDefaultIvyUserDir(new File(alternateIvyDir));
                ivySettings.setDefaultCache(new File(alternateIvyDir, "cache"));
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof IOException ? true : throwable2 instanceof ParseException)) throw throwable;
            throw new SparkException("Failed when loading Ivy settings from " + settingsFile, throwable2);
        }
        this.processIvyPathArg(ivySettings, ivyPath);
        this.processRemoteRepoArg(ivySettings, remoteRepos, printStream);
        return ivySettings;
    }

    private void processIvyPathArg(IvySettings ivySettings, Option<String> ivyPath) {
        String alternateIvyDir = (String)ivyPath.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MavenUtils$.$anonfun$processIvyPathArg$1(x$2))).getOrElse((Function0 & Serializable)() -> System.getProperty("ivy.home", System.getProperty("user.home") + File.separator + ".ivy2.5.2"));
        ivySettings.setDefaultIvyUserDir(new File(alternateIvyDir));
        ivySettings.setDefaultCache(new File(alternateIvyDir, "cache"));
    }

    private void processRemoteRepoArg(IvySettings ivySettings, Option<String> remoteRepos, PrintStream printStream) {
        remoteRepos.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MavenUtils$.$anonfun$processRemoteRepoArg$1(x$3))).map((Function1 & Serializable)x$4 -> x$4.split(",")).foreach((Function1 & Serializable)repositoryList -> {
            MavenUtils$.$anonfun$processRemoteRepoArg$3(ivySettings, printStream, repositoryList);
            return BoxedUnit.UNIT;
        });
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"org.apache.spark", (String)("spark-submit-parent-" + UUID.randomUUID().toString()), (String)"1.0"));
    }

    private void clearIvyResolutionFiles(ModuleRevisionId mdId, File defaultCacheFile, String ivyConfName) {
        .colon.colon currentResolutionFiles = new .colon.colon((Object)(mdId.getOrganisation() + "-" + mdId.getName() + "-" + ivyConfName + ".xml"), (List)new .colon.colon((Object)("resolved-" + mdId.getOrganisation() + "-" + mdId.getName() + "-" + mdId.getRevision() + ".xml"), (List)new .colon.colon((Object)("resolved-" + mdId.getOrganisation() + "-" + mdId.getName() + "-" + mdId.getRevision() + ".properties"), (List)Nil$.MODULE$)));
        currentResolutionFiles.foreach((Function1 & Serializable)filename -> BoxesRunTime.boxToBoolean((boolean)MavenUtils$.$anonfun$clearIvyResolutionFiles$1(defaultCacheFile, filename)));
    }

    private void clearInvalidIvyCacheFiles(ModuleRevisionId mdId, File defaultCacheFile) {
        .colon.colon cacheFiles = new .colon.colon((Object)(mdId.getOrganisation() + File.separator + mdId.getName() + File.separator + "ivy-" + mdId.getRevision() + ".xml"), (List)new .colon.colon((Object)(mdId.getOrganisation() + File.separator + mdId.getName() + File.separator + "ivy-" + mdId.getRevision() + ".xml.original"), (List)new .colon.colon((Object)(mdId.getOrganisation() + File.separator + mdId.getName() + File.separator + "ivydata-" + mdId.getRevision() + ".properties"), (List)Nil$.MODULE$)));
        cacheFiles.foreach((Function1 & Serializable)filename -> BoxesRunTime.boxToBoolean((boolean)MavenUtils$.$anonfun$clearInvalidIvyCacheFiles$1(defaultCacheFile, filename)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> resolveMavenCoordinates(String coordinates, IvySettings ivySettings, Option<IvySettings> noCacheIvySettings, boolean transitive, Seq<String> exclusions, boolean isTest, PrintStream printStream) {
        if (coordinates == null || coordinates.trim().isEmpty()) {
            return Nil$.MODULE$;
        }
        PrintStream sysOut = System.out;
        String ivyConfName = "default";
        DefaultModuleDescriptor md = this.getModuleDescriptor();
        md.setDefaultConf(ivyConfName);
        try {
            Seq<String> seq;
            System.setOut(printStream);
            Seq<MavenUtils.MavenCoordinate> artifacts = this.extractMavenCoordinates(coordinates);
            File packagesDirectory = new File(ivySettings.getDefaultIvyUserDir(), "jars");
            printStream.println("Ivy Default Cache set to: " + ivySettings.getDefaultCache().getAbsolutePath());
            printStream.println("The jars for the packages stored in: " + packagesDirectory);
            Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
            ivy.pushContext();
            ResolveOptions resolveOptions = new ResolveOptions();
            resolveOptions.setTransitive(transitive);
            RetrieveOptions retrieveOptions = new RetrieveOptions();
            if (isTest) {
                resolveOptions.setDownload(false);
                resolveOptions.setLog("quiet");
                v0 = retrieveOptions.setLog("quiet");
            } else {
                v0 = resolveOptions.setDownload(true);
            }
            retrieveOptions.setDestArtifactPattern(packagesDirectory.getAbsolutePath() + File.separator + "[organization]_[artifact]-[revision](-[classifier]).[ext]");
            retrieveOptions.setConfs((String[])((Object[])new String[]{ivyConfName}));
            this.addExclusionRules(ivySettings, ivyConfName, md);
            this.addDependenciesToIvy(md, artifacts, ivyConfName, printStream);
            exclusions.foreach((Function1 & Serializable)e -> {
                md.addExcludeRule(MavenUtils$.MODULE$.createExclusion(e + ":*", ivySettings, ivyConfName));
                return BoxedUnit.UNIT;
            });
            ResolveReport rr = ivy.resolve((ModuleDescriptor)md, resolveOptions);
            if (rr.hasError()) {
                ArtifactDownloadReport[] failedReports = rr.getArtifactsReports(DownloadStatus.FAILED, true);
                if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])failedReports)) || !noCacheIvySettings.isDefined()) throw new RuntimeException(rr.getAllProblemMessages().toString());
                Artifact[] failedArtifacts = (Artifact[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])failedReports), (Function1 & Serializable)r -> r.getArtifact(), ClassTag$.MODULE$.apply(Artifact.class));
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Download failed: " + Predef$.MODULE$.wrapRefArray((Object[])failedArtifacts).mkString("[", ", ", "]") + ", attempt to retry while skipping local-m2-cache.");
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])failedArtifacts), (Function1 & Serializable)artifact -> {
                    MavenUtils$.MODULE$.clearInvalidIvyCacheFiles(artifact.getModuleRevisionId(), ivySettings.getDefaultCache());
                    return BoxedUnit.UNIT;
                });
                ivy.popContext();
                Ivy noCacheIvy = Ivy.newInstance((IvySettings)((IvySettings)noCacheIvySettings.get()));
                noCacheIvy.pushContext();
                ResolveReport noCacheRr = noCacheIvy.resolve((ModuleDescriptor)md, resolveOptions);
                if (noCacheRr.hasError()) {
                    throw new RuntimeException(noCacheRr.getAllProblemMessages().toString());
                }
                noCacheIvy.retrieve(noCacheRr.getModuleDescriptor().getModuleRevisionId(), retrieveOptions);
                Seq<String> dependencyPaths = this.resolveDependencyPaths(noCacheRr.getArtifacts().toArray(), packagesDirectory);
                noCacheIvy.popContext();
                seq = dependencyPaths;
                return seq;
            } else {
                ivy.retrieve(rr.getModuleDescriptor().getModuleRevisionId(), retrieveOptions);
                Seq<String> dependencyPaths = this.resolveDependencyPaths(rr.getArtifacts().toArray(), packagesDirectory);
                ivy.popContext();
                seq = dependencyPaths;
            }
            return seq;
        }
        finally {
            System.setOut(sysOut);
            this.clearIvyResolutionFiles(md.getModuleRevisionId(), ivySettings.getDefaultCache(), ivyConfName);
        }
    }

    public Option<IvySettings> resolveMavenCoordinates$default$3() {
        return None$.MODULE$;
    }

    public Seq<String> resolveMavenCoordinates$default$5() {
        return Nil$.MODULE$;
    }

    public boolean resolveMavenCoordinates$default$6() {
        return false;
    }

    public ExcludeRule createExclusion(String coords, IvySettings ivySettings, String ivyConfName) {
        MavenUtils.MavenCoordinate c = (MavenUtils.MavenCoordinate)this.extractMavenCoordinates(coords).head();
        ArtifactId id = new ArtifactId(new ModuleId(c.groupId(), c.artifactId()), "*", "*", "*");
        DefaultExcludeRule rule = new DefaultExcludeRule(id, ivySettings.getMatcher("glob"), null);
        rule.addConfiguration(ivyConfName);
        return rule;
    }

    private boolean isInvalidQueryString(String[] tokens) {
        return tokens.length != 2 || StringUtils.isBlank((CharSequence)tokens[0]) || StringUtils.isBlank((CharSequence)tokens[1]);
    }

    public Tuple3<Object, String, String> parseQueryParams(URI uri) {
        String uriQuery = uri.getQuery();
        if (uriQuery == null) {
            return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"", (Object)"");
        }
        String[][] mapTokens = (String[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])uriQuery.split("&")), (Function1 & Serializable)x$5 -> x$5.split("="), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])mapTokens), (Function1 & Serializable)tokens -> BoxesRunTime.boxToBoolean((boolean)MavenUtils$.MODULE$.isInvalidQueryString(tokens)))) {
            throw new IllegalArgumentException("Invalid query string in Ivy URI " + uri.toString() + ": " + uriQuery);
        }
        scala.collection.immutable.Map groupedParams = ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])mapTokens), (Function1 & Serializable)kv -> new Tuple2((Object)kv[0], (Object)kv[1]), ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$6 -> (String)x$6._1());
        Option transitiveParams = groupedParams.get((Object)"transitive");
        if (BoxesRunTime.unboxToInt((Object)transitiveParams.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)MavenUtils$.$anonfun$parseQueryParams$5(x$7))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) > 1) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "It's best to specify `transitive` parameter in ivy URI query only once. If there are multiple `transitive` parameter, we will select the last one");
        }
        boolean transitive = BoxesRunTime.unboxToBoolean((Object)transitiveParams.flatMap((Function1 & Serializable)x$8 -> ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.booleanArrayOps((boolean[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])x$8), 1)), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MavenUtils$.$anonfun$parseQueryParams$9(x$9)), (ClassTag)ClassTag$.MODULE$.Boolean())))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        String exclusionList = (String)groupedParams.get((Object)"exclude").map((Function1 & Serializable)params -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])params), (Function1 & Serializable)x$10 -> (String)x$10._2(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)excludeString -> {
            String[] excludes = excludeString.split(",");
            if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])excludes), (Function1 & Serializable)x$11 -> x$11.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)tokens -> BoxesRunTime.boxToBoolean((boolean)MavenUtils$.MODULE$.isInvalidQueryString(tokens)))) {
                throw new IllegalArgumentException("Invalid exclude string in Ivy URI " + uri.toString() + ": expected 'org:module,org:module,..', found " + excludeString);
            }
            return excludes;
        }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class))).mkString(",")).getOrElse((Function0 & Serializable)() -> "");
        String repos = (String)groupedParams.get((Object)"repos").map((Function1 & Serializable)params -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])params), (Function1 & Serializable)x$12 -> (String)x$12._2(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$13 -> x$13.split(","), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class))).mkString(",")).getOrElse((Function0 & Serializable)() -> "");
        Set validParams = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"transitive", "exclude", "repos"}));
        Seq invalidParams = ((IterableOnceOps)groupedParams.keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validParams.contains((Object)elem)))).toSeq();
        if (invalidParams.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Invalid parameters `" + ((IterableOnceOps)invalidParams.sorted((Ordering)Ordering.String$.MODULE$)).mkString(",") + "` found in Ivy URI query `" + uriQuery + "`.");
        }
        return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)transitive), (Object)exclusionList, (Object)repos);
    }

    public static final /* synthetic */ boolean $anonfun$resolveDependencyPaths$2(Artifact artifactInfo) {
        String string = artifactInfo.getExt();
        String string2 = "jar";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return true;
        }
        MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Skipping non-jar dependency " + artifactInfo.getId());
        return false;
    }

    public static final /* synthetic */ void $anonfun$addDependenciesToIvy$1(String ivyConfName$1, PrintStream printStream$1, DefaultModuleDescriptor md$1, MavenUtils.MavenCoordinate mvn) {
        ModuleRevisionId ri = ModuleRevisionId.newInstance((String)mvn.groupId(), (String)mvn.artifactId(), (String)mvn.version());
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(ri, false, false);
        dd.addDependencyConfiguration(ivyConfName$1, ivyConfName$1 + "(runtime)");
        printStream$1.println(dd.getDependencyId() + " added as a dependency");
        md$1.addDependency((DependencyDescriptor)dd);
    }

    public static final /* synthetic */ boolean $anonfun$processIvyPathArg$1(String x$2) {
        return x$2.trim().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$processRemoteRepoArg$1(String x$3) {
        return x$3.trim().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$processRemoteRepoArg$5(ChainResolver cr$1, PrintStream printStream$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String repo = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            IBiblioResolver brr = new IBiblioResolver();
            brr.setM2compatible(true);
            brr.setUsepoms(true);
            brr.setRoot(repo);
            brr.setName("repo-" + (i + 1));
            cr$1.add((DependencyResolver)brr);
            printStream$2.println(repo + " added as a remote repository with the name: " + brr.getName());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$processRemoteRepoArg$3(IvySettings ivySettings$2, PrintStream printStream$2, String[] repositoryList) {
        ChainResolver cr = new ChainResolver();
        cr.setName("user-list");
        Option$.MODULE$.apply((Object)ivySettings$2.getDefaultResolver()).foreach((Function1 & Serializable)x$1 -> {
            cr.add(x$1);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])repositoryList))), (Function1 & Serializable)x0$1 -> {
            MavenUtils$.$anonfun$processRemoteRepoArg$5(cr, printStream$2, x0$1);
            return BoxedUnit.UNIT;
        });
        ivySettings$2.addResolver((DependencyResolver)cr);
        ivySettings$2.setDefaultResolver(cr.getName());
    }

    public static final /* synthetic */ boolean $anonfun$clearIvyResolutionFiles$1(File defaultCacheFile$1, String filename) {
        return new File(defaultCacheFile$1, filename).delete();
    }

    public static final /* synthetic */ boolean $anonfun$clearInvalidIvyCacheFiles$1(File defaultCacheFile$2, String filename) {
        return new File(defaultCacheFile$2, filename).delete();
    }

    public static final /* synthetic */ int $anonfun$parseQueryParams$5(Tuple2[] x$7) {
        return x$7.length;
    }

    public static final /* synthetic */ boolean $anonfun$parseQueryParams$9(Tuple2 x$9) {
        return ((String)x$9._2()).equalsIgnoreCase("true");
    }

    private MavenUtils$() {
    }
}

