/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class AvroReadBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final AvroReadBenchmark$ MODULE$ = new AvroReadBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$((SqlBasedBenchmark)MODULE$);
    }

    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$((SqlBasedBenchmark)this);
    }

    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$((SqlBasedBenchmark)this, (String)name, (long)cardinality, f);
    }

    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$((SqlBasedBenchmark)this, ds);
    }

    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$((SqlBasedBenchmark)this, (Benchmark)benchmark);
    }

    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$((SqlBasedBenchmark)this, (String)path, (int)rowsNum, (int)numCols);
    }

    public void afterAll() {
        SqlBasedBenchmark.afterAll$((SqlBasedBenchmark)this);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public SparkSession spark() {
        return spark;
    }

    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        AvroReadBenchmark$ avroReadBenchmark$ = this;
        synchronized (avroReadBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            Catalog catalog = this.spark().catalog();
            tableNames.foreach((Function1 & Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)catalog.dropTempView(viewName)));
        }
    }

    private void prepareTable(File dir, Dataset<Row> df, Option<String> partition) {
        String dirAvro = dir.getCanonicalPath();
        if (partition.isDefined()) {
            df.write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})).format("avro").save(dirAvro);
        } else {
            df.write().format("avro").save(dirAvro);
        }
        this.spark().read().format("avro").load(dirAvro).createOrReplaceTempView("avroTable");
    }

    private Option<String> prepareTable$default$3() {
        return None$.MODULE$;
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        String x$1 = "SQL Single " + dataType.sql() + " Column Scan";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$1).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT mod(value, 255) id FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$1.addCase("Sum", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM avroTable")).noop());
                benchmark$1.run(benchmark$1.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void intStringScanBenchmark(int values) {
        String x$1 = "Int and String Scan";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Int and String Scan", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$2).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT value % " + Integer.MAX_VALUE + " AS c1, CAST(value as STRING) AS c2 FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$2.addCase("Sum of columns", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM avroTable")).noop());
                benchmark$2.run(benchmark$2.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void partitionTableScanBenchmark(int values) {
        String x$1 = "Partitioned Table";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Partitioned Table", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$3).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT value % 2 AS p, value % " + Integer.MAX_VALUE + " AS id FROM t1"), (Option<String>)new Some((Object)"p"));
                benchmark$3.addCase("Data column", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM avroTable")).noop());
                benchmark$3.addCase("Partition column", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM avroTable")).noop());
                benchmark$3.addCase("Both columns", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM avroTable")).noop());
                benchmark$3.run(benchmark$3.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        String x$1 = "Repeated String";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Repeated String", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$4).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT CAST((id % 200) + 10000 as STRING) AS c1 FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$4.addCase("Sum of string length", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM avroTable")).noop());
                benchmark$4.run(benchmark$4.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$5).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT IF(RAND(1) < " + fractionOfNulls$1 + ", NULL, CAST(id as STRING)) AS c1, IF(RAND(2) < " + fractionOfNulls$1 + ", NULL, CAST(id as STRING)) AS c2 FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                double percentageOfNulls = fractionOfNulls$1 * (double)100;
                String x$1 = "String with Nulls Scan (" + percentageOfNulls + "%)";
                long x$2 = values$5;
                Option x$3 = AvroReadBenchmark$.MODULE$.output();
                int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
                FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
                benchmark.addCase("Sum of string length", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM avroTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop());
                benchmark.run(benchmark.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void columnsBenchmark(int values, int width) {
        String x$1 = "Single Column Scan from " + width + " columns";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                int middle = width$1 / 2;
                IndexedSeq selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable)i -> AvroReadBenchmark$.$anonfun$columnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)));
                AvroReadBenchmark$.MODULE$.spark().range((long)values$6).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$5.addCase("Sum of single column", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM avroTable")).noop());
                benchmark$5.run(benchmark$5.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    private void wideColumnsBenchmark(int values, int width, int files) {
        String x$1 = "Wide Column Scan from " + width + " columns";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                IndexedSeq selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width$2).map((Function1 & Serializable)i -> AvroReadBenchmark$.$anonfun$wideColumnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)));
                AvroReadBenchmark$.MODULE$.spark().range((long)values$7).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).repartition(files$1).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$6.addCase("Select of all columns", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$14 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT * FROM avroTable")).noop());
                benchmark$6.run(benchmark$6.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    private void filtersPushdownBenchmark(int rowsNum, int numIters) {
        String x$1 = "Filters pushdown";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Filters pushdown", x$2, x$4, x$5, x$6, x$7, x$3);
        int colsNum = 100;
        Seq fields = (Seq)package$.MODULE$.Seq().tabulate(colsNum, (Function1 & Serializable)i -> AvroReadBenchmark$.$anonfun$filtersPushdownBenchmark$1(BoxesRunTime.unboxToInt((Object)i)));
        StructField structField = new StructField("key", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)fields.$plus$colon((Object)structField));
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            AvroReadBenchmark$.$anonfun$filtersPushdownBenchmark$3(this, rowsNum, schema, benchmark, numIters, colsNum, path);
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("SQL Single Numeric Column Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)dataType -> {
            AvroReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Int and String Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.intStringScanBenchmark(0xA00000));
        this.runBenchmark("Partitioned Table Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.partitionTableScanBenchmark(0xF00000));
        this.runBenchmark("Repeated String Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.repeatedStringScanBenchmark(0xA00000));
        this.runBenchmark("String with Nulls Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable)fractionOfNulls -> MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls)));
        this.runBenchmark("Select All From Wide Columns", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.wideColumnsBenchmark(500000, 1000, 20));
        this.runBenchmark("Single Column Scan From Wide Columns", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.columnsBenchmark(0x100000, 100);
            MODULE$.columnsBenchmark(0x100000, 200);
            MODULE$.columnsBenchmark(0x100000, 300);
        });
        this.filtersPushdownBenchmark(1000000, 3);
    }

    public static final /* synthetic */ String $anonfun$columnsBenchmark$3(int i) {
        return "value % " + Integer.MAX_VALUE + " as c" + i;
    }

    public static final /* synthetic */ String $anonfun$wideColumnsBenchmark$3(int i) {
        return "value as c" + i;
    }

    public static final /* synthetic */ StructField $anonfun$filtersPushdownBenchmark$1(int i) {
        return new StructField("col" + i, (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Column $anonfun$filtersPushdownBenchmark$2(int i) {
        return functions$.MODULE$.lit((Object)Instant.ofEpochSecond(-30610224000L + (long)(i * 123456))).as("col" + i);
    }

    private final Seq columns$1(int colsNum$1) {
        Seq ts = (Seq)package$.MODULE$.Seq().tabulate(colsNum$1, (Function1 & Serializable)i -> AvroReadBenchmark$.$anonfun$filtersPushdownBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        Column column = this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToInteger((int)1000)).as("key");
        return (Seq)ts.$plus$colon((Object)column);
    }

    private static final Dataset readback$1(StructType schema$1, File path$1) {
        return MODULE$.spark().read().schema(schema$1).format("avro").load(path$1.getAbsolutePath());
    }

    private static final void withFilter$1(boolean configEnabled, StructType schema$1, File path$1) {
        MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key()), (Object)"LEGACY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AVRO_FILTER_PUSHDOWN_ENABLED().key()), (Object)Boolean.toString(configEnabled))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(AvroReadBenchmark$.readback$1(schema$1, path$1).filter(MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)))).noop());
    }

    public static final /* synthetic */ void $anonfun$filtersPushdownBenchmark$3(AvroReadBenchmark$ $this, int rowsNum$1, StructType schema$1, Benchmark benchmark$7, int numIters$1, int colsNum$1, File path) {
        MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE().key()), (Object)"LEGACY")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.spark().range((long)rowsNum$1).select($this.columns$1(colsNum$1)).write().format("avro").save(path.getAbsolutePath()));
        benchmark$7.addCase("w/o filters", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key()), (Object)"LEGACY")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(AvroReadBenchmark$.readback$1(schema$1, path)).noop()));
        benchmark$7.addCase("pushdown disabled", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key()), (Object)"LEGACY")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> AvroReadBenchmark$.withFilter$1(false, schema$1, path)));
        benchmark$7.addCase("w/ filters", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$17 -> AvroReadBenchmark$.withFilter$1(true, schema$1, path));
        benchmark$7.run(benchmark$7.run$default$1());
    }

    private AvroReadBenchmark$() {
    }
}

