/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.avro.AvroSerdeSuite$;
import org.apache.spark.sql.avro.AvroSerdeSuite$Deserializer$;
import org.apache.spark.sql.avro.AvroSerdeSuite$MatchType$;
import org.apache.spark.sql.avro.AvroSerdeSuite$Serializer$;
import org.apache.spark.sql.avro.AvroSerializer;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001B\u0011#\u00015BQA\r\u0001\u0005\u0002MBQA\u000e\u0001\u0005\n]B\u0011\"!0\u0001#\u0003%I!a0\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\u001e)!J\tE\u0001\u0017\u001a)\u0011E\tE\u0001\u0019\")!G\u0002C\u00011\"9\u0011L\u0002b\u0001\n\u0013Q\u0006BB1\u0007A\u0003%1lB\u0003c\r!%1MB\u0003f\r!%a\rC\u00033\u0017\u0011\u0005!.\u0002\u0003f\u0017\u0001Y\u0007bB8\f\u0005\u0004%\t\u0001\u001d\u0005\u0007c.\u0001\u000b\u0011B6\t\u000fI\\!\u0019!C\u0001a\"11o\u0003Q\u0001\n-DQ\u0001^\u0006\u0005\u0002UDq\u0001`\u0006\u0002\u0002\u0013%QPB\u0005\u0002\n\u0019\u0001\n1%\u000b\u0002\f!9\u0011q\u0002\u000b\u0007\u0002\u0005EqaBA5\r!%\u0011q\f\u0004\b\u0003#2\u0001\u0012BA*\u0011\u0019\u0011t\u0003\"\u0001\u0002^!9\u0011qB\f\u0005B\u0005\u0005taBA6\r!%\u0011Q\t\u0004\b\u0003o1\u0001\u0012BA\u001d\u0011\u0019\u00114\u0004\"\u0001\u0002D!9\u0011qB\u000e\u0005B\u0005\u001d\u0003bBA7\r\u0011%\u0011q\u000e\u0005\b\u0003G3A\u0011BAS\u0011\u001dah!!A\u0005\nu\u0014a\"\u0011<s_N+'\u000fZ3Tk&$XM\u0003\u0002$I\u0005!\u0011M\u001e:p\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0006\u0005\u00020a5\ta%\u0003\u00022M\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u001b\u0011\u0005U\u0002Q\"\u0001\u0012\u0002;\u0005\u001c8/\u001a:u\r\u0006LG.\u001a3D_:4XM]:j_:lUm]:bO\u0016$\u0012\u0002\u000f F\u0003_\u000b),!/\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007f\t\u0001\r\u0001Q\u0001\u000bCZ\u0014xnU2iK6\f\u0007CA!D\u001b\u0005\u0011%BA\u0012)\u0013\t!%I\u0001\u0004TG\",W.\u0019\u0005\u0006\r\n\u0001\raR\u0001\rg\u0016\u0014H-\u001a$bGR|'/\u001f\u0019\u0004\u0011\u0006-\u0006\u0003B%\u0015\u0003Ss!!N\u0003\u0002\u001d\u00053(o\\*fe\u0012,7+^5uKB\u0011QGB\n\u0004\r5\u0003\u0006CA\u001dO\u0013\ty%H\u0001\u0004B]f\u0014VM\u001a\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000b!![8\u000b\u0003U\u000bAA[1wC&\u0011qK\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0002\u0017\u0006y1)\u0011+B\u0019f\u001bFkX*U%V\u001bE+F\u0001\\!\tav,D\u0001^\u0015\tqF%A\u0003usB,7/\u0003\u0002a;\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002!\r\u000bE+\u0011'Z'R{6\u000b\u0016*V\u0007R\u0003\u0013!C'bi\u000eDG+\u001f9f!\t!7\"D\u0001\u0007\u0005%i\u0015\r^2i)f\u0004Xm\u0005\u0002\fOB\u0011\u0011\b[\u0005\u0003Sj\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]R\t1\r\u0005\u0002m[6\t1\"\u0003\u0002oQ\n)a+\u00197vK\u00069!)W0O\u00036+U#A6\u0002\u0011\tKvLT!N\u000b\u0002\n1BQ-`!>\u001b\u0016\nV%P\u001d\u0006a!)W0Q\u001fNKE+S(OA\u0005a\u0011n\u001d)pg&$\u0018n\u001c8bYR\u0011a/\u001f\t\u0003s]L!\u0001\u001f\u001e\u0003\u000f\t{w\u000e\\3b]\")!P\u0005a\u0001w\u0006qa-[3mI6\u000bGo\u00195UsB,\u0007C\u00017\u000e\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007!\u0016\u0001\u00027b]\u001eLA!a\u0002\u0002\u0002\t1qJ\u00196fGR\u0014AbU3sI\u00164\u0015m\u0019;pef,B!!\u0004\u0002\u0018M\u0011A#T\u0001\u0007GJ,\u0017\r^3\u0015\u0011\u0005M\u0011\u0011FA\u0017\u0003_\u0001B!!\u0006\u0002\u00181\u0001AaBA\r)\t\u0007\u00111\u0004\u0002\u0002)F!\u0011QDA\u0012!\rI\u0014qD\u0005\u0004\u0003CQ$a\u0002(pi\"Lgn\u001a\t\u0004s\u0005\u0015\u0012bAA\u0014u\t\u0019\u0011I\\=\t\r\u0005-R\u00031\u0001\\\u0003%\u0019\u0018\u000f\\*dQ\u0016l\u0017\rC\u0003@+\u0001\u0007\u0001\t\u0003\u0004{+\u0001\u0007\u0011\u0011\u0007\t\u0004\u0003giaB\u00013\u000bS\r!2d\u0006\u0002\r\t\u0016\u001cXM]5bY&TXM]\n\u000575\u000bY\u0004\u0005\u0003e)\u0005u\u0002cA\u001b\u0002@%\u0019\u0011\u0011\t\u0012\u0003!\u00053(o\u001c#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014HCAA#!\t!7\u0004\u0006\u0005\u0002>\u0005%\u00131JA'\u0011\u0015)S\u00041\u0001\\\u0011\u0015\u0019S\u00041\u0001A\u0011\u001d\ty%\ba\u0001\u0003c\t\u0011\"\\1uG\"$\u0016\u0010]3\u0003\u0015M+'/[1mSj,'o\u0005\u0003\u0018\u001b\u0006U\u0003\u0003\u00023\u0015\u0003/\u00022!NA-\u0013\r\tYF\t\u0002\u000f\u0003Z\u0014xnU3sS\u0006d\u0017N_3s)\t\ty\u0006\u0005\u0002e/QA\u0011qKA2\u0003K\n9\u0007C\u0003&3\u0001\u00071\fC\u0003$3\u0001\u0007\u0001\tC\u0004\u0002Pe\u0001\r!!\r\u0002\u0015M+'/[1mSj,'/\u0001\u0007EKN,'/[1mSj,'/\u0001\u0011de\u0016\fG/\u001a(fgR,G-\u0011<s_N\u001b\u0007.Z7b/&$\bNR5fY\u0012\u001cH#\u0002!\u0002r\u0005-\u0005bBA:=\u0001\u0007\u0011QO\u0001\u0016]\u0016\u001cH/\u001a3SK\u000e|'\u000f\u001a$jK2$g*Y7f!\u0011\t9(!\"\u000f\t\u0005e\u0014\u0011\u0011\t\u0004\u0003wRTBAA?\u0015\r\ty\bL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r%(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\u000bII\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007S\u0004bBAG=\u0001\u0007\u0011qR\u0001\u0002MB9\u0011(!%\u0002\u0016\u0006U\u0015bAAJu\tIa)\u001e8di&|g.\r\t\u0006\u0003/\u000bi\n\u0011\b\u0004\u0003\u0006e\u0015bAAN\u0005\u0006i1k\u00195f[\u0006\u0014U/\u001b7eKJLA!a(\u0002\"\nqa)[3mI\u0006\u001b8/Z7cY\u0016\u0014(bAAN\u0005\u0006\u00113M]3bi\u0016\feO]8TG\",W.Y,ji\"$v\u000e\u001d'fm\u0016dg)[3mIN$2\u0001QAT\u0011\u001d\tii\ba\u0001\u0003\u001f\u0003B!!\u0006\u0002,\u0012Y\u0011QV#\u0002\u0002\u0003\u0005)\u0011AA\u000e\u0005\ryF%\r\u0005\u0007u\n\u0001\r!!-\u0011\u0007\u0005MVB\u0004\u0002J\u0015!9\u0011q\u0017\u0002A\u0002\u0005U\u0014\u0001F3ya\u0016\u001cG/\u001a3DCV\u001cX-T3tg\u0006<W\r\u0003\u0005\u0002<\n\u0001\n\u00111\u0001\\\u00039\u0019\u0017\r^1msN$8k\u00195f[\u0006\fq%Y:tKJ$h)Y5mK\u0012\u001cuN\u001c<feNLwN\\'fgN\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u0019\u0016\u00047\u0006\r7FAAc!\u0011\t9-!5\u000e\u0005\u0005%'\u0002BAf\u0003\u001b\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005='(\u0001\u0006b]:|G/\u0019;j_:LA!a5\u0002J\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%]LG\u000f\u001b$jK2$W*\u0019;dQRK\b/\u001a\u000b\u0004q\u0005e\u0007bBAG\t\u0001\u0007\u00111\u001c\t\u0007s\u0005E\u0015\u0011\u0017\u001d")
public class AvroSerdeSuite
extends SparkFunSuite {
    private void assertFailedConversionMessage(Schema avroSchema, SerdeFactory<?> serdeFactory, Enumeration.Value fieldMatchType, String expectedCauseMessage, StructType catalystSchema) {
        String string;
        IncompatibleSchemaException e = (IncompatibleSchemaException)this.intercept((Function0 & Serializable)() -> serdeFactory.create(catalystSchema, avroSchema, fieldMatchType), ClassTag$.MODULE$.apply(IncompatibleSchemaException.class), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        SerdeFactory<?> serdeFactory2 = serdeFactory;
        if (AvroSerdeSuite$Deserializer$.MODULE$.equals(serdeFactory2)) {
            string = "Cannot convert Avro type " + avroSchema + " to SQL type " + catalystSchema.sql() + ".";
        } else if (AvroSerdeSuite$Serializer$.MODULE$.equals(serdeFactory2)) {
            string = "Cannot convert SQL type " + catalystSchema.sql() + " to Avro type " + avroSchema + ".";
        } else {
            throw new MatchError(serdeFactory2);
        }
        String expectMsg = string;
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = expectMsg;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(e.getCause().getMessage());
        String $org_scalatest_assert_macro_right2 = expectedCauseMessage;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
    }

    private StructType assertFailedConversionMessage$default$5() {
        return AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT();
    }

    public void withFieldMatchType(Function1<Enumeration.Value, BoxedUnit> f) {
        AvroSerdeSuite$MatchType$.MODULE$.values().foreach((Function1 & Serializable)fieldMatchType -> {
            this.withClue("fieldMatchType == " + fieldMatchType, (Function0)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)fieldMatchType));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$2(AvroSerdeSuite $this, Enumeration.Value fieldMatch) {
        Tuple2 tuple2;
        Enumeration.Value value = fieldMatch;
        Enumeration.Value value2 = AvroSerdeSuite$MatchType$.MODULE$.BY_NAME();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tuple2 = new Tuple2((Object)"foo", (Object)"bar");
        } else {
            Enumeration.Value value4 = AvroSerdeSuite$MatchType$.MODULE$.BY_POSITION();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                tuple2 = new Tuple2((Object)"NOTfoo", (Object)"NOTbar");
            } else {
                throw new MatchError((Object)value);
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String top = (String)tuple22._1();
        String nest = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)top, (Object)nest);
        String top2 = (String)tuple23._1();
        String nest2 = (String)tuple23._2();
        Schema avro = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields(top2, (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$2 -> x$2.optionalInt(nest2));
        GenericData.Record record = new GenericRecordBuilder(avro).set(top2, (Object)new GenericRecordBuilder(avro.getField(top2).schema()).set(nest2, (Object)BoxesRunTime.boxToInteger((int)42)).build()).build();
        AvroSerializer serializer = AvroSerdeSuite$Serializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avro, fieldMatch);
        AvroDeserializer deserializer = AvroSerdeSuite$Deserializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avro, fieldMatch);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(serializer.serialize(deserializer.deserialize((Object)record).get()));
        GenericData.Record $org_scalatest_assert_macro_right = record;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    public static final /* synthetic */ void $anonfun$new$6(AvroSerdeSuite $this, Schema avro$1, Enumeration.Value fieldMatch) {
        $this.assertFailedConversionMessage(avro$1, AvroSerdeSuite$Deserializer$.MODULE$, fieldMatch, "Cannot convert Avro field 'foo' to SQL field 'foo' because schema is incompatible (avroType = \"int\", sqlType = " + ((StructField)AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT().head()).dataType().sql() + ")", $this.assertFailedConversionMessage$default$5());
        $this.assertFailedConversionMessage(avro$1, AvroSerdeSuite$Serializer$.MODULE$, fieldMatch, "Cannot convert SQL field 'foo' to Avro field 'foo' because schema is incompatible (sqlType = " + ((StructField)AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT().head()).dataType().sql() + ", avroType = \"int\")", $this.assertFailedConversionMessage$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$9(AvroSerdeSuite $this, Schema avro$2, Enumeration.Value fieldMatch) {
        $this.assertFailedConversionMessage(avro$2, AvroSerdeSuite$Deserializer$.MODULE$, fieldMatch, "Cannot convert Avro field 'foo.bar' to SQL field 'foo.bar' because schema is incompatible (avroType = \"float\", sqlType = INT)", $this.assertFailedConversionMessage$default$5());
        $this.assertFailedConversionMessage(avro$2, AvroSerdeSuite$Serializer$.MODULE$, fieldMatch, "Cannot convert SQL field 'foo.bar' to Avro field 'foo.bar' because schema is incompatible (sqlType = INT, avroType = \"float\")", $this.assertFailedConversionMessage$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$14(AvroSerdeSuite $this, Schema avro$3, StructType catalyst$1, Enumeration.Value fieldMatch) {
        $this.assertFailedConversionMessage(avro$3, AvroSerdeSuite$Deserializer$.MODULE$, fieldMatch, "Cannot convert Avro field 'top.foo.bar' to SQL field 'top.foo.bar' because schema is incompatible (avroType = \"float\", sqlType = INT)", catalyst$1);
        $this.assertFailedConversionMessage(avro$3, AvroSerdeSuite$Serializer$.MODULE$, fieldMatch, "Cannot convert SQL field 'top.foo.bar' to Avro field 'top.foo.bar' because schema is incompatible (sqlType = INT, avroType = \"float\")", catalyst$1);
    }

    public AvroSerdeSuite() {
        this.test("Test basic conversion", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)fieldMatch -> {
            AvroSerdeSuite.$anonfun$new$2(this, fieldMatch);
            return BoxedUnit.UNIT;
        }), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("Fail to convert with field type mismatch", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Schema avro = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createAvroSchemaWithTopLevelFields((Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$3 -> x$3.requiredInt("foo"));
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)fieldMatch -> {
                AvroSerdeSuite.$anonfun$new$6(this, avro, fieldMatch);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Fail to convert with nested field type mismatch", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Schema avro = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields("foo", (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$4 -> x$4.optionalFloat("bar"));
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)fieldMatch -> {
                AvroSerdeSuite.$anonfun$new$9(this, avro, fieldMatch);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Fail to convert with missing nested Avro fields", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Schema avro = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields("foo", (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$5 -> x$5.optionalInt("NOTbar"));
            StructType nonnullCatalyst = new StructType().add("foo", (DataType)new StructType().add("bar", (DataType)IntegerType$.MODULE$, false));
            StructType extraNonnullCatalyst = new StructType().add("foo", (DataType)new StructType().add("bar", (DataType)IntegerType$.MODULE$).add("baz", (DataType)IntegerType$.MODULE$, false));
            AvroSerdeSuite$Deserializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avro, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME());
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Deserializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME(), "Cannot find field 'foo.bar' in Avro schema", nonnullCatalyst);
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Deserializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_POSITION(), "Cannot find field at position 1 of field 'foo' from Avro schema (using positional matching)", extraNonnullCatalyst);
            String byNameMsg = "Cannot find field 'foo.bar' in Avro schema";
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME(), byNameMsg, this.assertFailedConversionMessage$default$5());
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME(), byNameMsg, nonnullCatalyst);
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_POSITION(), "Cannot find field at position 1 of field 'foo' from Avro schema (using positional matching)", extraNonnullCatalyst);
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("Fail to convert with deeply nested field type mismatch", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Schema avro = (Schema)SchemaBuilder.builder().record("toptest").fields().name("top").type(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields("foo", (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$6 -> x$6.optionalFloat("bar"))).noDefault().endRecord();
            StructType catalyst = new StructType().add("top", (DataType)AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT());
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)fieldMatch -> {
                AvroSerdeSuite.$anonfun$new$14(this, avro, catalyst, fieldMatch);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("Fail to convert with missing Catalyst fields", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Schema nestedFooField = (Schema)SchemaBuilder.record((String)"foo").fields().optionalInt("bar").endRecord();
            Schema avroExtraOptional = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createAvroSchemaWithTopLevelFields((Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$7 -> x$7.name("foo").type(nestedFooField).noDefault().optionalLong("bar"));
            Schema avroExtraRequired = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createAvroSchemaWithTopLevelFields((Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$8 -> x$8.name("foo").type(nestedFooField).noDefault().requiredLong("bar"));
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)x$9 -> {
                AvroSerdeSuite$Serializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avroExtraOptional, x$9);
                return BoxedUnit.UNIT;
            });
            this.assertFailedConversionMessage(avroExtraRequired, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME(), "Found field 'bar' in Avro schema but there is no match in the SQL schema", this.assertFailedConversionMessage$default$5());
            this.assertFailedConversionMessage(avroExtraRequired, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_POSITION(), "Found field 'bar' at position 1 of top-level record from Avro schema but there is no match in the SQL schema at top-level record (using positional matching)", this.assertFailedConversionMessage$default$5());
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)x$10 -> {
                AvroSerdeSuite$Deserializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avroExtraOptional, x$10);
                return BoxedUnit.UNIT;
            });
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)x$11 -> {
                AvroSerdeSuite$Deserializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avroExtraRequired, x$11);
                return BoxedUnit.UNIT;
            });
            Schema avroExtraNestedOptional = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields("foo", (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$12 -> x$12.optionalInt("bar").optionalInt("baz"));
            Schema avroExtraNestedRequired = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields("foo", (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable)x$13 -> x$13.optionalInt("bar").requiredInt("baz"));
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)x$14 -> {
                AvroSerdeSuite$Serializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avroExtraNestedOptional, x$14);
                return BoxedUnit.UNIT;
            });
            this.assertFailedConversionMessage(avroExtraNestedRequired, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME(), "Found field 'foo.baz' in Avro schema but there is no match in the SQL schema", this.assertFailedConversionMessage$default$5());
            this.assertFailedConversionMessage(avroExtraNestedRequired, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_POSITION(), "Found field 'baz' at position 1 of field 'foo' from Avro schema but there is no match in the SQL schema at field 'foo' (using positional matching)", this.assertFailedConversionMessage$default$5());
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)x$15 -> {
                AvroSerdeSuite$Deserializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avroExtraNestedOptional, x$15);
                return BoxedUnit.UNIT;
            });
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable)x$16 -> {
                AvroSerdeSuite$Deserializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avroExtraNestedRequired, x$16);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
    }

    private static interface SerdeFactory<T> {
        public T create(StructType var1, Schema var2, Enumeration.Value var3);
    }
}

