/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.io.DatumWriter;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000554Qa\u0004\t\u0002\u0002mAQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00045\u0001\u0001\u0006I\u0001\f\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0011\u0019)\u0005\u0001)A\u0005o!)a\t\u0001C\u0001\u000f\"9A\u000b\u0001b\u0001\n\u0003Y\u0003BB+\u0001A\u0003%A\u0006C\u0004W\u0001\t\u0007I\u0011A,\t\r}\u0003\u0001\u0015!\u0003Y\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011DaA\u001a\u0001!\u0002\u0013)\u0007\"B4\u0001\t\u0003A'\u0001F!we>dunZ5dC2$\u0016\u0010]3Tk&$XM\u0003\u0002\u0012%\u0005!\u0011M\u001e:p\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0004\t\t\u0003;yi\u0011AE\u0005\u0003?I\u0011\u0011\"U;fef$Vm\u001d;\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0012\u0012\u0001\u0002;fgRL!!\n\u0012\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003A\t!\u0002Z1uKN\u001b\u0007.Z7b+\u0005a\u0003CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017\u0011\fG/Z*dQ\u0016l\u0017\rI\u0001\u000eI\u0006$X-\u00138qkR$\u0015\r^1\u0016\u0003]\u00022\u0001O B\u001b\u0005I$B\u0001\u001e<\u0003%IW.\\;uC\ndWM\u0003\u0002={\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001d\u0003\u0007M+\u0017\u000f\u0005\u0002C\u00076\tQ(\u0003\u0002E{\t\u0019\u0011J\u001c;\u0002\u001d\u0011\fG/Z%oaV$H)\u0019;bA\u0005AA-\u0019;f\r&dW\r\u0006\u0002I%B\u0011\u0011\n\u0015\b\u0003\u0015:\u0003\"aS\u001f\u000e\u00031S!!\u0014\u000e\u0002\rq\u0012xn\u001c;?\u0013\tyU(\u0001\u0004Qe\u0016$WMZ\u0005\u0003gES!aT\u001f\t\u000bM3\u0001\u0019\u0001%\u0002\tA\fG\u000f[\u0001\u0010i&lWm\u001d;b[B\u001c6\r[3nC\u0006\u0001B/[7fgR\fW\u000e]*dQ\u0016l\u0017\rI\u0001\u0013i&lWm\u001d;b[BLe\u000e];u\t\u0006$\u0018-F\u0001Y!\rAt(\u0017\t\b\u0005jcF\f\u0018/]\u0013\tYVH\u0001\u0004UkBdW-\u000e\t\u0003\u0005vK!AX\u001f\u0003\t1{gnZ\u0001\u0014i&lWm\u001d;b[BLe\u000e];u\t\u0006$\u0018\rI\u0001\u000ei&lWm\u001d;b[B4\u0015\u000e\\3\u0015\u0005!\u0013\u0007\"B*\f\u0001\u0004A\u0015\u0001\u00053fG&l\u0017\r\\%oaV$H)\u0019;b+\u0005)\u0007c\u0001\u001d@Y\u0005\tB-Z2j[\u0006d\u0017J\u001c9vi\u0012\u000bG/\u0019\u0011\u0002)\u0011,7-[7bYN\u001b\u0007.Z7b\u0003:$g)\u001b7f)\tIG\u000e\u0005\u0003CU\"C\u0015BA6>\u0005\u0019!V\u000f\u001d7fe!)1K\u0004a\u0001\u0011\u0002")
public abstract class AvroLogicalTypeSuite
extends QueryTest
implements SharedSparkSession {
    private final String dateSchema;
    private final Seq<Object> dateInputData;
    private final String timestampSchema;
    private final Seq<Tuple5<Object, Object, Object, Object, Object>> timestampInputData;
    private final Seq<String> decimalInputData;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$((SharedSparkSessionBase)this);
    }

    public void beforeAll() {
        SharedSparkSession.beforeAll$((SharedSparkSession)this);
    }

    public void afterAll() {
        SharedSparkSession.afterAll$((SharedSparkSession)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$((SharedSparkSessionBase)this);
    }

    public SparkSession spark() {
        return SharedSparkSessionBase.spark$((SharedSparkSessionBase)this);
    }

    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$((SharedSparkSessionBase)this);
    }

    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$((SharedSparkSessionBase)this);
    }

    public SQLConf sqlConf() {
        return SharedSparkSessionBase.sqlConf$((SharedSparkSessionBase)this);
    }

    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$((SharedSparkSessionBase)this);
    }

    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$((SharedSparkSessionBase)this);
    }

    public void afterEach() {
        SharedSparkSessionBase.afterEach$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testBody, Position pos) {
        super.test(testName, testTags, testBody, pos);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$((SQLTestUtils)this, f);
    }

    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$((SQLTestUtils)this, (String)testName, f);
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$((SQLTestUtils)this, (String)testName, testTags, testFun, (Position)pos);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$((SQLTestUtils)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$((SQLTestUtils)this);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$((SQLTestUtils)this, (int)numPaths, f);
    }

    public /* synthetic */ Object org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        return SQLConfHelper.withSQLConf$((SQLConfHelper)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$((SQLTestUtilsBase)this, cacheNames, f);
    }

    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$((SQLTestUtilsBase)this, (String)tableName);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$((SQLTestUtilsBase)this, namespaces, f);
    }

    public void withCurrentCatalogAndNamespace(Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCurrentCatalogAndNamespace$((SQLTestUtilsBase)this, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void withSessionVariable(Seq<String> variableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSessionVariable$((SQLTestUtilsBase)this, variableNames, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$((SQLTestUtilsBase)this, (File)file);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.sql$lzycompute();
        }
        return this.sql;
    }

    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.emptyTestData$lzycompute();
        }
        return this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.testData$lzycompute();
        }
        return this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.testData2$lzycompute();
        }
        return this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.testData3$lzycompute();
        }
        return this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.negativeData$lzycompute();
        }
        return this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.largeAndSmallInts$lzycompute();
        }
        return this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.decimalData$lzycompute();
        }
        return this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.binaryData$lzycompute();
        }
        return this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.upperCaseData$lzycompute();
        }
        return this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.lowerCaseData$lzycompute();
        }
        return this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.lowerCaseDataWithDuplicates$lzycompute();
        }
        return this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.arrayData$lzycompute();
        }
        return this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.mapData$lzycompute();
        }
        return this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        if ((this.bitmap$0 & 0x4000) == 0) {
            return this.calendarIntervalData$lzycompute();
        }
        return this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        if ((this.bitmap$0 & 0x8000) == 0) {
            return this.repeatedData$lzycompute();
        }
        return this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        if ((this.bitmap$0 & 0x10000) == 0) {
            return this.nullableRepeatedData$lzycompute();
        }
        return this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        if ((this.bitmap$0 & 0x20000) == 0) {
            return this.nullInts$lzycompute();
        }
        return this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        if ((this.bitmap$0 & 0x40000) == 0) {
            return this.allNulls$lzycompute();
        }
        return this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        if ((this.bitmap$0 & 0x80000) == 0) {
            return this.nullStrings$lzycompute();
        }
        return this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        if ((this.bitmap$0 & 0x100000) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        if ((this.bitmap$0 & 0x200000) == 0) {
            return this.unparsedStrings$lzycompute();
        }
        return this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        if ((this.bitmap$0 & 0x400000) == 0) {
            return this.withEmptyParts$lzycompute();
        }
        return this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        if ((this.bitmap$0 & 0x800000) == 0) {
            return this.person$lzycompute();
        }
        return this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        if ((this.bitmap$0 & 0x1000000) == 0) {
            return this.salary$lzycompute();
        }
        return this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        if ((this.bitmap$0 & 0x2000000) == 0) {
            return this.complexData$lzycompute();
        }
        return this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        if ((this.bitmap$0 & 0x4000000) == 0) {
            return this.courseSales$lzycompute();
        }
        return this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        if ((this.bitmap$0 & 0x8000000) == 0) {
            return this.trainingSales$lzycompute();
        }
        return this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    public Dataset<Row> intervalData() {
        if ((this.bitmap$0 & 0x10000000) == 0) {
            return this.intervalData$lzycompute();
        }
        return this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public String dateSchema() {
        return this.dateSchema;
    }

    public Seq<Object> dateInputData() {
        return this.dateInputData;
    }

    public String dateFile(String path) {
        Schema schema = new Schema.Parser().parse(this.dateSchema());
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        String result = path + "/test.avro";
        dataFileWriter.create(schema, new File(result));
        this.dateInputData().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x -> {
            GenericData.Record record = new GenericData.Record(schema);
            record.put("date", (Object)BoxesRunTime.boxToInteger((int)x));
            dataFileWriter.append((Object)record);
        });
        dataFileWriter.flush();
        dataFileWriter.close();
        return result;
    }

    public String timestampSchema() {
        return this.timestampSchema;
    }

    public Seq<Tuple5<Object, Object, Object, Object, Object>> timestampInputData() {
        return this.timestampInputData;
    }

    public String timestampFile(String path) {
        Schema schema = new Schema.Parser().parse(this.timestampSchema());
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        String result = path + "/test.avro";
        dataFileWriter.create(schema, new File(result));
        this.timestampInputData().foreach((Function1 & Serializable)t -> {
            AvroLogicalTypeSuite.$anonfun$timestampFile$1(schema, dataFileWriter, t);
            return BoxedUnit.UNIT;
        });
        dataFileWriter.flush();
        dataFileWriter.close();
        return result;
    }

    public Seq<String> decimalInputData() {
        return this.decimalInputData;
    }

    public Tuple2<String, String> decimalSchemaAndFile(String path) {
        int precision = 4;
        int scale = 2;
        String bytesFieldName = "bytes";
        String bytesSchema = "{\n         \"type\":\"bytes\",\n         \"logicalType\":\"decimal\",\n         \"precision\":" + precision + ",\n         \"scale\":" + scale + "\n      }\n    ";
        String fixedFieldName = "fixed";
        String fixedSchema = "{\n         \"type\":\"fixed\",\n         \"size\":5,\n         \"logicalType\":\"decimal\",\n         \"precision\":" + precision + ",\n         \"scale\":" + scale + ",\n         \"name\":\"foo\"\n      }\n    ";
        String avroSchema = "\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"" + bytesFieldName + "\", \"type\": " + bytesSchema + "},\n          {\"name\": \"" + fixedFieldName + "\", \"type\": " + fixedSchema + "}\n        ]\n      }\n    ";
        Schema schema = new Schema.Parser().parse(avroSchema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
        String avroFile = path + "/test.avro";
        dataFileWriter.create(schema, new File(avroFile));
        LogicalTypes.Decimal logicalType = LogicalTypes.decimal((int)precision, (int)scale);
        this.decimalInputData().foreach((Function1 & Serializable)x -> {
            AvroLogicalTypeSuite.$anonfun$decimalSchemaAndFile$1(schema, scale, decimalConversion, bytesFieldName, logicalType, fixedFieldName, dataFileWriter, x);
            return BoxedUnit.UNIT;
        });
        dataFileWriter.flush();
        dataFileWriter.close();
        return new Tuple2((Object)avroSchema, (Object)avroFile);
    }

    private final void testImplicits$lzycompute$1() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        AvroLogicalTypeSuite avroLogicalTypeSuite = this;
        synchronized (avroLogicalTypeSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$6(AvroLogicalTypeSuite $this, Dataset df$1, Seq expected$1, File path) {
        df$1.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$1);
    }

    public static final /* synthetic */ void $anonfun$new$2(AvroLogicalTypeSuite $this, File dir) {
        Seq expected = (Seq)$this.dateInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils$.MODULE$.toJavaDate(BoxesRunTime.unboxToInt((Object)t))})));
        String dateAvro = $this.dateFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(dateAvro);
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").option("avroSchema", $this.dateSchema()).load(dateAvro), expected);
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$6($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$timestampFile$1(Schema schema$2, DataFileWriter dataFileWriter$2, Tuple5 t) {
        GenericData.Record record = new GenericData.Record(schema$2);
        record.put("timestamp_millis", t._1());
        record.put("timestamp_micros", (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)t._2()) * 1000L)));
        record.put("local_timestamp_millis", t._3());
        record.put("local_timestamp_micros", (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)t._4()) * 1000L)));
        record.put("long", t._5());
        dataFileWriter$2.append((Object)record);
    }

    public static final /* synthetic */ void $anonfun$new$12(AvroLogicalTypeSuite $this, Dataset df$2, Seq expected$2, File path) {
        df$2.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$2);
    }

    public static final /* synthetic */ void $anonfun$new$9(AvroLogicalTypeSuite $this, File dir) {
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._1()))})));
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp_millis"}))).$((Seq)Nil$.MODULE$)}));
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$12($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$18(AvroLogicalTypeSuite $this, Dataset df$3, Seq expected$3, File path) {
        df$3.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$3);
    }

    public static final /* synthetic */ void $anonfun$new$15(AvroLogicalTypeSuite $this, File dir) {
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._2()))})));
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp_micros"}))).$((Seq)Nil$.MODULE$)}));
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$18($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$24(AvroLogicalTypeSuite $this, Dataset df$4, Seq expected$4, File path) {
        df$4.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$4);
    }

    public static final /* synthetic */ void $anonfun$new$21(AvroLogicalTypeSuite $this, File dir) {
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.millisToMicros(BoxesRunTime.unboxToLong((Object)t._3())))})));
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"local_timestamp_millis"}))).$((Seq)Nil$.MODULE$)}));
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$24($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(AvroLogicalTypeSuite $this, Dataset df$5, Seq expected$5, File path) {
        df$5.write().format("avro").save(path.toString());
        Dataset df2 = $this.spark().read().format("avro").load(path.toString());
        StructType $org_scalatest_assert_macro_left = df2.schema();
        StructField structField = new StructField("local_timestamp_micros", (DataType)TimestampNTZType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
        StructType structType = $org_scalatest_assert_macro_left;
        StructType structType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        $this.checkAnswer((Function0 & Serializable)() -> df2, expected$5);
    }

    public static final /* synthetic */ void $anonfun$new$27(AvroLogicalTypeSuite $this, File dir) {
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.millisToMicros(BoxesRunTime.unboxToLong((Object)t._4())))})));
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"local_timestamp_micros"}))).$((Seq)Nil$.MODULE$)}));
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$30($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$35(AvroLogicalTypeSuite $this, Dataset df$6, String userSpecifiedTimestampSchema$1, Seq expected$6, File path) {
        df$6.write().format("avro").option("avroSchema", userSpecifiedTimestampSchema$1).save(path.toString());
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$6);
    }

    public static final /* synthetic */ void $anonfun$new$33(AvroLogicalTypeSuite $this, File dir) {
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp_millis"}))).$((Seq)Nil$.MODULE$), $this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp_micros"}))).$((Seq)Nil$.MODULE$)}));
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._1())), new Timestamp(BoxesRunTime.unboxToLong((Object)t._2()))})));
        String userSpecifiedTimestampSchema = "\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"timestamp_millis\",\n            \"type\": [{\"type\": \"long\",\"logicalType\": \"timestamp-micros\"}, \"null\"]},\n          {\"name\": \"timestamp_micros\",\n            \"type\": [{\"type\": \"long\",\"logicalType\": \"timestamp-millis\"}, \"null\"]}\n        ]\n      }\n    ";
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$35($this, df, userSpecifiedTimestampSchema, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$40(AvroLogicalTypeSuite $this, Dataset df$7, String userSpecifiedTimestampSchema$2, Seq expected$7, File path) {
        df$7.write().format("avro").option("avroSchema", userSpecifiedTimestampSchema$2).save(path.toString());
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$7);
    }

    public static final /* synthetic */ void $anonfun$new$38(AvroLogicalTypeSuite $this, File dir) {
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Dataset df = $this.spark().read().format("avro").load(timestampAvro).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"local_timestamp_millis"}))).$((Seq)Nil$.MODULE$), $this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"local_timestamp_micros"}))).$((Seq)Nil$.MODULE$)}));
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.millisToMicros(BoxesRunTime.unboxToLong((Object)t._3()))), DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.millisToMicros(BoxesRunTime.unboxToLong((Object)t._4())))})));
        String userSpecifiedTimestampSchema = "\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"local_timestamp_millis\",\n            \"type\": [{\"type\": \"long\",\"logicalType\": \"local-timestamp-millis\"}, \"null\"]},\n          {\"name\": \"local_timestamp_micros\",\n            \"type\": [{\"type\": \"long\",\"logicalType\": \"local-timestamp-micros\"}, \"null\"]}\n        ]\n      }\n    ";
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$40($this, df, userSpecifiedTimestampSchema, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$43(AvroLogicalTypeSuite $this, File dir) {
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        StructField structField = new StructField("long", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
        Dataset df = $this.spark().read().format("avro").schema(schema).load(timestampAvro).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"long"}))).$((Seq)Nil$.MODULE$)}));
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._5()))})));
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
    }

    public static final /* synthetic */ void $anonfun$new$47(AvroLogicalTypeSuite $this, File dir) {
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        StructField structField = new StructField("long", (DataType)TimestampNTZType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
        Dataset df = $this.spark().read().format("avro").schema(schema).load(timestampAvro).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"long"}))).$((Seq)Nil$.MODULE$)}));
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.millisToMicros(BoxesRunTime.unboxToLong((Object)t._5())))})));
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
    }

    public static final /* synthetic */ void $anonfun$new$51(AvroLogicalTypeSuite $this, File dir) {
        String timestampAvro = $this.timestampFile(dir.getAbsolutePath());
        Seq expected = (Seq)$this.timestampInputData().map((Function1 & Serializable)t -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(BoxesRunTime.unboxToLong((Object)t._1())), new Timestamp(BoxesRunTime.unboxToLong((Object)t._2())), DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.millisToMicros(BoxesRunTime.unboxToLong((Object)t._3()))), DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.millisToMicros(BoxesRunTime.unboxToLong((Object)t._4()))), t._5()})));
        Dataset df = $this.spark().read().format("avro").option("avroSchema", $this.timestampSchema()).load(timestampAvro);
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
    }

    public static final /* synthetic */ void $anonfun$decimalSchemaAndFile$1(Schema schema$3, int scale$1, Conversions.DecimalConversion decimalConversion$1, String bytesFieldName$1, LogicalTypes.Decimal logicalType$1, String fixedFieldName$1, DataFileWriter dataFileWriter$3, String x) {
        GenericData.Record avroRec = new GenericData.Record(schema$3);
        BigDecimal decimal = new BigDecimal(x).setScale(scale$1);
        ByteBuffer bytes = decimalConversion$1.toBytes(decimal, schema$3.getField(bytesFieldName$1).schema(), (LogicalType)logicalType$1);
        avroRec.put(bytesFieldName$1, (Object)bytes);
        GenericFixed fixed = decimalConversion$1.toFixed(decimal, schema$3.getField(fixedFieldName$1).schema(), (LogicalType)logicalType$1);
        avroRec.put(fixedFieldName$1, (Object)fixed);
        dataFileWriter$3.append((Object)avroRec);
    }

    public static final /* synthetic */ void $anonfun$new$59(AvroLogicalTypeSuite $this, Dataset df$11, Seq expected$8, File path) {
        df$11.write().format("avro").save(path.toString());
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$8);
    }

    public static final /* synthetic */ void $anonfun$new$55(AvroLogicalTypeSuite $this, File dir) {
        Tuple2<String, String> tuple2 = $this.decimalSchemaAndFile(dir.getAbsolutePath());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String avroSchema = (String)tuple2._1();
        String avroFile = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)avroSchema, (Object)avroFile);
        String avroSchema2 = (String)tuple22._1();
        String avroFile2 = (String)tuple22._2();
        Seq expected = (Seq)$this.decimalInputData().map((Function1 & Serializable)x -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal((String)x), new BigDecimal((String)x)})));
        Dataset df = $this.spark().read().format("avro").load(avroFile2);
        $this.checkAnswer((Function0 & Serializable)() -> df, expected);
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").option("avroSchema", avroSchema2).load(avroFile2), expected);
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$59($this, df, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$64(AvroLogicalTypeSuite $this, Dataset df$12, String specifiedSchema$1, Seq expected$9, File path) {
        df$12.write().format("avro").option("avroSchema", specifiedSchema$1).save(path.toString());
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().format("avro").load(path.toString()), expected$9);
    }

    public static final /* synthetic */ void $anonfun$new$62(AvroLogicalTypeSuite $this, String specifiedSchema$1, File dir) {
        Tuple2<String, String> tuple2 = $this.decimalSchemaAndFile(dir.getAbsolutePath());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String avroSchema = (String)tuple2._1();
        String avroFile = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)avroSchema, (Object)avroFile);
        String avroSchema2 = (String)tuple22._1();
        String avroFile2 = (String)tuple22._2();
        String $org_scalatest_assert_macro_left = specifiedSchema$1;
        String $org_scalatest_assert_macro_right = avroSchema2;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        Seq expected = (Seq)$this.decimalInputData().map((Function1 & Serializable)x -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal((String)x), new BigDecimal((String)x)})));
        Dataset df = $this.spark().read().format("avro").load(avroFile2);
        $this.withTempPath((Function1 & Serializable)path -> {
            AvroLogicalTypeSuite.$anonfun$new$64($this, df, specifiedSchema$1, expected, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$67(AvroLogicalTypeSuite $this, File dir) {
        Schema schema = new Schema.Parser().parse("{\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [{\n          \"name\": \"decimal\",\n          \"type\": {\"type\": \"bytes\", \"logicalType\": \"decimal\", \"precision\": 4, \"scale\": 2}\n        }]\n      }");
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema, new File(dir + ".avro"));
        GenericData.Record avroRec = new GenericData.Record(schema);
        BigDecimal decimal = new BigDecimal("0.12345678901234567890123456789012345678");
        ByteBuffer bytes = new Conversions.DecimalConversion().toBytes(decimal, schema, (LogicalType)LogicalTypes.decimal((int)39, (int)38));
        avroRec.put("decimal", (Object)bytes);
        dataFileWriter.append((Object)avroRec);
        dataFileWriter.flush();
        dataFileWriter.close();
        SparkException ex = (SparkException)$this.intercept((Function0 & Serializable)() -> (Row[])$this.spark().read().format("avro").load(dir + ".avro").collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        String $org_scalatest_assert_macro_left = ex.getCondition();
        String $org_scalatest_assert_macro_right = "FAILED_READ_FILE";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        SparkArithmeticException x$1 = (SparkArithmeticException)ex.getCause();
        String x$2 = "NUMERIC_VALUE_OUT_OF_RANGE.WITH_SUGGESTION";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\"")}));
        Option x$4 = $this.checkError$default$3();
        boolean x$5 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$1, "NUMERIC_VALUE_OUT_OF_RANGE.WITH_SUGGESTION", x$4, x$3, x$5, x$6);
    }

    public static final /* synthetic */ void $anonfun$new$70(AvroLogicalTypeSuite $this, Schema schema$4, File dir) {
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema$4);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema$4, new File(dir + ".avro"));
        GenericData.Record avroRec = new GenericData.Record(schema$4);
        avroRec.put("field1", (Object)BoxesRunTime.boxToLong((long)123456789L));
        avroRec.put("field2", (Object)BoxesRunTime.boxToLong((long)123456789L));
        avroRec.put("field3", (Object)BoxesRunTime.boxToLong((long)123456789L));
        dataFileWriter.append((Object)avroRec);
        dataFileWriter.flush();
        dataFileWriter.close();
        Dataset df = $this.spark().read().format("avro").load(dir + ".avro");
        $this.assertResult(new DecimalType(38, 2), ((StructField)df.schema().head()).dataType(), Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        Row firstRow = ((Row[])df.take(1))[0];
        $this.assertResult(BigDecimal.valueOf(123456789L, 2), firstRow.getAs("field1"), Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        $this.assertResult(BigDecimal.valueOf(123456789L, 9), firstRow.getAs("field2"), Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        $this.assertResult(BoxesRunTime.boxToLong((long)123456789L), firstRow.getAs("field3"), Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
    }

    public static final /* synthetic */ void $anonfun$new$73(AvroLogicalTypeSuite $this, Schema schema$5, File dir) {
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema$5);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema$5, new File(dir + ".avro"));
        GenericData.Record avroRec = new GenericData.Record(schema$5);
        avroRec.put("field", (Object)BoxesRunTime.boxToLong((long)123456789L));
        dataFileWriter.append((Object)avroRec);
        dataFileWriter.flush();
        dataFileWriter.close();
        Dataset df = $this.spark().read().format("avro").load(dir + ".avro");
        $this.assertResult(LongType$.MODULE$, ((StructField)df.schema().head()).dataType(), Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        Row firstRow = ((Row[])df.take(1))[0];
        $this.assertResult(BoxesRunTime.boxToLong((long)123456789L), firstRow.getAs("field"), Prettifier$.MODULE$.default(), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
    }

    public static final /* synthetic */ void $anonfun$new$72(AvroLogicalTypeSuite $this, String d) {
        Schema schema = new Schema.Parser().parse("{\n            \"namespace\": \"logical\",\n            \"type\": \"record\",\n            \"name\": \"test\",\n            \"fields\": [\n            {\n              \"name\": \"field\",\n              \"type\": {" + d + "}\n             }]\n          }");
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$73($this, schema, dir);
            return BoxedUnit.UNIT;
        });
    }

    public AvroLogicalTypeSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        SharedSparkSessionBase.$init$((SharedSparkSessionBase)this);
        SharedSparkSession.$init$((SharedSparkSession)this);
        this.dateSchema = "\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"date\", \"type\": {\"type\": \"int\", \"logicalType\": \"date\"}}\n        ]\n      }\n    ";
        this.dateInputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 365, 0}));
        this.test("Logical type: date", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$2(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.timestampSchema = "\n      {\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n          {\"name\": \"timestamp_millis\", \"type\": {\"type\": \"long\",\"logicalType\": \"timestamp-millis\"}},\n          {\"name\": \"timestamp_micros\", \"type\": {\"type\": \"long\",\"logicalType\": \"timestamp-micros\"}},\n          {\"name\": \"local_timestamp_millis\", \"type\": {\"type\": \"long\",\"logicalType\": \"local-timestamp-millis\"}},\n          {\"name\": \"local_timestamp_micros\", \"type\": {\"type\": \"long\",\"logicalType\": \"local-timestamp-micros\"}},\n          {\"name\": \"long\", \"type\": \"long\"}\n        ]\n      }\n    ";
        this.timestampInputData = new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)1000L), (Object)BoxesRunTime.boxToLong((long)2000L), (Object)BoxesRunTime.boxToLong((long)1000L), (Object)BoxesRunTime.boxToLong((long)2000L), (Object)BoxesRunTime.boxToLong((long)3000L)), (List)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)666000L), (Object)BoxesRunTime.boxToLong((long)999000L), (Object)BoxesRunTime.boxToLong((long)666000L), (Object)BoxesRunTime.boxToLong((long)999000L), (Object)BoxesRunTime.boxToLong((long)777000L)), (List)Nil$.MODULE$));
        this.test("Logical type: timestamp_millis", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$9(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("Logical type: timestamp_micros", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$15(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("Logical type: local_timestamp_millis", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$21(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("Logical type: local_timestamp_micros", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$27(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("Logical type: user specified output schema with different timestamp types", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$33(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("Logical type: user specified output schema with different timestamp ntz types", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$38(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("Read Long type as Timestamp", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$43(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("Read Long type as Timestamp without time zone", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$47(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("Logical type: user specified read schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$51(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        this.decimalInputData = new .colon.colon((Object)"1.23", (List)new .colon.colon((Object)"4.56", (List)new .colon.colon((Object)"78.90", (List)new .colon.colon((Object)"-1", (List)new .colon.colon((Object)"-2.31", (List)Nil$.MODULE$)))));
        this.test("Logical type: Decimal", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$55(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("Logical type: write Decimal with BYTES type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String specifiedSchema = "\n      {\n        \"type\" : \"record\",\n        \"name\" : \"topLevelRecord\",\n        \"namespace\" : \"topLevelRecord\",\n        \"fields\" : [ {\n          \"name\" : \"bytes\",\n          \"type\" : [ {\n            \"type\" : \"bytes\",\n            \"namespace\" : \"topLevelRecord.bytes\",\n            \"logicalType\" : \"decimal\",\n            \"precision\" : 4,\n            \"scale\" : 2\n          }, \"null\" ]\n        }, {\n          \"name\" : \"fixed\",\n          \"type\" : [ {\n            \"type\" : \"bytes\",\n            \"logicalType\" : \"decimal\",\n            \"precision\" : 4,\n            \"scale\" : 2\n          }, \"null\" ]\n        } ]\n      }\n    ";
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                AvroLogicalTypeSuite.$anonfun$new$62(this, specifiedSchema, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("Logical type: Decimal with too large precision", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            AvroLogicalTypeSuite.$anonfun$new$67(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        this.test("SPARK-43901: LogicalType: Custom Decimal for Long Type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Schema schema = new Schema.Parser().parse("{\n        \"namespace\": \"logical\",\n        \"type\": \"record\",\n        \"name\": \"test\",\n        \"fields\": [\n         {\n           \"name\": \"field1\",\n           \"type\": {\"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": 2, \"precision\": 38}\n         },\n         {\n           \"name\": \"field2\",\n           \"type\": {\"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": 9, \"precision\": 33}\n         },\n         {\n           \"name\": \"field3\",\n           \"type\": \"long\"\n         }]\n        }");
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                AvroLogicalTypeSuite.$anonfun$new$70(this, schema, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        this.test("SPARK-43901: LogicalType: Decimal for Long Type Exception Cases", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": 2, \"precision\": 50 ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": -2, \"precision\": 30 ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": 2, \"precision\": -30 ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": 30, \"precision\": 20 ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": \"2\", \"precision\": 30 ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": \"xx\", \"precision\": 30 ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": 2, \"precision\": \"30\" ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": 2, \"precision\": \"xx\" ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"precision\": 30 ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\", \"scale\": 2 ", " \"type\": \"long\", \"logicalType\": \"custom-decimal\" "})).foreach((Function1 & Serializable)d -> {
            AvroLogicalTypeSuite.$anonfun$new$72(this, d);
            return BoxedUnit.UNIT;
        }), new Position("AvroLogicalTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        Statics.releaseFence();
    }
}

